# Generated by default/object.tt
package Paws::ES::SAMLIdp;
  use Moose;
  has EntityId => (is => 'ro', isa => 'Str', required => 1);
  has MetadataContent => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::SAMLIdp

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::SAMLIdp object:

  $service_obj->Method(Att1 => { EntityId => $value, ..., MetadataContent => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::SAMLIdp object:

  $result = $service_obj->Method(...);
  $result->Att1->EntityId

=head1 DESCRIPTION

Specifies the SAML Identity Provider's information.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EntityId => Str

The unique Entity ID of the application in SAML Identity Provider.


=head2 B<REQUIRED> MetadataContent => Str

The Metadata of the SAML application in xml format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

