# Generated by default/object.tt
package Paws::IoTSiteWise::Metric;
  use Moose;
  has Expression => (is => 'ro', isa => 'Str', request_name => 'expression', traits => ['NameInRequest'], required => 1);
  has Variables => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::ExpressionVariable]', request_name => 'variables', traits => ['NameInRequest'], required => 1);
  has Window => (is => 'ro', isa => 'Paws::IoTSiteWise::MetricWindow', request_name => 'window', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Metric

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Metric object:

  $service_obj->Method(Att1 => { Expression => $value, ..., Window => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Metric object:

  $result = $service_obj->Method(...);
  $result->Att1->Expression

=head1 DESCRIPTION

Contains an asset metric property. With metrics, you can calculate
aggregate functions, such as an average, maximum, or minimum, as
specified through an expression. A metric maps several values to a
single value (such as a sum).

The maximum number of dependent/cascading variables used in any one
metric calculation is 10. Therefore, a I<root> metric can have up to 10
cascading metrics in its computational dependency tree. Additionally, a
metric can only have a data type of C<DOUBLE> and consume properties
with data types of C<INTEGER> or C<DOUBLE>.

For more information, see Metrics
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics)
in the I<AWS IoT SiteWise User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Expression => Str

The mathematical expression that defines the metric aggregation
function. You can specify up to 10 variables per expression. You can
specify up to 10 functions per expression.

For more information, see Quotas
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
in the I<AWS IoT SiteWise User Guide>.


=head2 B<REQUIRED> Variables => ArrayRef[L<Paws::IoTSiteWise::ExpressionVariable>]

The list of variables used in the expression.


=head2 B<REQUIRED> Window => L<Paws::IoTSiteWise::MetricWindow>

The window (time interval) over which AWS IoT SiteWise computes the
metric's aggregation expression. AWS IoT SiteWise computes one data
point per C<window>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

