# Generated by default/object.tt
package Paws::SecurityHub::AwsEc2NetworkAclDetails;
  use Moose;
  has Associations => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEc2NetworkAclAssociation]');
  has Entries => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEc2NetworkAclEntry]');
  has IsDefault => (is => 'ro', isa => 'Bool');
  has NetworkAclId => (is => 'ro', isa => 'Str');
  has OwnerId => (is => 'ro', isa => 'Str');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEc2NetworkAclDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEc2NetworkAclDetails object:

  $service_obj->Method(Att1 => { Associations => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEc2NetworkAclDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Associations

=head1 DESCRIPTION

Contains details about an EC2 network access control list (ACL).

=head1 ATTRIBUTES


=head2 Associations => ArrayRef[L<Paws::SecurityHub::AwsEc2NetworkAclAssociation>]

Associations between the network ACL and subnets.


=head2 Entries => ArrayRef[L<Paws::SecurityHub::AwsEc2NetworkAclEntry>]

The set of rules in the network ACL.


=head2 IsDefault => Bool

Whether this is the default network ACL for the VPC.


=head2 NetworkAclId => Str

The identifier of the network ACL.


=head2 OwnerId => Str

The identifier of the AWS account that owns the network ACL.


=head2 VpcId => Str

The identifier of the VPC for the network ACL.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

