/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.MutationInfoWriter;
import org.couchbase.mock.memcached.MutationStatus;
import org.couchbase.mock.memcached.VBucketStore;
import org.couchbase.mock.memcached.protocol.BinaryArithmeticCommand;
import org.couchbase.mock.memcached.protocol.BinaryArithmeticResponse;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class ArithmeticCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) {
        block13: {
            long value;
            MutationInfoWriter miw;
            CommandCode cc;
            Item item;
            VBucketStore cache;
            BinaryArithmeticCommand cmd;
            block11: {
                block12: {
                    cmd = (BinaryArithmeticCommand)command;
                    cache = server.getStorage().getCache(server, cmd.getVBucketId());
                    item = cache.get(cmd.getKeySpec());
                    cc = cmd.getComCode();
                    miw = client.getMutinfoWriter();
                    if (item != null) break block11;
                    if (!cmd.create()) break block12;
                    item = new Item(cmd.getKeySpec(), 0, cmd.getExpiration(), Long.toString(cmd.getInitial()).getBytes(), 0L);
                    MutationStatus ms = cache.add(item);
                    ErrorCode err = ms.getStatus();
                    switch (err) {
                        case KEY_EEXISTS: {
                            this.execute(command, server, client);
                            break;
                        }
                        case SUCCESS: {
                            if (cc == CommandCode.INCREMENT || cc == CommandCode.DECREMENT) {
                                client.sendResponse(new BinaryArithmeticResponse(cmd, cmd.getInitial(), item.getCas(), ms, miw));
                                break;
                            }
                            break block13;
                        }
                        default: {
                            client.sendResponse(new BinaryResponse(command, err));
                            break;
                        }
                    }
                    break block13;
                }
                client.sendResponse(new BinaryResponse(command, ErrorCode.KEY_ENOENT));
                break block13;
            }
            if (!item.ensureUnlocked(command.getCas())) {
                client.sendResponse(new BinaryResponse(command, ErrorCode.ETMPFAIL));
                return;
            }
            try {
                value = Long.parseLong(new String(item.getValue()));
            }
            catch (NumberFormatException ex) {
                client.sendResponse(new BinaryResponse(command, ErrorCode.DELTA_BADVAL));
                return;
            }
            value = cc == CommandCode.INCREMENT || cc == CommandCode.INCREMENTQ ? (value += cmd.getDelta()) : (value -= cmd.getDelta());
            int exp = cmd.getExpiration() > 0 ? cmd.getExpiration() : item.getExpiryTime();
            Item newValue = new Item(cmd.getKeySpec(), item.getFlags(), exp, Long.toString(value).getBytes(), item.getCas());
            MutationStatus ms = cache.set(newValue);
            if (ms.getStatus() == ErrorCode.SUCCESS) {
                if (cc == CommandCode.INCREMENT || cc == CommandCode.DECREMENT) {
                    client.sendResponse(new BinaryArithmeticResponse(cmd, value, newValue.getCas(), ms, miw));
                }
            } else {
                client.sendResponse(new BinaryResponse(command, ms.getStatus()));
            }
        }
    }
}

