BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Env File::Copy File::Spec File::Temp Math::BigInt POSIX base bigint lib strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.62.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Alternate FFI::Raw implementation powered by FFI::Platypus",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Alien::libt2t"       => 0,
    "ExtUtils::MakeMaker" => 0,
    "FFI::Build::MM"      => "0.83"
  },
  "DISTNAME"         => "Alt-FFI-Raw-Platypus",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "Alt::FFI::Raw::Platypus",
  "PM"               => {
    "lib/Alt/FFI/Raw/Platypus.pm" => "\$(INST_LIB)/Alt/FFI/Raw/Platypus.pm",
    "lib/FFI/Raw.pm"              => "\$(INST_LIB)/FFI/Raw.pm",
    "lib/FFI/Raw/Callback.pm"     => "\$(INST_LIB)/FFI/Raw/Callback.pm",
    "lib/FFI/Raw/MemPtr.pm"       => "\$(INST_LIB)/FFI/Raw/MemPtr.pm",
    "lib/FFI/Raw/Ptr.pm"          => "\$(INST_LIB)/FFI/Raw/Ptr.pm"
  },
  "PREREQ_PM" => {
    "FFI::Platypus::Legacy::Raw" => 0
  },
  "TEST_REQUIRES" => {
    "Test2::Tools::FFI" => "0.04",
    "Test2::V0"         => "0.000060"
  },
  "VERSION" => "0.04",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::Platypus::Legacy::Raw" => 0,
  "Test2::Tools::FFI"          => "0.04",
  "Test2::V0"                  => "0.000060"
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM 0.83;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

# begin inserted by Dist::Zilla::Plugin::Alt 0.07
print "!!! This is an Alt:: distribution that will not actually install unless you !!!\n";
print "!!! set PERL_ALT_INSTALL=OVERWRITE.  See https://metacpan.org/pod/Alt       !!!\n";
my $alt = $ENV{PERL_ALT_INSTALL} || '';
$WriteMakefileArgs{DESTDIR} =
  $alt ? $alt eq 'OVERWRITE' ? '' : $alt : 'no-install-alt';
if ( $^O eq 'MSWin32' && $WriteMakefileArgs{DESTDIR} ) {

  # Windows is a precious snowflake that can't handle DESTDIR
  # Caveat: this probably ignores any PREFIX specified by the user
  require Config;
  require File::Spec;
  my @prefix = split /:/, $Config::Config{prefix};
  $WriteMakefileArgs{PREFIX} = File::Spec->catdir( $WriteMakefileArgs{DESTDIR}, @prefix );
  delete $WriteMakefileArgs{DESTDIR};

  # DO NOT DO THIS SORT OF THING
  # THIS IS PRETTY UGLY AND PROBABLY BAD
  # DO AS I SAY AND NOT AS I DO
  package
    ExtUtils::MM_Any;
  my $orig = \&init_INSTALL;
  *init_INSTALL = sub {
    my ( $self, @args ) = @_;
    delete $self->{ARGS}{INSTALL_BASE} if $self->{ARGS}{PREFIX};
    $self->$orig(@args);
  }
}

# end inserted by Dist::Zilla::Plugin::Alt 0.07
WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if ( my $old = MY->can('postamble') )
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
        "\n" .
        $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}

# END code inserted by Dist::Zilla::Plugin::FFI::Build