# Generated by default/object.tt
package Paws::SageMaker::ModelClientConfig;
  use Moose;
  has InvocationsMaxRetries => (is => 'ro', isa => 'Int');
  has InvocationsTimeoutInSeconds => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ModelClientConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ModelClientConfig object:

  $service_obj->Method(Att1 => { InvocationsMaxRetries => $value, ..., InvocationsTimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ModelClientConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->InvocationsMaxRetries

=head1 DESCRIPTION

Configures the timeout and maximum number of retries for processing a
transform job invocation.

=head1 ATTRIBUTES


=head2 InvocationsMaxRetries => Int

The maximum number of retries when invocation requests are failing.


=head2 InvocationsTimeoutInSeconds => Int

The timeout value in seconds for an invocation request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

