#
# $Id: Merge.pm,v cfbea05b0bc4 2025/01/28 15:06:19 gomor $
#
package OPP::Proc::Merge;
use strict;
use warnings;

use base qw(OPP::Proc);
__PACKAGE__->cgBuildIndices;

use Onyphe::Api;

our $VERSION = '1.00';

my $oa = Onyphe::Api->new->init or die("merge: init failed");
$oa->silent(1);
$oa->verbose(0);

#
# NOTE: this merge output result has precedence
#
# | merge category:datascan ip:$ip
#
sub process {
   my $self = shift;
   my ($input) = @_;

   my $options = $self->options;
   my $args = $options->{args};

   # Update place holders with found input values:
   my $searches = $self->placeholder($args, $input);

   my $cb = sub {
      my ($results) = @_;
      for my $r (@$results) {
         $r = $self->flatten($r);
         for (@$r) {
            my $merge = { %{$self->clone($input)}, %{$self->clone($_)} };
            $self->output->add($merge);
         }
      }
   };

   $oa->search($searches->[0], 1, 1, { trackquery => 'true' }, $cb);  # Use default callback

   return 1;
}

1;

__END__

=head1 NAME

OPP::Proc::Merge - ONYPHE Search API merging processor

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2025, ONYPHE SAS

You may distribute this module under the terms of The BSD 3-Clause License.
See LICENSE file in the source distribution archive.

=head1 AUTHOR

Patrice E<lt>GomoRE<gt> Auffret

=cut
