# Generated by default/object.tt
package Paws::SageMaker::SearchRecord;
  use Moose;
  has Endpoint => (is => 'ro', isa => 'Paws::SageMaker::Endpoint');
  has Experiment => (is => 'ro', isa => 'Paws::SageMaker::Experiment');
  has FeatureGroup => (is => 'ro', isa => 'Paws::SageMaker::FeatureGroup');
  has ModelPackage => (is => 'ro', isa => 'Paws::SageMaker::ModelPackage');
  has ModelPackageGroup => (is => 'ro', isa => 'Paws::SageMaker::ModelPackageGroup');
  has Pipeline => (is => 'ro', isa => 'Paws::SageMaker::Pipeline');
  has PipelineExecution => (is => 'ro', isa => 'Paws::SageMaker::PipelineExecution');
  has TrainingJob => (is => 'ro', isa => 'Paws::SageMaker::TrainingJob');
  has Trial => (is => 'ro', isa => 'Paws::SageMaker::Trial');
  has TrialComponent => (is => 'ro', isa => 'Paws::SageMaker::TrialComponent');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::SearchRecord

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::SearchRecord object:

  $service_obj->Method(Att1 => { Endpoint => $value, ..., TrialComponent => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::SearchRecord object:

  $result = $service_obj->Method(...);
  $result->Att1->Endpoint

=head1 DESCRIPTION

A single resource returned as part of the Search API response.

=head1 ATTRIBUTES


=head2 Endpoint => L<Paws::SageMaker::Endpoint>




=head2 Experiment => L<Paws::SageMaker::Experiment>

The properties of an experiment.


=head2 FeatureGroup => L<Paws::SageMaker::FeatureGroup>




=head2 ModelPackage => L<Paws::SageMaker::ModelPackage>




=head2 ModelPackageGroup => L<Paws::SageMaker::ModelPackageGroup>




=head2 Pipeline => L<Paws::SageMaker::Pipeline>




=head2 PipelineExecution => L<Paws::SageMaker::PipelineExecution>




=head2 TrainingJob => L<Paws::SageMaker::TrainingJob>

The properties of a training job.


=head2 Trial => L<Paws::SageMaker::Trial>

The properties of a trial.


=head2 TrialComponent => L<Paws::SageMaker::TrialComponent>

The properties of a trial component.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

