#!/usr/bin/perl

package eBay::API::XML::DataType::BiddingSummaryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BiddingSummaryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BiddingSummaryType

=head1 DESCRIPTION

Contains bidding summary information for the bidder of an item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BiddingSummaryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemBidDetailsType;


my @gaProperties = ( [ 'BidActivityWithSeller', 'xs:int', '', '', '' ]
	, [ 'BidRetractions', 'xs:int', '', '', '' ]
	, [ 'BidsToUniqueCategories', 'xs:int', '', '', '' ]
	, [ 'BidsToUniqueSellers', 'xs:int', '', '', '' ]
	, [ 'ItemBidDetails', 'ns:ItemBidDetailsType', '1'
	     ,'eBay::API::XML::DataType::ItemBidDetailsType', '1' ]
	, [ 'SummaryDays', 'xs:int', '', '', '' ]
	, [ 'TotalBids', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidActivityWithSeller()

Percentage of the bidder's total bids that the bidder
placed on items that the seller is offering.

#    Argument: 'xs:int'

=cut

sub setBidActivityWithSeller {
  my $self = shift;
  $self->{'BidActivityWithSeller'} = shift
}

=head2 getBidActivityWithSeller()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getBidActivityWithSeller {
  my $self = shift;
  return $self->{'BidActivityWithSeller'};
}


=head2 setBidRetractions()

The total number of bids that the bidder has retracted.

#    Argument: 'xs:int'

=cut

sub setBidRetractions {
  my $self = shift;
  $self->{'BidRetractions'} = shift
}

=head2 getBidRetractions()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getBidRetractions {
  my $self = shift;
  return $self->{'BidRetractions'};
}


=head2 setBidsToUniqueCategories()

For items that the bidder has bid on, the number of unique
categories that they belong to.

#    Argument: 'xs:int'

=cut

sub setBidsToUniqueCategories {
  my $self = shift;
  $self->{'BidsToUniqueCategories'} = shift
}

=head2 getBidsToUniqueCategories()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getBidsToUniqueCategories {
  my $self = shift;
  return $self->{'BidsToUniqueCategories'};
}


=head2 setBidsToUniqueSellers()

Number of unique sellers whose items the bidder has placed
bids on.

#    Argument: 'xs:int'

=cut

sub setBidsToUniqueSellers {
  my $self = shift;
  $self->{'BidsToUniqueSellers'} = shift
}

=head2 getBidsToUniqueSellers()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getBidsToUniqueSellers {
  my $self = shift;
  return $self->{'BidsToUniqueSellers'};
}


=head2 setItemBidDetails()

Detail bidding information on the items that the bidder has
bid on.

#    Argument: reference to an array  
                      of 'ns:ItemBidDetailsType'

=cut

sub setItemBidDetails {
  my $self = shift;
  $self->{'ItemBidDetails'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getItemBidDetails()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ItemBidDetailsType'

=cut

sub getItemBidDetails {
  my $self = shift;
  return $self->_getDataTypeArray('ItemBidDetails');
}


=head2 setSummaryDays()

The number of days included in the summary. Currently always
set to 30 days.

#    Argument: 'xs:int'

=cut

sub setSummaryDays {
  my $self = shift;
  $self->{'SummaryDays'} = shift
}

=head2 getSummaryDays()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getSummaryDays {
  my $self = shift;
  return $self->{'SummaryDays'};
}


=head2 setTotalBids()

The total number of bids that the bidder has placed.

#    Argument: 'xs:int'

=cut

sub setTotalBids {
  my $self = shift;
  $self->{'TotalBids'} = shift
}

=head2 getTotalBids()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getTotalBids {
  my $self = shift;
  return $self->{'TotalBids'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
