# Generated by default/object.tt
package Paws::SecurityHub::AwsElasticsearchDomainVPCOptions;
  use Moose;
  has AvailabilityZones => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has VPCId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElasticsearchDomainVPCOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElasticsearchDomainVPCOptions object:

  $service_obj->Method(Att1 => { AvailabilityZones => $value, ..., VPCId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElasticsearchDomainVPCOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailabilityZones

=head1 DESCRIPTION

Information that Amazon ES derives based on C<VPCOptions> for the
domain.

=head1 ATTRIBUTES


=head2 AvailabilityZones => ArrayRef[Str|Undef]

The list of Availability Zones associated with the VPC subnets.


=head2 SecurityGroupIds => ArrayRef[Str|Undef]

The list of security group IDs associated with the VPC endpoints for
the domain.


=head2 SubnetIds => ArrayRef[Str|Undef]

A list of subnet IDs associated with the VPC endpoints for the domain.


=head2 VPCId => Str

ID for the VPC.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

