# $Id: Table.pm,v 1.1 2010/11/20 20:38:51 Paulo Exp $
# file generated by build_Table.pl, do not edit

package Asm::Z80::Table;

#------------------------------------------------------------------------------

=head1 NAME

Asm::Z80::Table - Z80 assembly / disassembly tables

=cut

#------------------------------------------------------------------------------

use strict;
use warnings;

our $VERSION = '0.01';

#------------------------------------------------------------------------------

=head1 SYNOPSIS

  use Asm::Z80::Table;
  Asm::Z80::Table->asm_table->{'adc'}{'a'}{','}{'('}{'hl'}{')'}{''} is [0x8E]
  Asm::Z80::Table->disasm_table->{0x8E}{''} is ['adc', 'a', ',', '(', 'hl', ')']
  my $iter = Asm::Z80::Table->iterator;
  my($tokens, $bytes) = $iter->();

=cut

#------------------------------------------------------------------------------

my $asm_table    = {
  'adc' => {
    'a' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x8E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x8E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x8E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x8E,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x8E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x8E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x8E,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0xCE,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x8F
          ]
        },
        'b' => {
          '' => [
            0x88
          ]
        },
        'c' => {
          '' => [
            0x89
          ]
        },
        'd' => {
          '' => [
            0x8A
          ]
        },
        'e' => {
          '' => [
            0x8B
          ]
        },
        'h' => {
          '' => [
            0x8C
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x8C
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x8D
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x8C
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x8D
          ]
        },
        'l' => {
          '' => [
            0x8D
          ]
        }
      }
    },
    'hl' => {
      ',' => {
        'bc' => {
          '' => [
            0xED,
            0x4A
          ]
        },
        'de' => {
          '' => [
            0xED,
            0x5A
          ]
        },
        'hl' => {
          '' => [
            0xED,
            0x6A
          ]
        },
        'sp' => {
          '' => [
            0xED,
            0x7A
          ]
        }
      }
    }
  },
  'add' => {
    'a' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x86
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x86,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x86,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x86,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x86,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x86,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x86,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0xC6,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x87
          ]
        },
        'b' => {
          '' => [
            0x80
          ]
        },
        'c' => {
          '' => [
            0x81
          ]
        },
        'd' => {
          '' => [
            0x82
          ]
        },
        'e' => {
          '' => [
            0x83
          ]
        },
        'h' => {
          '' => [
            0x84
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x84
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x85
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x84
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x85
          ]
        },
        'l' => {
          '' => [
            0x85
          ]
        }
      }
    },
    'hl' => {
      ',' => {
        'bc' => {
          '' => [
            0x09
          ]
        },
        'de' => {
          '' => [
            0x19
          ]
        },
        'hl' => {
          '' => [
            0x29
          ]
        },
        'sp' => {
          '' => [
            0x39
          ]
        }
      }
    },
    'ix' => {
      ',' => {
        'bc' => {
          '' => [
            0xDD,
            0x09
          ]
        },
        'de' => {
          '' => [
            0xDD,
            0x19
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0x29
          ]
        },
        'sp' => {
          '' => [
            0xDD,
            0x39
          ]
        }
      }
    },
    'iy' => {
      ',' => {
        'bc' => {
          '' => [
            0xFD,
            0x09
          ]
        },
        'de' => {
          '' => [
            0xFD,
            0x19
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0x29
          ]
        },
        'sp' => {
          '' => [
            0xFD,
            0x39
          ]
        }
      }
    }
  },
  'and' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xA6
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xA6,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xA6,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xA6,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xA6,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xA6,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xA6,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'N' => {
      '' => [
        0xE6,
        'N'
      ]
    },
    'a' => {
      '' => [
        0xA7
      ]
    },
    'b' => {
      '' => [
        0xA0
      ]
    },
    'c' => {
      '' => [
        0xA1
      ]
    },
    'd' => {
      '' => [
        0xA2
      ]
    },
    'e' => {
      '' => [
        0xA3
      ]
    },
    'h' => {
      '' => [
        0xA4
      ]
    },
    'ixh' => {
      '' => [
        0xDD,
        0xA4
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0xA5
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0xA4
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0xA5
      ]
    },
    'l' => {
      '' => [
        0xA5
      ]
    }
  },
  'bit' => {
    0x00 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x46
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x46
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x46
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x46
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x46
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x46
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x46
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x47
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x40
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x41
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x42
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x43
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x44
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x45
          ]
        }
      }
    },
    0x01 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x4E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x4E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x4E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x4E
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x4E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x4E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x4E
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x4F
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x48
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x49
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x4A
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x4B
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x4C
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x4D
          ]
        }
      }
    },
    0x02 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x56
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x56
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x56
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x56
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x56
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x56
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x56
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x57
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x50
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x51
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x52
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x53
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x54
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x55
          ]
        }
      }
    },
    0x03 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x5E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x5E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x5E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x5E
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x5E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x5E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x5E
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x5F
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x58
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x59
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x5A
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x5B
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x5C
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x5D
          ]
        }
      }
    },
    0x04 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x66
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x66
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x66
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x66
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x66
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x66
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x66
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x67
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x60
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x61
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x62
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x63
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x64
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x65
          ]
        }
      }
    },
    0x05 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x6E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x6E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x6E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x6E
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x6E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x6E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x6E
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x6F
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x68
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x69
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x6A
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x6B
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x6C
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x6D
          ]
        }
      }
    },
    0x06 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x76
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x76
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x76
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x76
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x76
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x76
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x76
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x77
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x70
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x71
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x72
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x73
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x74
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x75
          ]
        }
      }
    },
    0x07 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x7E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x7E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x7E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x7E
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x7E
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x7E
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x7E
                  ]
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x7F
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x78
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x79
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x7A
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x7B
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x7C
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x7D
          ]
        }
      }
    }
  },
  'call' => {
    'NN' => {
      '' => [
        0xCD,
        'NNl',
        'NNh'
      ]
    },
    'c' => {
      ',' => {
        'NN' => {
          '' => [
            0xDC,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'm' => {
      ',' => {
        'NN' => {
          '' => [
            0xFC,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'nc' => {
      ',' => {
        'NN' => {
          '' => [
            0xD4,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'nz' => {
      ',' => {
        'NN' => {
          '' => [
            0xC4,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'p' => {
      ',' => {
        'NN' => {
          '' => [
            0xF4,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'pe' => {
      ',' => {
        'NN' => {
          '' => [
            0xEC,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'po' => {
      ',' => {
        'NN' => {
          '' => [
            0xE4,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'z' => {
      ',' => {
        'NN' => {
          '' => [
            0xCC,
            'NNl',
            'NNh'
          ]
        }
      }
    }
  },
  'ccf' => {
    '' => [
      0x3F
    ]
  },
  'cp' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xBE
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xBE,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xBE,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xBE,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xBE,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xBE,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xBE,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'N' => {
      '' => [
        0xFE,
        'N'
      ]
    },
    'a' => {
      '' => [
        0xBF
      ]
    },
    'b' => {
      '' => [
        0xB8
      ]
    },
    'c' => {
      '' => [
        0xB9
      ]
    },
    'd' => {
      '' => [
        0xBA
      ]
    },
    'e' => {
      '' => [
        0xBB
      ]
    },
    'h' => {
      '' => [
        0xBC
      ]
    },
    'ixh' => {
      '' => [
        0xDD,
        0xBC
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0xBD
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0xBC
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0xBD
      ]
    },
    'l' => {
      '' => [
        0xBD
      ]
    }
  },
  'cpd' => {
    '' => [
      0xED,
      0xA9
    ]
  },
  'cpdr' => {
    '' => [
      0xED,
      0xB9
    ]
  },
  'cpi' => {
    '' => [
      0xED,
      0xA1
    ]
  },
  'cpir' => {
    '' => [
      0xED,
      0xB1
    ]
  },
  'cpl' => {
    '' => [
      0x2F
    ]
  },
  'daa' => {
    '' => [
      0x27
    ]
  },
  'dec' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0x35
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0x35,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0x35,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0x35,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0x35,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0x35,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0x35,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0x3D
      ]
    },
    'b' => {
      '' => [
        0x05
      ]
    },
    'bc' => {
      '' => [
        0x0B
      ]
    },
    'c' => {
      '' => [
        0x0D
      ]
    },
    'd' => {
      '' => [
        0x15
      ]
    },
    'de' => {
      '' => [
        0x1B
      ]
    },
    'e' => {
      '' => [
        0x1D
      ]
    },
    'h' => {
      '' => [
        0x25
      ]
    },
    'hl' => {
      '' => [
        0x2B
      ]
    },
    'ix' => {
      '' => [
        0xDD,
        0x2B
      ]
    },
    'ixh' => {
      '' => [
        0xDD,
        0x25
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0x2D
      ]
    },
    'iy' => {
      '' => [
        0xFD,
        0x2B
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0x25
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0x2D
      ]
    },
    'l' => {
      '' => [
        0x2D
      ]
    },
    'sp' => {
      '' => [
        0x3B
      ]
    }
  },
  'di' => {
    '' => [
      0xF3
    ]
  },
  'djnz' => {
    'NN' => {
      '' => [
        0x10,
        'NNo'
      ]
    }
  },
  'ei' => {
    '' => [
      0xFB
    ]
  },
  'ex' => {
    '(' => {
      'sp' => {
        ')' => {
          ',' => {
            'hl' => {
              '' => [
                0xE3
              ]
            },
            'ix' => {
              '' => [
                0xDD,
                0xE3
              ]
            },
            'iy' => {
              '' => [
                0xFD,
                0xE3
              ]
            }
          }
        }
      }
    },
    'af' => {
      ',' => {
        'af\'' => {
          '' => [
            0x08
          ]
        }
      }
    },
    'de' => {
      ',' => {
        'hl' => {
          '' => [
            0xEB
          ]
        }
      }
    }
  },
  'exx' => {
    '' => [
      0xD9
    ]
  },
  'halt' => {
    '' => [
      0x76
    ]
  },
  'im' => {
    0x00 => {
      '' => [
        0xED,
        0x46
      ]
    },
    0x01 => {
      '' => [
        0xED,
        0x56
      ]
    },
    0x02 => {
      '' => [
        0xED,
        0x5E
      ]
    }
  },
  'in' => {
    'a' => {
      ',' => {
        '(' => {
          'N' => {
            ')' => {
              '' => [
                0xDB,
                'N'
              ]
            }
          },
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x78
              ]
            }
          }
        }
      }
    },
    'b' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x40
              ]
            }
          }
        }
      }
    },
    'c' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x48
              ]
            }
          }
        }
      }
    },
    'd' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x50
              ]
            }
          }
        }
      }
    },
    'e' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x58
              ]
            }
          }
        }
      }
    },
    'f' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x70
              ]
            }
          }
        }
      }
    },
    'h' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x60
              ]
            }
          }
        }
      }
    },
    'l' => {
      ',' => {
        '(' => {
          'c' => {
            ')' => {
              '' => [
                0xED,
                0x68
              ]
            }
          }
        }
      }
    }
  },
  'inc' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0x34
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0x34,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0x34,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0x34,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0x34,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0x34,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0x34,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0x3C
      ]
    },
    'b' => {
      '' => [
        0x04
      ]
    },
    'bc' => {
      '' => [
        0x03
      ]
    },
    'c' => {
      '' => [
        0x0C
      ]
    },
    'd' => {
      '' => [
        0x14
      ]
    },
    'de' => {
      '' => [
        0x13
      ]
    },
    'e' => {
      '' => [
        0x1C
      ]
    },
    'h' => {
      '' => [
        0x24
      ]
    },
    'hl' => {
      '' => [
        0x23
      ]
    },
    'ix' => {
      '' => [
        0xDD,
        0x23
      ]
    },
    'ixh' => {
      '' => [
        0xDD,
        0x24
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0x2C
      ]
    },
    'iy' => {
      '' => [
        0xFD,
        0x23
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0x24
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0x2C
      ]
    },
    'l' => {
      '' => [
        0x2C
      ]
    },
    'sp' => {
      '' => [
        0x33
      ]
    }
  },
  'ind' => {
    '' => [
      0xED,
      0xAA
    ]
  },
  'indr' => {
    '' => [
      0xED,
      0xBA
    ]
  },
  'ini' => {
    '' => [
      0xED,
      0xA2
    ]
  },
  'inir' => {
    '' => [
      0xED,
      0xB2
    ]
  },
  'jp' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xE9
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xE9
          ]
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xE9
          ]
        }
      }
    },
    'NN' => {
      '' => [
        0xC3,
        'NNl',
        'NNh'
      ]
    },
    'c' => {
      ',' => {
        'NN' => {
          '' => [
            0xDA,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'm' => {
      ',' => {
        'NN' => {
          '' => [
            0xFA,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'nc' => {
      ',' => {
        'NN' => {
          '' => [
            0xD2,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'nz' => {
      ',' => {
        'NN' => {
          '' => [
            0xC2,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'p' => {
      ',' => {
        'NN' => {
          '' => [
            0xF2,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'pe' => {
      ',' => {
        'NN' => {
          '' => [
            0xEA,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'po' => {
      ',' => {
        'NN' => {
          '' => [
            0xE2,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'z' => {
      ',' => {
        'NN' => {
          '' => [
            0xCA,
            'NNl',
            'NNh'
          ]
        }
      }
    }
  },
  'jr' => {
    'NN' => {
      '' => [
        0x18,
        'NNo'
      ]
    },
    'c' => {
      ',' => {
        'NN' => {
          '' => [
            0x38,
            'NNo'
          ]
        }
      }
    },
    'm' => {
      ',' => {
        'NN' => {
          '' => [
            0xFA,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'nc' => {
      ',' => {
        'NN' => {
          '' => [
            0x30,
            'NNo'
          ]
        }
      }
    },
    'nz' => {
      ',' => {
        'NN' => {
          '' => [
            0x20,
            'NNo'
          ]
        }
      }
    },
    'p' => {
      ',' => {
        'NN' => {
          '' => [
            0xF2,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'pe' => {
      ',' => {
        'NN' => {
          '' => [
            0xEA,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'po' => {
      ',' => {
        'NN' => {
          '' => [
            0xE2,
            'NNl',
            'NNh'
          ]
        }
      }
    },
    'z' => {
      ',' => {
        'NN' => {
          '' => [
            0x28,
            'NNo'
          ]
        }
      }
    }
  },
  'ld' => {
    '(' => {
      'NN' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x32,
                'NNl',
                'NNh'
              ]
            },
            'bc' => {
              '' => [
                0xED,
                0x43,
                'NNl',
                'NNh'
              ]
            },
            'de' => {
              '' => [
                0xED,
                0x53,
                'NNl',
                'NNh'
              ]
            },
            'hl' => {
              '' => [
                0x22,
                'NNl',
                'NNh'
              ]
            },
            'ix' => {
              '' => [
                0xDD,
                0x22,
                'NNl',
                'NNh'
              ]
            },
            'iy' => {
              '' => [
                0xFD,
                0x22,
                'NNl',
                'NNh'
              ]
            },
            'sp' => {
              '' => [
                0xED,
                0x73,
                'NNl',
                'NNh'
              ]
            }
          }
        }
      },
      'bc' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x02
              ]
            }
          }
        }
      },
      'de' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x12
              ]
            }
          }
        }
      },
      'hl' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0x36,
                'N'
              ]
            },
            'a' => {
              '' => [
                0x77
              ]
            },
            'b' => {
              '' => [
                0x70
              ]
            },
            'bc' => {
              '' => [
                0x71,
                0x23,
                0x70,
                0x2B
              ]
            },
            'c' => {
              '' => [
                0x71
              ]
            },
            'd' => {
              '' => [
                0x72
              ]
            },
            'de' => {
              '' => [
                0x73,
                0x23,
                0x72,
                0x2B
              ]
            },
            'e' => {
              '' => [
                0x73
              ]
            },
            'h' => {
              '' => [
                0x74
              ]
            },
            'l' => {
              '' => [
                0x75
              ]
            }
          }
        }
      },
      'ix' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0xDD,
                0x36,
                0x00,
                'N'
              ]
            },
            'a' => {
              '' => [
                0xDD,
                0x77,
                0x00
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0x70,
                0x00
              ]
            },
            'bc' => {
              '' => [
                0xDD,
                0x71,
                0x00,
                0xDD,
                0x70,
                0x01
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0x71,
                0x00
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0x72,
                0x00
              ]
            },
            'de' => {
              '' => [
                0xDD,
                0x73,
                0x00,
                0xDD,
                0x72,
                0x01
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0x73,
                0x00
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0x74,
                0x00
              ]
            },
            'hl' => {
              '' => [
                0xDD,
                0x75,
                0x00,
                0xDD,
                0x74,
                0x01
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0x75,
                0x00
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xDD,
                    0x36,
                    'DIS',
                    'N'
                  ]
                },
                'a' => {
                  '' => [
                    0xDD,
                    0x77,
                    'DIS'
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0x70,
                    'DIS'
                  ]
                },
                'bc' => {
                  '' => [
                    0xDD,
                    0x71,
                    'DIS',
                    0xDD,
                    0x70,
                    'DIS+1'
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0x71,
                    'DIS'
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0x72,
                    'DIS'
                  ]
                },
                'de' => {
                  '' => [
                    0xDD,
                    0x73,
                    'DIS',
                    0xDD,
                    0x72,
                    'DIS+1'
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0x73,
                    'DIS'
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0x74,
                    'DIS'
                  ]
                },
                'hl' => {
                  '' => [
                    0xDD,
                    0x75,
                    'DIS',
                    0xDD,
                    0x74,
                    'DIS+1'
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0x75,
                    'DIS'
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xDD,
                    0x36,
                    'NDIS',
                    'N'
                  ]
                },
                'a' => {
                  '' => [
                    0xDD,
                    0x77,
                    'NDIS'
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0x70,
                    'NDIS'
                  ]
                },
                'bc' => {
                  '' => [
                    0xDD,
                    0x71,
                    'NDIS',
                    0xDD,
                    0x70,
                    'NDIS+1'
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0x71,
                    'NDIS'
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0x72,
                    'NDIS'
                  ]
                },
                'de' => {
                  '' => [
                    0xDD,
                    0x73,
                    'NDIS',
                    0xDD,
                    0x72,
                    'NDIS+1'
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0x73,
                    'NDIS'
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0x74,
                    'NDIS'
                  ]
                },
                'hl' => {
                  '' => [
                    0xDD,
                    0x75,
                    'NDIS',
                    0xDD,
                    0x74,
                    'NDIS+1'
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0x75,
                    'NDIS'
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0xFD,
                0x36,
                0x00,
                'N'
              ]
            },
            'a' => {
              '' => [
                0xFD,
                0x77,
                0x00
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0x70,
                0x00
              ]
            },
            'bc' => {
              '' => [
                0xFD,
                0x71,
                0x00,
                0xFD,
                0x70,
                0x01
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0x71,
                0x00
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0x72,
                0x00
              ]
            },
            'de' => {
              '' => [
                0xFD,
                0x73,
                0x00,
                0xFD,
                0x72,
                0x01
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0x73,
                0x00
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0x74,
                0x00
              ]
            },
            'hl' => {
              '' => [
                0xFD,
                0x75,
                0x00,
                0xFD,
                0x74,
                0x01
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0x75,
                0x00
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xFD,
                    0x36,
                    'DIS',
                    'N'
                  ]
                },
                'a' => {
                  '' => [
                    0xFD,
                    0x77,
                    'DIS'
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0x70,
                    'DIS'
                  ]
                },
                'bc' => {
                  '' => [
                    0xFD,
                    0x71,
                    'DIS',
                    0xFD,
                    0x70,
                    'DIS+1'
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0x71,
                    'DIS'
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0x72,
                    'DIS'
                  ]
                },
                'de' => {
                  '' => [
                    0xFD,
                    0x73,
                    'DIS',
                    0xFD,
                    0x72,
                    'DIS+1'
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0x73,
                    'DIS'
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0x74,
                    'DIS'
                  ]
                },
                'hl' => {
                  '' => [
                    0xFD,
                    0x75,
                    'DIS',
                    0xFD,
                    0x74,
                    'DIS+1'
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0x75,
                    'DIS'
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xFD,
                    0x36,
                    'NDIS',
                    'N'
                  ]
                },
                'a' => {
                  '' => [
                    0xFD,
                    0x77,
                    'NDIS'
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0x70,
                    'NDIS'
                  ]
                },
                'bc' => {
                  '' => [
                    0xFD,
                    0x71,
                    'NDIS',
                    0xFD,
                    0x70,
                    'NDIS+1'
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0x71,
                    'NDIS'
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0x72,
                    'NDIS'
                  ]
                },
                'de' => {
                  '' => [
                    0xFD,
                    0x73,
                    'NDIS',
                    0xFD,
                    0x72,
                    'NDIS+1'
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0x73,
                    'NDIS'
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0x74,
                    'NDIS'
                  ]
                },
                'hl' => {
                  '' => [
                    0xFD,
                    0x75,
                    'NDIS',
                    0xFD,
                    0x74,
                    'NDIS+1'
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0x75,
                    'NDIS'
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0x3A,
                'NNl',
                'NNh'
              ]
            }
          },
          'bc' => {
            ')' => {
              '' => [
                0x0A
              ]
            }
          },
          'de' => {
            ')' => {
              '' => [
                0x1A
              ]
            }
          },
          'hl' => {
            ')' => {
              '' => [
                0x7E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x7E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x7E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x7E,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x7E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x7E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x7E,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x3E,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x7F
          ]
        },
        'b' => {
          '' => [
            0x78
          ]
        },
        'c' => {
          '' => [
            0x79
          ]
        },
        'd' => {
          '' => [
            0x7A
          ]
        },
        'e' => {
          '' => [
            0x7B
          ]
        },
        'h' => {
          '' => [
            0x7C
          ]
        },
        'i' => {
          '' => [
            0xED,
            0x57
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x7C
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x7D
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x7C
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x7D
          ]
        },
        'l' => {
          '' => [
            0x7D
          ]
        },
        'r' => {
          '' => [
            0xED,
            0x5F
          ]
        }
      }
    },
    'b' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x46
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x46,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x46,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x46,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x46,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x46,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x46,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x06,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x47
          ]
        },
        'b' => {
          '' => [
            0x40
          ]
        },
        'c' => {
          '' => [
            0x41
          ]
        },
        'd' => {
          '' => [
            0x42
          ]
        },
        'e' => {
          '' => [
            0x43
          ]
        },
        'h' => {
          '' => [
            0x44
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x44
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x45
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x44
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x45
          ]
        },
        'l' => {
          '' => [
            0x45
          ]
        }
      }
    },
    'bc' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0xED,
                0x4B,
                'NNl',
                'NNh'
              ]
            }
          },
          'hl' => {
            ')' => {
              '' => [
                0x4E,
                0x23,
                0x46,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x4E,
                0x00,
                0xDD,
                0x46,
                0x01
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'DIS',
                    0xDD,
                    0x46,
                    'DIS+1'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'NDIS',
                    0xDD,
                    0x46,
                    'NDIS+1'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x4E,
                0x00,
                0xFD,
                0x46,
                0x01
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'DIS',
                    0xFD,
                    0x46,
                    'DIS+1'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'NDIS',
                    0xFD,
                    0x46,
                    'NDIS+1'
                  ]
                }
              }
            }
          }
        },
        'NN' => {
          '' => [
            0x01,
            'NNl',
            'NNh'
          ]
        },
        'bc' => {
          '' => [
            0x40,
            0x49
          ]
        },
        'de' => {
          '' => [
            0x42,
            0x4B
          ]
        },
        'hl' => {
          '' => [
            0x44,
            0x4D
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0x44,
            0xDD,
            0x4D
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0x44,
            0xFD,
            0x4D
          ]
        }
      }
    },
    'c' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x4E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x4E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x4E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x0E,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x4F
          ]
        },
        'b' => {
          '' => [
            0x48
          ]
        },
        'c' => {
          '' => [
            0x49
          ]
        },
        'd' => {
          '' => [
            0x4A
          ]
        },
        'e' => {
          '' => [
            0x4B
          ]
        },
        'h' => {
          '' => [
            0x4C
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x4C
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x4D
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x4C
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x4D
          ]
        },
        'l' => {
          '' => [
            0x4D
          ]
        }
      }
    },
    'd' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x56
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x56,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x56,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x56,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x56,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x56,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x56,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x16,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x57
          ]
        },
        'b' => {
          '' => [
            0x50
          ]
        },
        'c' => {
          '' => [
            0x51
          ]
        },
        'd' => {
          '' => [
            0x52
          ]
        },
        'e' => {
          '' => [
            0x53
          ]
        },
        'h' => {
          '' => [
            0x54
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x54
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x55
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x54
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x55
          ]
        },
        'l' => {
          '' => [
            0x55
          ]
        }
      }
    },
    'de' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0xED,
                0x5B,
                'NNl',
                'NNh'
              ]
            }
          },
          'hl' => {
            ')' => {
              '' => [
                0x5E,
                0x23,
                0x56,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x5E,
                0x00,
                0xDD,
                0x56,
                0x01
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'DIS',
                    0xDD,
                    0x56,
                    'DIS+1'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'NDIS',
                    0xDD,
                    0x56,
                    'NDIS+1'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x5E,
                0x00,
                0xFD,
                0x56,
                0x01
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'DIS',
                    0xFD,
                    0x56,
                    'DIS+1'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'NDIS',
                    0xFD,
                    0x56,
                    'NDIS+1'
                  ]
                }
              }
            }
          }
        },
        'NN' => {
          '' => [
            0x11,
            'NNl',
            'NNh'
          ]
        },
        'bc' => {
          '' => [
            0x50,
            0x59
          ]
        },
        'de' => {
          '' => [
            0x52,
            0x5B
          ]
        },
        'hl' => {
          '' => [
            0x54,
            0x5D
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0x54,
            0xDD,
            0x5D
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0x54,
            0xFD,
            0x5D
          ]
        }
      }
    },
    'e' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x5E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x5E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x5E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x1E,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x5F
          ]
        },
        'b' => {
          '' => [
            0x58
          ]
        },
        'c' => {
          '' => [
            0x59
          ]
        },
        'd' => {
          '' => [
            0x5A
          ]
        },
        'e' => {
          '' => [
            0x5B
          ]
        },
        'h' => {
          '' => [
            0x5C
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x5C
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x5D
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x5C
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x5D
          ]
        },
        'l' => {
          '' => [
            0x5D
          ]
        }
      }
    },
    'h' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x66
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x66,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x66,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x66,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x66,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x66,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x66,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x26,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x67
          ]
        },
        'b' => {
          '' => [
            0x60
          ]
        },
        'c' => {
          '' => [
            0x61
          ]
        },
        'd' => {
          '' => [
            0x62
          ]
        },
        'e' => {
          '' => [
            0x63
          ]
        },
        'h' => {
          '' => [
            0x64
          ]
        },
        'l' => {
          '' => [
            0x65
          ]
        }
      }
    },
    'hl' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0x2A,
                'NNl',
                'NNh'
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x6E,
                0x00,
                0xDD,
                0x66,
                0x01
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'DIS',
                    0xDD,
                    0x66,
                    'DIS+1'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'NDIS',
                    0xDD,
                    0x66,
                    'NDIS+1'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x6E,
                0x00,
                0xFD,
                0x66,
                0x01
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'DIS',
                    0xFD,
                    0x66,
                    'DIS+1'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'NDIS',
                    0xFD,
                    0x66,
                    'NDIS+1'
                  ]
                }
              }
            }
          }
        },
        'NN' => {
          '' => [
            0x21,
            'NNl',
            'NNh'
          ]
        },
        'bc' => {
          '' => [
            0x60,
            0x69
          ]
        },
        'de' => {
          '' => [
            0x62,
            0x6B
          ]
        },
        'hl' => {
          '' => [
            0x64,
            0x6D
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0xE5,
            0xE1
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0xE5,
            0xE1
          ]
        }
      }
    },
    'i' => {
      ',' => {
        'a' => {
          '' => [
            0xED,
            0x47
          ]
        }
      }
    },
    'ix' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0xDD,
                0x2A,
                'NNl',
                'NNh'
              ]
            }
          }
        },
        'NN' => {
          '' => [
            0xDD,
            0x21,
            'NNl',
            'NNh'
          ]
        },
        'bc' => {
          '' => [
            0xDD,
            0x69,
            0xDD,
            0x60
          ]
        },
        'de' => {
          '' => [
            0xDD,
            0x6B,
            0xDD,
            0x62
          ]
        },
        'hl' => {
          '' => [
            0xE5,
            0xDD,
            0xE1
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0x6D,
            0xDD,
            0x64
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0xE5,
            0xDD,
            0xE1
          ]
        }
      }
    },
    'ixh' => {
      ',' => {
        'N' => {
          '' => [
            0xDD,
            0x26,
            'N'
          ]
        },
        'a' => {
          '' => [
            0xDD,
            0x67
          ]
        },
        'b' => {
          '' => [
            0xDD,
            0x60
          ]
        },
        'c' => {
          '' => [
            0xDD,
            0x61
          ]
        },
        'd' => {
          '' => [
            0xDD,
            0x62
          ]
        },
        'e' => {
          '' => [
            0xDD,
            0x63
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x64
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x65
          ]
        }
      }
    },
    'ixl' => {
      ',' => {
        'N' => {
          '' => [
            0xDD,
            0x2E,
            'N'
          ]
        },
        'a' => {
          '' => [
            0xDD,
            0x6F
          ]
        },
        'b' => {
          '' => [
            0xDD,
            0x68
          ]
        },
        'c' => {
          '' => [
            0xDD,
            0x69
          ]
        },
        'd' => {
          '' => [
            0xDD,
            0x6A
          ]
        },
        'e' => {
          '' => [
            0xDD,
            0x6B
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x6C
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x6D
          ]
        }
      }
    },
    'iy' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0xFD,
                0x2A,
                'NNl',
                'NNh'
              ]
            }
          }
        },
        'NN' => {
          '' => [
            0xFD,
            0x21,
            'NNl',
            'NNh'
          ]
        },
        'bc' => {
          '' => [
            0xFD,
            0x69,
            0xFD,
            0x60
          ]
        },
        'de' => {
          '' => [
            0xFD,
            0x6B,
            0xFD,
            0x62
          ]
        },
        'hl' => {
          '' => [
            0xE5,
            0xFD,
            0xE1
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0xE5,
            0xFD,
            0xE1
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0x6D,
            0xFD,
            0x64
          ]
        }
      }
    },
    'iyh' => {
      ',' => {
        'N' => {
          '' => [
            0xFD,
            0x26,
            'N'
          ]
        },
        'a' => {
          '' => [
            0xFD,
            0x67
          ]
        },
        'b' => {
          '' => [
            0xFD,
            0x60
          ]
        },
        'c' => {
          '' => [
            0xFD,
            0x61
          ]
        },
        'd' => {
          '' => [
            0xFD,
            0x62
          ]
        },
        'e' => {
          '' => [
            0xFD,
            0x63
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x64
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x65
          ]
        }
      }
    },
    'iyl' => {
      ',' => {
        'N' => {
          '' => [
            0xFD,
            0x2E,
            'N'
          ]
        },
        'a' => {
          '' => [
            0xFD,
            0x6F
          ]
        },
        'b' => {
          '' => [
            0xFD,
            0x68
          ]
        },
        'c' => {
          '' => [
            0xFD,
            0x69
          ]
        },
        'd' => {
          '' => [
            0xFD,
            0x6A
          ]
        },
        'e' => {
          '' => [
            0xFD,
            0x6B
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x6C
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x6D
          ]
        }
      }
    },
    'l' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x6E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x6E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x6E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0x2E,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x6F
          ]
        },
        'b' => {
          '' => [
            0x68
          ]
        },
        'c' => {
          '' => [
            0x69
          ]
        },
        'd' => {
          '' => [
            0x6A
          ]
        },
        'e' => {
          '' => [
            0x6B
          ]
        },
        'h' => {
          '' => [
            0x6C
          ]
        },
        'l' => {
          '' => [
            0x6D
          ]
        }
      }
    },
    'r' => {
      ',' => {
        'a' => {
          '' => [
            0xED,
            0x4F
          ]
        }
      }
    },
    'sp' => {
      ',' => {
        '(' => {
          'NN' => {
            ')' => {
              '' => [
                0xED,
                0x7B,
                'NNl',
                'NNh'
              ]
            }
          }
        },
        'NN' => {
          '' => [
            0x31,
            'NNl',
            'NNh'
          ]
        },
        'hl' => {
          '' => [
            0xF9
          ]
        },
        'ix' => {
          '' => [
            0xDD,
            0xF9
          ]
        },
        'iy' => {
          '' => [
            0xFD,
            0xF9
          ]
        }
      }
    }
  },
  'ldd' => {
    '' => [
      0xED,
      0xA8
    ],
    '(' => {
      'bc' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x02,
                0x0B
              ]
            }
          }
        }
      },
      'de' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x12,
                0x1B
              ]
            }
          }
        }
      },
      'hl' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0x36,
                'N',
                0x2B
              ]
            },
            'a' => {
              '' => [
                0x77,
                0x2B
              ]
            },
            'b' => {
              '' => [
                0x70,
                0x2B
              ]
            },
            'c' => {
              '' => [
                0x71,
                0x2B
              ]
            },
            'd' => {
              '' => [
                0x72,
                0x2B
              ]
            },
            'e' => {
              '' => [
                0x73,
                0x2B
              ]
            },
            'h' => {
              '' => [
                0x74,
                0x2B
              ]
            },
            'l' => {
              '' => [
                0x75,
                0x2B
              ]
            }
          }
        }
      },
      'ix' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0xDD,
                0x36,
                0x00,
                'N',
                0xDD,
                0x2B
              ]
            },
            'a' => {
              '' => [
                0xDD,
                0x77,
                0x00,
                0xDD,
                0x2B
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0x70,
                0x00,
                0xDD,
                0x2B
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0x71,
                0x00,
                0xDD,
                0x2B
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0x72,
                0x00,
                0xDD,
                0x2B
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0x73,
                0x00,
                0xDD,
                0x2B
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0x74,
                0x00,
                0xDD,
                0x2B
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0x75,
                0x00,
                0xDD,
                0x2B
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xDD,
                    0x36,
                    'DIS',
                    'N',
                    0xDD,
                    0x2B
                  ]
                },
                'a' => {
                  '' => [
                    0xDD,
                    0x77,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0x70,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0x71,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0x72,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0x73,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0x74,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0x75,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xDD,
                    0x36,
                    'NDIS',
                    'N',
                    0xDD,
                    0x2B
                  ]
                },
                'a' => {
                  '' => [
                    0xDD,
                    0x77,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0x70,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0x71,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0x72,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0x73,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0x74,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0x75,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0xFD,
                0x36,
                0x00,
                'N',
                0xFD,
                0x2B
              ]
            },
            'a' => {
              '' => [
                0xFD,
                0x77,
                0x00,
                0xFD,
                0x2B
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0x70,
                0x00,
                0xFD,
                0x2B
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0x71,
                0x00,
                0xFD,
                0x2B
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0x72,
                0x00,
                0xFD,
                0x2B
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0x73,
                0x00,
                0xFD,
                0x2B
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0x74,
                0x00,
                0xFD,
                0x2B
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0x75,
                0x00,
                0xFD,
                0x2B
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xFD,
                    0x36,
                    'DIS',
                    'N',
                    0xFD,
                    0x2B
                  ]
                },
                'a' => {
                  '' => [
                    0xFD,
                    0x77,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0x70,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0x71,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0x72,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0x73,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0x74,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0x75,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xFD,
                    0x36,
                    'NDIS',
                    'N',
                    0xFD,
                    0x2B
                  ]
                },
                'a' => {
                  '' => [
                    0xFD,
                    0x77,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0x70,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0x71,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0x72,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0x73,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0x74,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0x75,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      ',' => {
        '(' => {
          'bc' => {
            ')' => {
              '' => [
                0x0A,
                0x0B
              ]
            }
          },
          'de' => {
            ')' => {
              '' => [
                0x1A,
                0x1B
              ]
            }
          },
          'hl' => {
            ')' => {
              '' => [
                0x7E,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x7E,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x7E,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x7E,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x7E,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x7E,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x7E,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'b' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x46,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x46,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x46,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x46,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x46,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x46,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x46,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'c' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x4E,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x4E,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x4E,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'd' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x56,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x56,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x56,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x56,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x56,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x56,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x56,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'e' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x5E,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x5E,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x5E,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'h' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x66,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x66,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x66,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x66,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x66,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x66,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x66,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    },
    'l' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x6E,
                0x2B
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x6E,
                0x00,
                0xDD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'DIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'NDIS',
                    0xDD,
                    0x2B
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x6E,
                0x00,
                0xFD,
                0x2B
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'DIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'NDIS',
                    0xFD,
                    0x2B
                  ]
                }
              }
            }
          }
        }
      }
    }
  },
  'lddr' => {
    '' => [
      0xED,
      0xB8
    ]
  },
  'ldi' => {
    '' => [
      0xED,
      0xA0
    ],
    '(' => {
      'bc' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x02,
                0x03
              ]
            }
          }
        }
      },
      'de' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0x12,
                0x13
              ]
            }
          }
        }
      },
      'hl' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0x36,
                'N',
                0x23
              ]
            },
            'a' => {
              '' => [
                0x77,
                0x23
              ]
            },
            'b' => {
              '' => [
                0x70,
                0x23
              ]
            },
            'bc' => {
              '' => [
                0x71,
                0x23,
                0x70,
                0x23
              ]
            },
            'c' => {
              '' => [
                0x71,
                0x23
              ]
            },
            'd' => {
              '' => [
                0x72,
                0x23
              ]
            },
            'de' => {
              '' => [
                0x73,
                0x23,
                0x72,
                0x23
              ]
            },
            'e' => {
              '' => [
                0x73,
                0x23
              ]
            },
            'h' => {
              '' => [
                0x74,
                0x23
              ]
            },
            'l' => {
              '' => [
                0x75,
                0x23
              ]
            }
          }
        }
      },
      'ix' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0xDD,
                0x36,
                0x00,
                'N',
                0xDD,
                0x23
              ]
            },
            'a' => {
              '' => [
                0xDD,
                0x77,
                0x00,
                0xDD,
                0x23
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0x70,
                0x00,
                0xDD,
                0x23
              ]
            },
            'bc' => {
              '' => [
                0xDD,
                0x71,
                0x00,
                0xDD,
                0x23,
                0xDD,
                0x70,
                0x00,
                0xDD,
                0x23
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0x71,
                0x00,
                0xDD,
                0x23
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0x72,
                0x00,
                0xDD,
                0x23
              ]
            },
            'de' => {
              '' => [
                0xDD,
                0x73,
                0x00,
                0xDD,
                0x23,
                0xDD,
                0x72,
                0x00,
                0xDD,
                0x23
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0x73,
                0x00,
                0xDD,
                0x23
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0x74,
                0x00,
                0xDD,
                0x23
              ]
            },
            'hl' => {
              '' => [
                0xDD,
                0x75,
                0x00,
                0xDD,
                0x23,
                0xDD,
                0x74,
                0x00,
                0xDD,
                0x23
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0x75,
                0x00,
                0xDD,
                0x23
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xDD,
                    0x36,
                    'DIS',
                    'N',
                    0xDD,
                    0x23
                  ]
                },
                'a' => {
                  '' => [
                    0xDD,
                    0x77,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0x70,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'bc' => {
                  '' => [
                    0xDD,
                    0x71,
                    'DIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x70,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0x71,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0x72,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'de' => {
                  '' => [
                    0xDD,
                    0x73,
                    'DIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x72,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0x73,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0x74,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'hl' => {
                  '' => [
                    0xDD,
                    0x75,
                    'DIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x74,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0x75,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xDD,
                    0x36,
                    'NDIS',
                    'N',
                    0xDD,
                    0x23
                  ]
                },
                'a' => {
                  '' => [
                    0xDD,
                    0x77,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0x70,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'bc' => {
                  '' => [
                    0xDD,
                    0x71,
                    'NDIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x70,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0x71,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0x72,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'de' => {
                  '' => [
                    0xDD,
                    0x73,
                    'NDIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x72,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0x73,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0x74,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'hl' => {
                  '' => [
                    0xDD,
                    0x75,
                    'NDIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x74,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0x75,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          ',' => {
            'N' => {
              '' => [
                0xFD,
                0x36,
                0x00,
                'N',
                0xFD,
                0x23
              ]
            },
            'a' => {
              '' => [
                0xFD,
                0x77,
                0x00,
                0xFD,
                0x23
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0x70,
                0x00,
                0xFD,
                0x23
              ]
            },
            'bc' => {
              '' => [
                0xFD,
                0x71,
                0x00,
                0xFD,
                0x23,
                0xFD,
                0x70,
                0x00,
                0xFD,
                0x23
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0x71,
                0x00,
                0xFD,
                0x23
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0x72,
                0x00,
                0xFD,
                0x23
              ]
            },
            'de' => {
              '' => [
                0xFD,
                0x73,
                0x00,
                0xFD,
                0x23,
                0xFD,
                0x72,
                0x00,
                0xFD,
                0x23
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0x73,
                0x00,
                0xFD,
                0x23
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0x74,
                0x00,
                0xFD,
                0x23
              ]
            },
            'hl' => {
              '' => [
                0xFD,
                0x75,
                0x00,
                0xFD,
                0x23,
                0xFD,
                0x74,
                0x00,
                0xFD,
                0x23
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0x75,
                0x00,
                0xFD,
                0x23
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xFD,
                    0x36,
                    'DIS',
                    'N',
                    0xFD,
                    0x23
                  ]
                },
                'a' => {
                  '' => [
                    0xFD,
                    0x77,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0x70,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'bc' => {
                  '' => [
                    0xFD,
                    0x71,
                    'DIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x70,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0x71,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0x72,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'de' => {
                  '' => [
                    0xFD,
                    0x73,
                    'DIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x72,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0x73,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0x74,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'hl' => {
                  '' => [
                    0xFD,
                    0x75,
                    'DIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x74,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0x75,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              ',' => {
                'N' => {
                  '' => [
                    0xFD,
                    0x36,
                    'NDIS',
                    'N',
                    0xFD,
                    0x23
                  ]
                },
                'a' => {
                  '' => [
                    0xFD,
                    0x77,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0x70,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'bc' => {
                  '' => [
                    0xFD,
                    0x71,
                    'NDIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x70,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0x71,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0x72,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'de' => {
                  '' => [
                    0xFD,
                    0x73,
                    'NDIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x72,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0x73,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0x74,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'hl' => {
                  '' => [
                    0xFD,
                    0x75,
                    'NDIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x74,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0x75,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      ',' => {
        '(' => {
          'bc' => {
            ')' => {
              '' => [
                0x0A,
                0x03
              ]
            }
          },
          'de' => {
            ')' => {
              '' => [
                0x1A,
                0x13
              ]
            }
          },
          'hl' => {
            ')' => {
              '' => [
                0x7E,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x7E,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x7E,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x7E,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x7E,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x7E,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x7E,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'b' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x46,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x46,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x46,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x46,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x46,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x46,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x46,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'bc' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x4E,
                0x23,
                0x46,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x4E,
                0x00,
                0xDD,
                0x23,
                0xDD,
                0x46,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'DIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x46,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'NDIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x46,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x4E,
                0x00,
                0xFD,
                0x23,
                0xFD,
                0x46,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'DIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x46,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'NDIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x46,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'c' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x4E,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x4E,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x4E,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x4E,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x4E,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'd' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x56,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x56,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x56,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x56,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x56,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x56,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x56,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'de' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x5E,
                0x23,
                0x56,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x5E,
                0x00,
                0xDD,
                0x23,
                0xDD,
                0x56,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'DIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x56,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'NDIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x56,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x5E,
                0x00,
                0xFD,
                0x23,
                0xFD,
                0x56,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'DIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x56,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'NDIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x56,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'e' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x5E,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x5E,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x5E,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x5E,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x5E,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'h' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x66,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x66,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x66,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x66,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x66,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x66,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x66,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'hl' => {
      ',' => {
        '(' => {
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x6E,
                0x00,
                0xDD,
                0x23,
                0xDD,
                0x66,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'DIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x66,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'NDIS',
                    0xDD,
                    0x23,
                    0xDD,
                    0x66,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x6E,
                0x00,
                0xFD,
                0x23,
                0xFD,
                0x66,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'DIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x66,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'NDIS',
                    0xFD,
                    0x23,
                    0xFD,
                    0x66,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    },
    'l' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x6E,
                0x23
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x6E,
                0x00,
                0xDD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'DIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x6E,
                    'NDIS',
                    0xDD,
                    0x23
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x6E,
                0x00,
                0xFD,
                0x23
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'DIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x6E,
                    'NDIS',
                    0xFD,
                    0x23
                  ]
                }
              }
            }
          }
        }
      }
    }
  },
  'ldir' => {
    '' => [
      0xED,
      0xB0
    ]
  },
  'neg' => {
    '' => [
      0xED,
      0x44
    ]
  },
  'nop' => {
    '' => [
      0x00
    ]
  },
  'or' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xB6
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xB6,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xB6,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xB6,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xB6,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xB6,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xB6,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'N' => {
      '' => [
        0xF6,
        'N'
      ]
    },
    'a' => {
      '' => [
        0xB7
      ]
    },
    'b' => {
      '' => [
        0xB0
      ]
    },
    'c' => {
      '' => [
        0xB1
      ]
    },
    'd' => {
      '' => [
        0xB2
      ]
    },
    'e' => {
      '' => [
        0xB3
      ]
    },
    'h' => {
      '' => [
        0xB4
      ]
    },
    'ixh' => {
      '' => [
        0xDD,
        0xB4
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0xB5
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0xB4
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0xB5
      ]
    },
    'l' => {
      '' => [
        0xB5
      ]
    }
  },
  'otdr' => {
    '' => [
      0xED,
      0xBB
    ]
  },
  'otir' => {
    '' => [
      0xED,
      0xB3
    ]
  },
  'out' => {
    '(' => {
      'N' => {
        ')' => {
          ',' => {
            'a' => {
              '' => [
                0xD3,
                'N'
              ]
            }
          }
        }
      },
      'c' => {
        ')' => {
          ',' => {
            0x00 => {
              '' => [
                0xED,
                0x71
              ]
            },
            'a' => {
              '' => [
                0xED,
                0x79
              ]
            },
            'b' => {
              '' => [
                0xED,
                0x41
              ]
            },
            'c' => {
              '' => [
                0xED,
                0x49
              ]
            },
            'd' => {
              '' => [
                0xED,
                0x51
              ]
            },
            'e' => {
              '' => [
                0xED,
                0x59
              ]
            },
            'h' => {
              '' => [
                0xED,
                0x61
              ]
            },
            'l' => {
              '' => [
                0xED,
                0x69
              ]
            }
          }
        }
      }
    }
  },
  'outd' => {
    '' => [
      0xED,
      0xAB
    ]
  },
  'outi' => {
    '' => [
      0xED,
      0xA3
    ]
  },
  'pop' => {
    'af' => {
      '' => [
        0xF1
      ]
    },
    'bc' => {
      '' => [
        0xC1
      ]
    },
    'de' => {
      '' => [
        0xD1
      ]
    },
    'hl' => {
      '' => [
        0xE1
      ]
    },
    'ix' => {
      '' => [
        0xDD,
        0xE1
      ]
    },
    'iy' => {
      '' => [
        0xFD,
        0xE1
      ]
    }
  },
  'push' => {
    'af' => {
      '' => [
        0xF5
      ]
    },
    'bc' => {
      '' => [
        0xC5
      ]
    },
    'de' => {
      '' => [
        0xD5
      ]
    },
    'hl' => {
      '' => [
        0xE5
      ]
    },
    'ix' => {
      '' => [
        0xDD,
        0xE5
      ]
    },
    'iy' => {
      '' => [
        0xFD,
        0xE5
      ]
    }
  },
  'res' => {
    0x00 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x86
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x86
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x87
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x80
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x81
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x82
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x83
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x84
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x85
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x86
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x87
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x80
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x81
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x82
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x83
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x84
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x85
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x86
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x87
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x80
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x81
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x82
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x83
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x84
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x85
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x86
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x87
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x80
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x81
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x82
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x83
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x84
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x85
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x86
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x87
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x80
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x81
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x82
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x83
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x84
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x85
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x86
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x87
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x80
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x81
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x82
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x83
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x84
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x85
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x87
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x80
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x81
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x82
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x83
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x84
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x85
          ]
        }
      }
    },
    0x01 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x8E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x8E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x8F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x88
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x89
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x8A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x8B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x8C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x8D
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x8E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x8F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x88
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x89
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x8A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x8B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x8C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x8D
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x8E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x8F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x88
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x89
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x8A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x8B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x8C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x8D
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x8E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x8F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x88
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x89
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x8A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x8B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x8C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x8D
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x8E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x8F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x88
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x89
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x8A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x8B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x8C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x8D
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x8E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x8F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x88
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x89
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x8A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x8B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x8C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x8D
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x8F
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x88
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x89
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x8A
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x8B
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x8C
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x8D
          ]
        }
      }
    },
    0x02 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x96
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x96
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x97
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x90
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x91
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x92
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x93
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x94
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x95
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x96
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x97
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x90
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x91
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x92
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x93
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x94
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x95
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x96
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x97
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x90
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x91
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x92
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x93
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x94
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x95
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x96
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x97
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x90
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x91
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x92
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x93
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x94
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x95
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x96
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x97
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x90
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x91
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x92
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x93
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x94
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x95
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x96
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x97
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x90
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x91
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x92
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x93
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x94
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x95
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x97
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x90
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x91
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x92
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x93
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x94
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x95
          ]
        }
      }
    },
    0x03 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0x9E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x9E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x9F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x98
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x99
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x9A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x9B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x9C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0x9D
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x9E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x9F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x98
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x99
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x9A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x9B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x9C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0x9D
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x9E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x9F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x98
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x99
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x9A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x9B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x9C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0x9D
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x9E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x9F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x98
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x99
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x9A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x9B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x9C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0x9D
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x9E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x9F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x98
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x99
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x9A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x9B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x9C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0x9D
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x9E
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x9F
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x98
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x99
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x9A
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x9B
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x9C
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0x9D
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0x9F
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0x98
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0x99
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0x9A
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0x9B
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0x9C
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0x9D
          ]
        }
      }
    },
    0x04 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xA6
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xA6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA7
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA0
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA1
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA2
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA3
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA4
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xA6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xA6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA5
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xA6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA7
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA0
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA1
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA2
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA3
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA4
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xA6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xA6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA5
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xA7
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xA0
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xA1
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xA2
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xA3
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xA4
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xA5
          ]
        }
      }
    },
    0x05 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xAE
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xAE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xAF
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA8
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xA9
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xAA
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xAB
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xAC
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xAD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xAE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xAF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xA9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xAA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xAB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xAC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xAD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xAE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xAF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xA9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xAA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xAB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xAC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xAD
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xAE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xAF
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA8
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xA9
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xAA
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xAB
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xAC
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xAD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xAE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xAF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xA9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xAA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xAB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xAC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xAD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xAE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xAF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xA9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xAA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xAB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xAC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xAD
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xAF
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xA8
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xA9
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xAA
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xAB
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xAC
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xAD
          ]
        }
      }
    },
    0x06 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xB6
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xB6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB7
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB0
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB1
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB2
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB3
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB4
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xB6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xB6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB5
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xB6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB7
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB0
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB1
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB2
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB3
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB4
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xB6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xB6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB5
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xB7
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xB0
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xB1
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xB2
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xB3
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xB4
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xB5
          ]
        }
      }
    },
    0x07 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xBE
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xBE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xBF
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB8
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xB9
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xBA
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xBB
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xBC
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xBD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xBE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xBF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xB9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xBA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xBB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xBC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xBD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xBE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xBF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xB9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xBA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xBB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xBC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xBD
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xBE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xBF
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB8
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xB9
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xBA
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xBB
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xBC
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xBD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xBE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xBF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xB9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xBA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xBB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xBC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xBD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xBE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xBF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xB9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xBA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xBB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xBC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xBD
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xBF
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xB8
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xB9
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xBA
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xBB
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xBC
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xBD
          ]
        }
      }
    }
  },
  'ret' => {
    '' => [
      0xC9
    ],
    'c' => {
      '' => [
        0xD8
      ]
    },
    'm' => {
      '' => [
        0xF8
      ]
    },
    'nc' => {
      '' => [
        0xD0
      ]
    },
    'nz' => {
      '' => [
        0xC0
      ]
    },
    'p' => {
      '' => [
        0xF0
      ]
    },
    'pe' => {
      '' => [
        0xE8
      ]
    },
    'po' => {
      '' => [
        0xE0
      ]
    },
    'z' => {
      '' => [
        0xC8
      ]
    }
  },
  'reti' => {
    '' => [
      0xED,
      0x4D
    ]
  },
  'retn' => {
    '' => [
      0xED,
      0x45
    ]
  },
  'rl' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x16
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x16
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x17
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x10
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x11
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x12
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x13
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x14
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x15
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x16
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x17
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x10
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x11
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x12
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x13
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x14
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x15
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x16
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x17
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x10
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x11
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x12
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x13
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x14
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x15
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x16
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x17
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x10
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x11
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x12
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x13
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x14
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x15
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x16
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x17
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x10
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x11
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x12
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x13
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x14
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x15
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x16
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x17
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x10
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x11
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x12
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x13
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x14
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x15
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x17
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x10
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x11,
        0xCB,
        0x10
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x11
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x12
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x13,
        0xCB,
        0x12
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x13
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x14
      ]
    },
    'hl' => {
      '' => [
        0xCB,
        0x15,
        0xCB,
        0x14
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x15
      ]
    }
  },
  'rla' => {
    '' => [
      0x17
    ]
  },
  'rlc' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x06
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x06
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x07
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x00
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x01
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x02
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x03
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x04
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x05
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x06
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x07
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x00
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x01
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x02
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x03
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x04
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x05
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x06
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x07
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x00
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x01
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x02
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x03
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x04
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x05
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x06
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x07
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x00
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x01
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x02
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x03
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x04
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x05
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x06
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x07
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x00
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x01
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x02
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x03
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x04
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x05
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x06
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x07
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x00
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x01
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x02
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x03
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x04
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x05
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x07
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x00
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x01
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x02
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x03
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x04
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x05
      ]
    }
  },
  'rlca' => {
    '' => [
      0x07
    ]
  },
  'rld' => {
    '' => [
      0xED,
      0x6F
    ]
  },
  'rr' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x1E
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x1E
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x1F
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x18
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x19
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x1A
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x1B
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x1C
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x1D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x1E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x1F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x18
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x19
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x1A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x1B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x1C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x1D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x1E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x1F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x18
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x19
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x1A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x1B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x1C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x1D
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x1E
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x1F
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x18
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x19
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x1A
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x1B
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x1C
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x1D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x1E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x1F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x18
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x19
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x1A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x1B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x1C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x1D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x1E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x1F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x18
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x19
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x1A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x1B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x1C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x1D
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x1F
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x18
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x18,
        0xCB,
        0x19
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x19
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x1A
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x1A,
        0xCB,
        0x1B
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x1B
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x1C
      ]
    },
    'hl' => {
      '' => [
        0xCB,
        0x1C,
        0xCB,
        0x1D
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x1D
      ]
    }
  },
  'rra' => {
    '' => [
      0x1F
    ]
  },
  'rrc' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x0E
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x0E
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x0F
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x08
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x09
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x0A
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x0B
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x0C
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x0D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x0E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x0F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x08
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x09
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x0A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x0B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x0C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x0D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x0E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x0F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x08
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x09
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x0A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x0B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x0C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x0D
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x0E
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x0F
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x08
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x09
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x0A
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x0B
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x0C
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x0D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x0E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x0F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x08
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x09
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x0A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x0B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x0C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x0D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x0E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x0F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x08
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x09
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x0A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x0B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x0C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x0D
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x0F
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x08
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x09
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x0A
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x0B
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x0C
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x0D
      ]
    }
  },
  'rrca' => {
    '' => [
      0x0F
    ]
  },
  'rrd' => {
    '' => [
      0xED,
      0x67
    ]
  },
  'rst' => {
    0x00 => {
      '' => [
        0xC7
      ]
    },
    0x10 => {
      '' => [
        0xD7
      ]
    },
    0x18 => {
      '' => [
        0xDF
      ]
    },
    0x20 => {
      '' => [
        0xE7
      ]
    },
    0x28 => {
      '' => [
        0xEF
      ]
    },
    0x30 => {
      '' => [
        0xF7
      ]
    },
    0x38 => {
      '' => [
        0xFF
      ]
    },
    0x08 => {
      '' => [
        0xCF
      ]
    }
  },
  'sbc' => {
    'a' => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0x9E
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0x9E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x9E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0x9E,
                    'NDIS'
                  ]
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0x9E,
                0x00
              ]
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x9E,
                    'DIS'
                  ]
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0x9E,
                    'NDIS'
                  ]
                }
              }
            }
          }
        },
        'N' => {
          '' => [
            0xDE,
            'N'
          ]
        },
        'a' => {
          '' => [
            0x9F
          ]
        },
        'b' => {
          '' => [
            0x98
          ]
        },
        'c' => {
          '' => [
            0x99
          ]
        },
        'd' => {
          '' => [
            0x9A
          ]
        },
        'e' => {
          '' => [
            0x9B
          ]
        },
        'h' => {
          '' => [
            0x9C
          ]
        },
        'ixh' => {
          '' => [
            0xDD,
            0x9C
          ]
        },
        'ixl' => {
          '' => [
            0xDD,
            0x9D
          ]
        },
        'iyh' => {
          '' => [
            0xFD,
            0x9C
          ]
        },
        'iyl' => {
          '' => [
            0xFD,
            0x9D
          ]
        },
        'l' => {
          '' => [
            0x9D
          ]
        }
      }
    },
    'hl' => {
      ',' => {
        'bc' => {
          '' => [
            0xED,
            0x42
          ]
        },
        'de' => {
          '' => [
            0xED,
            0x52
          ]
        },
        'hl' => {
          '' => [
            0xED,
            0x62
          ]
        },
        'sp' => {
          '' => [
            0xED,
            0x72
          ]
        }
      }
    }
  },
  'scf' => {
    '' => [
      0x37
    ]
  },
  'set' => {
    0x00 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xC6
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xC6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC7
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC0
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC1
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC2
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC3
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC4
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xC6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xC6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC5
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xC6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC7
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC0
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC1
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC2
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC3
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC4
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xC6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xC6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC5
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xC7
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xC0
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xC1
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xC2
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xC3
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xC4
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xC5
          ]
        }
      }
    },
    0x01 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xCE
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xCE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xCF
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC8
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xC9
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xCA
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xCB
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xCC
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xCD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xCE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xCF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xC9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xCA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xCB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xCC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xCD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xCE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xCF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xC9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xCA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xCB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xCC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xCD
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xCE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xCF
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC8
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xC9
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xCA
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xCB
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xCC
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xCD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xCE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xCF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xC9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xCA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xCB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xCC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xCD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xCE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xCF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xC9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xCA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xCB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xCC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xCD
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xCF
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xC8
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xC9
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xCA
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xCB
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xCC
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xCD
          ]
        }
      }
    },
    0x02 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xD6
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xD6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD7
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD0
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD1
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD2
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD3
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD4
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xD6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xD6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD5
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xD6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD7
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD0
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD1
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD2
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD3
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD4
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xD6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xD6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD5
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xD7
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xD0
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xD1
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xD2
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xD3
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xD4
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xD5
          ]
        }
      }
    },
    0x03 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xDE
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xDE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xDF
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD8
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xD9
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xDA
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xDB
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xDC
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xDD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xDE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xDF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xD9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xDA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xDB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xDC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xDD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xDE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xDF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xD9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xDA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xDB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xDC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xDD
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xDE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xDF
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD8
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xD9
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xDA
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xDB
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xDC
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xDD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xDE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xDF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xD9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xDA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xDB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xDC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xDD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xDE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xDF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xD9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xDA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xDB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xDC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xDD
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xDF
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xD8
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xD9
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xDA
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xDB
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xDC
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xDD
          ]
        }
      }
    },
    0x04 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xE6
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xE6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE7
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE0
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE1
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE2
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE3
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE4
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xE6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xE6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE5
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xE6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE7
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE0
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE1
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE2
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE3
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE4
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xE6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xE6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE5
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xE7
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xE0
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xE1
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xE2
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xE3
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xE4
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xE5
          ]
        }
      }
    },
    0x05 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xEE
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xEE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xEF
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE8
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xE9
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xEA
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xEB
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xEC
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xED
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xEE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xEF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xE9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xEA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xEB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xEC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xED
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xEE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xEF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xE9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xEA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xEB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xEC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xED
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xEE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xEF
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE8
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xE9
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xEA
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xEB
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xEC
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xED
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xEE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xEF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xE9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xEA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xEB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xEC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xED
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xEE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xEF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xE9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xEA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xEB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xEC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xED
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xEF
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xE8
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xE9
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xEA
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xEB
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xEC
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xED
          ]
        }
      }
    },
    0x06 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xF6
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xF6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF7
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF0
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF1
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF2
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF3
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF4
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xF6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xF6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF5
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xF6
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF7
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF0
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF1
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF2
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF3
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF4
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF5
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xF6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF5
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xF6
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF7
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF0
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF1
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF2
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF3
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF4
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF5
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xF7
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xF0
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xF1
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xF2
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xF3
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xF4
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xF5
          ]
        }
      }
    },
    0x07 => {
      ',' => {
        '(' => {
          'hl' => {
            ')' => {
              '' => [
                0xCB,
                0xFE
              ]
            }
          },
          'ix' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0xFE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xFF
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF8
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xF9
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xFA
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xFB
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xFC
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    0x00,
                    0xFD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0xFE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xFF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xF9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xFA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xFB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xFC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'DIS',
                        0xFD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0xFE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xFF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xF9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xFA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xFB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xFC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xDD,
                        0xCB,
                        'NDIS',
                        0xFD
                      ]
                    }
                  }
                }
              }
            }
          },
          'iy' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0xFE
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xFF
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF8
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xF9
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xFA
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xFB
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xFC
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    0x00,
                    0xFD
                  ]
                }
              }
            },
            '+' => {
              'DIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0xFE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xFF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xF9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xFA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xFB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xFC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'DIS',
                        0xFD
                      ]
                    }
                  }
                }
              }
            },
            '-' => {
              'NDIS' => {
                ')' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0xFE
                  ],
                  ',' => {
                    'a' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xFF
                      ]
                    },
                    'b' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF8
                      ]
                    },
                    'c' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xF9
                      ]
                    },
                    'd' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xFA
                      ]
                    },
                    'e' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xFB
                      ]
                    },
                    'h' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xFC
                      ]
                    },
                    'l' => {
                      '' => [
                        0xFD,
                        0xCB,
                        'NDIS',
                        0xFD
                      ]
                    }
                  }
                }
              }
            }
          }
        },
        'a' => {
          '' => [
            0xCB,
            0xFF
          ]
        },
        'b' => {
          '' => [
            0xCB,
            0xF8
          ]
        },
        'c' => {
          '' => [
            0xCB,
            0xF9
          ]
        },
        'd' => {
          '' => [
            0xCB,
            0xFA
          ]
        },
        'e' => {
          '' => [
            0xCB,
            0xFB
          ]
        },
        'h' => {
          '' => [
            0xCB,
            0xFC
          ]
        },
        'l' => {
          '' => [
            0xCB,
            0xFD
          ]
        }
      }
    }
  },
  'sla' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x26
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x26
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x27
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x20
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x21
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x22
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x23
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x24
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x25
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x26
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x27
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x20
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x21
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x22
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x24
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x25
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x26
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x27
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x20
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x21
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x22
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x24
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x25
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x26
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x27
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x20
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x21
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x22
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x23
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x24
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x25
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x26
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x27
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x20
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x21
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x22
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x24
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x25
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x26
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x27
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x20
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x21
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x22
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x23
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x24
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x25
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x27
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x20
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x21,
        0xCB,
        0x10
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x21
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x22
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x23,
        0xCB,
        0x12
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x23
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x24
      ]
    },
    'hl' => {
      '' => [
        0x29
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x25
      ]
    }
  },
  'sli' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x36
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x36
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x37
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x30
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x31
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x32
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x33
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x34
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x35
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x35
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x35
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x36
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x37
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x30
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x31
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x32
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x33
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x34
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x35
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x35
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x35
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x37
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x30
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x31,
        0xCB,
        0x10
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x31
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x32
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x33,
        0xCB,
        0x12
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x33
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x34
      ]
    },
    'hl' => {
      '' => [
        0xCB,
        0x35,
        0xCB,
        0x14
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x35
      ]
    }
  },
  'sll' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x36
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x36
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x37
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x30
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x31
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x32
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x33
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x34
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x35
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x35
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x35
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x36
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x37
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x30
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x31
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x32
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x33
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x34
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x35
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x35
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x36
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x37
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x30
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x31
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x32
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x33
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x34
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x35
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x37
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x30
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x31,
        0xCB,
        0x10
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x31
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x32
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x33,
        0xCB,
        0x12
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x33
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x34
      ]
    },
    'hl' => {
      '' => [
        0xCB,
        0x35,
        0xCB,
        0x14
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x35
      ]
    }
  },
  'sra' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x2E
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x2E
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x2F
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x28
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x29
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x2A
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x2B
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x2C
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x2D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x2E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x2F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x28
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x29
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x2A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x2C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x2D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x2E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x2F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x28
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x29
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x2A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x2C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x2D
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x2E
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x2F
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x28
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x29
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x2A
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x2B
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x2C
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x2D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x2E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x2F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x28
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x29
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x2A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x2C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x2D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x2E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x2F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x28
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x29
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x2A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x2B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x2C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x2D
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x2F
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x28
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x28,
        0xCB,
        0x19
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x29
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x2A
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x2A,
        0xCB,
        0x1B
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x2B
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x2C
      ]
    },
    'hl' => {
      '' => [
        0xCB,
        0x2C,
        0xCB,
        0x1D
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x2D
      ]
    }
  },
  'srl' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xCB,
            0x3E
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xCB,
            0x00,
            0x3E
          ],
          ',' => {
            'a' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x3F
              ]
            },
            'b' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x38
              ]
            },
            'c' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x39
              ]
            },
            'd' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x3A
              ]
            },
            'e' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x3B
              ]
            },
            'h' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x3C
              ]
            },
            'l' => {
              '' => [
                0xDD,
                0xCB,
                0x00,
                0x3D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'DIS',
                0x3E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x3F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x38
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x39
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x3A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x3B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x3C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'DIS',
                    0x3D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xCB,
                'NDIS',
                0x3E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x3F
                  ]
                },
                'b' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x38
                  ]
                },
                'c' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x39
                  ]
                },
                'd' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x3A
                  ]
                },
                'e' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x3B
                  ]
                },
                'h' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x3C
                  ]
                },
                'l' => {
                  '' => [
                    0xDD,
                    0xCB,
                    'NDIS',
                    0x3D
                  ]
                }
              }
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xCB,
            0x00,
            0x3E
          ],
          ',' => {
            'a' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x3F
              ]
            },
            'b' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x38
              ]
            },
            'c' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x39
              ]
            },
            'd' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x3A
              ]
            },
            'e' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x3B
              ]
            },
            'h' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x3C
              ]
            },
            'l' => {
              '' => [
                0xFD,
                0xCB,
                0x00,
                0x3D
              ]
            }
          }
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'DIS',
                0x3E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x3F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x38
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x39
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x3A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x3B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x3C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'DIS',
                    0x3D
                  ]
                }
              }
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xCB,
                'NDIS',
                0x3E
              ],
              ',' => {
                'a' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x3F
                  ]
                },
                'b' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x38
                  ]
                },
                'c' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x39
                  ]
                },
                'd' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x3A
                  ]
                },
                'e' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x3B
                  ]
                },
                'h' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x3C
                  ]
                },
                'l' => {
                  '' => [
                    0xFD,
                    0xCB,
                    'NDIS',
                    0x3D
                  ]
                }
              }
            }
          }
        }
      }
    },
    'a' => {
      '' => [
        0xCB,
        0x3F
      ]
    },
    'b' => {
      '' => [
        0xCB,
        0x38
      ]
    },
    'bc' => {
      '' => [
        0xCB,
        0x38,
        0xCB,
        0x19
      ]
    },
    'c' => {
      '' => [
        0xCB,
        0x39
      ]
    },
    'd' => {
      '' => [
        0xCB,
        0x3A
      ]
    },
    'de' => {
      '' => [
        0xCB,
        0x3A,
        0xCB,
        0x1B
      ]
    },
    'e' => {
      '' => [
        0xCB,
        0x3B
      ]
    },
    'h' => {
      '' => [
        0xCB,
        0x3C
      ]
    },
    'hl' => {
      '' => [
        0xCB,
        0x3C,
        0xCB,
        0x1D
      ]
    },
    'l' => {
      '' => [
        0xCB,
        0x3D
      ]
    }
  },
  'stop' => {
    '' => [
      0xDD,
      0xDD,
      0x00
    ]
  },
  'sub' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0x96
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0x96,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0x96,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0x96,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0x96,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0x96,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0x96,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'N' => {
      '' => [
        0xD6,
        'N'
      ]
    },
    'a' => {
      '' => [
        0x97
      ]
    },
    'b' => {
      '' => [
        0x90
      ]
    },
    'c' => {
      '' => [
        0x91
      ]
    },
    'd' => {
      '' => [
        0x92
      ]
    },
    'e' => {
      '' => [
        0x93
      ]
    },
    'h' => {
      '' => [
        0x94
      ]
    },
    'hl' => {
      ',' => {
        'bc' => {
          '' => [
            0xB7,
            0xED,
            0x42
          ]
        },
        'de' => {
          '' => [
            0xB7,
            0xED,
            0x52
          ]
        },
        'hl' => {
          '' => [
            0xB7,
            0xED,
            0x62
          ]
        },
        'sp' => {
          '' => [
            0xB7,
            0xED,
            0x72
          ]
        }
      }
    },
    'ixh' => {
      '' => [
        0xDD,
        0x94
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0x95
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0x94
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0x95
      ]
    },
    'l' => {
      '' => [
        0x95
      ]
    }
  },
  'xor' => {
    '(' => {
      'hl' => {
        ')' => {
          '' => [
            0xAE
          ]
        }
      },
      'ix' => {
        ')' => {
          '' => [
            0xDD,
            0xAE,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xDD,
                0xAE,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xDD,
                0xAE,
                'NDIS'
              ]
            }
          }
        }
      },
      'iy' => {
        ')' => {
          '' => [
            0xFD,
            0xAE,
            0x00
          ]
        },
        '+' => {
          'DIS' => {
            ')' => {
              '' => [
                0xFD,
                0xAE,
                'DIS'
              ]
            }
          }
        },
        '-' => {
          'NDIS' => {
            ')' => {
              '' => [
                0xFD,
                0xAE,
                'NDIS'
              ]
            }
          }
        }
      }
    },
    'N' => {
      '' => [
        0xEE,
        'N'
      ]
    },
    'a' => {
      '' => [
        0xAF
      ]
    },
    'b' => {
      '' => [
        0xA8
      ]
    },
    'c' => {
      '' => [
        0xA9
      ]
    },
    'd' => {
      '' => [
        0xAA
      ]
    },
    'e' => {
      '' => [
        0xAB
      ]
    },
    'h' => {
      '' => [
        0xAC
      ]
    },
    'ixh' => {
      '' => [
        0xDD,
        0xAC
      ]
    },
    'ixl' => {
      '' => [
        0xDD,
        0xAD
      ]
    },
    'iyh' => {
      '' => [
        0xFD,
        0xAC
      ]
    },
    'iyl' => {
      '' => [
        0xFD,
        0xAD
      ]
    },
    'l' => {
      '' => [
        0xAD
      ]
    }
  }
}
;
my $disasm_table = {
  0x00 => {
    '' => [
      'nop'
    ]
  },
  0x01 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          'bc',
          ',',
          'NN'
        ]
      }
    }
  },
  0x0A => {
    '' => [
      'ld',
      'a',
      ',',
      '(',
      'bc',
      ')'
    ],
    0x0B => {
      '' => [
        'ldd',
        'a',
        ',',
        '(',
        'bc',
        ')'
      ]
    },
    0x03 => {
      '' => [
        'ldi',
        'a',
        ',',
        '(',
        'bc',
        ')'
      ]
    }
  },
  0x64 => {
    '' => [
      'ld',
      'h',
      ',',
      'h'
    ],
    0x6D => {
      '' => [
        'ld',
        'hl',
        ',',
        'hl'
      ]
    }
  },
  0x65 => {
    '' => [
      'ld',
      'h',
      ',',
      'l'
    ]
  },
  0x66 => {
    '' => [
      'ld',
      'h',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'h',
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        'h',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x67 => {
    '' => [
      'ld',
      'h',
      ',',
      'a'
    ]
  },
  0x68 => {
    '' => [
      'ld',
      'l',
      ',',
      'b'
    ]
  },
  0x69 => {
    '' => [
      'ld',
      'l',
      ',',
      'c'
    ]
  },
  0x6A => {
    '' => [
      'ld',
      'l',
      ',',
      'd'
    ]
  },
  0x6B => {
    '' => [
      'ld',
      'l',
      ',',
      'e'
    ]
  },
  0x6C => {
    '' => [
      'ld',
      'l',
      ',',
      'h'
    ]
  },
  0x6D => {
    '' => [
      'ld',
      'l',
      ',',
      'l'
    ]
  },
  0x0B => {
    '' => [
      'dec',
      'bc'
    ]
  },
  0x6E => {
    '' => [
      'ld',
      'l',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'l',
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        'l',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x6F => {
    '' => [
      'ld',
      'l',
      ',',
      'a'
    ]
  },
  0x70 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'b'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'b'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'b'
      ]
    }
  },
  0x71 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'c'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'c'
      ],
      0x70 => {
        0x23 => {
          '' => [
            'ldi',
            '(',
            'hl',
            ')',
            ',',
            'bc'
          ]
        },
        0x2B => {
          '' => [
            'ld',
            '(',
            'hl',
            ')',
            ',',
            'bc'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'c'
      ]
    }
  },
  0x72 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'd'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'd'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'd'
      ]
    }
  },
  0x73 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'e'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'e'
      ],
      0x72 => {
        0x23 => {
          '' => [
            'ldi',
            '(',
            'hl',
            ')',
            ',',
            'de'
          ]
        },
        0x2B => {
          '' => [
            'ld',
            '(',
            'hl',
            ')',
            ',',
            'de'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'e'
      ]
    }
  },
  0x74 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'h'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'h'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'h'
      ]
    }
  },
  0x75 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'l'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'l'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'l'
      ]
    }
  },
  0x76 => {
    '' => [
      'halt'
    ]
  },
  0x77 => {
    '' => [
      'ld',
      '(',
      'hl',
      ')',
      ',',
      'a'
    ],
    0x23 => {
      '' => [
        'ldi',
        '(',
        'hl',
        ')',
        ',',
        'a'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        '(',
        'hl',
        ')',
        ',',
        'a'
      ]
    }
  },
  0x0C => {
    '' => [
      'inc',
      'c'
    ]
  },
  0x78 => {
    '' => [
      'ld',
      'a',
      ',',
      'b'
    ]
  },
  0x79 => {
    '' => [
      'ld',
      'a',
      ',',
      'c'
    ]
  },
  0x7A => {
    '' => [
      'ld',
      'a',
      ',',
      'd'
    ]
  },
  0x7B => {
    '' => [
      'ld',
      'a',
      ',',
      'e'
    ]
  },
  0x7C => {
    '' => [
      'ld',
      'a',
      ',',
      'h'
    ]
  },
  0x7D => {
    '' => [
      'ld',
      'a',
      ',',
      'l'
    ]
  },
  0x7E => {
    '' => [
      'ld',
      'a',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'a',
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        'a',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x7F => {
    '' => [
      'ld',
      'a',
      ',',
      'a'
    ]
  },
  0x80 => {
    '' => [
      'add',
      'a',
      ',',
      'b'
    ]
  },
  0x81 => {
    '' => [
      'add',
      'a',
      ',',
      'c'
    ]
  },
  0x0D => {
    '' => [
      'dec',
      'c'
    ]
  },
  0x82 => {
    '' => [
      'add',
      'a',
      ',',
      'd'
    ]
  },
  0x83 => {
    '' => [
      'add',
      'a',
      ',',
      'e'
    ]
  },
  0x84 => {
    '' => [
      'add',
      'a',
      ',',
      'h'
    ]
  },
  0x85 => {
    '' => [
      'add',
      'a',
      ',',
      'l'
    ]
  },
  0x86 => {
    '' => [
      'add',
      'a',
      ',',
      '(',
      'hl',
      ')'
    ]
  },
  0x87 => {
    '' => [
      'add',
      'a',
      ',',
      'a'
    ]
  },
  0x88 => {
    '' => [
      'adc',
      'a',
      ',',
      'b'
    ]
  },
  0x89 => {
    '' => [
      'adc',
      'a',
      ',',
      'c'
    ]
  },
  0x8A => {
    '' => [
      'adc',
      'a',
      ',',
      'd'
    ]
  },
  0x8B => {
    '' => [
      'adc',
      'a',
      ',',
      'e'
    ]
  },
  0x0E => {
    'N' => {
      '' => [
        'ld',
        'c',
        ',',
        'N'
      ]
    }
  },
  0x8C => {
    '' => [
      'adc',
      'a',
      ',',
      'h'
    ]
  },
  0x8D => {
    '' => [
      'adc',
      'a',
      ',',
      'l'
    ]
  },
  0x8E => {
    '' => [
      'adc',
      'a',
      ',',
      '(',
      'hl',
      ')'
    ]
  },
  0x8F => {
    '' => [
      'adc',
      'a',
      ',',
      'a'
    ]
  },
  0x90 => {
    '' => [
      'sub',
      'b'
    ]
  },
  0x91 => {
    '' => [
      'sub',
      'c'
    ]
  },
  0x92 => {
    '' => [
      'sub',
      'd'
    ]
  },
  0x93 => {
    '' => [
      'sub',
      'e'
    ]
  },
  0x94 => {
    '' => [
      'sub',
      'h'
    ]
  },
  0x95 => {
    '' => [
      'sub',
      'l'
    ]
  },
  0x0F => {
    '' => [
      'rrca'
    ]
  },
  0x96 => {
    '' => [
      'sub',
      '(',
      'hl',
      ')'
    ]
  },
  0x97 => {
    '' => [
      'sub',
      'a'
    ]
  },
  0x98 => {
    '' => [
      'sbc',
      'a',
      ',',
      'b'
    ]
  },
  0x99 => {
    '' => [
      'sbc',
      'a',
      ',',
      'c'
    ]
  },
  0x9A => {
    '' => [
      'sbc',
      'a',
      ',',
      'd'
    ]
  },
  0x9B => {
    '' => [
      'sbc',
      'a',
      ',',
      'e'
    ]
  },
  0x9C => {
    '' => [
      'sbc',
      'a',
      ',',
      'h'
    ]
  },
  0x9D => {
    '' => [
      'sbc',
      'a',
      ',',
      'l'
    ]
  },
  0x9E => {
    '' => [
      'sbc',
      'a',
      ',',
      '(',
      'hl',
      ')'
    ]
  },
  0x9F => {
    '' => [
      'sbc',
      'a',
      ',',
      'a'
    ]
  },
  0x10 => {
    'NNo' => {
      '' => [
        'djnz',
        'NN'
      ]
    }
  },
  0xA0 => {
    '' => [
      'and',
      'b'
    ]
  },
  0xA1 => {
    '' => [
      'and',
      'c'
    ]
  },
  0xA2 => {
    '' => [
      'and',
      'd'
    ]
  },
  0xA3 => {
    '' => [
      'and',
      'e'
    ]
  },
  0xA4 => {
    '' => [
      'and',
      'h'
    ]
  },
  0xA5 => {
    '' => [
      'and',
      'l'
    ]
  },
  0xA6 => {
    '' => [
      'and',
      '(',
      'hl',
      ')'
    ]
  },
  0xA7 => {
    '' => [
      'and',
      'a'
    ]
  },
  0xA8 => {
    '' => [
      'xor',
      'b'
    ]
  },
  0xA9 => {
    '' => [
      'xor',
      'c'
    ]
  },
  0x11 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          'de',
          ',',
          'NN'
        ]
      }
    }
  },
  0xAA => {
    '' => [
      'xor',
      'd'
    ]
  },
  0xAB => {
    '' => [
      'xor',
      'e'
    ]
  },
  0xAC => {
    '' => [
      'xor',
      'h'
    ]
  },
  0xAD => {
    '' => [
      'xor',
      'l'
    ]
  },
  0xAE => {
    '' => [
      'xor',
      '(',
      'hl',
      ')'
    ]
  },
  0xAF => {
    '' => [
      'xor',
      'a'
    ]
  },
  0xB0 => {
    '' => [
      'or',
      'b'
    ]
  },
  0xB1 => {
    '' => [
      'or',
      'c'
    ]
  },
  0xB2 => {
    '' => [
      'or',
      'd'
    ]
  },
  0xB3 => {
    '' => [
      'or',
      'e'
    ]
  },
  0x12 => {
    '' => [
      'ld',
      '(',
      'de',
      ')',
      ',',
      'a'
    ],
    0x13 => {
      '' => [
        'ldi',
        '(',
        'de',
        ')',
        ',',
        'a'
      ]
    },
    0x1B => {
      '' => [
        'ldd',
        '(',
        'de',
        ')',
        ',',
        'a'
      ]
    }
  },
  0xB4 => {
    '' => [
      'or',
      'h'
    ]
  },
  0xB5 => {
    '' => [
      'or',
      'l'
    ]
  },
  0xB6 => {
    '' => [
      'or',
      '(',
      'hl',
      ')'
    ]
  },
  0xB7 => {
    '' => [
      'or',
      'a'
    ],
    0xED => {
      0x72 => {
        '' => [
          'sub',
          'hl',
          ',',
          'sp'
        ]
      },
      0x42 => {
        '' => [
          'sub',
          'hl',
          ',',
          'bc'
        ]
      },
      0x52 => {
        '' => [
          'sub',
          'hl',
          ',',
          'de'
        ]
      },
      0x62 => {
        '' => [
          'sub',
          'hl',
          ',',
          'hl'
        ]
      }
    }
  },
  0xB8 => {
    '' => [
      'cp',
      'b'
    ]
  },
  0xB9 => {
    '' => [
      'cp',
      'c'
    ]
  },
  0xBA => {
    '' => [
      'cp',
      'd'
    ]
  },
  0xBB => {
    '' => [
      'cp',
      'e'
    ]
  },
  0xBC => {
    '' => [
      'cp',
      'h'
    ]
  },
  0xBD => {
    '' => [
      'cp',
      'l'
    ]
  },
  0x13 => {
    '' => [
      'inc',
      'de'
    ]
  },
  0xBE => {
    '' => [
      'cp',
      '(',
      'hl',
      ')'
    ]
  },
  0xBF => {
    '' => [
      'cp',
      'a'
    ]
  },
  0xC0 => {
    '' => [
      'ret',
      'nz'
    ]
  },
  0xC1 => {
    '' => [
      'pop',
      'bc'
    ]
  },
  0xC2 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'nz',
          ',',
          'NN'
        ]
      }
    }
  },
  0xC3 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'NN'
        ]
      }
    }
  },
  0xC4 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'nz',
          ',',
          'NN'
        ]
      }
    }
  },
  0xC5 => {
    '' => [
      'push',
      'bc'
    ]
  },
  0xC6 => {
    'N' => {
      '' => [
        'add',
        'a',
        ',',
        'N'
      ]
    }
  },
  0xC7 => {
    '' => [
      'rst',
      0x00
    ]
  },
  0x02 => {
    '' => [
      'ld',
      '(',
      'bc',
      ')',
      ',',
      'a'
    ],
    0x0B => {
      '' => [
        'ldd',
        '(',
        'bc',
        ')',
        ',',
        'a'
      ]
    },
    0x03 => {
      '' => [
        'ldi',
        '(',
        'bc',
        ')',
        ',',
        'a'
      ]
    }
  },
  0x14 => {
    '' => [
      'inc',
      'd'
    ]
  },
  0xC8 => {
    '' => [
      'ret',
      'z'
    ]
  },
  0xC9 => {
    '' => [
      'ret'
    ]
  },
  0xCA => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'z',
          ',',
          'NN'
        ]
      }
    }
  },
  0xCB => {
    0x00 => {
      '' => [
        'rlc',
        'b'
      ]
    },
    0x01 => {
      '' => [
        'rlc',
        'c'
      ]
    },
    0x0A => {
      '' => [
        'rrc',
        'd'
      ]
    },
    0x64 => {
      '' => [
        'bit',
        0x04,
        ',',
        'h'
      ]
    },
    0x65 => {
      '' => [
        'bit',
        0x04,
        ',',
        'l'
      ]
    },
    0x66 => {
      '' => [
        'bit',
        0x04,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x67 => {
      '' => [
        'bit',
        0x04,
        ',',
        'a'
      ]
    },
    0x68 => {
      '' => [
        'bit',
        0x05,
        ',',
        'b'
      ]
    },
    0x69 => {
      '' => [
        'bit',
        0x05,
        ',',
        'c'
      ]
    },
    0x6A => {
      '' => [
        'bit',
        0x05,
        ',',
        'd'
      ]
    },
    0x6B => {
      '' => [
        'bit',
        0x05,
        ',',
        'e'
      ]
    },
    0x6C => {
      '' => [
        'bit',
        0x05,
        ',',
        'h'
      ]
    },
    0x6D => {
      '' => [
        'bit',
        0x05,
        ',',
        'l'
      ]
    },
    0x0B => {
      '' => [
        'rrc',
        'e'
      ]
    },
    0x6E => {
      '' => [
        'bit',
        0x05,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x6F => {
      '' => [
        'bit',
        0x05,
        ',',
        'a'
      ]
    },
    0x70 => {
      '' => [
        'bit',
        0x06,
        ',',
        'b'
      ]
    },
    0x71 => {
      '' => [
        'bit',
        0x06,
        ',',
        'c'
      ]
    },
    0x72 => {
      '' => [
        'bit',
        0x06,
        ',',
        'd'
      ]
    },
    0x73 => {
      '' => [
        'bit',
        0x06,
        ',',
        'e'
      ]
    },
    0x74 => {
      '' => [
        'bit',
        0x06,
        ',',
        'h'
      ]
    },
    0x75 => {
      '' => [
        'bit',
        0x06,
        ',',
        'l'
      ]
    },
    0x76 => {
      '' => [
        'bit',
        0x06,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x77 => {
      '' => [
        'bit',
        0x06,
        ',',
        'a'
      ]
    },
    0x0C => {
      '' => [
        'rrc',
        'h'
      ]
    },
    0x78 => {
      '' => [
        'bit',
        0x07,
        ',',
        'b'
      ]
    },
    0x79 => {
      '' => [
        'bit',
        0x07,
        ',',
        'c'
      ]
    },
    0x7A => {
      '' => [
        'bit',
        0x07,
        ',',
        'd'
      ]
    },
    0x7B => {
      '' => [
        'bit',
        0x07,
        ',',
        'e'
      ]
    },
    0x7C => {
      '' => [
        'bit',
        0x07,
        ',',
        'h'
      ]
    },
    0x7D => {
      '' => [
        'bit',
        0x07,
        ',',
        'l'
      ]
    },
    0x7E => {
      '' => [
        'bit',
        0x07,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x7F => {
      '' => [
        'bit',
        0x07,
        ',',
        'a'
      ]
    },
    0x80 => {
      '' => [
        'res',
        0x00,
        ',',
        'b'
      ]
    },
    0x81 => {
      '' => [
        'res',
        0x00,
        ',',
        'c'
      ]
    },
    0x0D => {
      '' => [
        'rrc',
        'l'
      ]
    },
    0x82 => {
      '' => [
        'res',
        0x00,
        ',',
        'd'
      ]
    },
    0x83 => {
      '' => [
        'res',
        0x00,
        ',',
        'e'
      ]
    },
    0x84 => {
      '' => [
        'res',
        0x00,
        ',',
        'h'
      ]
    },
    0x85 => {
      '' => [
        'res',
        0x00,
        ',',
        'l'
      ]
    },
    0x86 => {
      '' => [
        'res',
        0x00,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x87 => {
      '' => [
        'res',
        0x00,
        ',',
        'a'
      ]
    },
    0x88 => {
      '' => [
        'res',
        0x01,
        ',',
        'b'
      ]
    },
    0x89 => {
      '' => [
        'res',
        0x01,
        ',',
        'c'
      ]
    },
    0x8A => {
      '' => [
        'res',
        0x01,
        ',',
        'd'
      ]
    },
    0x8B => {
      '' => [
        'res',
        0x01,
        ',',
        'e'
      ]
    },
    0x0E => {
      '' => [
        'rrc',
        '(',
        'hl',
        ')'
      ]
    },
    0x8C => {
      '' => [
        'res',
        0x01,
        ',',
        'h'
      ]
    },
    0x8D => {
      '' => [
        'res',
        0x01,
        ',',
        'l'
      ]
    },
    0x8E => {
      '' => [
        'res',
        0x01,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x8F => {
      '' => [
        'res',
        0x01,
        ',',
        'a'
      ]
    },
    0x90 => {
      '' => [
        'res',
        0x02,
        ',',
        'b'
      ]
    },
    0x91 => {
      '' => [
        'res',
        0x02,
        ',',
        'c'
      ]
    },
    0x92 => {
      '' => [
        'res',
        0x02,
        ',',
        'd'
      ]
    },
    0x93 => {
      '' => [
        'res',
        0x02,
        ',',
        'e'
      ]
    },
    0x94 => {
      '' => [
        'res',
        0x02,
        ',',
        'h'
      ]
    },
    0x95 => {
      '' => [
        'res',
        0x02,
        ',',
        'l'
      ]
    },
    0x0F => {
      '' => [
        'rrc',
        'a'
      ]
    },
    0x96 => {
      '' => [
        'res',
        0x02,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x97 => {
      '' => [
        'res',
        0x02,
        ',',
        'a'
      ]
    },
    0x98 => {
      '' => [
        'res',
        0x03,
        ',',
        'b'
      ]
    },
    0x99 => {
      '' => [
        'res',
        0x03,
        ',',
        'c'
      ]
    },
    0x9A => {
      '' => [
        'res',
        0x03,
        ',',
        'd'
      ]
    },
    0x9B => {
      '' => [
        'res',
        0x03,
        ',',
        'e'
      ]
    },
    0x9C => {
      '' => [
        'res',
        0x03,
        ',',
        'h'
      ]
    },
    0x9D => {
      '' => [
        'res',
        0x03,
        ',',
        'l'
      ]
    },
    0x9E => {
      '' => [
        'res',
        0x03,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x9F => {
      '' => [
        'res',
        0x03,
        ',',
        'a'
      ]
    },
    0x10 => {
      '' => [
        'rl',
        'b'
      ]
    },
    0xA0 => {
      '' => [
        'res',
        0x04,
        ',',
        'b'
      ]
    },
    0xA1 => {
      '' => [
        'res',
        0x04,
        ',',
        'c'
      ]
    },
    0xA2 => {
      '' => [
        'res',
        0x04,
        ',',
        'd'
      ]
    },
    0xA3 => {
      '' => [
        'res',
        0x04,
        ',',
        'e'
      ]
    },
    0xA4 => {
      '' => [
        'res',
        0x04,
        ',',
        'h'
      ]
    },
    0xA5 => {
      '' => [
        'res',
        0x04,
        ',',
        'l'
      ]
    },
    0xA6 => {
      '' => [
        'res',
        0x04,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xA7 => {
      '' => [
        'res',
        0x04,
        ',',
        'a'
      ]
    },
    0xA8 => {
      '' => [
        'res',
        0x05,
        ',',
        'b'
      ]
    },
    0xA9 => {
      '' => [
        'res',
        0x05,
        ',',
        'c'
      ]
    },
    0x11 => {
      '' => [
        'rl',
        'c'
      ],
      0xCB => {
        0x10 => {
          '' => [
            'rl',
            'bc'
          ]
        }
      }
    },
    0xAA => {
      '' => [
        'res',
        0x05,
        ',',
        'd'
      ]
    },
    0xAB => {
      '' => [
        'res',
        0x05,
        ',',
        'e'
      ]
    },
    0xAC => {
      '' => [
        'res',
        0x05,
        ',',
        'h'
      ]
    },
    0xAD => {
      '' => [
        'res',
        0x05,
        ',',
        'l'
      ]
    },
    0xAE => {
      '' => [
        'res',
        0x05,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xAF => {
      '' => [
        'res',
        0x05,
        ',',
        'a'
      ]
    },
    0xB0 => {
      '' => [
        'res',
        0x06,
        ',',
        'b'
      ]
    },
    0xB1 => {
      '' => [
        'res',
        0x06,
        ',',
        'c'
      ]
    },
    0xB2 => {
      '' => [
        'res',
        0x06,
        ',',
        'd'
      ]
    },
    0xB3 => {
      '' => [
        'res',
        0x06,
        ',',
        'e'
      ]
    },
    0x12 => {
      '' => [
        'rl',
        'd'
      ]
    },
    0xB4 => {
      '' => [
        'res',
        0x06,
        ',',
        'h'
      ]
    },
    0xB5 => {
      '' => [
        'res',
        0x06,
        ',',
        'l'
      ]
    },
    0xB6 => {
      '' => [
        'res',
        0x06,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xB7 => {
      '' => [
        'res',
        0x06,
        ',',
        'a'
      ]
    },
    0xB8 => {
      '' => [
        'res',
        0x07,
        ',',
        'b'
      ]
    },
    0xB9 => {
      '' => [
        'res',
        0x07,
        ',',
        'c'
      ]
    },
    0xBA => {
      '' => [
        'res',
        0x07,
        ',',
        'd'
      ]
    },
    0xBB => {
      '' => [
        'res',
        0x07,
        ',',
        'e'
      ]
    },
    0xBC => {
      '' => [
        'res',
        0x07,
        ',',
        'h'
      ]
    },
    0xBD => {
      '' => [
        'res',
        0x07,
        ',',
        'l'
      ]
    },
    0x13 => {
      '' => [
        'rl',
        'e'
      ],
      0xCB => {
        0x12 => {
          '' => [
            'rl',
            'de'
          ]
        }
      }
    },
    0xBE => {
      '' => [
        'res',
        0x07,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xBF => {
      '' => [
        'res',
        0x07,
        ',',
        'a'
      ]
    },
    0xC0 => {
      '' => [
        'set',
        0x00,
        ',',
        'b'
      ]
    },
    0xC1 => {
      '' => [
        'set',
        0x00,
        ',',
        'c'
      ]
    },
    0xC2 => {
      '' => [
        'set',
        0x00,
        ',',
        'd'
      ]
    },
    0xC3 => {
      '' => [
        'set',
        0x00,
        ',',
        'e'
      ]
    },
    0xC4 => {
      '' => [
        'set',
        0x00,
        ',',
        'h'
      ]
    },
    0xC5 => {
      '' => [
        'set',
        0x00,
        ',',
        'l'
      ]
    },
    0xC6 => {
      '' => [
        'set',
        0x00,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xC7 => {
      '' => [
        'set',
        0x00,
        ',',
        'a'
      ]
    },
    0x02 => {
      '' => [
        'rlc',
        'd'
      ]
    },
    0x14 => {
      '' => [
        'rl',
        'h'
      ]
    },
    0xC8 => {
      '' => [
        'set',
        0x01,
        ',',
        'b'
      ]
    },
    0xC9 => {
      '' => [
        'set',
        0x01,
        ',',
        'c'
      ]
    },
    0xCA => {
      '' => [
        'set',
        0x01,
        ',',
        'd'
      ]
    },
    0xCB => {
      '' => [
        'set',
        0x01,
        ',',
        'e'
      ]
    },
    0xCC => {
      '' => [
        'set',
        0x01,
        ',',
        'h'
      ]
    },
    0xCD => {
      '' => [
        'set',
        0x01,
        ',',
        'l'
      ]
    },
    0xCE => {
      '' => [
        'set',
        0x01,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xCF => {
      '' => [
        'set',
        0x01,
        ',',
        'a'
      ]
    },
    0xD0 => {
      '' => [
        'set',
        0x02,
        ',',
        'b'
      ]
    },
    0xD1 => {
      '' => [
        'set',
        0x02,
        ',',
        'c'
      ]
    },
    0x15 => {
      '' => [
        'rl',
        'l'
      ],
      0xCB => {
        0x14 => {
          '' => [
            'rl',
            'hl'
          ]
        }
      }
    },
    0xD2 => {
      '' => [
        'set',
        0x02,
        ',',
        'd'
      ]
    },
    0xD3 => {
      '' => [
        'set',
        0x02,
        ',',
        'e'
      ]
    },
    0xD4 => {
      '' => [
        'set',
        0x02,
        ',',
        'h'
      ]
    },
    0xD5 => {
      '' => [
        'set',
        0x02,
        ',',
        'l'
      ]
    },
    0xD6 => {
      '' => [
        'set',
        0x02,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xD7 => {
      '' => [
        'set',
        0x02,
        ',',
        'a'
      ]
    },
    0xD8 => {
      '' => [
        'set',
        0x03,
        ',',
        'b'
      ]
    },
    0xD9 => {
      '' => [
        'set',
        0x03,
        ',',
        'c'
      ]
    },
    0xDA => {
      '' => [
        'set',
        0x03,
        ',',
        'd'
      ]
    },
    0xDB => {
      '' => [
        'set',
        0x03,
        ',',
        'e'
      ]
    },
    0x16 => {
      '' => [
        'rl',
        '(',
        'hl',
        ')'
      ]
    },
    0xDC => {
      '' => [
        'set',
        0x03,
        ',',
        'h'
      ]
    },
    0xDD => {
      '' => [
        'set',
        0x03,
        ',',
        'l'
      ]
    },
    0xDE => {
      '' => [
        'set',
        0x03,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xDF => {
      '' => [
        'set',
        0x03,
        ',',
        'a'
      ]
    },
    0xE0 => {
      '' => [
        'set',
        0x04,
        ',',
        'b'
      ]
    },
    0xE1 => {
      '' => [
        'set',
        0x04,
        ',',
        'c'
      ]
    },
    0xE2 => {
      '' => [
        'set',
        0x04,
        ',',
        'd'
      ]
    },
    0xE3 => {
      '' => [
        'set',
        0x04,
        ',',
        'e'
      ]
    },
    0xE4 => {
      '' => [
        'set',
        0x04,
        ',',
        'h'
      ]
    },
    0xE5 => {
      '' => [
        'set',
        0x04,
        ',',
        'l'
      ]
    },
    0x17 => {
      '' => [
        'rl',
        'a'
      ]
    },
    0xE6 => {
      '' => [
        'set',
        0x04,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xE7 => {
      '' => [
        'set',
        0x04,
        ',',
        'a'
      ]
    },
    0xE8 => {
      '' => [
        'set',
        0x05,
        ',',
        'b'
      ]
    },
    0xE9 => {
      '' => [
        'set',
        0x05,
        ',',
        'c'
      ]
    },
    0xEA => {
      '' => [
        'set',
        0x05,
        ',',
        'd'
      ]
    },
    0xEB => {
      '' => [
        'set',
        0x05,
        ',',
        'e'
      ]
    },
    0xEC => {
      '' => [
        'set',
        0x05,
        ',',
        'h'
      ]
    },
    0xED => {
      '' => [
        'set',
        0x05,
        ',',
        'l'
      ]
    },
    0xEE => {
      '' => [
        'set',
        0x05,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xEF => {
      '' => [
        'set',
        0x05,
        ',',
        'a'
      ]
    },
    0x18 => {
      '' => [
        'rr',
        'b'
      ],
      0xCB => {
        0x19 => {
          '' => [
            'rr',
            'bc'
          ]
        }
      }
    },
    0xF0 => {
      '' => [
        'set',
        0x06,
        ',',
        'b'
      ]
    },
    0xF1 => {
      '' => [
        'set',
        0x06,
        ',',
        'c'
      ]
    },
    0xF2 => {
      '' => [
        'set',
        0x06,
        ',',
        'd'
      ]
    },
    0xF3 => {
      '' => [
        'set',
        0x06,
        ',',
        'e'
      ]
    },
    0xF4 => {
      '' => [
        'set',
        0x06,
        ',',
        'h'
      ]
    },
    0xF5 => {
      '' => [
        'set',
        0x06,
        ',',
        'l'
      ]
    },
    0xF6 => {
      '' => [
        'set',
        0x06,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xF7 => {
      '' => [
        'set',
        0x06,
        ',',
        'a'
      ]
    },
    0xF8 => {
      '' => [
        'set',
        0x07,
        ',',
        'b'
      ]
    },
    0xF9 => {
      '' => [
        'set',
        0x07,
        ',',
        'c'
      ]
    },
    0x19 => {
      '' => [
        'rr',
        'c'
      ]
    },
    0xFA => {
      '' => [
        'set',
        0x07,
        ',',
        'd'
      ]
    },
    0xFB => {
      '' => [
        'set',
        0x07,
        ',',
        'e'
      ]
    },
    0xFC => {
      '' => [
        'set',
        0x07,
        ',',
        'h'
      ]
    },
    0xFD => {
      '' => [
        'set',
        0x07,
        ',',
        'l'
      ]
    },
    0xFE => {
      '' => [
        'set',
        0x07,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0xFF => {
      '' => [
        'set',
        0x07,
        ',',
        'a'
      ]
    },
    0x1A => {
      '' => [
        'rr',
        'd'
      ],
      0xCB => {
        0x1B => {
          '' => [
            'rr',
            'de'
          ]
        }
      }
    },
    0x1B => {
      '' => [
        'rr',
        'e'
      ]
    },
    0x1C => {
      '' => [
        'rr',
        'h'
      ],
      0xCB => {
        0x1D => {
          '' => [
            'rr',
            'hl'
          ]
        }
      }
    },
    0x1D => {
      '' => [
        'rr',
        'l'
      ]
    },
    0x03 => {
      '' => [
        'rlc',
        'e'
      ]
    },
    0x1E => {
      '' => [
        'rr',
        '(',
        'hl',
        ')'
      ]
    },
    0x1F => {
      '' => [
        'rr',
        'a'
      ]
    },
    0x20 => {
      '' => [
        'sla',
        'b'
      ]
    },
    0x21 => {
      '' => [
        'sla',
        'c'
      ],
      0xCB => {
        0x10 => {
          '' => [
            'sla',
            'bc'
          ]
        }
      }
    },
    0x22 => {
      '' => [
        'sla',
        'd'
      ]
    },
    0x23 => {
      '' => [
        'sla',
        'e'
      ],
      0xCB => {
        0x12 => {
          '' => [
            'sla',
            'de'
          ]
        }
      }
    },
    0x24 => {
      '' => [
        'sla',
        'h'
      ]
    },
    0x25 => {
      '' => [
        'sla',
        'l'
      ],
      0xCB => {
        0x14 => {
          '' => [
            'sla',
            'hl'
          ]
        }
      }
    },
    0x26 => {
      '' => [
        'sla',
        '(',
        'hl',
        ')'
      ]
    },
    0x27 => {
      '' => [
        'sla',
        'a'
      ]
    },
    0x04 => {
      '' => [
        'rlc',
        'h'
      ]
    },
    0x28 => {
      '' => [
        'sra',
        'b'
      ],
      0xCB => {
        0x19 => {
          '' => [
            'sra',
            'bc'
          ]
        }
      }
    },
    0x29 => {
      '' => [
        'sra',
        'c'
      ]
    },
    0x2A => {
      '' => [
        'sra',
        'd'
      ],
      0xCB => {
        0x1B => {
          '' => [
            'sra',
            'de'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'sra',
        'e'
      ]
    },
    0x2C => {
      '' => [
        'sra',
        'h'
      ],
      0xCB => {
        0x1D => {
          '' => [
            'sra',
            'hl'
          ]
        }
      }
    },
    0x2D => {
      '' => [
        'sra',
        'l'
      ]
    },
    0x2E => {
      '' => [
        'sra',
        '(',
        'hl',
        ')'
      ]
    },
    0x2F => {
      '' => [
        'sra',
        'a'
      ]
    },
    0x30 => {
      '' => [
        'sll',
        'b'
      ]
    },
    0x31 => {
      '' => [
        'sll',
        'c'
      ],
      0xCB => {
        0x10 => {
          '' => [
            'sll',
            'bc'
          ]
        }
      }
    },
    0x05 => {
      '' => [
        'rlc',
        'l'
      ]
    },
    0x32 => {
      '' => [
        'sll',
        'd'
      ]
    },
    0x33 => {
      '' => [
        'sll',
        'e'
      ],
      0xCB => {
        0x12 => {
          '' => [
            'sll',
            'de'
          ]
        }
      }
    },
    0x34 => {
      '' => [
        'sll',
        'h'
      ]
    },
    0x35 => {
      '' => [
        'sll',
        'l'
      ],
      0xCB => {
        0x14 => {
          '' => [
            'sll',
            'hl'
          ]
        }
      }
    },
    0x36 => {
      '' => [
        'sll',
        '(',
        'hl',
        ')'
      ]
    },
    0x37 => {
      '' => [
        'sll',
        'a'
      ]
    },
    0x38 => {
      '' => [
        'srl',
        'b'
      ],
      0xCB => {
        0x19 => {
          '' => [
            'srl',
            'bc'
          ]
        }
      }
    },
    0x39 => {
      '' => [
        'srl',
        'c'
      ]
    },
    0x3A => {
      '' => [
        'srl',
        'd'
      ],
      0xCB => {
        0x1B => {
          '' => [
            'srl',
            'de'
          ]
        }
      }
    },
    0x3B => {
      '' => [
        'srl',
        'e'
      ]
    },
    0x06 => {
      '' => [
        'rlc',
        '(',
        'hl',
        ')'
      ]
    },
    0x3C => {
      '' => [
        'srl',
        'h'
      ],
      0xCB => {
        0x1D => {
          '' => [
            'srl',
            'hl'
          ]
        }
      }
    },
    0x3D => {
      '' => [
        'srl',
        'l'
      ]
    },
    0x3E => {
      '' => [
        'srl',
        '(',
        'hl',
        ')'
      ]
    },
    0x3F => {
      '' => [
        'srl',
        'a'
      ]
    },
    0x40 => {
      '' => [
        'bit',
        0x00,
        ',',
        'b'
      ]
    },
    0x41 => {
      '' => [
        'bit',
        0x00,
        ',',
        'c'
      ]
    },
    0x42 => {
      '' => [
        'bit',
        0x00,
        ',',
        'd'
      ]
    },
    0x43 => {
      '' => [
        'bit',
        0x00,
        ',',
        'e'
      ]
    },
    0x44 => {
      '' => [
        'bit',
        0x00,
        ',',
        'h'
      ]
    },
    0x45 => {
      '' => [
        'bit',
        0x00,
        ',',
        'l'
      ]
    },
    0x07 => {
      '' => [
        'rlc',
        'a'
      ]
    },
    0x46 => {
      '' => [
        'bit',
        0x00,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x47 => {
      '' => [
        'bit',
        0x00,
        ',',
        'a'
      ]
    },
    0x48 => {
      '' => [
        'bit',
        0x01,
        ',',
        'b'
      ]
    },
    0x49 => {
      '' => [
        'bit',
        0x01,
        ',',
        'c'
      ]
    },
    0x4A => {
      '' => [
        'bit',
        0x01,
        ',',
        'd'
      ]
    },
    0x4B => {
      '' => [
        'bit',
        0x01,
        ',',
        'e'
      ]
    },
    0x4C => {
      '' => [
        'bit',
        0x01,
        ',',
        'h'
      ]
    },
    0x4D => {
      '' => [
        'bit',
        0x01,
        ',',
        'l'
      ]
    },
    0x4E => {
      '' => [
        'bit',
        0x01,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x4F => {
      '' => [
        'bit',
        0x01,
        ',',
        'a'
      ]
    },
    0x08 => {
      '' => [
        'rrc',
        'b'
      ]
    },
    0x50 => {
      '' => [
        'bit',
        0x02,
        ',',
        'b'
      ]
    },
    0x51 => {
      '' => [
        'bit',
        0x02,
        ',',
        'c'
      ]
    },
    0x52 => {
      '' => [
        'bit',
        0x02,
        ',',
        'd'
      ]
    },
    0x53 => {
      '' => [
        'bit',
        0x02,
        ',',
        'e'
      ]
    },
    0x54 => {
      '' => [
        'bit',
        0x02,
        ',',
        'h'
      ]
    },
    0x55 => {
      '' => [
        'bit',
        0x02,
        ',',
        'l'
      ]
    },
    0x56 => {
      '' => [
        'bit',
        0x02,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x57 => {
      '' => [
        'bit',
        0x02,
        ',',
        'a'
      ]
    },
    0x58 => {
      '' => [
        'bit',
        0x03,
        ',',
        'b'
      ]
    },
    0x59 => {
      '' => [
        'bit',
        0x03,
        ',',
        'c'
      ]
    },
    0x09 => {
      '' => [
        'rrc',
        'c'
      ]
    },
    0x5A => {
      '' => [
        'bit',
        0x03,
        ',',
        'd'
      ]
    },
    0x5B => {
      '' => [
        'bit',
        0x03,
        ',',
        'e'
      ]
    },
    0x5C => {
      '' => [
        'bit',
        0x03,
        ',',
        'h'
      ]
    },
    0x5D => {
      '' => [
        'bit',
        0x03,
        ',',
        'l'
      ]
    },
    0x5E => {
      '' => [
        'bit',
        0x03,
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x5F => {
      '' => [
        'bit',
        0x03,
        ',',
        'a'
      ]
    },
    0x60 => {
      '' => [
        'bit',
        0x04,
        ',',
        'b'
      ]
    },
    0x61 => {
      '' => [
        'bit',
        0x04,
        ',',
        'c'
      ]
    },
    0x62 => {
      '' => [
        'bit',
        0x04,
        ',',
        'd'
      ]
    },
    0x63 => {
      '' => [
        'bit',
        0x04,
        ',',
        'e'
      ]
    }
  },
  0xCC => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'z',
          ',',
          'NN'
        ]
      }
    }
  },
  0xCD => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'NN'
        ]
      }
    }
  },
  0xCE => {
    'N' => {
      '' => [
        'adc',
        'a',
        ',',
        'N'
      ]
    }
  },
  0xCF => {
    '' => [
      'rst',
      0x08
    ]
  },
  0xD0 => {
    '' => [
      'ret',
      'nc'
    ]
  },
  0xD1 => {
    '' => [
      'pop',
      'de'
    ]
  },
  0x15 => {
    '' => [
      'dec',
      'd'
    ]
  },
  0xD2 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'nc',
          ',',
          'NN'
        ]
      }
    }
  },
  0xD3 => {
    'N' => {
      '' => [
        'out',
        '(',
        'N',
        ')',
        ',',
        'a'
      ]
    }
  },
  0xD4 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'nc',
          ',',
          'NN'
        ]
      }
    }
  },
  0xD5 => {
    '' => [
      'push',
      'de'
    ]
  },
  0xD6 => {
    'N' => {
      '' => [
        'sub',
        'N'
      ]
    }
  },
  0xD7 => {
    '' => [
      'rst',
      0x10
    ]
  },
  0xD8 => {
    '' => [
      'ret',
      'c'
    ]
  },
  0xD9 => {
    '' => [
      'exx'
    ]
  },
  0xDA => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'c',
          ',',
          'NN'
        ]
      }
    }
  },
  0xDB => {
    'N' => {
      '' => [
        'in',
        'a',
        ',',
        '(',
        'N',
        ')'
      ]
    }
  },
  0x16 => {
    'N' => {
      '' => [
        'ld',
        'd',
        ',',
        'N'
      ]
    }
  },
  0xDC => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'c',
          ',',
          'NN'
        ]
      }
    }
  },
  0xDD => {
    0x64 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'ixh'
      ]
    },
    0x65 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'ixl'
      ]
    },
    0x66 => {
      0x00 => {
        '' => [
          'ld',
          'h',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'h',
              ',',
              '(',
              'ix',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'h',
              ',',
              '(',
              'ix',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'h',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'h',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'h',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'h',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'h',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'h',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x67 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'a'
      ]
    },
    0x68 => {
      '' => [
        'ld',
        'ixl',
        ',',
        'b'
      ]
    },
    0x69 => {
      '' => [
        'ld',
        'ixl',
        ',',
        'c'
      ],
      0xDD => {
        0x60 => {
          '' => [
            'ld',
            'ix',
            ',',
            'bc'
          ]
        }
      }
    },
    0x6A => {
      '' => [
        'ld',
        'ixl',
        ',',
        'd'
      ]
    },
    0x6B => {
      '' => [
        'ld',
        'ixl',
        ',',
        'e'
      ],
      0xDD => {
        0x62 => {
          '' => [
            'ld',
            'ix',
            ',',
            'de'
          ]
        }
      }
    },
    0x6C => {
      '' => [
        'ld',
        'ixl',
        ',',
        'ixh'
      ]
    },
    0x6D => {
      '' => [
        'ld',
        'ixl',
        ',',
        'ixl'
      ],
      0xDD => {
        0x64 => {
          '' => [
            'ld',
            'ix',
            ',',
            'ix'
          ]
        }
      }
    },
    0x6E => {
      0x00 => {
        '' => [
          'ld',
          'l',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x66 => {
            0x01 => {
              '' => [
                'ld',
                'hl',
                ',',
                '(',
                'ix',
                ')'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              'l',
              ',',
              '(',
              'ix',
              ')'
            ],
            0xDD => {
              0x66 => {
                0x00 => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'hl',
                        ',',
                        '(',
                        'ix',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'l',
              ',',
              '(',
              'ix',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'l',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x66 => {
            'DIS+1' => {
              '' => [
                'ld',
                'hl',
                ',',
                '(',
                'ix',
                '+',
                'DIS',
                ')'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              'l',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ],
            0xDD => {
              0x66 => {
                'DIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'hl',
                        ',',
                        '(',
                        'ix',
                        '+',
                        'DIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'l',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'l',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x66 => {
            'NDIS+1' => {
              '' => [
                'ld',
                'hl',
                ',',
                '(',
                'ix',
                '-',
                'NDIS',
                ')'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              'l',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ],
            0xDD => {
              0x66 => {
                'NDIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'hl',
                        ',',
                        '(',
                        'ix',
                        '-',
                        'NDIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'l',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x6F => {
      '' => [
        'ld',
        'ixl',
        ',',
        'a'
      ]
    },
    0x70 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'b'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'b'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'b'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'b'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'b'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'b'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'b'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'b'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'b'
            ]
          }
        }
      }
    },
    0x71 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'c'
        ],
        0xDD => {
          0x70 => {
            0x01 => {
              '' => [
                'ld',
                '(',
                'ix',
                ')',
                ',',
                'bc'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'c'
            ],
            0xDD => {
              0x70 => {
                0x00 => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        ')',
                        ',',
                        'bc'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'c'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'c'
        ],
        0xDD => {
          0x70 => {
            'DIS+1' => {
              '' => [
                'ld',
                '(',
                'ix',
                '+',
                'DIS',
                ')',
                ',',
                'bc'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'c'
            ],
            0xDD => {
              0x70 => {
                'DIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        '+',
                        'DIS',
                        ')',
                        ',',
                        'bc'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'c'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'c'
        ],
        0xDD => {
          0x70 => {
            'NDIS+1' => {
              '' => [
                'ld',
                '(',
                'ix',
                '-',
                'NDIS',
                ')',
                ',',
                'bc'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'c'
            ],
            0xDD => {
              0x70 => {
                'NDIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        '-',
                        'NDIS',
                        ')',
                        ',',
                        'bc'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'c'
            ]
          }
        }
      }
    },
    0x72 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'd'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'd'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'd'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'd'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'd'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'd'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'd'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'd'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'd'
            ]
          }
        }
      }
    },
    0x73 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'e'
        ],
        0xDD => {
          0x72 => {
            0x01 => {
              '' => [
                'ld',
                '(',
                'ix',
                ')',
                ',',
                'de'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'e'
            ],
            0xDD => {
              0x72 => {
                0x00 => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        ')',
                        ',',
                        'de'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'e'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'e'
        ],
        0xDD => {
          0x72 => {
            'DIS+1' => {
              '' => [
                'ld',
                '(',
                'ix',
                '+',
                'DIS',
                ')',
                ',',
                'de'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'e'
            ],
            0xDD => {
              0x72 => {
                'DIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        '+',
                        'DIS',
                        ')',
                        ',',
                        'de'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'e'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'e'
        ],
        0xDD => {
          0x72 => {
            'NDIS+1' => {
              '' => [
                'ld',
                '(',
                'ix',
                '-',
                'NDIS',
                ')',
                ',',
                'de'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'e'
            ],
            0xDD => {
              0x72 => {
                'NDIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        '-',
                        'NDIS',
                        ')',
                        ',',
                        'de'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'e'
            ]
          }
        }
      }
    },
    0x74 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'h'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'h'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'h'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'h'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'h'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'h'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'h'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'h'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'h'
            ]
          }
        }
      }
    },
    0x75 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'l'
        ],
        0xDD => {
          0x74 => {
            0x01 => {
              '' => [
                'ld',
                '(',
                'ix',
                ')',
                ',',
                'hl'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'l'
            ],
            0xDD => {
              0x74 => {
                0x00 => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        ')',
                        ',',
                        'hl'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'l'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'l'
        ],
        0xDD => {
          0x74 => {
            'DIS+1' => {
              '' => [
                'ld',
                '(',
                'ix',
                '+',
                'DIS',
                ')',
                ',',
                'hl'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'l'
            ],
            0xDD => {
              0x74 => {
                'DIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        '+',
                        'DIS',
                        ')',
                        ',',
                        'hl'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'l'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'l'
        ],
        0xDD => {
          0x74 => {
            'NDIS+1' => {
              '' => [
                'ld',
                '(',
                'ix',
                '-',
                'NDIS',
                ')',
                ',',
                'hl'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'l'
            ],
            0xDD => {
              0x74 => {
                'NDIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'ix',
                        '-',
                        'NDIS',
                        ')',
                        ',',
                        'hl'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'l'
            ]
          }
        }
      }
    },
    0x77 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'ix',
          ')',
          ',',
          'a'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              ')',
              ',',
              'a'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              ')',
              ',',
              'a'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '+',
          'DIS',
          ')',
          ',',
          'a'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'a'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '+',
              'DIS',
              ')',
              ',',
              'a'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'ix',
          '-',
          'NDIS',
          ')',
          ',',
          'a'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'a'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'ix',
              '-',
              'NDIS',
              ')',
              ',',
              'a'
            ]
          }
        }
      }
    },
    0x7C => {
      '' => [
        'ld',
        'a',
        ',',
        'ixh'
      ]
    },
    0x7D => {
      '' => [
        'ld',
        'a',
        ',',
        'ixl'
      ]
    },
    0x7E => {
      0x00 => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'a',
              ',',
              '(',
              'ix',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'a',
              ',',
              '(',
              'ix',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'a',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'a',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'a',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'a',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x84 => {
      '' => [
        'add',
        'a',
        ',',
        'ixh'
      ]
    },
    0x85 => {
      '' => [
        'add',
        'a',
        ',',
        'ixl'
      ]
    },
    0x86 => {
      0x00 => {
        '' => [
          'add',
          'a',
          ',',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'add',
          'a',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'add',
          'a',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x8C => {
      '' => [
        'adc',
        'a',
        ',',
        'ixh'
      ]
    },
    0x8D => {
      '' => [
        'adc',
        'a',
        ',',
        'ixl'
      ]
    },
    0x8E => {
      0x00 => {
        '' => [
          'adc',
          'a',
          ',',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'adc',
          'a',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'adc',
          'a',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x94 => {
      '' => [
        'sub',
        'ixh'
      ]
    },
    0x95 => {
      '' => [
        'sub',
        'ixl'
      ]
    },
    0x96 => {
      0x00 => {
        '' => [
          'sub',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'sub',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'sub',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x9C => {
      '' => [
        'sbc',
        'a',
        ',',
        'ixh'
      ]
    },
    0x9D => {
      '' => [
        'sbc',
        'a',
        ',',
        'ixl'
      ]
    },
    0x9E => {
      0x00 => {
        '' => [
          'sbc',
          'a',
          ',',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'sbc',
          'a',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'sbc',
          'a',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xA4 => {
      '' => [
        'and',
        'ixh'
      ]
    },
    0xA5 => {
      '' => [
        'and',
        'ixl'
      ]
    },
    0xA6 => {
      0x00 => {
        '' => [
          'and',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'and',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'and',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xAC => {
      '' => [
        'xor',
        'ixh'
      ]
    },
    0xAD => {
      '' => [
        'xor',
        'ixl'
      ]
    },
    0xAE => {
      0x00 => {
        '' => [
          'xor',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'xor',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'xor',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xB4 => {
      '' => [
        'or',
        'ixh'
      ]
    },
    0xB5 => {
      '' => [
        'or',
        'ixl'
      ]
    },
    0xB6 => {
      0x00 => {
        '' => [
          'or',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'or',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'or',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xBC => {
      '' => [
        'cp',
        'ixh'
      ]
    },
    0xBD => {
      '' => [
        'cp',
        'ixl'
      ]
    },
    0xBE => {
      0x00 => {
        '' => [
          'cp',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'cp',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'cp',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xCB => {
      0x00 => {
        0x00 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x01 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x0A => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x66 => {
          '' => [
            'bit',
            0x04,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x0B => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x6E => {
          '' => [
            'bit',
            0x05,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x76 => {
          '' => [
            'bit',
            0x06,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x0C => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x7E => {
          '' => [
            'bit',
            0x07,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x80 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x81 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x0D => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x82 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x83 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x84 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x85 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x86 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x87 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x88 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x89 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x8A => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x8B => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x0E => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')'
          ]
        },
        0x8C => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x8D => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x8E => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x8F => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x90 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x91 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x92 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x93 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x94 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x95 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x0F => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x96 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x97 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x98 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x99 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x9A => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x9B => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x9C => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x9D => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x9E => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x9F => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x10 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xA0 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xA1 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xA2 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xA3 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xA4 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xA5 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xA6 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xA7 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xA8 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xA9 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x11 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xAA => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xAB => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xAC => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xAD => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xAE => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xAF => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xB0 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xB1 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xB2 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xB3 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x12 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xB4 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xB5 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xB6 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xB7 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xB8 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xB9 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xBA => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xBB => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xBC => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xBD => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x13 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xBE => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xBF => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xC0 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xC1 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xC2 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xC3 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xC4 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xC5 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xC6 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xC7 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x02 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x14 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xC8 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xC9 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xCA => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xCB => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xCC => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xCD => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xCE => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xCF => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xD0 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xD1 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x15 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xD2 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xD3 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xD4 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xD5 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xD6 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xD7 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xD8 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xD9 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xDA => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xDB => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x16 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')'
          ]
        },
        0xDC => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xDD => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xDE => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xDF => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xE0 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xE1 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xE2 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xE3 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xE4 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xE5 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x17 => {
          '' => [
            'rl',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xE6 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xE7 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xE8 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xE9 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xEA => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xEB => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xEC => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xED => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xEE => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xEF => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x18 => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xF0 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xF1 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xF2 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xF3 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xF4 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xF5 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xF6 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xF7 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0xF8 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0xF9 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x19 => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0xFA => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0xFB => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0xFC => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0xFD => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0xFE => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0xFF => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x1A => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x1B => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x1C => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x1D => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x03 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x1E => {
          '' => [
            'rr',
            '(',
            'ix',
            ')'
          ]
        },
        0x1F => {
          '' => [
            'rr',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x20 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x21 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x22 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x23 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x24 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x25 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x26 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')'
          ]
        },
        0x27 => {
          '' => [
            'sla',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x04 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x28 => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x29 => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x2A => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x2B => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x2C => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x2D => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x2E => {
          '' => [
            'sra',
            '(',
            'ix',
            ')'
          ]
        },
        0x2F => {
          '' => [
            'sra',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x30 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x31 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x05 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x32 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x33 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x34 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x35 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x36 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')'
          ]
        },
        0x37 => {
          '' => [
            'sll',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x38 => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x39 => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x3A => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'd'
          ]
        },
        0x3B => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'e'
          ]
        },
        0x06 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')'
          ]
        },
        0x3C => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'h'
          ]
        },
        0x3D => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'l'
          ]
        },
        0x3E => {
          '' => [
            'srl',
            '(',
            'ix',
            ')'
          ]
        },
        0x3F => {
          '' => [
            'srl',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x07 => {
          '' => [
            'rlc',
            '(',
            'ix',
            ')',
            ',',
            'a'
          ]
        },
        0x46 => {
          '' => [
            'bit',
            0x00,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x4E => {
          '' => [
            'bit',
            0x01,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x08 => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'b'
          ]
        },
        0x56 => {
          '' => [
            'bit',
            0x02,
            ',',
            '(',
            'ix',
            ')'
          ]
        },
        0x09 => {
          '' => [
            'rrc',
            '(',
            'ix',
            ')',
            ',',
            'c'
          ]
        },
        0x5E => {
          '' => [
            'bit',
            0x03,
            ',',
            '(',
            'ix',
            ')'
          ]
        }
      },
      'DIS' => {
        0x00 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x01 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0A => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x66 => {
          '' => [
            'bit',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x0B => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x6E => {
          '' => [
            'bit',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x76 => {
          '' => [
            'bit',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x0C => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x7E => {
          '' => [
            'bit',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x80 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x81 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0D => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x82 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x83 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x84 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x85 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x86 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x87 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x88 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x89 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x8A => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x8B => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x0E => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x8C => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x8D => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x8E => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x8F => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x90 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x91 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x92 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x93 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x94 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x95 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x0F => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x96 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x97 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x98 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x99 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x9A => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x9B => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x9C => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x9D => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x9E => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x9F => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x10 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA0 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA1 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xA2 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xA3 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xA4 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xA5 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xA6 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xA7 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xA8 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA9 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x11 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xAA => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xAB => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xAC => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xAD => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xAE => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xAF => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB0 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB1 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xB2 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB3 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x12 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB4 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xB5 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xB6 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xB7 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB8 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB9 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xBA => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xBB => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBC => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xBD => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x13 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBE => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xBF => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xC0 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC1 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xC2 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xC3 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xC4 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC5 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xC6 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xC7 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x02 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x14 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC8 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC9 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xCA => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xCB => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xCC => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xCD => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xCE => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xCF => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD0 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD1 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x15 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD2 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xD3 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xD4 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xD5 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD6 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xD7 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD8 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD9 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xDA => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xDB => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x16 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xDC => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xDD => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xDE => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xDF => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE0 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE1 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xE2 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xE3 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xE4 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xE5 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x17 => {
          '' => [
            'rl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE6 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xE7 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE8 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE9 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xEA => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xEB => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xEC => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xED => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xEE => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xEF => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x18 => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF0 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF1 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xF2 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xF3 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xF4 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xF5 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xF6 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xF7 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xF8 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF9 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x19 => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xFA => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xFB => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xFC => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xFD => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xFE => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0xFF => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x1A => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x1B => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1C => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x1D => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x03 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1E => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x1F => {
          '' => [
            'rr',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x20 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x21 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x22 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x23 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x24 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x25 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x26 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x27 => {
          '' => [
            'sla',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x04 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x28 => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x29 => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x2A => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x2B => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x2C => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x2D => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x2E => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x2F => {
          '' => [
            'sra',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x30 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x31 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x05 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x32 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x33 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x34 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x35 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x36 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x37 => {
          '' => [
            'sll',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x38 => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x39 => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x3A => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x3B => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x06 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x3C => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x3D => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x3E => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x3F => {
          '' => [
            'srl',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x07 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x46 => {
          '' => [
            'bit',
            0x00,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x4E => {
          '' => [
            'bit',
            0x01,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x08 => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x56 => {
          '' => [
            'bit',
            0x02,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        },
        0x09 => {
          '' => [
            'rrc',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x5E => {
          '' => [
            'bit',
            0x03,
            ',',
            '(',
            'ix',
            '+',
            'DIS',
            ')'
          ]
        }
      },
      'NDIS' => {
        0x00 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x01 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0A => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x66 => {
          '' => [
            'bit',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x0B => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x6E => {
          '' => [
            'bit',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x76 => {
          '' => [
            'bit',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x0C => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x7E => {
          '' => [
            'bit',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x80 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x81 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0D => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x82 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x83 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x84 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x85 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x86 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x87 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x88 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x89 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x8A => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x8B => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x0E => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x8C => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x8D => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x8E => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x8F => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x90 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x91 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x92 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x93 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x94 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x95 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x0F => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x96 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x97 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x98 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x99 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x9A => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x9B => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x9C => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x9D => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x9E => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x9F => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x10 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA0 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA1 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xA2 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xA3 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xA4 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xA5 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xA6 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xA7 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xA8 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA9 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x11 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xAA => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xAB => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xAC => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xAD => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xAE => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xAF => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB0 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB1 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xB2 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB3 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x12 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB4 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xB5 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xB6 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xB7 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB8 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB9 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xBA => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xBB => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBC => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xBD => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x13 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBE => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xBF => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xC0 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC1 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xC2 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xC3 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xC4 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC5 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xC6 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xC7 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x02 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x14 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC8 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC9 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xCA => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xCB => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xCC => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xCD => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xCE => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xCF => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD0 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD1 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x15 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD2 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xD3 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xD4 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xD5 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD6 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xD7 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD8 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD9 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xDA => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xDB => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x16 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xDC => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xDD => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xDE => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xDF => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE0 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE1 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xE2 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xE3 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xE4 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xE5 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x17 => {
          '' => [
            'rl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE6 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xE7 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE8 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE9 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xEA => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xEB => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xEC => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xED => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xEE => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xEF => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x18 => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF0 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF1 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xF2 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xF3 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xF4 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xF5 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xF6 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xF7 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xF8 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF9 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x19 => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xFA => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xFB => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xFC => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xFD => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xFE => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xFF => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x1A => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x1B => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1C => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x1D => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x03 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1E => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x1F => {
          '' => [
            'rr',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x20 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x21 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x22 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x23 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x24 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x25 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x26 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x27 => {
          '' => [
            'sla',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x04 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x28 => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x29 => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x2A => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x2B => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x2C => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x2D => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x2E => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x2F => {
          '' => [
            'sra',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x30 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x31 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x05 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x32 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x33 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x34 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x35 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x36 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x37 => {
          '' => [
            'sll',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x38 => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x39 => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x3A => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x3B => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x06 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x3C => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x3D => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x3E => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x3F => {
          '' => [
            'srl',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x07 => {
          '' => [
            'rlc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x46 => {
          '' => [
            'bit',
            0x00,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x4E => {
          '' => [
            'bit',
            0x01,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x08 => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x56 => {
          '' => [
            'bit',
            0x02,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x09 => {
          '' => [
            'rrc',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x5E => {
          '' => [
            'bit',
            0x03,
            ',',
            '(',
            'ix',
            '-',
            'NDIS',
            ')'
          ]
        }
      }
    },
    0xDD => {
      0x00 => {
        '' => [
          'stop'
        ]
      }
    },
    0xE1 => {
      '' => [
        'pop',
        'ix'
      ]
    },
    0xE3 => {
      '' => [
        'ex',
        '(',
        'sp',
        ')',
        ',',
        'ix'
      ]
    },
    0xE5 => {
      '' => [
        'push',
        'ix'
      ],
      0xE1 => {
        '' => [
          'ld',
          'hl',
          ',',
          'ix'
        ]
      },
      0xFD => {
        0xE1 => {
          '' => [
            'ld',
            'iy',
            ',',
            'ix'
          ]
        }
      }
    },
    0xE9 => {
      '' => [
        'jp',
        '(',
        'ix',
        ')'
      ]
    },
    0xF9 => {
      '' => [
        'ld',
        'sp',
        ',',
        'ix'
      ]
    },
    0x19 => {
      '' => [
        'add',
        'ix',
        ',',
        'de'
      ]
    },
    0x21 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'ix',
            ',',
            'NN'
          ]
        }
      }
    },
    0x22 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            '(',
            'NN',
            ')',
            ',',
            'ix'
          ]
        }
      }
    },
    0x23 => {
      '' => [
        'inc',
        'ix'
      ]
    },
    0x24 => {
      '' => [
        'inc',
        'ixh'
      ]
    },
    0x25 => {
      '' => [
        'dec',
        'ixh'
      ]
    },
    0x26 => {
      'N' => {
        '' => [
          'ld',
          'ixh',
          ',',
          'N'
        ]
      }
    },
    0x29 => {
      '' => [
        'add',
        'ix',
        ',',
        'ix'
      ]
    },
    0x2A => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'ix',
            ',',
            '(',
            'NN',
            ')'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'dec',
        'ix'
      ]
    },
    0x2C => {
      '' => [
        'inc',
        'ixl'
      ]
    },
    0x2D => {
      '' => [
        'dec',
        'ixl'
      ]
    },
    0x2E => {
      'N' => {
        '' => [
          'ld',
          'ixl',
          ',',
          'N'
        ]
      }
    },
    0x34 => {
      0x00 => {
        '' => [
          'inc',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'inc',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'inc',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x35 => {
      0x00 => {
        '' => [
          'dec',
          '(',
          'ix',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'dec',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'dec',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x36 => {
      0x00 => {
        'N' => {
          '' => [
            'ld',
            '(',
            'ix',
            ')',
            ',',
            'N'
          ],
          0xDD => {
            0x23 => {
              '' => [
                'ldi',
                '(',
                'ix',
                ')',
                ',',
                'N'
              ]
            },
            0x2B => {
              '' => [
                'ldd',
                '(',
                'ix',
                ')',
                ',',
                'N'
              ]
            }
          }
        }
      },
      'DIS' => {
        'N' => {
          '' => [
            'ld',
            '(',
            'ix',
            '+',
            'DIS',
            ')',
            ',',
            'N'
          ],
          0xDD => {
            0x23 => {
              '' => [
                'ldi',
                '(',
                'ix',
                '+',
                'DIS',
                ')',
                ',',
                'N'
              ]
            },
            0x2B => {
              '' => [
                'ldd',
                '(',
                'ix',
                '+',
                'DIS',
                ')',
                ',',
                'N'
              ]
            }
          }
        }
      },
      'NDIS' => {
        'N' => {
          '' => [
            'ld',
            '(',
            'ix',
            '-',
            'NDIS',
            ')',
            ',',
            'N'
          ],
          0xDD => {
            0x23 => {
              '' => [
                'ldi',
                '(',
                'ix',
                '-',
                'NDIS',
                ')',
                ',',
                'N'
              ]
            },
            0x2B => {
              '' => [
                'ldd',
                '(',
                'ix',
                '-',
                'NDIS',
                ')',
                ',',
                'N'
              ]
            }
          }
        }
      }
    },
    0x39 => {
      '' => [
        'add',
        'ix',
        ',',
        'sp'
      ]
    },
    0x44 => {
      '' => [
        'ld',
        'b',
        ',',
        'ixh'
      ],
      0xDD => {
        0x4D => {
          '' => [
            'ld',
            'bc',
            ',',
            'ix'
          ]
        }
      }
    },
    0x45 => {
      '' => [
        'ld',
        'b',
        ',',
        'ixl'
      ]
    },
    0x46 => {
      0x00 => {
        '' => [
          'ld',
          'b',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'b',
              ',',
              '(',
              'ix',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'b',
              ',',
              '(',
              'ix',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'b',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'b',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'b',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'b',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'b',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'b',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x4C => {
      '' => [
        'ld',
        'c',
        ',',
        'ixh'
      ]
    },
    0x4D => {
      '' => [
        'ld',
        'c',
        ',',
        'ixl'
      ]
    },
    0x4E => {
      0x00 => {
        '' => [
          'ld',
          'c',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'c',
              ',',
              '(',
              'ix',
              ')'
            ],
            0xDD => {
              0x46 => {
                0x00 => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'bc',
                        ',',
                        '(',
                        'ix',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'c',
              ',',
              '(',
              'ix',
              ')'
            ]
          },
          0x46 => {
            0x01 => {
              '' => [
                'ld',
                'bc',
                ',',
                '(',
                'ix',
                ')'
              ]
            }
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'c',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'c',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ],
            0xDD => {
              0x46 => {
                'DIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'bc',
                        ',',
                        '(',
                        'ix',
                        '+',
                        'DIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'c',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          },
          0x46 => {
            'DIS+1' => {
              '' => [
                'ld',
                'bc',
                ',',
                '(',
                'ix',
                '+',
                'DIS',
                ')'
              ]
            }
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'c',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'c',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ],
            0xDD => {
              0x46 => {
                'NDIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'bc',
                        ',',
                        '(',
                        'ix',
                        '-',
                        'NDIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'c',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x46 => {
            'NDIS+1' => {
              '' => [
                'ld',
                'bc',
                ',',
                '(',
                'ix',
                '-',
                'NDIS',
                ')'
              ]
            }
          }
        }
      }
    },
    0x54 => {
      '' => [
        'ld',
        'd',
        ',',
        'ixh'
      ],
      0xDD => {
        0x5D => {
          '' => [
            'ld',
            'de',
            ',',
            'ix'
          ]
        }
      }
    },
    0x55 => {
      '' => [
        'ld',
        'd',
        ',',
        'ixl'
      ]
    },
    0x56 => {
      0x00 => {
        '' => [
          'ld',
          'd',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'd',
              ',',
              '(',
              'ix',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'd',
              ',',
              '(',
              'ix',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'd',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'd',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'd',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'd',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'd',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'd',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x09 => {
      '' => [
        'add',
        'ix',
        ',',
        'bc'
      ]
    },
    0x5C => {
      '' => [
        'ld',
        'e',
        ',',
        'ixh'
      ]
    },
    0x5D => {
      '' => [
        'ld',
        'e',
        ',',
        'ixl'
      ]
    },
    0x5E => {
      0x00 => {
        '' => [
          'ld',
          'e',
          ',',
          '(',
          'ix',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'e',
              ',',
              '(',
              'ix',
              ')'
            ],
            0xDD => {
              0x56 => {
                0x00 => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'de',
                        ',',
                        '(',
                        'ix',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'e',
              ',',
              '(',
              'ix',
              ')'
            ]
          },
          0x56 => {
            0x01 => {
              '' => [
                'ld',
                'de',
                ',',
                '(',
                'ix',
                ')'
              ]
            }
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'e',
          ',',
          '(',
          'ix',
          '+',
          'DIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'e',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ],
            0xDD => {
              0x56 => {
                'DIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'de',
                        ',',
                        '(',
                        'ix',
                        '+',
                        'DIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'e',
              ',',
              '(',
              'ix',
              '+',
              'DIS',
              ')'
            ]
          },
          0x56 => {
            'DIS+1' => {
              '' => [
                'ld',
                'de',
                ',',
                '(',
                'ix',
                '+',
                'DIS',
                ')'
              ]
            }
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'e',
          ',',
          '(',
          'ix',
          '-',
          'NDIS',
          ')'
        ],
        0xDD => {
          0x23 => {
            '' => [
              'ldi',
              'e',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ],
            0xDD => {
              0x56 => {
                'NDIS' => {
                  0xDD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'de',
                        ',',
                        '(',
                        'ix',
                        '-',
                        'NDIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'e',
              ',',
              '(',
              'ix',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x56 => {
            'NDIS+1' => {
              '' => [
                'ld',
                'de',
                ',',
                '(',
                'ix',
                '-',
                'NDIS',
                ')'
              ]
            }
          }
        }
      }
    },
    0x60 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'b'
      ]
    },
    0x61 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'c'
      ]
    },
    0x62 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'd'
      ]
    },
    0x63 => {
      '' => [
        'ld',
        'ixh',
        ',',
        'e'
      ]
    }
  },
  0xDE => {
    'N' => {
      '' => [
        'sbc',
        'a',
        ',',
        'N'
      ]
    }
  },
  0xDF => {
    '' => [
      'rst',
      0x18
    ]
  },
  0xE0 => {
    '' => [
      'ret',
      'po'
    ]
  },
  0xE1 => {
    '' => [
      'pop',
      'hl'
    ]
  },
  0xE2 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'po',
          ',',
          'NN'
        ]
      }
    }
  },
  0xE3 => {
    '' => [
      'ex',
      '(',
      'sp',
      ')',
      ',',
      'hl'
    ]
  },
  0xE4 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'po',
          ',',
          'NN'
        ]
      }
    }
  },
  0xE5 => {
    '' => [
      'push',
      'hl'
    ],
    0xDD => {
      0xE1 => {
        '' => [
          'ld',
          'ix',
          ',',
          'hl'
        ]
      }
    },
    0xFD => {
      0xE1 => {
        '' => [
          'ld',
          'iy',
          ',',
          'hl'
        ]
      }
    }
  },
  0x17 => {
    '' => [
      'rla'
    ]
  },
  0xE6 => {
    'N' => {
      '' => [
        'and',
        'N'
      ]
    }
  },
  0xE7 => {
    '' => [
      'rst',
      0x20
    ]
  },
  0xE8 => {
    '' => [
      'ret',
      'pe'
    ]
  },
  0xE9 => {
    '' => [
      'jp',
      '(',
      'hl',
      ')'
    ]
  },
  0xEA => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'pe',
          ',',
          'NN'
        ]
      }
    }
  },
  0xEB => {
    '' => [
      'ex',
      'de',
      ',',
      'hl'
    ]
  },
  0xEC => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'pe',
          ',',
          'NN'
        ]
      }
    }
  },
  0xED => {
    0x67 => {
      '' => [
        'rrd'
      ]
    },
    0x68 => {
      '' => [
        'in',
        'l',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x69 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'l'
      ]
    },
    0x6A => {
      '' => [
        'adc',
        'hl',
        ',',
        'hl'
      ]
    },
    0x6B => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'hl',
            ',',
            '(',
            'NN',
            ')'
          ]
        }
      }
    },
    0x6F => {
      '' => [
        'rld'
      ]
    },
    0x70 => {
      '' => [
        'in',
        'f',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x71 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        0x00
      ]
    },
    0x72 => {
      '' => [
        'sbc',
        'hl',
        ',',
        'sp'
      ]
    },
    0x73 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            '(',
            'NN',
            ')',
            ',',
            'sp'
          ]
        }
      }
    },
    0x78 => {
      '' => [
        'in',
        'a',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x79 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'a'
      ]
    },
    0x7A => {
      '' => [
        'adc',
        'hl',
        ',',
        'sp'
      ]
    },
    0x7B => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'sp',
            ',',
            '(',
            'NN',
            ')'
          ]
        }
      }
    },
    0xA0 => {
      '' => [
        'ldi'
      ]
    },
    0xA1 => {
      '' => [
        'cpi'
      ]
    },
    0xA2 => {
      '' => [
        'ini'
      ]
    },
    0xA3 => {
      '' => [
        'outi'
      ]
    },
    0xA8 => {
      '' => [
        'ldd'
      ]
    },
    0xA9 => {
      '' => [
        'cpd'
      ]
    },
    0xAA => {
      '' => [
        'ind'
      ]
    },
    0xAB => {
      '' => [
        'outd'
      ]
    },
    0xB0 => {
      '' => [
        'ldir'
      ]
    },
    0xB1 => {
      '' => [
        'cpir'
      ]
    },
    0xB2 => {
      '' => [
        'inir'
      ]
    },
    0xB3 => {
      '' => [
        'otir'
      ]
    },
    0xB8 => {
      '' => [
        'lddr'
      ]
    },
    0xB9 => {
      '' => [
        'cpdr'
      ]
    },
    0xBA => {
      '' => [
        'indr'
      ]
    },
    0xBB => {
      '' => [
        'otdr'
      ]
    },
    0x40 => {
      '' => [
        'in',
        'b',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x41 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'b'
      ]
    },
    0x42 => {
      '' => [
        'sbc',
        'hl',
        ',',
        'bc'
      ]
    },
    0x43 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            '(',
            'NN',
            ')',
            ',',
            'bc'
          ]
        }
      }
    },
    0x44 => {
      '' => [
        'neg'
      ]
    },
    0x45 => {
      '' => [
        'retn'
      ]
    },
    0x46 => {
      '' => [
        'im',
        0x00
      ]
    },
    0x47 => {
      '' => [
        'ld',
        'i',
        ',',
        'a'
      ]
    },
    0x48 => {
      '' => [
        'in',
        'c',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x49 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'c'
      ]
    },
    0x4A => {
      '' => [
        'adc',
        'hl',
        ',',
        'bc'
      ]
    },
    0x4B => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'bc',
            ',',
            '(',
            'NN',
            ')'
          ]
        }
      }
    },
    0x4D => {
      '' => [
        'reti'
      ]
    },
    0x4F => {
      '' => [
        'ld',
        'r',
        ',',
        'a'
      ]
    },
    0x50 => {
      '' => [
        'in',
        'd',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x51 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'd'
      ]
    },
    0x52 => {
      '' => [
        'sbc',
        'hl',
        ',',
        'de'
      ]
    },
    0x53 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            '(',
            'NN',
            ')',
            ',',
            'de'
          ]
        }
      }
    },
    0x56 => {
      '' => [
        'im',
        0x01
      ]
    },
    0x57 => {
      '' => [
        'ld',
        'a',
        ',',
        'i'
      ]
    },
    0x58 => {
      '' => [
        'in',
        'e',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x59 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'e'
      ]
    },
    0x5A => {
      '' => [
        'adc',
        'hl',
        ',',
        'de'
      ]
    },
    0x5B => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'de',
            ',',
            '(',
            'NN',
            ')'
          ]
        }
      }
    },
    0x5E => {
      '' => [
        'im',
        0x02
      ]
    },
    0x5F => {
      '' => [
        'ld',
        'a',
        ',',
        'r'
      ]
    },
    0x60 => {
      '' => [
        'in',
        'h',
        ',',
        '(',
        'c',
        ')'
      ]
    },
    0x61 => {
      '' => [
        'out',
        '(',
        'c',
        ')',
        ',',
        'h'
      ]
    },
    0x62 => {
      '' => [
        'sbc',
        'hl',
        ',',
        'hl'
      ]
    },
    0x63 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            '(',
            'NN',
            ')',
            ',',
            'hl'
          ]
        }
      }
    }
  },
  0xEE => {
    'N' => {
      '' => [
        'xor',
        'N'
      ]
    }
  },
  0xEF => {
    '' => [
      'rst',
      0x28
    ]
  },
  0x18 => {
    'NNo' => {
      '' => [
        'jr',
        'NN'
      ]
    }
  },
  0xF0 => {
    '' => [
      'ret',
      'p'
    ]
  },
  0xF1 => {
    '' => [
      'pop',
      'af'
    ]
  },
  0xF2 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'p',
          ',',
          'NN'
        ]
      }
    }
  },
  0xF3 => {
    '' => [
      'di'
    ]
  },
  0xF4 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'p',
          ',',
          'NN'
        ]
      }
    }
  },
  0xF5 => {
    '' => [
      'push',
      'af'
    ]
  },
  0xF6 => {
    'N' => {
      '' => [
        'or',
        'N'
      ]
    }
  },
  0xF7 => {
    '' => [
      'rst',
      0x30
    ]
  },
  0xF8 => {
    '' => [
      'ret',
      'm'
    ]
  },
  0xF9 => {
    '' => [
      'ld',
      'sp',
      ',',
      'hl'
    ]
  },
  0x19 => {
    '' => [
      'add',
      'hl',
      ',',
      'de'
    ]
  },
  0xFA => {
    'NNl' => {
      'NNh' => {
        '' => [
          'jp',
          'm',
          ',',
          'NN'
        ]
      }
    }
  },
  0xFB => {
    '' => [
      'ei'
    ]
  },
  0xFC => {
    'NNl' => {
      'NNh' => {
        '' => [
          'call',
          'm',
          ',',
          'NN'
        ]
      }
    }
  },
  0xFD => {
    0x64 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'iyh'
      ]
    },
    0x65 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'iyl'
      ]
    },
    0x66 => {
      0x00 => {
        '' => [
          'ld',
          'h',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'h',
              ',',
              '(',
              'iy',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'h',
              ',',
              '(',
              'iy',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'h',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'h',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'h',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'h',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'h',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'h',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x67 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'a'
      ]
    },
    0x68 => {
      '' => [
        'ld',
        'iyl',
        ',',
        'b'
      ]
    },
    0x69 => {
      '' => [
        'ld',
        'iyl',
        ',',
        'c'
      ],
      0xFD => {
        0x60 => {
          '' => [
            'ld',
            'iy',
            ',',
            'bc'
          ]
        }
      }
    },
    0x6A => {
      '' => [
        'ld',
        'iyl',
        ',',
        'd'
      ]
    },
    0x6B => {
      '' => [
        'ld',
        'iyl',
        ',',
        'e'
      ],
      0xFD => {
        0x62 => {
          '' => [
            'ld',
            'iy',
            ',',
            'de'
          ]
        }
      }
    },
    0x6C => {
      '' => [
        'ld',
        'iyl',
        ',',
        'iyh'
      ]
    },
    0x6D => {
      '' => [
        'ld',
        'iyl',
        ',',
        'iyl'
      ],
      0xFD => {
        0x64 => {
          '' => [
            'ld',
            'iy',
            ',',
            'iy'
          ]
        }
      }
    },
    0x6E => {
      0x00 => {
        '' => [
          'ld',
          'l',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x66 => {
            0x01 => {
              '' => [
                'ld',
                'hl',
                ',',
                '(',
                'iy',
                ')'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              'l',
              ',',
              '(',
              'iy',
              ')'
            ],
            0xFD => {
              0x66 => {
                0x00 => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'hl',
                        ',',
                        '(',
                        'iy',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'l',
              ',',
              '(',
              'iy',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'l',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x66 => {
            'DIS+1' => {
              '' => [
                'ld',
                'hl',
                ',',
                '(',
                'iy',
                '+',
                'DIS',
                ')'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              'l',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ],
            0xFD => {
              0x66 => {
                'DIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'hl',
                        ',',
                        '(',
                        'iy',
                        '+',
                        'DIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'l',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'l',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x66 => {
            'NDIS+1' => {
              '' => [
                'ld',
                'hl',
                ',',
                '(',
                'iy',
                '-',
                'NDIS',
                ')'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              'l',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ],
            0xFD => {
              0x66 => {
                'NDIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'hl',
                        ',',
                        '(',
                        'iy',
                        '-',
                        'NDIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'l',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x6F => {
      '' => [
        'ld',
        'iyl',
        ',',
        'a'
      ]
    },
    0x70 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'b'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'b'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'b'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'b'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'b'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'b'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'b'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'b'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'b'
            ]
          }
        }
      }
    },
    0x71 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'c'
        ],
        0xFD => {
          0x70 => {
            0x01 => {
              '' => [
                'ld',
                '(',
                'iy',
                ')',
                ',',
                'bc'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'c'
            ],
            0xFD => {
              0x70 => {
                0x00 => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        ')',
                        ',',
                        'bc'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'c'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'c'
        ],
        0xFD => {
          0x70 => {
            'DIS+1' => {
              '' => [
                'ld',
                '(',
                'iy',
                '+',
                'DIS',
                ')',
                ',',
                'bc'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'c'
            ],
            0xFD => {
              0x70 => {
                'DIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        '+',
                        'DIS',
                        ')',
                        ',',
                        'bc'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'c'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'c'
        ],
        0xFD => {
          0x70 => {
            'NDIS+1' => {
              '' => [
                'ld',
                '(',
                'iy',
                '-',
                'NDIS',
                ')',
                ',',
                'bc'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'c'
            ],
            0xFD => {
              0x70 => {
                'NDIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        '-',
                        'NDIS',
                        ')',
                        ',',
                        'bc'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'c'
            ]
          }
        }
      }
    },
    0x72 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'd'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'd'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'd'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'd'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'd'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'd'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'd'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'd'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'd'
            ]
          }
        }
      }
    },
    0x73 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'e'
        ],
        0xFD => {
          0x72 => {
            0x01 => {
              '' => [
                'ld',
                '(',
                'iy',
                ')',
                ',',
                'de'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'e'
            ],
            0xFD => {
              0x72 => {
                0x00 => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        ')',
                        ',',
                        'de'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'e'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'e'
        ],
        0xFD => {
          0x72 => {
            'DIS+1' => {
              '' => [
                'ld',
                '(',
                'iy',
                '+',
                'DIS',
                ')',
                ',',
                'de'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'e'
            ],
            0xFD => {
              0x72 => {
                'DIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        '+',
                        'DIS',
                        ')',
                        ',',
                        'de'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'e'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'e'
        ],
        0xFD => {
          0x72 => {
            'NDIS+1' => {
              '' => [
                'ld',
                '(',
                'iy',
                '-',
                'NDIS',
                ')',
                ',',
                'de'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'e'
            ],
            0xFD => {
              0x72 => {
                'NDIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        '-',
                        'NDIS',
                        ')',
                        ',',
                        'de'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'e'
            ]
          }
        }
      }
    },
    0x74 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'h'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'h'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'h'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'h'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'h'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'h'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'h'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'h'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'h'
            ]
          }
        }
      }
    },
    0x75 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'l'
        ],
        0xFD => {
          0x74 => {
            0x01 => {
              '' => [
                'ld',
                '(',
                'iy',
                ')',
                ',',
                'hl'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'l'
            ],
            0xFD => {
              0x74 => {
                0x00 => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        ')',
                        ',',
                        'hl'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'l'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'l'
        ],
        0xFD => {
          0x74 => {
            'DIS+1' => {
              '' => [
                'ld',
                '(',
                'iy',
                '+',
                'DIS',
                ')',
                ',',
                'hl'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'l'
            ],
            0xFD => {
              0x74 => {
                'DIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        '+',
                        'DIS',
                        ')',
                        ',',
                        'hl'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'l'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'l'
        ],
        0xFD => {
          0x74 => {
            'NDIS+1' => {
              '' => [
                'ld',
                '(',
                'iy',
                '-',
                'NDIS',
                ')',
                ',',
                'hl'
              ]
            }
          },
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'l'
            ],
            0xFD => {
              0x74 => {
                'NDIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        '(',
                        'iy',
                        '-',
                        'NDIS',
                        ')',
                        ',',
                        'hl'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'l'
            ]
          }
        }
      }
    },
    0x77 => {
      0x00 => {
        '' => [
          'ld',
          '(',
          'iy',
          ')',
          ',',
          'a'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              ')',
              ',',
              'a'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              ')',
              ',',
              'a'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '+',
          'DIS',
          ')',
          ',',
          'a'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'a'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '+',
              'DIS',
              ')',
              ',',
              'a'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          '(',
          'iy',
          '-',
          'NDIS',
          ')',
          ',',
          'a'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'a'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              '(',
              'iy',
              '-',
              'NDIS',
              ')',
              ',',
              'a'
            ]
          }
        }
      }
    },
    0x7C => {
      '' => [
        'ld',
        'a',
        ',',
        'iyh'
      ]
    },
    0x7D => {
      '' => [
        'ld',
        'a',
        ',',
        'iyl'
      ]
    },
    0x7E => {
      0x00 => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'a',
              ',',
              '(',
              'iy',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'a',
              ',',
              '(',
              'iy',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'a',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'a',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'a',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'a',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x84 => {
      '' => [
        'add',
        'a',
        ',',
        'iyh'
      ]
    },
    0x85 => {
      '' => [
        'add',
        'a',
        ',',
        'iyl'
      ]
    },
    0x86 => {
      0x00 => {
        '' => [
          'add',
          'a',
          ',',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'add',
          'a',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'add',
          'a',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x8C => {
      '' => [
        'adc',
        'a',
        ',',
        'iyh'
      ]
    },
    0x8D => {
      '' => [
        'adc',
        'a',
        ',',
        'iyl'
      ]
    },
    0x8E => {
      0x00 => {
        '' => [
          'adc',
          'a',
          ',',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'adc',
          'a',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'adc',
          'a',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x94 => {
      '' => [
        'sub',
        'iyh'
      ]
    },
    0x95 => {
      '' => [
        'sub',
        'iyl'
      ]
    },
    0x96 => {
      0x00 => {
        '' => [
          'sub',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'sub',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'sub',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x9C => {
      '' => [
        'sbc',
        'a',
        ',',
        'iyh'
      ]
    },
    0x9D => {
      '' => [
        'sbc',
        'a',
        ',',
        'iyl'
      ]
    },
    0x9E => {
      0x00 => {
        '' => [
          'sbc',
          'a',
          ',',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'sbc',
          'a',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'sbc',
          'a',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xA4 => {
      '' => [
        'and',
        'iyh'
      ]
    },
    0xA5 => {
      '' => [
        'and',
        'iyl'
      ]
    },
    0xA6 => {
      0x00 => {
        '' => [
          'and',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'and',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'and',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xAC => {
      '' => [
        'xor',
        'iyh'
      ]
    },
    0xAD => {
      '' => [
        'xor',
        'iyl'
      ]
    },
    0xAE => {
      0x00 => {
        '' => [
          'xor',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'xor',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'xor',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xB4 => {
      '' => [
        'or',
        'iyh'
      ]
    },
    0xB5 => {
      '' => [
        'or',
        'iyl'
      ]
    },
    0xB6 => {
      0x00 => {
        '' => [
          'or',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'or',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'or',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xBC => {
      '' => [
        'cp',
        'iyh'
      ]
    },
    0xBD => {
      '' => [
        'cp',
        'iyl'
      ]
    },
    0xBE => {
      0x00 => {
        '' => [
          'cp',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'cp',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'cp',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0xCB => {
      0x00 => {
        0x00 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x01 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x0A => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x66 => {
          '' => [
            'bit',
            0x04,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x0B => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x6E => {
          '' => [
            'bit',
            0x05,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x76 => {
          '' => [
            'bit',
            0x06,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x0C => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x7E => {
          '' => [
            'bit',
            0x07,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x80 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x81 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x0D => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x82 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x83 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x84 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x85 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x86 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x87 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x88 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x89 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x8A => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x8B => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x0E => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')'
          ]
        },
        0x8C => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x8D => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x8E => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x8F => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x90 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x91 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x92 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x93 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x94 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x95 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x0F => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x96 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x97 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x98 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x99 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x9A => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x9B => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x9C => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x9D => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x9E => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x9F => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x10 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xA0 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xA1 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xA2 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xA3 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xA4 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xA5 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xA6 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xA7 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xA8 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xA9 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x11 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xAA => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xAB => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xAC => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xAD => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xAE => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xAF => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xB0 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xB1 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xB2 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xB3 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x12 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xB4 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xB5 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xB6 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xB7 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xB8 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xB9 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xBA => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xBB => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xBC => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xBD => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x13 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xBE => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xBF => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xC0 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xC1 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xC2 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xC3 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xC4 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xC5 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xC6 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xC7 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x02 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x14 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xC8 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xC9 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xCA => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xCB => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xCC => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xCD => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xCE => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xCF => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xD0 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xD1 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x15 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xD2 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xD3 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xD4 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xD5 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xD6 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xD7 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xD8 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xD9 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xDA => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xDB => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x16 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')'
          ]
        },
        0xDC => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xDD => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xDE => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xDF => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xE0 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xE1 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xE2 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xE3 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xE4 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xE5 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x17 => {
          '' => [
            'rl',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xE6 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xE7 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xE8 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xE9 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xEA => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xEB => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xEC => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xED => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xEE => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xEF => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x18 => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xF0 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xF1 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xF2 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xF3 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xF4 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xF5 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xF6 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xF7 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0xF8 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0xF9 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x19 => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0xFA => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0xFB => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0xFC => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0xFD => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0xFE => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0xFF => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x1A => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x1B => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x1C => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x1D => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x03 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x1E => {
          '' => [
            'rr',
            '(',
            'iy',
            ')'
          ]
        },
        0x1F => {
          '' => [
            'rr',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x20 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x21 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x22 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x23 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x24 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x25 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x26 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')'
          ]
        },
        0x27 => {
          '' => [
            'sla',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x04 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x28 => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x29 => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x2A => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x2B => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x2C => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x2D => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x2E => {
          '' => [
            'sra',
            '(',
            'iy',
            ')'
          ]
        },
        0x2F => {
          '' => [
            'sra',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x30 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x31 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x05 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x32 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x33 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x34 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x35 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x36 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')'
          ]
        },
        0x37 => {
          '' => [
            'sll',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x38 => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x39 => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x3A => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'd'
          ]
        },
        0x3B => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'e'
          ]
        },
        0x06 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')'
          ]
        },
        0x3C => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'h'
          ]
        },
        0x3D => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'l'
          ]
        },
        0x3E => {
          '' => [
            'srl',
            '(',
            'iy',
            ')'
          ]
        },
        0x3F => {
          '' => [
            'srl',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x07 => {
          '' => [
            'rlc',
            '(',
            'iy',
            ')',
            ',',
            'a'
          ]
        },
        0x46 => {
          '' => [
            'bit',
            0x00,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x4E => {
          '' => [
            'bit',
            0x01,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x08 => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'b'
          ]
        },
        0x56 => {
          '' => [
            'bit',
            0x02,
            ',',
            '(',
            'iy',
            ')'
          ]
        },
        0x09 => {
          '' => [
            'rrc',
            '(',
            'iy',
            ')',
            ',',
            'c'
          ]
        },
        0x5E => {
          '' => [
            'bit',
            0x03,
            ',',
            '(',
            'iy',
            ')'
          ]
        }
      },
      'DIS' => {
        0x00 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x01 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0A => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x66 => {
          '' => [
            'bit',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x0B => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x6E => {
          '' => [
            'bit',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x76 => {
          '' => [
            'bit',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x0C => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x7E => {
          '' => [
            'bit',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x80 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x81 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0D => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x82 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x83 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x84 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x85 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x86 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x87 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x88 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x89 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x8A => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x8B => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x0E => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x8C => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x8D => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x8E => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x8F => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x90 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x91 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x92 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x93 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x94 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x95 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x0F => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x96 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x97 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x98 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x99 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x9A => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x9B => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x9C => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x9D => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x9E => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x9F => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x10 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA0 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA1 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xA2 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xA3 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xA4 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xA5 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xA6 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xA7 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xA8 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA9 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x11 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xAA => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xAB => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xAC => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xAD => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xAE => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xAF => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB0 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB1 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xB2 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB3 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x12 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB4 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xB5 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xB6 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xB7 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB8 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB9 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xBA => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xBB => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBC => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xBD => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x13 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBE => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xBF => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xC0 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC1 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xC2 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xC3 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xC4 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC5 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xC6 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xC7 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x02 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x14 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC8 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC9 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xCA => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xCB => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xCC => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xCD => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xCE => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xCF => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD0 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD1 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x15 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD2 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xD3 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xD4 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xD5 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD6 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xD7 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD8 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD9 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xDA => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xDB => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x16 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xDC => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xDD => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xDE => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xDF => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE0 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE1 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xE2 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xE3 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xE4 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xE5 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x17 => {
          '' => [
            'rl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE6 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xE7 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE8 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE9 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xEA => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xEB => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xEC => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xED => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xEE => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xEF => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x18 => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF0 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF1 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xF2 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xF3 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xF4 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xF5 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xF6 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xF7 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0xF8 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF9 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x19 => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0xFA => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0xFB => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0xFC => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0xFD => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0xFE => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0xFF => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x1A => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x1B => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1C => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x1D => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x03 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1E => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x1F => {
          '' => [
            'rr',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x20 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x21 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x22 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x23 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x24 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x25 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x26 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x27 => {
          '' => [
            'sla',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x04 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x28 => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x29 => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x2A => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x2B => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x2C => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x2D => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x2E => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x2F => {
          '' => [
            'sra',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x30 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x31 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x05 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x32 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x33 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x34 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x35 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x36 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x37 => {
          '' => [
            'sll',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x38 => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x39 => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x3A => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'd'
          ]
        },
        0x3B => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'e'
          ]
        },
        0x06 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x3C => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'h'
          ]
        },
        0x3D => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'l'
          ]
        },
        0x3E => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x3F => {
          '' => [
            'srl',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x07 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'a'
          ]
        },
        0x46 => {
          '' => [
            'bit',
            0x00,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x4E => {
          '' => [
            'bit',
            0x01,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x08 => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'b'
          ]
        },
        0x56 => {
          '' => [
            'bit',
            0x02,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        },
        0x09 => {
          '' => [
            'rrc',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'c'
          ]
        },
        0x5E => {
          '' => [
            'bit',
            0x03,
            ',',
            '(',
            'iy',
            '+',
            'DIS',
            ')'
          ]
        }
      },
      'NDIS' => {
        0x00 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x01 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0A => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x66 => {
          '' => [
            'bit',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x0B => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x6E => {
          '' => [
            'bit',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x76 => {
          '' => [
            'bit',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x0C => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x7E => {
          '' => [
            'bit',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x80 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x81 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x0D => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x82 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x83 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x84 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x85 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x86 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x87 => {
          '' => [
            'res',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x88 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x89 => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x8A => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x8B => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x0E => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x8C => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x8D => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x8E => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x8F => {
          '' => [
            'res',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x90 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x91 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x92 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x93 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x94 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x95 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x0F => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x96 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x97 => {
          '' => [
            'res',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x98 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x99 => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x9A => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x9B => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x9C => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x9D => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x9E => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x9F => {
          '' => [
            'res',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x10 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA0 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA1 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xA2 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xA3 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xA4 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xA5 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xA6 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xA7 => {
          '' => [
            'res',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xA8 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xA9 => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x11 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xAA => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xAB => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xAC => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xAD => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xAE => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xAF => {
          '' => [
            'res',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB0 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB1 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xB2 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB3 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x12 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xB4 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xB5 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xB6 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xB7 => {
          '' => [
            'res',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xB8 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xB9 => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xBA => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xBB => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBC => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xBD => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x13 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xBE => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xBF => {
          '' => [
            'res',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xC0 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC1 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xC2 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xC3 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xC4 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC5 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xC6 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xC7 => {
          '' => [
            'set',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x02 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x14 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xC8 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xC9 => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xCA => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xCB => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xCC => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xCD => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xCE => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xCF => {
          '' => [
            'set',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD0 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD1 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x15 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD2 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xD3 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xD4 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xD5 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xD6 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xD7 => {
          '' => [
            'set',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xD8 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xD9 => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xDA => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xDB => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x16 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xDC => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xDD => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xDE => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xDF => {
          '' => [
            'set',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE0 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE1 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xE2 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xE3 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xE4 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xE5 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x17 => {
          '' => [
            'rl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE6 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xE7 => {
          '' => [
            'set',
            0x04,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xE8 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xE9 => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xEA => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xEB => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xEC => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xED => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xEE => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xEF => {
          '' => [
            'set',
            0x05,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x18 => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF0 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF1 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xF2 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xF3 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xF4 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xF5 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xF6 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xF7 => {
          '' => [
            'set',
            0x06,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0xF8 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0xF9 => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x19 => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0xFA => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0xFB => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0xFC => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0xFD => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0xFE => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0xFF => {
          '' => [
            'set',
            0x07,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x1A => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x1B => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1C => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x1D => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x03 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x1E => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x1F => {
          '' => [
            'rr',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x20 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x21 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x22 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x23 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x24 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x25 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x26 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x27 => {
          '' => [
            'sla',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x04 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x28 => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x29 => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x2A => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x2B => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x2C => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x2D => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x2E => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x2F => {
          '' => [
            'sra',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x30 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x31 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x05 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x32 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x33 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x34 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x35 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x36 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x37 => {
          '' => [
            'sll',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x38 => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x39 => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x3A => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'd'
          ]
        },
        0x3B => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'e'
          ]
        },
        0x06 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x3C => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'h'
          ]
        },
        0x3D => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'l'
          ]
        },
        0x3E => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x3F => {
          '' => [
            'srl',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x07 => {
          '' => [
            'rlc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'a'
          ]
        },
        0x46 => {
          '' => [
            'bit',
            0x00,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x4E => {
          '' => [
            'bit',
            0x01,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x08 => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'b'
          ]
        },
        0x56 => {
          '' => [
            'bit',
            0x02,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        },
        0x09 => {
          '' => [
            'rrc',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'c'
          ]
        },
        0x5E => {
          '' => [
            'bit',
            0x03,
            ',',
            '(',
            'iy',
            '-',
            'NDIS',
            ')'
          ]
        }
      }
    },
    0xE1 => {
      '' => [
        'pop',
        'iy'
      ]
    },
    0xE3 => {
      '' => [
        'ex',
        '(',
        'sp',
        ')',
        ',',
        'iy'
      ]
    },
    0xE5 => {
      '' => [
        'push',
        'iy'
      ],
      0xDD => {
        0xE1 => {
          '' => [
            'ld',
            'ix',
            ',',
            'iy'
          ]
        }
      },
      0xE1 => {
        '' => [
          'ld',
          'hl',
          ',',
          'iy'
        ]
      }
    },
    0xE9 => {
      '' => [
        'jp',
        '(',
        'iy',
        ')'
      ]
    },
    0xF9 => {
      '' => [
        'ld',
        'sp',
        ',',
        'iy'
      ]
    },
    0x19 => {
      '' => [
        'add',
        'iy',
        ',',
        'de'
      ]
    },
    0x21 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'iy',
            ',',
            'NN'
          ]
        }
      }
    },
    0x22 => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            '(',
            'NN',
            ')',
            ',',
            'iy'
          ]
        }
      }
    },
    0x23 => {
      '' => [
        'inc',
        'iy'
      ]
    },
    0x24 => {
      '' => [
        'inc',
        'iyh'
      ]
    },
    0x25 => {
      '' => [
        'dec',
        'iyh'
      ]
    },
    0x26 => {
      'N' => {
        '' => [
          'ld',
          'iyh',
          ',',
          'N'
        ]
      }
    },
    0x29 => {
      '' => [
        'add',
        'iy',
        ',',
        'iy'
      ]
    },
    0x2A => {
      'NNl' => {
        'NNh' => {
          '' => [
            'ld',
            'iy',
            ',',
            '(',
            'NN',
            ')'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'dec',
        'iy'
      ]
    },
    0x2C => {
      '' => [
        'inc',
        'iyl'
      ]
    },
    0x2D => {
      '' => [
        'dec',
        'iyl'
      ]
    },
    0x2E => {
      'N' => {
        '' => [
          'ld',
          'iyl',
          ',',
          'N'
        ]
      }
    },
    0x34 => {
      0x00 => {
        '' => [
          'inc',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'inc',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'inc',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x35 => {
      0x00 => {
        '' => [
          'dec',
          '(',
          'iy',
          ')'
        ]
      },
      'DIS' => {
        '' => [
          'dec',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ]
      },
      'NDIS' => {
        '' => [
          'dec',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ]
      }
    },
    0x36 => {
      0x00 => {
        'N' => {
          '' => [
            'ld',
            '(',
            'iy',
            ')',
            ',',
            'N'
          ],
          0xFD => {
            0x23 => {
              '' => [
                'ldi',
                '(',
                'iy',
                ')',
                ',',
                'N'
              ]
            },
            0x2B => {
              '' => [
                'ldd',
                '(',
                'iy',
                ')',
                ',',
                'N'
              ]
            }
          }
        }
      },
      'DIS' => {
        'N' => {
          '' => [
            'ld',
            '(',
            'iy',
            '+',
            'DIS',
            ')',
            ',',
            'N'
          ],
          0xFD => {
            0x23 => {
              '' => [
                'ldi',
                '(',
                'iy',
                '+',
                'DIS',
                ')',
                ',',
                'N'
              ]
            },
            0x2B => {
              '' => [
                'ldd',
                '(',
                'iy',
                '+',
                'DIS',
                ')',
                ',',
                'N'
              ]
            }
          }
        }
      },
      'NDIS' => {
        'N' => {
          '' => [
            'ld',
            '(',
            'iy',
            '-',
            'NDIS',
            ')',
            ',',
            'N'
          ],
          0xFD => {
            0x23 => {
              '' => [
                'ldi',
                '(',
                'iy',
                '-',
                'NDIS',
                ')',
                ',',
                'N'
              ]
            },
            0x2B => {
              '' => [
                'ldd',
                '(',
                'iy',
                '-',
                'NDIS',
                ')',
                ',',
                'N'
              ]
            }
          }
        }
      }
    },
    0x39 => {
      '' => [
        'add',
        'iy',
        ',',
        'sp'
      ]
    },
    0x44 => {
      '' => [
        'ld',
        'b',
        ',',
        'iyh'
      ],
      0xFD => {
        0x4D => {
          '' => [
            'ld',
            'bc',
            ',',
            'iy'
          ]
        }
      }
    },
    0x45 => {
      '' => [
        'ld',
        'b',
        ',',
        'iyl'
      ]
    },
    0x46 => {
      0x00 => {
        '' => [
          'ld',
          'b',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'b',
              ',',
              '(',
              'iy',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'b',
              ',',
              '(',
              'iy',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'b',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'b',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'b',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'b',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'b',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'b',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x4C => {
      '' => [
        'ld',
        'c',
        ',',
        'iyh'
      ]
    },
    0x4D => {
      '' => [
        'ld',
        'c',
        ',',
        'iyl'
      ]
    },
    0x4E => {
      0x00 => {
        '' => [
          'ld',
          'c',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'c',
              ',',
              '(',
              'iy',
              ')'
            ],
            0xFD => {
              0x46 => {
                0x00 => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'bc',
                        ',',
                        '(',
                        'iy',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'c',
              ',',
              '(',
              'iy',
              ')'
            ]
          },
          0x46 => {
            0x01 => {
              '' => [
                'ld',
                'bc',
                ',',
                '(',
                'iy',
                ')'
              ]
            }
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'c',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'c',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ],
            0xFD => {
              0x46 => {
                'DIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'bc',
                        ',',
                        '(',
                        'iy',
                        '+',
                        'DIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'c',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          },
          0x46 => {
            'DIS+1' => {
              '' => [
                'ld',
                'bc',
                ',',
                '(',
                'iy',
                '+',
                'DIS',
                ')'
              ]
            }
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'c',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'c',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ],
            0xFD => {
              0x46 => {
                'NDIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'bc',
                        ',',
                        '(',
                        'iy',
                        '-',
                        'NDIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'c',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x46 => {
            'NDIS+1' => {
              '' => [
                'ld',
                'bc',
                ',',
                '(',
                'iy',
                '-',
                'NDIS',
                ')'
              ]
            }
          }
        }
      }
    },
    0x54 => {
      '' => [
        'ld',
        'd',
        ',',
        'iyh'
      ],
      0xFD => {
        0x5D => {
          '' => [
            'ld',
            'de',
            ',',
            'iy'
          ]
        }
      }
    },
    0x55 => {
      '' => [
        'ld',
        'd',
        ',',
        'iyl'
      ]
    },
    0x56 => {
      0x00 => {
        '' => [
          'ld',
          'd',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'd',
              ',',
              '(',
              'iy',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'd',
              ',',
              '(',
              'iy',
              ')'
            ]
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'd',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'd',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'd',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'd',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'd',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x2B => {
            '' => [
              'ldd',
              'd',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          }
        }
      }
    },
    0x09 => {
      '' => [
        'add',
        'iy',
        ',',
        'bc'
      ]
    },
    0x5C => {
      '' => [
        'ld',
        'e',
        ',',
        'iyh'
      ]
    },
    0x5D => {
      '' => [
        'ld',
        'e',
        ',',
        'iyl'
      ]
    },
    0x5E => {
      0x00 => {
        '' => [
          'ld',
          'e',
          ',',
          '(',
          'iy',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'e',
              ',',
              '(',
              'iy',
              ')'
            ],
            0xFD => {
              0x56 => {
                0x00 => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'de',
                        ',',
                        '(',
                        'iy',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'e',
              ',',
              '(',
              'iy',
              ')'
            ]
          },
          0x56 => {
            0x01 => {
              '' => [
                'ld',
                'de',
                ',',
                '(',
                'iy',
                ')'
              ]
            }
          }
        }
      },
      'DIS' => {
        '' => [
          'ld',
          'e',
          ',',
          '(',
          'iy',
          '+',
          'DIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'e',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ],
            0xFD => {
              0x56 => {
                'DIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'de',
                        ',',
                        '(',
                        'iy',
                        '+',
                        'DIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'e',
              ',',
              '(',
              'iy',
              '+',
              'DIS',
              ')'
            ]
          },
          0x56 => {
            'DIS+1' => {
              '' => [
                'ld',
                'de',
                ',',
                '(',
                'iy',
                '+',
                'DIS',
                ')'
              ]
            }
          }
        }
      },
      'NDIS' => {
        '' => [
          'ld',
          'e',
          ',',
          '(',
          'iy',
          '-',
          'NDIS',
          ')'
        ],
        0xFD => {
          0x23 => {
            '' => [
              'ldi',
              'e',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ],
            0xFD => {
              0x56 => {
                'NDIS' => {
                  0xFD => {
                    0x23 => {
                      '' => [
                        'ldi',
                        'de',
                        ',',
                        '(',
                        'iy',
                        '-',
                        'NDIS',
                        ')'
                      ]
                    }
                  }
                }
              }
            }
          },
          0x2B => {
            '' => [
              'ldd',
              'e',
              ',',
              '(',
              'iy',
              '-',
              'NDIS',
              ')'
            ]
          },
          0x56 => {
            'NDIS+1' => {
              '' => [
                'ld',
                'de',
                ',',
                '(',
                'iy',
                '-',
                'NDIS',
                ')'
              ]
            }
          }
        }
      }
    },
    0x60 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'b'
      ]
    },
    0x61 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'c'
      ]
    },
    0x62 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'd'
      ]
    },
    0x63 => {
      '' => [
        'ld',
        'iyh',
        ',',
        'e'
      ]
    }
  },
  0xFE => {
    'N' => {
      '' => [
        'cp',
        'N'
      ]
    }
  },
  0xFF => {
    '' => [
      'rst',
      0x38
    ]
  },
  0x1A => {
    '' => [
      'ld',
      'a',
      ',',
      '(',
      'de',
      ')'
    ],
    0x13 => {
      '' => [
        'ldi',
        'a',
        ',',
        '(',
        'de',
        ')'
      ]
    },
    0x1B => {
      '' => [
        'ldd',
        'a',
        ',',
        '(',
        'de',
        ')'
      ]
    }
  },
  0x1B => {
    '' => [
      'dec',
      'de'
    ]
  },
  0x1C => {
    '' => [
      'inc',
      'e'
    ]
  },
  0x1D => {
    '' => [
      'dec',
      'e'
    ]
  },
  0x03 => {
    '' => [
      'inc',
      'bc'
    ]
  },
  0x1E => {
    'N' => {
      '' => [
        'ld',
        'e',
        ',',
        'N'
      ]
    }
  },
  0x1F => {
    '' => [
      'rra'
    ]
  },
  0x20 => {
    'NNo' => {
      '' => [
        'jr',
        'nz',
        ',',
        'NN'
      ]
    }
  },
  0x21 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          'hl',
          ',',
          'NN'
        ]
      }
    }
  },
  0x22 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          '(',
          'NN',
          ')',
          ',',
          'hl'
        ]
      }
    }
  },
  0x23 => {
    '' => [
      'inc',
      'hl'
    ]
  },
  0x24 => {
    '' => [
      'inc',
      'h'
    ]
  },
  0x25 => {
    '' => [
      'dec',
      'h'
    ]
  },
  0x26 => {
    'N' => {
      '' => [
        'ld',
        'h',
        ',',
        'N'
      ]
    }
  },
  0x27 => {
    '' => [
      'daa'
    ]
  },
  0x04 => {
    '' => [
      'inc',
      'b'
    ]
  },
  0x28 => {
    'NNo' => {
      '' => [
        'jr',
        'z',
        ',',
        'NN'
      ]
    }
  },
  0x29 => {
    '' => [
      'add',
      'hl',
      ',',
      'hl'
    ]
  },
  0x2A => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          'hl',
          ',',
          '(',
          'NN',
          ')'
        ]
      }
    }
  },
  0x2B => {
    '' => [
      'dec',
      'hl'
    ]
  },
  0x2C => {
    '' => [
      'inc',
      'l'
    ]
  },
  0x2D => {
    '' => [
      'dec',
      'l'
    ]
  },
  0x2E => {
    'N' => {
      '' => [
        'ld',
        'l',
        ',',
        'N'
      ]
    }
  },
  0x2F => {
    '' => [
      'cpl'
    ]
  },
  0x30 => {
    'NNo' => {
      '' => [
        'jr',
        'nc',
        ',',
        'NN'
      ]
    }
  },
  0x31 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          'sp',
          ',',
          'NN'
        ]
      }
    }
  },
  0x05 => {
    '' => [
      'dec',
      'b'
    ]
  },
  0x32 => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          '(',
          'NN',
          ')',
          ',',
          'a'
        ]
      }
    }
  },
  0x33 => {
    '' => [
      'inc',
      'sp'
    ]
  },
  0x34 => {
    '' => [
      'inc',
      '(',
      'hl',
      ')'
    ]
  },
  0x35 => {
    '' => [
      'dec',
      '(',
      'hl',
      ')'
    ]
  },
  0x36 => {
    'N' => {
      '' => [
        'ld',
        '(',
        'hl',
        ')',
        ',',
        'N'
      ],
      0x23 => {
        '' => [
          'ldi',
          '(',
          'hl',
          ')',
          ',',
          'N'
        ]
      },
      0x2B => {
        '' => [
          'ldd',
          '(',
          'hl',
          ')',
          ',',
          'N'
        ]
      }
    }
  },
  0x37 => {
    '' => [
      'scf'
    ]
  },
  0x38 => {
    'NNo' => {
      '' => [
        'jr',
        'c',
        ',',
        'NN'
      ]
    }
  },
  0x39 => {
    '' => [
      'add',
      'hl',
      ',',
      'sp'
    ]
  },
  0x3A => {
    'NNl' => {
      'NNh' => {
        '' => [
          'ld',
          'a',
          ',',
          '(',
          'NN',
          ')'
        ]
      }
    }
  },
  0x3B => {
    '' => [
      'dec',
      'sp'
    ]
  },
  0x06 => {
    'N' => {
      '' => [
        'ld',
        'b',
        ',',
        'N'
      ]
    }
  },
  0x3C => {
    '' => [
      'inc',
      'a'
    ]
  },
  0x3D => {
    '' => [
      'dec',
      'a'
    ]
  },
  0x3E => {
    'N' => {
      '' => [
        'ld',
        'a',
        ',',
        'N'
      ]
    }
  },
  0x3F => {
    '' => [
      'ccf'
    ]
  },
  0x40 => {
    '' => [
      'ld',
      'b',
      ',',
      'b'
    ],
    0x49 => {
      '' => [
        'ld',
        'bc',
        ',',
        'bc'
      ]
    }
  },
  0x41 => {
    '' => [
      'ld',
      'b',
      ',',
      'c'
    ]
  },
  0x42 => {
    '' => [
      'ld',
      'b',
      ',',
      'd'
    ],
    0x4B => {
      '' => [
        'ld',
        'bc',
        ',',
        'de'
      ]
    }
  },
  0x43 => {
    '' => [
      'ld',
      'b',
      ',',
      'e'
    ]
  },
  0x44 => {
    '' => [
      'ld',
      'b',
      ',',
      'h'
    ],
    0x4D => {
      '' => [
        'ld',
        'bc',
        ',',
        'hl'
      ]
    }
  },
  0x45 => {
    '' => [
      'ld',
      'b',
      ',',
      'l'
    ]
  },
  0x07 => {
    '' => [
      'rlca'
    ]
  },
  0x46 => {
    '' => [
      'ld',
      'b',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'b',
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        'b',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x47 => {
    '' => [
      'ld',
      'b',
      ',',
      'a'
    ]
  },
  0x48 => {
    '' => [
      'ld',
      'c',
      ',',
      'b'
    ]
  },
  0x49 => {
    '' => [
      'ld',
      'c',
      ',',
      'c'
    ]
  },
  0x4A => {
    '' => [
      'ld',
      'c',
      ',',
      'd'
    ]
  },
  0x4B => {
    '' => [
      'ld',
      'c',
      ',',
      'e'
    ]
  },
  0x4C => {
    '' => [
      'ld',
      'c',
      ',',
      'h'
    ]
  },
  0x4D => {
    '' => [
      'ld',
      'c',
      ',',
      'l'
    ]
  },
  0x4E => {
    '' => [
      'ld',
      'c',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'c',
        ',',
        '(',
        'hl',
        ')'
      ],
      0x46 => {
        0x23 => {
          '' => [
            'ldi',
            'bc',
            ',',
            '(',
            'hl',
            ')'
          ]
        },
        0x2B => {
          '' => [
            'ld',
            'bc',
            ',',
            '(',
            'hl',
            ')'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'ldd',
        'c',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x4F => {
    '' => [
      'ld',
      'c',
      ',',
      'a'
    ]
  },
  0x08 => {
    '' => [
      'ex',
      'af',
      ',',
      'af\''
    ]
  },
  0x50 => {
    '' => [
      'ld',
      'd',
      ',',
      'b'
    ],
    0x59 => {
      '' => [
        'ld',
        'de',
        ',',
        'bc'
      ]
    }
  },
  0x51 => {
    '' => [
      'ld',
      'd',
      ',',
      'c'
    ]
  },
  0x52 => {
    '' => [
      'ld',
      'd',
      ',',
      'd'
    ],
    0x5B => {
      '' => [
        'ld',
        'de',
        ',',
        'de'
      ]
    }
  },
  0x53 => {
    '' => [
      'ld',
      'd',
      ',',
      'e'
    ]
  },
  0x54 => {
    '' => [
      'ld',
      'd',
      ',',
      'h'
    ],
    0x5D => {
      '' => [
        'ld',
        'de',
        ',',
        'hl'
      ]
    }
  },
  0x55 => {
    '' => [
      'ld',
      'd',
      ',',
      'l'
    ]
  },
  0x56 => {
    '' => [
      'ld',
      'd',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'd',
        ',',
        '(',
        'hl',
        ')'
      ]
    },
    0x2B => {
      '' => [
        'ldd',
        'd',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x57 => {
    '' => [
      'ld',
      'd',
      ',',
      'a'
    ]
  },
  0x58 => {
    '' => [
      'ld',
      'e',
      ',',
      'b'
    ]
  },
  0x59 => {
    '' => [
      'ld',
      'e',
      ',',
      'c'
    ]
  },
  0x09 => {
    '' => [
      'add',
      'hl',
      ',',
      'bc'
    ]
  },
  0x5A => {
    '' => [
      'ld',
      'e',
      ',',
      'd'
    ]
  },
  0x5B => {
    '' => [
      'ld',
      'e',
      ',',
      'e'
    ]
  },
  0x5C => {
    '' => [
      'ld',
      'e',
      ',',
      'h'
    ]
  },
  0x5D => {
    '' => [
      'ld',
      'e',
      ',',
      'l'
    ]
  },
  0x5E => {
    '' => [
      'ld',
      'e',
      ',',
      '(',
      'hl',
      ')'
    ],
    0x23 => {
      '' => [
        'ldi',
        'e',
        ',',
        '(',
        'hl',
        ')'
      ],
      0x56 => {
        0x23 => {
          '' => [
            'ldi',
            'de',
            ',',
            '(',
            'hl',
            ')'
          ]
        },
        0x2B => {
          '' => [
            'ld',
            'de',
            ',',
            '(',
            'hl',
            ')'
          ]
        }
      }
    },
    0x2B => {
      '' => [
        'ldd',
        'e',
        ',',
        '(',
        'hl',
        ')'
      ]
    }
  },
  0x5F => {
    '' => [
      'ld',
      'e',
      ',',
      'a'
    ]
  },
  0x60 => {
    '' => [
      'ld',
      'h',
      ',',
      'b'
    ],
    0x69 => {
      '' => [
        'ld',
        'hl',
        ',',
        'bc'
      ]
    }
  },
  0x61 => {
    '' => [
      'ld',
      'h',
      ',',
      'c'
    ]
  },
  0x62 => {
    '' => [
      'ld',
      'h',
      ',',
      'd'
    ],
    0x6B => {
      '' => [
        'ld',
        'hl',
        ',',
        'de'
      ]
    }
  },
  0x63 => {
    '' => [
      'ld',
      'h',
      ',',
      'e'
    ]
  }
}
;

sub asm_table    { $asm_table }
sub disasm_table { $disasm_table }

#------------------------------------------------------------------------------
# return iterator to return all items in the asm_table
sub iterator {
	my($class) = @_;
	
	my $table = $class->asm_table;
	my @children = sort keys %$table;
	my @tokens;
	my @stack = [$table, \@children, \@tokens];	
	
	# unroll recursive algorithm
	return sub {
		while (@stack) {
			my($table, $children, $tokens) = @{$stack[-1]};
			my $child = shift @$children;
			if (! defined $child) {
				pop @stack;						# end of leaf
			}
			elsif ($child eq '') {				# leaf
				my @bytes = @{$table->{''}};
				return ([@$tokens], \@bytes);	# make a copy
			}
			else {								# node
				my @grand_children = sort keys %{$table->{$child}};
				push @stack, [ $table->{$child}, 
							   \@grand_children,
							   [@$tokens, $child] ];
			}
		}
		return ();								# end
	};
}

1;

__END__

#------------------------------------------------------------------------------

=head1 DESCRIPTION

This module provides hash tables to assemble / disassemble all Z80 CPU 
assembly instructions, including undocumented ones (e.g. 'ld ixh,N')
and instructions composed by sequences (e.g. 'ld bc,hl'). 

This module is used in a Z80 assembler / disassembler. 

It was spun off the L<CPU::Z80::Assembler|CPU::Z80::Assembler> module.

=head1 EXPORTS

Nothing.

=head1 FUNCTIONS

=head2 asm_table

This function returns the assembly hash table.

Starting at the root and 
following one sub-hash table for each token, with an empty token at the 
end of the list, produces an array of opcode bytes of the corresponding Z80 
assembly.

=head2 disasm_table

Starting at the root key and following one sub-hash table for each 
opcode byte, with an empty byte at the end of the list, produces an array
of tokens of the corresponding disassembled Z80 instruction.

=head2 iterator

Returns an iterator function that returns the next pair of 
token list and bytes list, while traversing all the C<asm_table>. The iterator 
funtion returns an empty list C<()> at the end.

=head1 SPECIAL TOKENS

The following special tokens are used in both the tokens and bytes lists:

=over 4

=item N

One byte;

=item NN

One word;

=item NNl

The low byte of the word;

=item NNh

The high byte of the word;

=item NNo

The offset byte of a JR/DJNZ instruction that is converted to NN by adding
address + 1;

=item DIS

The offset of a (ix+DIS) expression;

=item DIS+1

The offset of a (ix+DIS) expression for 16-bit load, e.g. C<ld (ix+DIS),bc>;

=item NDIS

The offset of a (ix-NDIS) expression.

=item NDIS+1

The offset of a (ix-NDIS) expression for 16-bit load, e.g. C<ld (ix-NDIS),bc>;

=back

=head1 EXTENSIONS TO STANDARD Z80 ASSEMBLY

The following extensions were implemented in this assembly/disassembly table:

=over 4

=item *

C<ixh> and C<ixl> can be used as the high- and low-byte of C<ix>; 
the same with C<iyh> and C<iyl>.

=item *

C<ldi> increments the memory pointer in indirect register addressing after
the load, e.g. C<'ldi a,(hl)'> is C<'ld a,(hl):inc hl'>.

=item *

C<ldd> decrements the memory pointer in indirect register addressing after
the load; e.g. C<'lda a,(hl)'> is C<'ld a,(hl):dec hl'>.

=item *

16-bit load between two registers is composed by two 8-bit load instructions or 
a sequence of push/pop, e.g. C<'ld bc,de'> is C<'ld b,d:ld c,e'>, and 
C<'ld hl,ix'> is C<'push ix:pop hl'>.

=item *

16-bit load in indirect register addressing is composed by a sequence of 
8-bit load instructions and register increment/decrement, 
e.g. C<'ld bc,(hl)'> is C<'ld c,(hl):inc hl:ld b,(hl):dec hl'>.

=item *

16-bit subtract is composed by clearing the carry flag and subtract with carry,
e.g. C<'sub hl,bc'> is C<'or a:sbc hl,bc'>.

=item *

C<sll> (and s synonym C<sli>) is Shift Logical Left, works as C<sla> but sets
bit 0.

=item *

C<'in f,(c)'> reads the port pointed by C<c> and sets the flags, but does not
store the result.

=item *

C<'out (c),0'> outputs zero to the port pointed by C<c>.

=item *

Two argument rotate instrution in index register indirect mode stores the result
in the second argument, e.g. C<'rlc (ix+d),c'> rotates the value pointed by
C<(ix+d)> and stores the result in C<c>.

=item *

Three argument bit set/clear instrution in index register indirect mode 
stores the result in the third argument, e.g. C<'set 3,(ix+d),c'> 
sets bit-3 of the the value pointed by
C<(ix+d)> and stores the result in C<c>.

=item *

Rotate instructions (C<rl>, C<rr>, C<sla>, C<sll>, C<sli>, C<sra>, C<srl>)
with the 16-bit registers are implemented by rotating one register
into carry and the other from carry.

=item *

Conditional relative jump with flags not available in C<jr> are coded as 
absolute jumps, e.g. <'jr po,NN'> is <'jp po,NN'>.

=item *

C<'stop'> is a special instruction for L<CPU::Emulator::Z80|CPU::Emulator::Z80>
coded as C<0xDD, 0xDD, 0x00>.

=back

=head2 Full Z80 Assembly Table

The official Z80 assembly instructions have a maximum of 4 bytes; the composed 
instructions have a maximum of 10 bytes.

  adc  a,(hl)        ; 8E
  adc  a,(ix)        ; DD 8E 00
  adc  a,(ix+DIS)    ; DD 8E DIS
  adc  a,(ix-NDIS)   ; DD 8E NDIS
  adc  a,(iy)        ; FD 8E 00
  adc  a,(iy+DIS)    ; FD 8E DIS
  adc  a,(iy-NDIS)   ; FD 8E NDIS
  adc  a,N           ; CE N
  adc  a,a           ; 8F
  adc  a,b           ; 88
  adc  a,c           ; 89
  adc  a,d           ; 8A
  adc  a,e           ; 8B
  adc  a,h           ; 8C
  adc  a,ixh         ; DD 8C
  adc  a,ixl         ; DD 8D
  adc  a,iyh         ; FD 8C
  adc  a,iyl         ; FD 8D
  adc  a,l           ; 8D
  adc  hl,bc         ; ED 4A
  adc  hl,de         ; ED 5A
  adc  hl,hl         ; ED 6A
  adc  hl,sp         ; ED 7A
  add  a,(hl)        ; 86
  add  a,(ix)        ; DD 86 00
  add  a,(ix+DIS)    ; DD 86 DIS
  add  a,(ix-NDIS)   ; DD 86 NDIS
  add  a,(iy)        ; FD 86 00
  add  a,(iy+DIS)    ; FD 86 DIS
  add  a,(iy-NDIS)   ; FD 86 NDIS
  add  a,N           ; C6 N
  add  a,a           ; 87
  add  a,b           ; 80
  add  a,c           ; 81
  add  a,d           ; 82
  add  a,e           ; 83
  add  a,h           ; 84
  add  a,ixh         ; DD 84
  add  a,ixl         ; DD 85
  add  a,iyh         ; FD 84
  add  a,iyl         ; FD 85
  add  a,l           ; 85
  add  hl,bc         ; 09
  add  hl,de         ; 19
  add  hl,hl         ; 29
  add  hl,sp         ; 39
  add  ix,bc         ; DD 09
  add  ix,de         ; DD 19
  add  ix,ix         ; DD 29
  add  ix,sp         ; DD 39
  add  iy,bc         ; FD 09
  add  iy,de         ; FD 19
  add  iy,iy         ; FD 29
  add  iy,sp         ; FD 39
  and  (hl)          ; A6
  and  (ix)          ; DD A6 00
  and  (ix+DIS)      ; DD A6 DIS
  and  (ix-NDIS)     ; DD A6 NDIS
  and  (iy)          ; FD A6 00
  and  (iy+DIS)      ; FD A6 DIS
  and  (iy-NDIS)     ; FD A6 NDIS
  and  N             ; E6 N
  and  a             ; A7
  and  b             ; A0
  and  c             ; A1
  and  d             ; A2
  and  e             ; A3
  and  h             ; A4
  and  ixh           ; DD A4
  and  ixl           ; DD A5
  and  iyh           ; FD A4
  and  iyl           ; FD A5
  and  l             ; A5
  bit  0,(hl)        ; CB 46
  bit  0,(ix)        ; DD CB 00 46
  bit  0,(ix+DIS)    ; DD CB DIS 46
  bit  0,(ix-NDIS)   ; DD CB NDIS 46
  bit  0,(iy)        ; FD CB 00 46
  bit  0,(iy+DIS)    ; FD CB DIS 46
  bit  0,(iy-NDIS)   ; FD CB NDIS 46
  bit  0,a           ; CB 47
  bit  0,b           ; CB 40
  bit  0,c           ; CB 41
  bit  0,d           ; CB 42
  bit  0,e           ; CB 43
  bit  0,h           ; CB 44
  bit  0,l           ; CB 45
  bit  1,(hl)        ; CB 4E
  bit  1,(ix)        ; DD CB 00 4E
  bit  1,(ix+DIS)    ; DD CB DIS 4E
  bit  1,(ix-NDIS)   ; DD CB NDIS 4E
  bit  1,(iy)        ; FD CB 00 4E
  bit  1,(iy+DIS)    ; FD CB DIS 4E
  bit  1,(iy-NDIS)   ; FD CB NDIS 4E
  bit  1,a           ; CB 4F
  bit  1,b           ; CB 48
  bit  1,c           ; CB 49
  bit  1,d           ; CB 4A
  bit  1,e           ; CB 4B
  bit  1,h           ; CB 4C
  bit  1,l           ; CB 4D
  bit  2,(hl)        ; CB 56
  bit  2,(ix)        ; DD CB 00 56
  bit  2,(ix+DIS)    ; DD CB DIS 56
  bit  2,(ix-NDIS)   ; DD CB NDIS 56
  bit  2,(iy)        ; FD CB 00 56
  bit  2,(iy+DIS)    ; FD CB DIS 56
  bit  2,(iy-NDIS)   ; FD CB NDIS 56
  bit  2,a           ; CB 57
  bit  2,b           ; CB 50
  bit  2,c           ; CB 51
  bit  2,d           ; CB 52
  bit  2,e           ; CB 53
  bit  2,h           ; CB 54
  bit  2,l           ; CB 55
  bit  3,(hl)        ; CB 5E
  bit  3,(ix)        ; DD CB 00 5E
  bit  3,(ix+DIS)    ; DD CB DIS 5E
  bit  3,(ix-NDIS)   ; DD CB NDIS 5E
  bit  3,(iy)        ; FD CB 00 5E
  bit  3,(iy+DIS)    ; FD CB DIS 5E
  bit  3,(iy-NDIS)   ; FD CB NDIS 5E
  bit  3,a           ; CB 5F
  bit  3,b           ; CB 58
  bit  3,c           ; CB 59
  bit  3,d           ; CB 5A
  bit  3,e           ; CB 5B
  bit  3,h           ; CB 5C
  bit  3,l           ; CB 5D
  bit  4,(hl)        ; CB 66
  bit  4,(ix)        ; DD CB 00 66
  bit  4,(ix+DIS)    ; DD CB DIS 66
  bit  4,(ix-NDIS)   ; DD CB NDIS 66
  bit  4,(iy)        ; FD CB 00 66
  bit  4,(iy+DIS)    ; FD CB DIS 66
  bit  4,(iy-NDIS)   ; FD CB NDIS 66
  bit  4,a           ; CB 67
  bit  4,b           ; CB 60
  bit  4,c           ; CB 61
  bit  4,d           ; CB 62
  bit  4,e           ; CB 63
  bit  4,h           ; CB 64
  bit  4,l           ; CB 65
  bit  5,(hl)        ; CB 6E
  bit  5,(ix)        ; DD CB 00 6E
  bit  5,(ix+DIS)    ; DD CB DIS 6E
  bit  5,(ix-NDIS)   ; DD CB NDIS 6E
  bit  5,(iy)        ; FD CB 00 6E
  bit  5,(iy+DIS)    ; FD CB DIS 6E
  bit  5,(iy-NDIS)   ; FD CB NDIS 6E
  bit  5,a           ; CB 6F
  bit  5,b           ; CB 68
  bit  5,c           ; CB 69
  bit  5,d           ; CB 6A
  bit  5,e           ; CB 6B
  bit  5,h           ; CB 6C
  bit  5,l           ; CB 6D
  bit  6,(hl)        ; CB 76
  bit  6,(ix)        ; DD CB 00 76
  bit  6,(ix+DIS)    ; DD CB DIS 76
  bit  6,(ix-NDIS)   ; DD CB NDIS 76
  bit  6,(iy)        ; FD CB 00 76
  bit  6,(iy+DIS)    ; FD CB DIS 76
  bit  6,(iy-NDIS)   ; FD CB NDIS 76
  bit  6,a           ; CB 77
  bit  6,b           ; CB 70
  bit  6,c           ; CB 71
  bit  6,d           ; CB 72
  bit  6,e           ; CB 73
  bit  6,h           ; CB 74
  bit  6,l           ; CB 75
  bit  7,(hl)        ; CB 7E
  bit  7,(ix)        ; DD CB 00 7E
  bit  7,(ix+DIS)    ; DD CB DIS 7E
  bit  7,(ix-NDIS)   ; DD CB NDIS 7E
  bit  7,(iy)        ; FD CB 00 7E
  bit  7,(iy+DIS)    ; FD CB DIS 7E
  bit  7,(iy-NDIS)   ; FD CB NDIS 7E
  bit  7,a           ; CB 7F
  bit  7,b           ; CB 78
  bit  7,c           ; CB 79
  bit  7,d           ; CB 7A
  bit  7,e           ; CB 7B
  bit  7,h           ; CB 7C
  bit  7,l           ; CB 7D
  call NN            ; CD NNl NNh
  call c,NN          ; DC NNl NNh
  call m,NN          ; FC NNl NNh
  call nc,NN         ; D4 NNl NNh
  call nz,NN         ; C4 NNl NNh
  call p,NN          ; F4 NNl NNh
  call pe,NN         ; EC NNl NNh
  call po,NN         ; E4 NNl NNh
  call z,NN          ; CC NNl NNh
  ccf                ; 3F
  cp   (hl)          ; BE
  cp   (ix)          ; DD BE 00
  cp   (ix+DIS)      ; DD BE DIS
  cp   (ix-NDIS)     ; DD BE NDIS
  cp   (iy)          ; FD BE 00
  cp   (iy+DIS)      ; FD BE DIS
  cp   (iy-NDIS)     ; FD BE NDIS
  cp   N             ; FE N
  cp   a             ; BF
  cp   b             ; B8
  cp   c             ; B9
  cp   d             ; BA
  cp   e             ; BB
  cp   h             ; BC
  cp   ixh           ; DD BC
  cp   ixl           ; DD BD
  cp   iyh           ; FD BC
  cp   iyl           ; FD BD
  cp   l             ; BD
  cpd                ; ED A9
  cpdr               ; ED B9
  cpi                ; ED A1
  cpir               ; ED B1
  cpl                ; 2F
  daa                ; 27
  dec  (hl)          ; 35
  dec  (ix)          ; DD 35 00
  dec  (ix+DIS)      ; DD 35 DIS
  dec  (ix-NDIS)     ; DD 35 NDIS
  dec  (iy)          ; FD 35 00
  dec  (iy+DIS)      ; FD 35 DIS
  dec  (iy-NDIS)     ; FD 35 NDIS
  dec  a             ; 3D
  dec  b             ; 05
  dec  bc            ; 0B
  dec  c             ; 0D
  dec  d             ; 15
  dec  de            ; 1B
  dec  e             ; 1D
  dec  h             ; 25
  dec  hl            ; 2B
  dec  ix            ; DD 2B
  dec  ixh           ; DD 25
  dec  ixl           ; DD 2D
  dec  iy            ; FD 2B
  dec  iyh           ; FD 25
  dec  iyl           ; FD 2D
  dec  l             ; 2D
  dec  sp            ; 3B
  di                 ; F3
  djnz NN            ; 10 NNo
  ei                 ; FB
  ex   (sp),hl       ; E3
  ex   (sp),ix       ; DD E3
  ex   (sp),iy       ; FD E3
  ex   af,af'        ; 08
  ex   de,hl         ; EB
  exx                ; D9
  halt               ; 76
  im   0             ; ED 46
  im   1             ; ED 56
  im   2             ; ED 5E
  in   a,(N)         ; DB N
  in   a,(c)         ; ED 78
  in   b,(c)         ; ED 40
  in   c,(c)         ; ED 48
  in   d,(c)         ; ED 50
  in   e,(c)         ; ED 58
  in   f,(c)         ; ED 70
  in   h,(c)         ; ED 60
  in   l,(c)         ; ED 68
  inc  (hl)          ; 34
  inc  (ix)          ; DD 34 00
  inc  (ix+DIS)      ; DD 34 DIS
  inc  (ix-NDIS)     ; DD 34 NDIS
  inc  (iy)          ; FD 34 00
  inc  (iy+DIS)      ; FD 34 DIS
  inc  (iy-NDIS)     ; FD 34 NDIS
  inc  a             ; 3C
  inc  b             ; 04
  inc  bc            ; 03
  inc  c             ; 0C
  inc  d             ; 14
  inc  de            ; 13
  inc  e             ; 1C
  inc  h             ; 24
  inc  hl            ; 23
  inc  ix            ; DD 23
  inc  ixh           ; DD 24
  inc  ixl           ; DD 2C
  inc  iy            ; FD 23
  inc  iyh           ; FD 24
  inc  iyl           ; FD 2C
  inc  l             ; 2C
  inc  sp            ; 33
  ind                ; ED AA
  indr               ; ED BA
  ini                ; ED A2
  inir               ; ED B2
  jp   (hl)          ; E9
  jp   (ix)          ; DD E9
  jp   (iy)          ; FD E9
  jp   NN            ; C3 NNl NNh
  jp   c,NN          ; DA NNl NNh
  jp   m,NN          ; FA NNl NNh
  jp   nc,NN         ; D2 NNl NNh
  jp   nz,NN         ; C2 NNl NNh
  jp   p,NN          ; F2 NNl NNh
  jp   pe,NN         ; EA NNl NNh
  jp   po,NN         ; E2 NNl NNh
  jp   z,NN          ; CA NNl NNh
  jr   NN            ; 18 NNo
  jr   c,NN          ; 38 NNo
  jr   m,NN          ; FA NNl NNh
  jr   nc,NN         ; 30 NNo
  jr   nz,NN         ; 20 NNo
  jr   p,NN          ; F2 NNl NNh
  jr   pe,NN         ; EA NNl NNh
  jr   po,NN         ; E2 NNl NNh
  jr   z,NN          ; 28 NNo
  ld   (NN),a        ; 32 NNl NNh
  ld   (NN),bc       ; ED 43 NNl NNh
  ld   (NN),de       ; ED 53 NNl NNh
  ld   (NN),hl       ; 22 NNl NNh
  ld   (NN),ix       ; DD 22 NNl NNh
  ld   (NN),iy       ; FD 22 NNl NNh
  ld   (NN),sp       ; ED 73 NNl NNh
  ld   (bc),a        ; 02
  ld   (de),a        ; 12
  ld   (hl),N        ; 36 N
  ld   (hl),a        ; 77
  ld   (hl),b        ; 70
  ld   (hl),bc       ; 71 23 70 2B
  ld   (hl),c        ; 71
  ld   (hl),d        ; 72
  ld   (hl),de       ; 73 23 72 2B
  ld   (hl),e        ; 73
  ld   (hl),h        ; 74
  ld   (hl),l        ; 75
  ld   (ix),N        ; DD 36 00 N
  ld   (ix),a        ; DD 77 00
  ld   (ix),b        ; DD 70 00
  ld   (ix),bc       ; DD 71 00 DD 70 01
  ld   (ix),c        ; DD 71 00
  ld   (ix),d        ; DD 72 00
  ld   (ix),de       ; DD 73 00 DD 72 01
  ld   (ix),e        ; DD 73 00
  ld   (ix),h        ; DD 74 00
  ld   (ix),hl       ; DD 75 00 DD 74 01
  ld   (ix),l        ; DD 75 00
  ld   (ix+DIS),N    ; DD 36 DIS N
  ld   (ix+DIS),a    ; DD 77 DIS
  ld   (ix+DIS),b    ; DD 70 DIS
  ld   (ix+DIS),bc   ; DD 71 DIS DD 70 DIS+1
  ld   (ix+DIS),c    ; DD 71 DIS
  ld   (ix+DIS),d    ; DD 72 DIS
  ld   (ix+DIS),de   ; DD 73 DIS DD 72 DIS+1
  ld   (ix+DIS),e    ; DD 73 DIS
  ld   (ix+DIS),h    ; DD 74 DIS
  ld   (ix+DIS),hl   ; DD 75 DIS DD 74 DIS+1
  ld   (ix+DIS),l    ; DD 75 DIS
  ld   (ix-NDIS),N   ; DD 36 NDIS N
  ld   (ix-NDIS),a   ; DD 77 NDIS
  ld   (ix-NDIS),b   ; DD 70 NDIS
  ld   (ix-NDIS),bc  ; DD 71 NDIS DD 70 NDIS+1
  ld   (ix-NDIS),c   ; DD 71 NDIS
  ld   (ix-NDIS),d   ; DD 72 NDIS
  ld   (ix-NDIS),de  ; DD 73 NDIS DD 72 NDIS+1
  ld   (ix-NDIS),e   ; DD 73 NDIS
  ld   (ix-NDIS),h   ; DD 74 NDIS
  ld   (ix-NDIS),hl  ; DD 75 NDIS DD 74 NDIS+1
  ld   (ix-NDIS),l   ; DD 75 NDIS
  ld   (iy),N        ; FD 36 00 N
  ld   (iy),a        ; FD 77 00
  ld   (iy),b        ; FD 70 00
  ld   (iy),bc       ; FD 71 00 FD 70 01
  ld   (iy),c        ; FD 71 00
  ld   (iy),d        ; FD 72 00
  ld   (iy),de       ; FD 73 00 FD 72 01
  ld   (iy),e        ; FD 73 00
  ld   (iy),h        ; FD 74 00
  ld   (iy),hl       ; FD 75 00 FD 74 01
  ld   (iy),l        ; FD 75 00
  ld   (iy+DIS),N    ; FD 36 DIS N
  ld   (iy+DIS),a    ; FD 77 DIS
  ld   (iy+DIS),b    ; FD 70 DIS
  ld   (iy+DIS),bc   ; FD 71 DIS FD 70 DIS+1
  ld   (iy+DIS),c    ; FD 71 DIS
  ld   (iy+DIS),d    ; FD 72 DIS
  ld   (iy+DIS),de   ; FD 73 DIS FD 72 DIS+1
  ld   (iy+DIS),e    ; FD 73 DIS
  ld   (iy+DIS),h    ; FD 74 DIS
  ld   (iy+DIS),hl   ; FD 75 DIS FD 74 DIS+1
  ld   (iy+DIS),l    ; FD 75 DIS
  ld   (iy-NDIS),N   ; FD 36 NDIS N
  ld   (iy-NDIS),a   ; FD 77 NDIS
  ld   (iy-NDIS),b   ; FD 70 NDIS
  ld   (iy-NDIS),bc  ; FD 71 NDIS FD 70 NDIS+1
  ld   (iy-NDIS),c   ; FD 71 NDIS
  ld   (iy-NDIS),d   ; FD 72 NDIS
  ld   (iy-NDIS),de  ; FD 73 NDIS FD 72 NDIS+1
  ld   (iy-NDIS),e   ; FD 73 NDIS
  ld   (iy-NDIS),h   ; FD 74 NDIS
  ld   (iy-NDIS),hl  ; FD 75 NDIS FD 74 NDIS+1
  ld   (iy-NDIS),l   ; FD 75 NDIS
  ld   a,(NN)        ; 3A NNl NNh
  ld   a,(bc)        ; 0A
  ld   a,(de)        ; 1A
  ld   a,(hl)        ; 7E
  ld   a,(ix)        ; DD 7E 00
  ld   a,(ix+DIS)    ; DD 7E DIS
  ld   a,(ix-NDIS)   ; DD 7E NDIS
  ld   a,(iy)        ; FD 7E 00
  ld   a,(iy+DIS)    ; FD 7E DIS
  ld   a,(iy-NDIS)   ; FD 7E NDIS
  ld   a,N           ; 3E N
  ld   a,a           ; 7F
  ld   a,b           ; 78
  ld   a,c           ; 79
  ld   a,d           ; 7A
  ld   a,e           ; 7B
  ld   a,h           ; 7C
  ld   a,i           ; ED 57
  ld   a,ixh         ; DD 7C
  ld   a,ixl         ; DD 7D
  ld   a,iyh         ; FD 7C
  ld   a,iyl         ; FD 7D
  ld   a,l           ; 7D
  ld   a,r           ; ED 5F
  ld   b,(hl)        ; 46
  ld   b,(ix)        ; DD 46 00
  ld   b,(ix+DIS)    ; DD 46 DIS
  ld   b,(ix-NDIS)   ; DD 46 NDIS
  ld   b,(iy)        ; FD 46 00
  ld   b,(iy+DIS)    ; FD 46 DIS
  ld   b,(iy-NDIS)   ; FD 46 NDIS
  ld   b,N           ; 06 N
  ld   b,a           ; 47
  ld   b,b           ; 40
  ld   b,c           ; 41
  ld   b,d           ; 42
  ld   b,e           ; 43
  ld   b,h           ; 44
  ld   b,ixh         ; DD 44
  ld   b,ixl         ; DD 45
  ld   b,iyh         ; FD 44
  ld   b,iyl         ; FD 45
  ld   b,l           ; 45
  ld   bc,(NN)       ; ED 4B NNl NNh
  ld   bc,(hl)       ; 4E 23 46 2B
  ld   bc,(ix)       ; DD 4E 00 DD 46 01
  ld   bc,(ix+DIS)   ; DD 4E DIS DD 46 DIS+1
  ld   bc,(ix-NDIS)  ; DD 4E NDIS DD 46 NDIS+1
  ld   bc,(iy)       ; FD 4E 00 FD 46 01
  ld   bc,(iy+DIS)   ; FD 4E DIS FD 46 DIS+1
  ld   bc,(iy-NDIS)  ; FD 4E NDIS FD 46 NDIS+1
  ld   bc,NN         ; 01 NNl NNh
  ld   bc,bc         ; 40 49
  ld   bc,de         ; 42 4B
  ld   bc,hl         ; 44 4D
  ld   bc,ix         ; DD 44 DD 4D
  ld   bc,iy         ; FD 44 FD 4D
  ld   c,(hl)        ; 4E
  ld   c,(ix)        ; DD 4E 00
  ld   c,(ix+DIS)    ; DD 4E DIS
  ld   c,(ix-NDIS)   ; DD 4E NDIS
  ld   c,(iy)        ; FD 4E 00
  ld   c,(iy+DIS)    ; FD 4E DIS
  ld   c,(iy-NDIS)   ; FD 4E NDIS
  ld   c,N           ; 0E N
  ld   c,a           ; 4F
  ld   c,b           ; 48
  ld   c,c           ; 49
  ld   c,d           ; 4A
  ld   c,e           ; 4B
  ld   c,h           ; 4C
  ld   c,ixh         ; DD 4C
  ld   c,ixl         ; DD 4D
  ld   c,iyh         ; FD 4C
  ld   c,iyl         ; FD 4D
  ld   c,l           ; 4D
  ld   d,(hl)        ; 56
  ld   d,(ix)        ; DD 56 00
  ld   d,(ix+DIS)    ; DD 56 DIS
  ld   d,(ix-NDIS)   ; DD 56 NDIS
  ld   d,(iy)        ; FD 56 00
  ld   d,(iy+DIS)    ; FD 56 DIS
  ld   d,(iy-NDIS)   ; FD 56 NDIS
  ld   d,N           ; 16 N
  ld   d,a           ; 57
  ld   d,b           ; 50
  ld   d,c           ; 51
  ld   d,d           ; 52
  ld   d,e           ; 53
  ld   d,h           ; 54
  ld   d,ixh         ; DD 54
  ld   d,ixl         ; DD 55
  ld   d,iyh         ; FD 54
  ld   d,iyl         ; FD 55
  ld   d,l           ; 55
  ld   de,(NN)       ; ED 5B NNl NNh
  ld   de,(hl)       ; 5E 23 56 2B
  ld   de,(ix)       ; DD 5E 00 DD 56 01
  ld   de,(ix+DIS)   ; DD 5E DIS DD 56 DIS+1
  ld   de,(ix-NDIS)  ; DD 5E NDIS DD 56 NDIS+1
  ld   de,(iy)       ; FD 5E 00 FD 56 01
  ld   de,(iy+DIS)   ; FD 5E DIS FD 56 DIS+1
  ld   de,(iy-NDIS)  ; FD 5E NDIS FD 56 NDIS+1
  ld   de,NN         ; 11 NNl NNh
  ld   de,bc         ; 50 59
  ld   de,de         ; 52 5B
  ld   de,hl         ; 54 5D
  ld   de,ix         ; DD 54 DD 5D
  ld   de,iy         ; FD 54 FD 5D
  ld   e,(hl)        ; 5E
  ld   e,(ix)        ; DD 5E 00
  ld   e,(ix+DIS)    ; DD 5E DIS
  ld   e,(ix-NDIS)   ; DD 5E NDIS
  ld   e,(iy)        ; FD 5E 00
  ld   e,(iy+DIS)    ; FD 5E DIS
  ld   e,(iy-NDIS)   ; FD 5E NDIS
  ld   e,N           ; 1E N
  ld   e,a           ; 5F
  ld   e,b           ; 58
  ld   e,c           ; 59
  ld   e,d           ; 5A
  ld   e,e           ; 5B
  ld   e,h           ; 5C
  ld   e,ixh         ; DD 5C
  ld   e,ixl         ; DD 5D
  ld   e,iyh         ; FD 5C
  ld   e,iyl         ; FD 5D
  ld   e,l           ; 5D
  ld   h,(hl)        ; 66
  ld   h,(ix)        ; DD 66 00
  ld   h,(ix+DIS)    ; DD 66 DIS
  ld   h,(ix-NDIS)   ; DD 66 NDIS
  ld   h,(iy)        ; FD 66 00
  ld   h,(iy+DIS)    ; FD 66 DIS
  ld   h,(iy-NDIS)   ; FD 66 NDIS
  ld   h,N           ; 26 N
  ld   h,a           ; 67
  ld   h,b           ; 60
  ld   h,c           ; 61
  ld   h,d           ; 62
  ld   h,e           ; 63
  ld   h,h           ; 64
  ld   h,l           ; 65
  ld   hl,(NN)       ; 2A NNl NNh
  ld   hl,(ix)       ; DD 6E 00 DD 66 01
  ld   hl,(ix+DIS)   ; DD 6E DIS DD 66 DIS+1
  ld   hl,(ix-NDIS)  ; DD 6E NDIS DD 66 NDIS+1
  ld   hl,(iy)       ; FD 6E 00 FD 66 01
  ld   hl,(iy+DIS)   ; FD 6E DIS FD 66 DIS+1
  ld   hl,(iy-NDIS)  ; FD 6E NDIS FD 66 NDIS+1
  ld   hl,NN         ; 21 NNl NNh
  ld   hl,bc         ; 60 69
  ld   hl,de         ; 62 6B
  ld   hl,hl         ; 64 6D
  ld   hl,ix         ; DD E5 E1
  ld   hl,iy         ; FD E5 E1
  ld   i,a           ; ED 47
  ld   ix,(NN)       ; DD 2A NNl NNh
  ld   ix,NN         ; DD 21 NNl NNh
  ld   ix,bc         ; DD 69 DD 60
  ld   ix,de         ; DD 6B DD 62
  ld   ix,hl         ; E5 DD E1
  ld   ix,ix         ; DD 6D DD 64
  ld   ix,iy         ; FD E5 DD E1
  ld   ixh,N         ; DD 26 N
  ld   ixh,a         ; DD 67
  ld   ixh,b         ; DD 60
  ld   ixh,c         ; DD 61
  ld   ixh,d         ; DD 62
  ld   ixh,e         ; DD 63
  ld   ixh,ixh       ; DD 64
  ld   ixh,ixl       ; DD 65
  ld   ixl,N         ; DD 2E N
  ld   ixl,a         ; DD 6F
  ld   ixl,b         ; DD 68
  ld   ixl,c         ; DD 69
  ld   ixl,d         ; DD 6A
  ld   ixl,e         ; DD 6B
  ld   ixl,ixh       ; DD 6C
  ld   ixl,ixl       ; DD 6D
  ld   iy,(NN)       ; FD 2A NNl NNh
  ld   iy,NN         ; FD 21 NNl NNh
  ld   iy,bc         ; FD 69 FD 60
  ld   iy,de         ; FD 6B FD 62
  ld   iy,hl         ; E5 FD E1
  ld   iy,ix         ; DD E5 FD E1
  ld   iy,iy         ; FD 6D FD 64
  ld   iyh,N         ; FD 26 N
  ld   iyh,a         ; FD 67
  ld   iyh,b         ; FD 60
  ld   iyh,c         ; FD 61
  ld   iyh,d         ; FD 62
  ld   iyh,e         ; FD 63
  ld   iyh,iyh       ; FD 64
  ld   iyh,iyl       ; FD 65
  ld   iyl,N         ; FD 2E N
  ld   iyl,a         ; FD 6F
  ld   iyl,b         ; FD 68
  ld   iyl,c         ; FD 69
  ld   iyl,d         ; FD 6A
  ld   iyl,e         ; FD 6B
  ld   iyl,iyh       ; FD 6C
  ld   iyl,iyl       ; FD 6D
  ld   l,(hl)        ; 6E
  ld   l,(ix)        ; DD 6E 00
  ld   l,(ix+DIS)    ; DD 6E DIS
  ld   l,(ix-NDIS)   ; DD 6E NDIS
  ld   l,(iy)        ; FD 6E 00
  ld   l,(iy+DIS)    ; FD 6E DIS
  ld   l,(iy-NDIS)   ; FD 6E NDIS
  ld   l,N           ; 2E N
  ld   l,a           ; 6F
  ld   l,b           ; 68
  ld   l,c           ; 69
  ld   l,d           ; 6A
  ld   l,e           ; 6B
  ld   l,h           ; 6C
  ld   l,l           ; 6D
  ld   r,a           ; ED 4F
  ld   sp,(NN)       ; ED 7B NNl NNh
  ld   sp,NN         ; 31 NNl NNh
  ld   sp,hl         ; F9
  ld   sp,ix         ; DD F9
  ld   sp,iy         ; FD F9
  ldd                ; ED A8
  ldd  (bc),a        ; 02 0B
  ldd  (de),a        ; 12 1B
  ldd  (hl),N        ; 36 N 2B
  ldd  (hl),a        ; 77 2B
  ldd  (hl),b        ; 70 2B
  ldd  (hl),c        ; 71 2B
  ldd  (hl),d        ; 72 2B
  ldd  (hl),e        ; 73 2B
  ldd  (hl),h        ; 74 2B
  ldd  (hl),l        ; 75 2B
  ldd  (ix),N        ; DD 36 00 N DD 2B
  ldd  (ix),a        ; DD 77 00 DD 2B
  ldd  (ix),b        ; DD 70 00 DD 2B
  ldd  (ix),c        ; DD 71 00 DD 2B
  ldd  (ix),d        ; DD 72 00 DD 2B
  ldd  (ix),e        ; DD 73 00 DD 2B
  ldd  (ix),h        ; DD 74 00 DD 2B
  ldd  (ix),l        ; DD 75 00 DD 2B
  ldd  (ix+DIS),N    ; DD 36 DIS N DD 2B
  ldd  (ix+DIS),a    ; DD 77 DIS DD 2B
  ldd  (ix+DIS),b    ; DD 70 DIS DD 2B
  ldd  (ix+DIS),c    ; DD 71 DIS DD 2B
  ldd  (ix+DIS),d    ; DD 72 DIS DD 2B
  ldd  (ix+DIS),e    ; DD 73 DIS DD 2B
  ldd  (ix+DIS),h    ; DD 74 DIS DD 2B
  ldd  (ix+DIS),l    ; DD 75 DIS DD 2B
  ldd  (ix-NDIS),N   ; DD 36 NDIS N DD 2B
  ldd  (ix-NDIS),a   ; DD 77 NDIS DD 2B
  ldd  (ix-NDIS),b   ; DD 70 NDIS DD 2B
  ldd  (ix-NDIS),c   ; DD 71 NDIS DD 2B
  ldd  (ix-NDIS),d   ; DD 72 NDIS DD 2B
  ldd  (ix-NDIS),e   ; DD 73 NDIS DD 2B
  ldd  (ix-NDIS),h   ; DD 74 NDIS DD 2B
  ldd  (ix-NDIS),l   ; DD 75 NDIS DD 2B
  ldd  (iy),N        ; FD 36 00 N FD 2B
  ldd  (iy),a        ; FD 77 00 FD 2B
  ldd  (iy),b        ; FD 70 00 FD 2B
  ldd  (iy),c        ; FD 71 00 FD 2B
  ldd  (iy),d        ; FD 72 00 FD 2B
  ldd  (iy),e        ; FD 73 00 FD 2B
  ldd  (iy),h        ; FD 74 00 FD 2B
  ldd  (iy),l        ; FD 75 00 FD 2B
  ldd  (iy+DIS),N    ; FD 36 DIS N FD 2B
  ldd  (iy+DIS),a    ; FD 77 DIS FD 2B
  ldd  (iy+DIS),b    ; FD 70 DIS FD 2B
  ldd  (iy+DIS),c    ; FD 71 DIS FD 2B
  ldd  (iy+DIS),d    ; FD 72 DIS FD 2B
  ldd  (iy+DIS),e    ; FD 73 DIS FD 2B
  ldd  (iy+DIS),h    ; FD 74 DIS FD 2B
  ldd  (iy+DIS),l    ; FD 75 DIS FD 2B
  ldd  (iy-NDIS),N   ; FD 36 NDIS N FD 2B
  ldd  (iy-NDIS),a   ; FD 77 NDIS FD 2B
  ldd  (iy-NDIS),b   ; FD 70 NDIS FD 2B
  ldd  (iy-NDIS),c   ; FD 71 NDIS FD 2B
  ldd  (iy-NDIS),d   ; FD 72 NDIS FD 2B
  ldd  (iy-NDIS),e   ; FD 73 NDIS FD 2B
  ldd  (iy-NDIS),h   ; FD 74 NDIS FD 2B
  ldd  (iy-NDIS),l   ; FD 75 NDIS FD 2B
  ldd  a,(bc)        ; 0A 0B
  ldd  a,(de)        ; 1A 1B
  ldd  a,(hl)        ; 7E 2B
  ldd  a,(ix)        ; DD 7E 00 DD 2B
  ldd  a,(ix+DIS)    ; DD 7E DIS DD 2B
  ldd  a,(ix-NDIS)   ; DD 7E NDIS DD 2B
  ldd  a,(iy)        ; FD 7E 00 FD 2B
  ldd  a,(iy+DIS)    ; FD 7E DIS FD 2B
  ldd  a,(iy-NDIS)   ; FD 7E NDIS FD 2B
  ldd  b,(hl)        ; 46 2B
  ldd  b,(ix)        ; DD 46 00 DD 2B
  ldd  b,(ix+DIS)    ; DD 46 DIS DD 2B
  ldd  b,(ix-NDIS)   ; DD 46 NDIS DD 2B
  ldd  b,(iy)        ; FD 46 00 FD 2B
  ldd  b,(iy+DIS)    ; FD 46 DIS FD 2B
  ldd  b,(iy-NDIS)   ; FD 46 NDIS FD 2B
  ldd  c,(hl)        ; 4E 2B
  ldd  c,(ix)        ; DD 4E 00 DD 2B
  ldd  c,(ix+DIS)    ; DD 4E DIS DD 2B
  ldd  c,(ix-NDIS)   ; DD 4E NDIS DD 2B
  ldd  c,(iy)        ; FD 4E 00 FD 2B
  ldd  c,(iy+DIS)    ; FD 4E DIS FD 2B
  ldd  c,(iy-NDIS)   ; FD 4E NDIS FD 2B
  ldd  d,(hl)        ; 56 2B
  ldd  d,(ix)        ; DD 56 00 DD 2B
  ldd  d,(ix+DIS)    ; DD 56 DIS DD 2B
  ldd  d,(ix-NDIS)   ; DD 56 NDIS DD 2B
  ldd  d,(iy)        ; FD 56 00 FD 2B
  ldd  d,(iy+DIS)    ; FD 56 DIS FD 2B
  ldd  d,(iy-NDIS)   ; FD 56 NDIS FD 2B
  ldd  e,(hl)        ; 5E 2B
  ldd  e,(ix)        ; DD 5E 00 DD 2B
  ldd  e,(ix+DIS)    ; DD 5E DIS DD 2B
  ldd  e,(ix-NDIS)   ; DD 5E NDIS DD 2B
  ldd  e,(iy)        ; FD 5E 00 FD 2B
  ldd  e,(iy+DIS)    ; FD 5E DIS FD 2B
  ldd  e,(iy-NDIS)   ; FD 5E NDIS FD 2B
  ldd  h,(hl)        ; 66 2B
  ldd  h,(ix)        ; DD 66 00 DD 2B
  ldd  h,(ix+DIS)    ; DD 66 DIS DD 2B
  ldd  h,(ix-NDIS)   ; DD 66 NDIS DD 2B
  ldd  h,(iy)        ; FD 66 00 FD 2B
  ldd  h,(iy+DIS)    ; FD 66 DIS FD 2B
  ldd  h,(iy-NDIS)   ; FD 66 NDIS FD 2B
  ldd  l,(hl)        ; 6E 2B
  ldd  l,(ix)        ; DD 6E 00 DD 2B
  ldd  l,(ix+DIS)    ; DD 6E DIS DD 2B
  ldd  l,(ix-NDIS)   ; DD 6E NDIS DD 2B
  ldd  l,(iy)        ; FD 6E 00 FD 2B
  ldd  l,(iy+DIS)    ; FD 6E DIS FD 2B
  ldd  l,(iy-NDIS)   ; FD 6E NDIS FD 2B
  lddr               ; ED B8
  ldi                ; ED A0
  ldi  (bc),a        ; 02 03
  ldi  (de),a        ; 12 13
  ldi  (hl),N        ; 36 N 23
  ldi  (hl),a        ; 77 23
  ldi  (hl),b        ; 70 23
  ldi  (hl),bc       ; 71 23 70 23
  ldi  (hl),c        ; 71 23
  ldi  (hl),d        ; 72 23
  ldi  (hl),de       ; 73 23 72 23
  ldi  (hl),e        ; 73 23
  ldi  (hl),h        ; 74 23
  ldi  (hl),l        ; 75 23
  ldi  (ix),N        ; DD 36 00 N DD 23
  ldi  (ix),a        ; DD 77 00 DD 23
  ldi  (ix),b        ; DD 70 00 DD 23
  ldi  (ix),bc       ; DD 71 00 DD 23 DD 70 00 DD 23
  ldi  (ix),c        ; DD 71 00 DD 23
  ldi  (ix),d        ; DD 72 00 DD 23
  ldi  (ix),de       ; DD 73 00 DD 23 DD 72 00 DD 23
  ldi  (ix),e        ; DD 73 00 DD 23
  ldi  (ix),h        ; DD 74 00 DD 23
  ldi  (ix),hl       ; DD 75 00 DD 23 DD 74 00 DD 23
  ldi  (ix),l        ; DD 75 00 DD 23
  ldi  (ix+DIS),N    ; DD 36 DIS N DD 23
  ldi  (ix+DIS),a    ; DD 77 DIS DD 23
  ldi  (ix+DIS),b    ; DD 70 DIS DD 23
  ldi  (ix+DIS),bc   ; DD 71 DIS DD 23 DD 70 DIS DD 23
  ldi  (ix+DIS),c    ; DD 71 DIS DD 23
  ldi  (ix+DIS),d    ; DD 72 DIS DD 23
  ldi  (ix+DIS),de   ; DD 73 DIS DD 23 DD 72 DIS DD 23
  ldi  (ix+DIS),e    ; DD 73 DIS DD 23
  ldi  (ix+DIS),h    ; DD 74 DIS DD 23
  ldi  (ix+DIS),hl   ; DD 75 DIS DD 23 DD 74 DIS DD 23
  ldi  (ix+DIS),l    ; DD 75 DIS DD 23
  ldi  (ix-NDIS),N   ; DD 36 NDIS N DD 23
  ldi  (ix-NDIS),a   ; DD 77 NDIS DD 23
  ldi  (ix-NDIS),b   ; DD 70 NDIS DD 23
  ldi  (ix-NDIS),bc  ; DD 71 NDIS DD 23 DD 70 NDIS DD 23
  ldi  (ix-NDIS),c   ; DD 71 NDIS DD 23
  ldi  (ix-NDIS),d   ; DD 72 NDIS DD 23
  ldi  (ix-NDIS),de  ; DD 73 NDIS DD 23 DD 72 NDIS DD 23
  ldi  (ix-NDIS),e   ; DD 73 NDIS DD 23
  ldi  (ix-NDIS),h   ; DD 74 NDIS DD 23
  ldi  (ix-NDIS),hl  ; DD 75 NDIS DD 23 DD 74 NDIS DD 23
  ldi  (ix-NDIS),l   ; DD 75 NDIS DD 23
  ldi  (iy),N        ; FD 36 00 N FD 23
  ldi  (iy),a        ; FD 77 00 FD 23
  ldi  (iy),b        ; FD 70 00 FD 23
  ldi  (iy),bc       ; FD 71 00 FD 23 FD 70 00 FD 23
  ldi  (iy),c        ; FD 71 00 FD 23
  ldi  (iy),d        ; FD 72 00 FD 23
  ldi  (iy),de       ; FD 73 00 FD 23 FD 72 00 FD 23
  ldi  (iy),e        ; FD 73 00 FD 23
  ldi  (iy),h        ; FD 74 00 FD 23
  ldi  (iy),hl       ; FD 75 00 FD 23 FD 74 00 FD 23
  ldi  (iy),l        ; FD 75 00 FD 23
  ldi  (iy+DIS),N    ; FD 36 DIS N FD 23
  ldi  (iy+DIS),a    ; FD 77 DIS FD 23
  ldi  (iy+DIS),b    ; FD 70 DIS FD 23
  ldi  (iy+DIS),bc   ; FD 71 DIS FD 23 FD 70 DIS FD 23
  ldi  (iy+DIS),c    ; FD 71 DIS FD 23
  ldi  (iy+DIS),d    ; FD 72 DIS FD 23
  ldi  (iy+DIS),de   ; FD 73 DIS FD 23 FD 72 DIS FD 23
  ldi  (iy+DIS),e    ; FD 73 DIS FD 23
  ldi  (iy+DIS),h    ; FD 74 DIS FD 23
  ldi  (iy+DIS),hl   ; FD 75 DIS FD 23 FD 74 DIS FD 23
  ldi  (iy+DIS),l    ; FD 75 DIS FD 23
  ldi  (iy-NDIS),N   ; FD 36 NDIS N FD 23
  ldi  (iy-NDIS),a   ; FD 77 NDIS FD 23
  ldi  (iy-NDIS),b   ; FD 70 NDIS FD 23
  ldi  (iy-NDIS),bc  ; FD 71 NDIS FD 23 FD 70 NDIS FD 23
  ldi  (iy-NDIS),c   ; FD 71 NDIS FD 23
  ldi  (iy-NDIS),d   ; FD 72 NDIS FD 23
  ldi  (iy-NDIS),de  ; FD 73 NDIS FD 23 FD 72 NDIS FD 23
  ldi  (iy-NDIS),e   ; FD 73 NDIS FD 23
  ldi  (iy-NDIS),h   ; FD 74 NDIS FD 23
  ldi  (iy-NDIS),hl  ; FD 75 NDIS FD 23 FD 74 NDIS FD 23
  ldi  (iy-NDIS),l   ; FD 75 NDIS FD 23
  ldi  a,(bc)        ; 0A 03
  ldi  a,(de)        ; 1A 13
  ldi  a,(hl)        ; 7E 23
  ldi  a,(ix)        ; DD 7E 00 DD 23
  ldi  a,(ix+DIS)    ; DD 7E DIS DD 23
  ldi  a,(ix-NDIS)   ; DD 7E NDIS DD 23
  ldi  a,(iy)        ; FD 7E 00 FD 23
  ldi  a,(iy+DIS)    ; FD 7E DIS FD 23
  ldi  a,(iy-NDIS)   ; FD 7E NDIS FD 23
  ldi  b,(hl)        ; 46 23
  ldi  b,(ix)        ; DD 46 00 DD 23
  ldi  b,(ix+DIS)    ; DD 46 DIS DD 23
  ldi  b,(ix-NDIS)   ; DD 46 NDIS DD 23
  ldi  b,(iy)        ; FD 46 00 FD 23
  ldi  b,(iy+DIS)    ; FD 46 DIS FD 23
  ldi  b,(iy-NDIS)   ; FD 46 NDIS FD 23
  ldi  bc,(hl)       ; 4E 23 46 23
  ldi  bc,(ix)       ; DD 4E 00 DD 23 DD 46 00 DD 23
  ldi  bc,(ix+DIS)   ; DD 4E DIS DD 23 DD 46 DIS DD 23
  ldi  bc,(ix-NDIS)  ; DD 4E NDIS DD 23 DD 46 NDIS DD 23
  ldi  bc,(iy)       ; FD 4E 00 FD 23 FD 46 00 FD 23
  ldi  bc,(iy+DIS)   ; FD 4E DIS FD 23 FD 46 DIS FD 23
  ldi  bc,(iy-NDIS)  ; FD 4E NDIS FD 23 FD 46 NDIS FD 23
  ldi  c,(hl)        ; 4E 23
  ldi  c,(ix)        ; DD 4E 00 DD 23
  ldi  c,(ix+DIS)    ; DD 4E DIS DD 23
  ldi  c,(ix-NDIS)   ; DD 4E NDIS DD 23
  ldi  c,(iy)        ; FD 4E 00 FD 23
  ldi  c,(iy+DIS)    ; FD 4E DIS FD 23
  ldi  c,(iy-NDIS)   ; FD 4E NDIS FD 23
  ldi  d,(hl)        ; 56 23
  ldi  d,(ix)        ; DD 56 00 DD 23
  ldi  d,(ix+DIS)    ; DD 56 DIS DD 23
  ldi  d,(ix-NDIS)   ; DD 56 NDIS DD 23
  ldi  d,(iy)        ; FD 56 00 FD 23
  ldi  d,(iy+DIS)    ; FD 56 DIS FD 23
  ldi  d,(iy-NDIS)   ; FD 56 NDIS FD 23
  ldi  de,(hl)       ; 5E 23 56 23
  ldi  de,(ix)       ; DD 5E 00 DD 23 DD 56 00 DD 23
  ldi  de,(ix+DIS)   ; DD 5E DIS DD 23 DD 56 DIS DD 23
  ldi  de,(ix-NDIS)  ; DD 5E NDIS DD 23 DD 56 NDIS DD 23
  ldi  de,(iy)       ; FD 5E 00 FD 23 FD 56 00 FD 23
  ldi  de,(iy+DIS)   ; FD 5E DIS FD 23 FD 56 DIS FD 23
  ldi  de,(iy-NDIS)  ; FD 5E NDIS FD 23 FD 56 NDIS FD 23
  ldi  e,(hl)        ; 5E 23
  ldi  e,(ix)        ; DD 5E 00 DD 23
  ldi  e,(ix+DIS)    ; DD 5E DIS DD 23
  ldi  e,(ix-NDIS)   ; DD 5E NDIS DD 23
  ldi  e,(iy)        ; FD 5E 00 FD 23
  ldi  e,(iy+DIS)    ; FD 5E DIS FD 23
  ldi  e,(iy-NDIS)   ; FD 5E NDIS FD 23
  ldi  h,(hl)        ; 66 23
  ldi  h,(ix)        ; DD 66 00 DD 23
  ldi  h,(ix+DIS)    ; DD 66 DIS DD 23
  ldi  h,(ix-NDIS)   ; DD 66 NDIS DD 23
  ldi  h,(iy)        ; FD 66 00 FD 23
  ldi  h,(iy+DIS)    ; FD 66 DIS FD 23
  ldi  h,(iy-NDIS)   ; FD 66 NDIS FD 23
  ldi  hl,(ix)       ; DD 6E 00 DD 23 DD 66 00 DD 23
  ldi  hl,(ix+DIS)   ; DD 6E DIS DD 23 DD 66 DIS DD 23
  ldi  hl,(ix-NDIS)  ; DD 6E NDIS DD 23 DD 66 NDIS DD 23
  ldi  hl,(iy)       ; FD 6E 00 FD 23 FD 66 00 FD 23
  ldi  hl,(iy+DIS)   ; FD 6E DIS FD 23 FD 66 DIS FD 23
  ldi  hl,(iy-NDIS)  ; FD 6E NDIS FD 23 FD 66 NDIS FD 23
  ldi  l,(hl)        ; 6E 23
  ldi  l,(ix)        ; DD 6E 00 DD 23
  ldi  l,(ix+DIS)    ; DD 6E DIS DD 23
  ldi  l,(ix-NDIS)   ; DD 6E NDIS DD 23
  ldi  l,(iy)        ; FD 6E 00 FD 23
  ldi  l,(iy+DIS)    ; FD 6E DIS FD 23
  ldi  l,(iy-NDIS)   ; FD 6E NDIS FD 23
  ldir               ; ED B0
  neg                ; ED 44
  nop                ; 00
  or   (hl)          ; B6
  or   (ix)          ; DD B6 00
  or   (ix+DIS)      ; DD B6 DIS
  or   (ix-NDIS)     ; DD B6 NDIS
  or   (iy)          ; FD B6 00
  or   (iy+DIS)      ; FD B6 DIS
  or   (iy-NDIS)     ; FD B6 NDIS
  or   N             ; F6 N
  or   a             ; B7
  or   b             ; B0
  or   c             ; B1
  or   d             ; B2
  or   e             ; B3
  or   h             ; B4
  or   ixh           ; DD B4
  or   ixl           ; DD B5
  or   iyh           ; FD B4
  or   iyl           ; FD B5
  or   l             ; B5
  otdr               ; ED BB
  otir               ; ED B3
  out  (N),a         ; D3 N
  out  (c),0         ; ED 71
  out  (c),a         ; ED 79
  out  (c),b         ; ED 41
  out  (c),c         ; ED 49
  out  (c),d         ; ED 51
  out  (c),e         ; ED 59
  out  (c),h         ; ED 61
  out  (c),l         ; ED 69
  outd               ; ED AB
  outi               ; ED A3
  pop  af            ; F1
  pop  bc            ; C1
  pop  de            ; D1
  pop  hl            ; E1
  pop  ix            ; DD E1
  pop  iy            ; FD E1
  push af            ; F5
  push bc            ; C5
  push de            ; D5
  push hl            ; E5
  push ix            ; DD E5
  push iy            ; FD E5
  res  0,(hl)        ; CB 86
  res  0,(ix)        ; DD CB 00 86
  res  0,(ix),a      ; DD CB 00 87
  res  0,(ix),b      ; DD CB 00 80
  res  0,(ix),c      ; DD CB 00 81
  res  0,(ix),d      ; DD CB 00 82
  res  0,(ix),e      ; DD CB 00 83
  res  0,(ix),h      ; DD CB 00 84
  res  0,(ix),l      ; DD CB 00 85
  res  0,(ix+DIS)    ; DD CB DIS 86
  res  0,(ix+DIS),a  ; DD CB DIS 87
  res  0,(ix+DIS),b  ; DD CB DIS 80
  res  0,(ix+DIS),c  ; DD CB DIS 81
  res  0,(ix+DIS),d  ; DD CB DIS 82
  res  0,(ix+DIS),e  ; DD CB DIS 83
  res  0,(ix+DIS),h  ; DD CB DIS 84
  res  0,(ix+DIS),l  ; DD CB DIS 85
  res  0,(ix-NDIS)   ; DD CB NDIS 86
  res  0,(ix-NDIS),a ; DD CB NDIS 87
  res  0,(ix-NDIS),b ; DD CB NDIS 80
  res  0,(ix-NDIS),c ; DD CB NDIS 81
  res  0,(ix-NDIS),d ; DD CB NDIS 82
  res  0,(ix-NDIS),e ; DD CB NDIS 83
  res  0,(ix-NDIS),h ; DD CB NDIS 84
  res  0,(ix-NDIS),l ; DD CB NDIS 85
  res  0,(iy)        ; FD CB 00 86
  res  0,(iy),a      ; FD CB 00 87
  res  0,(iy),b      ; FD CB 00 80
  res  0,(iy),c      ; FD CB 00 81
  res  0,(iy),d      ; FD CB 00 82
  res  0,(iy),e      ; FD CB 00 83
  res  0,(iy),h      ; FD CB 00 84
  res  0,(iy),l      ; FD CB 00 85
  res  0,(iy+DIS)    ; FD CB DIS 86
  res  0,(iy+DIS),a  ; FD CB DIS 87
  res  0,(iy+DIS),b  ; FD CB DIS 80
  res  0,(iy+DIS),c  ; FD CB DIS 81
  res  0,(iy+DIS),d  ; FD CB DIS 82
  res  0,(iy+DIS),e  ; FD CB DIS 83
  res  0,(iy+DIS),h  ; FD CB DIS 84
  res  0,(iy+DIS),l  ; FD CB DIS 85
  res  0,(iy-NDIS)   ; FD CB NDIS 86
  res  0,(iy-NDIS),a ; FD CB NDIS 87
  res  0,(iy-NDIS),b ; FD CB NDIS 80
  res  0,(iy-NDIS),c ; FD CB NDIS 81
  res  0,(iy-NDIS),d ; FD CB NDIS 82
  res  0,(iy-NDIS),e ; FD CB NDIS 83
  res  0,(iy-NDIS),h ; FD CB NDIS 84
  res  0,(iy-NDIS),l ; FD CB NDIS 85
  res  0,a           ; CB 87
  res  0,b           ; CB 80
  res  0,c           ; CB 81
  res  0,d           ; CB 82
  res  0,e           ; CB 83
  res  0,h           ; CB 84
  res  0,l           ; CB 85
  res  1,(hl)        ; CB 8E
  res  1,(ix)        ; DD CB 00 8E
  res  1,(ix),a      ; DD CB 00 8F
  res  1,(ix),b      ; DD CB 00 88
  res  1,(ix),c      ; DD CB 00 89
  res  1,(ix),d      ; DD CB 00 8A
  res  1,(ix),e      ; DD CB 00 8B
  res  1,(ix),h      ; DD CB 00 8C
  res  1,(ix),l      ; DD CB 00 8D
  res  1,(ix+DIS)    ; DD CB DIS 8E
  res  1,(ix+DIS),a  ; DD CB DIS 8F
  res  1,(ix+DIS),b  ; DD CB DIS 88
  res  1,(ix+DIS),c  ; DD CB DIS 89
  res  1,(ix+DIS),d  ; DD CB DIS 8A
  res  1,(ix+DIS),e  ; DD CB DIS 8B
  res  1,(ix+DIS),h  ; DD CB DIS 8C
  res  1,(ix+DIS),l  ; DD CB DIS 8D
  res  1,(ix-NDIS)   ; DD CB NDIS 8E
  res  1,(ix-NDIS),a ; DD CB NDIS 8F
  res  1,(ix-NDIS),b ; DD CB NDIS 88
  res  1,(ix-NDIS),c ; DD CB NDIS 89
  res  1,(ix-NDIS),d ; DD CB NDIS 8A
  res  1,(ix-NDIS),e ; DD CB NDIS 8B
  res  1,(ix-NDIS),h ; DD CB NDIS 8C
  res  1,(ix-NDIS),l ; DD CB NDIS 8D
  res  1,(iy)        ; FD CB 00 8E
  res  1,(iy),a      ; FD CB 00 8F
  res  1,(iy),b      ; FD CB 00 88
  res  1,(iy),c      ; FD CB 00 89
  res  1,(iy),d      ; FD CB 00 8A
  res  1,(iy),e      ; FD CB 00 8B
  res  1,(iy),h      ; FD CB 00 8C
  res  1,(iy),l      ; FD CB 00 8D
  res  1,(iy+DIS)    ; FD CB DIS 8E
  res  1,(iy+DIS),a  ; FD CB DIS 8F
  res  1,(iy+DIS),b  ; FD CB DIS 88
  res  1,(iy+DIS),c  ; FD CB DIS 89
  res  1,(iy+DIS),d  ; FD CB DIS 8A
  res  1,(iy+DIS),e  ; FD CB DIS 8B
  res  1,(iy+DIS),h  ; FD CB DIS 8C
  res  1,(iy+DIS),l  ; FD CB DIS 8D
  res  1,(iy-NDIS)   ; FD CB NDIS 8E
  res  1,(iy-NDIS),a ; FD CB NDIS 8F
  res  1,(iy-NDIS),b ; FD CB NDIS 88
  res  1,(iy-NDIS),c ; FD CB NDIS 89
  res  1,(iy-NDIS),d ; FD CB NDIS 8A
  res  1,(iy-NDIS),e ; FD CB NDIS 8B
  res  1,(iy-NDIS),h ; FD CB NDIS 8C
  res  1,(iy-NDIS),l ; FD CB NDIS 8D
  res  1,a           ; CB 8F
  res  1,b           ; CB 88
  res  1,c           ; CB 89
  res  1,d           ; CB 8A
  res  1,e           ; CB 8B
  res  1,h           ; CB 8C
  res  1,l           ; CB 8D
  res  2,(hl)        ; CB 96
  res  2,(ix)        ; DD CB 00 96
  res  2,(ix),a      ; DD CB 00 97
  res  2,(ix),b      ; DD CB 00 90
  res  2,(ix),c      ; DD CB 00 91
  res  2,(ix),d      ; DD CB 00 92
  res  2,(ix),e      ; DD CB 00 93
  res  2,(ix),h      ; DD CB 00 94
  res  2,(ix),l      ; DD CB 00 95
  res  2,(ix+DIS)    ; DD CB DIS 96
  res  2,(ix+DIS),a  ; DD CB DIS 97
  res  2,(ix+DIS),b  ; DD CB DIS 90
  res  2,(ix+DIS),c  ; DD CB DIS 91
  res  2,(ix+DIS),d  ; DD CB DIS 92
  res  2,(ix+DIS),e  ; DD CB DIS 93
  res  2,(ix+DIS),h  ; DD CB DIS 94
  res  2,(ix+DIS),l  ; DD CB DIS 95
  res  2,(ix-NDIS)   ; DD CB NDIS 96
  res  2,(ix-NDIS),a ; DD CB NDIS 97
  res  2,(ix-NDIS),b ; DD CB NDIS 90
  res  2,(ix-NDIS),c ; DD CB NDIS 91
  res  2,(ix-NDIS),d ; DD CB NDIS 92
  res  2,(ix-NDIS),e ; DD CB NDIS 93
  res  2,(ix-NDIS),h ; DD CB NDIS 94
  res  2,(ix-NDIS),l ; DD CB NDIS 95
  res  2,(iy)        ; FD CB 00 96
  res  2,(iy),a      ; FD CB 00 97
  res  2,(iy),b      ; FD CB 00 90
  res  2,(iy),c      ; FD CB 00 91
  res  2,(iy),d      ; FD CB 00 92
  res  2,(iy),e      ; FD CB 00 93
  res  2,(iy),h      ; FD CB 00 94
  res  2,(iy),l      ; FD CB 00 95
  res  2,(iy+DIS)    ; FD CB DIS 96
  res  2,(iy+DIS),a  ; FD CB DIS 97
  res  2,(iy+DIS),b  ; FD CB DIS 90
  res  2,(iy+DIS),c  ; FD CB DIS 91
  res  2,(iy+DIS),d  ; FD CB DIS 92
  res  2,(iy+DIS),e  ; FD CB DIS 93
  res  2,(iy+DIS),h  ; FD CB DIS 94
  res  2,(iy+DIS),l  ; FD CB DIS 95
  res  2,(iy-NDIS)   ; FD CB NDIS 96
  res  2,(iy-NDIS),a ; FD CB NDIS 97
  res  2,(iy-NDIS),b ; FD CB NDIS 90
  res  2,(iy-NDIS),c ; FD CB NDIS 91
  res  2,(iy-NDIS),d ; FD CB NDIS 92
  res  2,(iy-NDIS),e ; FD CB NDIS 93
  res  2,(iy-NDIS),h ; FD CB NDIS 94
  res  2,(iy-NDIS),l ; FD CB NDIS 95
  res  2,a           ; CB 97
  res  2,b           ; CB 90
  res  2,c           ; CB 91
  res  2,d           ; CB 92
  res  2,e           ; CB 93
  res  2,h           ; CB 94
  res  2,l           ; CB 95
  res  3,(hl)        ; CB 9E
  res  3,(ix)        ; DD CB 00 9E
  res  3,(ix),a      ; DD CB 00 9F
  res  3,(ix),b      ; DD CB 00 98
  res  3,(ix),c      ; DD CB 00 99
  res  3,(ix),d      ; DD CB 00 9A
  res  3,(ix),e      ; DD CB 00 9B
  res  3,(ix),h      ; DD CB 00 9C
  res  3,(ix),l      ; DD CB 00 9D
  res  3,(ix+DIS)    ; DD CB DIS 9E
  res  3,(ix+DIS),a  ; DD CB DIS 9F
  res  3,(ix+DIS),b  ; DD CB DIS 98
  res  3,(ix+DIS),c  ; DD CB DIS 99
  res  3,(ix+DIS),d  ; DD CB DIS 9A
  res  3,(ix+DIS),e  ; DD CB DIS 9B
  res  3,(ix+DIS),h  ; DD CB DIS 9C
  res  3,(ix+DIS),l  ; DD CB DIS 9D
  res  3,(ix-NDIS)   ; DD CB NDIS 9E
  res  3,(ix-NDIS),a ; DD CB NDIS 9F
  res  3,(ix-NDIS),b ; DD CB NDIS 98
  res  3,(ix-NDIS),c ; DD CB NDIS 99
  res  3,(ix-NDIS),d ; DD CB NDIS 9A
  res  3,(ix-NDIS),e ; DD CB NDIS 9B
  res  3,(ix-NDIS),h ; DD CB NDIS 9C
  res  3,(ix-NDIS),l ; DD CB NDIS 9D
  res  3,(iy)        ; FD CB 00 9E
  res  3,(iy),a      ; FD CB 00 9F
  res  3,(iy),b      ; FD CB 00 98
  res  3,(iy),c      ; FD CB 00 99
  res  3,(iy),d      ; FD CB 00 9A
  res  3,(iy),e      ; FD CB 00 9B
  res  3,(iy),h      ; FD CB 00 9C
  res  3,(iy),l      ; FD CB 00 9D
  res  3,(iy+DIS)    ; FD CB DIS 9E
  res  3,(iy+DIS),a  ; FD CB DIS 9F
  res  3,(iy+DIS),b  ; FD CB DIS 98
  res  3,(iy+DIS),c  ; FD CB DIS 99
  res  3,(iy+DIS),d  ; FD CB DIS 9A
  res  3,(iy+DIS),e  ; FD CB DIS 9B
  res  3,(iy+DIS),h  ; FD CB DIS 9C
  res  3,(iy+DIS),l  ; FD CB DIS 9D
  res  3,(iy-NDIS)   ; FD CB NDIS 9E
  res  3,(iy-NDIS),a ; FD CB NDIS 9F
  res  3,(iy-NDIS),b ; FD CB NDIS 98
  res  3,(iy-NDIS),c ; FD CB NDIS 99
  res  3,(iy-NDIS),d ; FD CB NDIS 9A
  res  3,(iy-NDIS),e ; FD CB NDIS 9B
  res  3,(iy-NDIS),h ; FD CB NDIS 9C
  res  3,(iy-NDIS),l ; FD CB NDIS 9D
  res  3,a           ; CB 9F
  res  3,b           ; CB 98
  res  3,c           ; CB 99
  res  3,d           ; CB 9A
  res  3,e           ; CB 9B
  res  3,h           ; CB 9C
  res  3,l           ; CB 9D
  res  4,(hl)        ; CB A6
  res  4,(ix)        ; DD CB 00 A6
  res  4,(ix),a      ; DD CB 00 A7
  res  4,(ix),b      ; DD CB 00 A0
  res  4,(ix),c      ; DD CB 00 A1
  res  4,(ix),d      ; DD CB 00 A2
  res  4,(ix),e      ; DD CB 00 A3
  res  4,(ix),h      ; DD CB 00 A4
  res  4,(ix),l      ; DD CB 00 A5
  res  4,(ix+DIS)    ; DD CB DIS A6
  res  4,(ix+DIS),a  ; DD CB DIS A7
  res  4,(ix+DIS),b  ; DD CB DIS A0
  res  4,(ix+DIS),c  ; DD CB DIS A1
  res  4,(ix+DIS),d  ; DD CB DIS A2
  res  4,(ix+DIS),e  ; DD CB DIS A3
  res  4,(ix+DIS),h  ; DD CB DIS A4
  res  4,(ix+DIS),l  ; DD CB DIS A5
  res  4,(ix-NDIS)   ; DD CB NDIS A6
  res  4,(ix-NDIS),a ; DD CB NDIS A7
  res  4,(ix-NDIS),b ; DD CB NDIS A0
  res  4,(ix-NDIS),c ; DD CB NDIS A1
  res  4,(ix-NDIS),d ; DD CB NDIS A2
  res  4,(ix-NDIS),e ; DD CB NDIS A3
  res  4,(ix-NDIS),h ; DD CB NDIS A4
  res  4,(ix-NDIS),l ; DD CB NDIS A5
  res  4,(iy)        ; FD CB 00 A6
  res  4,(iy),a      ; FD CB 00 A7
  res  4,(iy),b      ; FD CB 00 A0
  res  4,(iy),c      ; FD CB 00 A1
  res  4,(iy),d      ; FD CB 00 A2
  res  4,(iy),e      ; FD CB 00 A3
  res  4,(iy),h      ; FD CB 00 A4
  res  4,(iy),l      ; FD CB 00 A5
  res  4,(iy+DIS)    ; FD CB DIS A6
  res  4,(iy+DIS),a  ; FD CB DIS A7
  res  4,(iy+DIS),b  ; FD CB DIS A0
  res  4,(iy+DIS),c  ; FD CB DIS A1
  res  4,(iy+DIS),d  ; FD CB DIS A2
  res  4,(iy+DIS),e  ; FD CB DIS A3
  res  4,(iy+DIS),h  ; FD CB DIS A4
  res  4,(iy+DIS),l  ; FD CB DIS A5
  res  4,(iy-NDIS)   ; FD CB NDIS A6
  res  4,(iy-NDIS),a ; FD CB NDIS A7
  res  4,(iy-NDIS),b ; FD CB NDIS A0
  res  4,(iy-NDIS),c ; FD CB NDIS A1
  res  4,(iy-NDIS),d ; FD CB NDIS A2
  res  4,(iy-NDIS),e ; FD CB NDIS A3
  res  4,(iy-NDIS),h ; FD CB NDIS A4
  res  4,(iy-NDIS),l ; FD CB NDIS A5
  res  4,a           ; CB A7
  res  4,b           ; CB A0
  res  4,c           ; CB A1
  res  4,d           ; CB A2
  res  4,e           ; CB A3
  res  4,h           ; CB A4
  res  4,l           ; CB A5
  res  5,(hl)        ; CB AE
  res  5,(ix)        ; DD CB 00 AE
  res  5,(ix),a      ; DD CB 00 AF
  res  5,(ix),b      ; DD CB 00 A8
  res  5,(ix),c      ; DD CB 00 A9
  res  5,(ix),d      ; DD CB 00 AA
  res  5,(ix),e      ; DD CB 00 AB
  res  5,(ix),h      ; DD CB 00 AC
  res  5,(ix),l      ; DD CB 00 AD
  res  5,(ix+DIS)    ; DD CB DIS AE
  res  5,(ix+DIS),a  ; DD CB DIS AF
  res  5,(ix+DIS),b  ; DD CB DIS A8
  res  5,(ix+DIS),c  ; DD CB DIS A9
  res  5,(ix+DIS),d  ; DD CB DIS AA
  res  5,(ix+DIS),e  ; DD CB DIS AB
  res  5,(ix+DIS),h  ; DD CB DIS AC
  res  5,(ix+DIS),l  ; DD CB DIS AD
  res  5,(ix-NDIS)   ; DD CB NDIS AE
  res  5,(ix-NDIS),a ; DD CB NDIS AF
  res  5,(ix-NDIS),b ; DD CB NDIS A8
  res  5,(ix-NDIS),c ; DD CB NDIS A9
  res  5,(ix-NDIS),d ; DD CB NDIS AA
  res  5,(ix-NDIS),e ; DD CB NDIS AB
  res  5,(ix-NDIS),h ; DD CB NDIS AC
  res  5,(ix-NDIS),l ; DD CB NDIS AD
  res  5,(iy)        ; FD CB 00 AE
  res  5,(iy),a      ; FD CB 00 AF
  res  5,(iy),b      ; FD CB 00 A8
  res  5,(iy),c      ; FD CB 00 A9
  res  5,(iy),d      ; FD CB 00 AA
  res  5,(iy),e      ; FD CB 00 AB
  res  5,(iy),h      ; FD CB 00 AC
  res  5,(iy),l      ; FD CB 00 AD
  res  5,(iy+DIS)    ; FD CB DIS AE
  res  5,(iy+DIS),a  ; FD CB DIS AF
  res  5,(iy+DIS),b  ; FD CB DIS A8
  res  5,(iy+DIS),c  ; FD CB DIS A9
  res  5,(iy+DIS),d  ; FD CB DIS AA
  res  5,(iy+DIS),e  ; FD CB DIS AB
  res  5,(iy+DIS),h  ; FD CB DIS AC
  res  5,(iy+DIS),l  ; FD CB DIS AD
  res  5,(iy-NDIS)   ; FD CB NDIS AE
  res  5,(iy-NDIS),a ; FD CB NDIS AF
  res  5,(iy-NDIS),b ; FD CB NDIS A8
  res  5,(iy-NDIS),c ; FD CB NDIS A9
  res  5,(iy-NDIS),d ; FD CB NDIS AA
  res  5,(iy-NDIS),e ; FD CB NDIS AB
  res  5,(iy-NDIS),h ; FD CB NDIS AC
  res  5,(iy-NDIS),l ; FD CB NDIS AD
  res  5,a           ; CB AF
  res  5,b           ; CB A8
  res  5,c           ; CB A9
  res  5,d           ; CB AA
  res  5,e           ; CB AB
  res  5,h           ; CB AC
  res  5,l           ; CB AD
  res  6,(hl)        ; CB B6
  res  6,(ix)        ; DD CB 00 B6
  res  6,(ix),a      ; DD CB 00 B7
  res  6,(ix),b      ; DD CB 00 B0
  res  6,(ix),c      ; DD CB 00 B1
  res  6,(ix),d      ; DD CB 00 B2
  res  6,(ix),e      ; DD CB 00 B3
  res  6,(ix),h      ; DD CB 00 B4
  res  6,(ix),l      ; DD CB 00 B5
  res  6,(ix+DIS)    ; DD CB DIS B6
  res  6,(ix+DIS),a  ; DD CB DIS B7
  res  6,(ix+DIS),b  ; DD CB DIS B0
  res  6,(ix+DIS),c  ; DD CB DIS B1
  res  6,(ix+DIS),d  ; DD CB DIS B2
  res  6,(ix+DIS),e  ; DD CB DIS B3
  res  6,(ix+DIS),h  ; DD CB DIS B4
  res  6,(ix+DIS),l  ; DD CB DIS B5
  res  6,(ix-NDIS)   ; DD CB NDIS B6
  res  6,(ix-NDIS),a ; DD CB NDIS B7
  res  6,(ix-NDIS),b ; DD CB NDIS B0
  res  6,(ix-NDIS),c ; DD CB NDIS B1
  res  6,(ix-NDIS),d ; DD CB NDIS B2
  res  6,(ix-NDIS),e ; DD CB NDIS B3
  res  6,(ix-NDIS),h ; DD CB NDIS B4
  res  6,(ix-NDIS),l ; DD CB NDIS B5
  res  6,(iy)        ; FD CB 00 B6
  res  6,(iy),a      ; FD CB 00 B7
  res  6,(iy),b      ; FD CB 00 B0
  res  6,(iy),c      ; FD CB 00 B1
  res  6,(iy),d      ; FD CB 00 B2
  res  6,(iy),e      ; FD CB 00 B3
  res  6,(iy),h      ; FD CB 00 B4
  res  6,(iy),l      ; FD CB 00 B5
  res  6,(iy+DIS)    ; FD CB DIS B6
  res  6,(iy+DIS),a  ; FD CB DIS B7
  res  6,(iy+DIS),b  ; FD CB DIS B0
  res  6,(iy+DIS),c  ; FD CB DIS B1
  res  6,(iy+DIS),d  ; FD CB DIS B2
  res  6,(iy+DIS),e  ; FD CB DIS B3
  res  6,(iy+DIS),h  ; FD CB DIS B4
  res  6,(iy+DIS),l  ; FD CB DIS B5
  res  6,(iy-NDIS)   ; FD CB NDIS B6
  res  6,(iy-NDIS),a ; FD CB NDIS B7
  res  6,(iy-NDIS),b ; FD CB NDIS B0
  res  6,(iy-NDIS),c ; FD CB NDIS B1
  res  6,(iy-NDIS),d ; FD CB NDIS B2
  res  6,(iy-NDIS),e ; FD CB NDIS B3
  res  6,(iy-NDIS),h ; FD CB NDIS B4
  res  6,(iy-NDIS),l ; FD CB NDIS B5
  res  6,a           ; CB B7
  res  6,b           ; CB B0
  res  6,c           ; CB B1
  res  6,d           ; CB B2
  res  6,e           ; CB B3
  res  6,h           ; CB B4
  res  6,l           ; CB B5
  res  7,(hl)        ; CB BE
  res  7,(ix)        ; DD CB 00 BE
  res  7,(ix),a      ; DD CB 00 BF
  res  7,(ix),b      ; DD CB 00 B8
  res  7,(ix),c      ; DD CB 00 B9
  res  7,(ix),d      ; DD CB 00 BA
  res  7,(ix),e      ; DD CB 00 BB
  res  7,(ix),h      ; DD CB 00 BC
  res  7,(ix),l      ; DD CB 00 BD
  res  7,(ix+DIS)    ; DD CB DIS BE
  res  7,(ix+DIS),a  ; DD CB DIS BF
  res  7,(ix+DIS),b  ; DD CB DIS B8
  res  7,(ix+DIS),c  ; DD CB DIS B9
  res  7,(ix+DIS),d  ; DD CB DIS BA
  res  7,(ix+DIS),e  ; DD CB DIS BB
  res  7,(ix+DIS),h  ; DD CB DIS BC
  res  7,(ix+DIS),l  ; DD CB DIS BD
  res  7,(ix-NDIS)   ; DD CB NDIS BE
  res  7,(ix-NDIS),a ; DD CB NDIS BF
  res  7,(ix-NDIS),b ; DD CB NDIS B8
  res  7,(ix-NDIS),c ; DD CB NDIS B9
  res  7,(ix-NDIS),d ; DD CB NDIS BA
  res  7,(ix-NDIS),e ; DD CB NDIS BB
  res  7,(ix-NDIS),h ; DD CB NDIS BC
  res  7,(ix-NDIS),l ; DD CB NDIS BD
  res  7,(iy)        ; FD CB 00 BE
  res  7,(iy),a      ; FD CB 00 BF
  res  7,(iy),b      ; FD CB 00 B8
  res  7,(iy),c      ; FD CB 00 B9
  res  7,(iy),d      ; FD CB 00 BA
  res  7,(iy),e      ; FD CB 00 BB
  res  7,(iy),h      ; FD CB 00 BC
  res  7,(iy),l      ; FD CB 00 BD
  res  7,(iy+DIS)    ; FD CB DIS BE
  res  7,(iy+DIS),a  ; FD CB DIS BF
  res  7,(iy+DIS),b  ; FD CB DIS B8
  res  7,(iy+DIS),c  ; FD CB DIS B9
  res  7,(iy+DIS),d  ; FD CB DIS BA
  res  7,(iy+DIS),e  ; FD CB DIS BB
  res  7,(iy+DIS),h  ; FD CB DIS BC
  res  7,(iy+DIS),l  ; FD CB DIS BD
  res  7,(iy-NDIS)   ; FD CB NDIS BE
  res  7,(iy-NDIS),a ; FD CB NDIS BF
  res  7,(iy-NDIS),b ; FD CB NDIS B8
  res  7,(iy-NDIS),c ; FD CB NDIS B9
  res  7,(iy-NDIS),d ; FD CB NDIS BA
  res  7,(iy-NDIS),e ; FD CB NDIS BB
  res  7,(iy-NDIS),h ; FD CB NDIS BC
  res  7,(iy-NDIS),l ; FD CB NDIS BD
  res  7,a           ; CB BF
  res  7,b           ; CB B8
  res  7,c           ; CB B9
  res  7,d           ; CB BA
  res  7,e           ; CB BB
  res  7,h           ; CB BC
  res  7,l           ; CB BD
  ret                ; C9
  ret  c             ; D8
  ret  m             ; F8
  ret  nc            ; D0
  ret  nz            ; C0
  ret  p             ; F0
  ret  pe            ; E8
  ret  po            ; E0
  ret  z             ; C8
  reti               ; ED 4D
  retn               ; ED 45
  rl   (hl)          ; CB 16
  rl   (ix)          ; DD CB 00 16
  rl   (ix),a        ; DD CB 00 17
  rl   (ix),b        ; DD CB 00 10
  rl   (ix),c        ; DD CB 00 11
  rl   (ix),d        ; DD CB 00 12
  rl   (ix),e        ; DD CB 00 13
  rl   (ix),h        ; DD CB 00 14
  rl   (ix),l        ; DD CB 00 15
  rl   (ix+DIS)      ; DD CB DIS 16
  rl   (ix+DIS),a    ; DD CB DIS 17
  rl   (ix+DIS),b    ; DD CB DIS 10
  rl   (ix+DIS),c    ; DD CB DIS 11
  rl   (ix+DIS),d    ; DD CB DIS 12
  rl   (ix+DIS),e    ; DD CB DIS 13
  rl   (ix+DIS),h    ; DD CB DIS 14
  rl   (ix+DIS),l    ; DD CB DIS 15
  rl   (ix-NDIS)     ; DD CB NDIS 16
  rl   (ix-NDIS),a   ; DD CB NDIS 17
  rl   (ix-NDIS),b   ; DD CB NDIS 10
  rl   (ix-NDIS),c   ; DD CB NDIS 11
  rl   (ix-NDIS),d   ; DD CB NDIS 12
  rl   (ix-NDIS),e   ; DD CB NDIS 13
  rl   (ix-NDIS),h   ; DD CB NDIS 14
  rl   (ix-NDIS),l   ; DD CB NDIS 15
  rl   (iy)          ; FD CB 00 16
  rl   (iy),a        ; FD CB 00 17
  rl   (iy),b        ; FD CB 00 10
  rl   (iy),c        ; FD CB 00 11
  rl   (iy),d        ; FD CB 00 12
  rl   (iy),e        ; FD CB 00 13
  rl   (iy),h        ; FD CB 00 14
  rl   (iy),l        ; FD CB 00 15
  rl   (iy+DIS)      ; FD CB DIS 16
  rl   (iy+DIS),a    ; FD CB DIS 17
  rl   (iy+DIS),b    ; FD CB DIS 10
  rl   (iy+DIS),c    ; FD CB DIS 11
  rl   (iy+DIS),d    ; FD CB DIS 12
  rl   (iy+DIS),e    ; FD CB DIS 13
  rl   (iy+DIS),h    ; FD CB DIS 14
  rl   (iy+DIS),l    ; FD CB DIS 15
  rl   (iy-NDIS)     ; FD CB NDIS 16
  rl   (iy-NDIS),a   ; FD CB NDIS 17
  rl   (iy-NDIS),b   ; FD CB NDIS 10
  rl   (iy-NDIS),c   ; FD CB NDIS 11
  rl   (iy-NDIS),d   ; FD CB NDIS 12
  rl   (iy-NDIS),e   ; FD CB NDIS 13
  rl   (iy-NDIS),h   ; FD CB NDIS 14
  rl   (iy-NDIS),l   ; FD CB NDIS 15
  rl   a             ; CB 17
  rl   b             ; CB 10
  rl   bc            ; CB 11 CB 10
  rl   c             ; CB 11
  rl   d             ; CB 12
  rl   de            ; CB 13 CB 12
  rl   e             ; CB 13
  rl   h             ; CB 14
  rl   hl            ; CB 15 CB 14
  rl   l             ; CB 15
  rla                ; 17
  rlc  (hl)          ; CB 06
  rlc  (ix)          ; DD CB 00 06
  rlc  (ix),a        ; DD CB 00 07
  rlc  (ix),b        ; DD CB 00 00
  rlc  (ix),c        ; DD CB 00 01
  rlc  (ix),d        ; DD CB 00 02
  rlc  (ix),e        ; DD CB 00 03
  rlc  (ix),h        ; DD CB 00 04
  rlc  (ix),l        ; DD CB 00 05
  rlc  (ix+DIS)      ; DD CB DIS 06
  rlc  (ix+DIS),a    ; DD CB DIS 07
  rlc  (ix+DIS),b    ; DD CB DIS 00
  rlc  (ix+DIS),c    ; DD CB DIS 01
  rlc  (ix+DIS),d    ; DD CB DIS 02
  rlc  (ix+DIS),e    ; DD CB DIS 03
  rlc  (ix+DIS),h    ; DD CB DIS 04
  rlc  (ix+DIS),l    ; DD CB DIS 05
  rlc  (ix-NDIS)     ; DD CB NDIS 06
  rlc  (ix-NDIS),a   ; DD CB NDIS 07
  rlc  (ix-NDIS),b   ; DD CB NDIS 00
  rlc  (ix-NDIS),c   ; DD CB NDIS 01
  rlc  (ix-NDIS),d   ; DD CB NDIS 02
  rlc  (ix-NDIS),e   ; DD CB NDIS 03
  rlc  (ix-NDIS),h   ; DD CB NDIS 04
  rlc  (ix-NDIS),l   ; DD CB NDIS 05
  rlc  (iy)          ; FD CB 00 06
  rlc  (iy),a        ; FD CB 00 07
  rlc  (iy),b        ; FD CB 00 00
  rlc  (iy),c        ; FD CB 00 01
  rlc  (iy),d        ; FD CB 00 02
  rlc  (iy),e        ; FD CB 00 03
  rlc  (iy),h        ; FD CB 00 04
  rlc  (iy),l        ; FD CB 00 05
  rlc  (iy+DIS)      ; FD CB DIS 06
  rlc  (iy+DIS),a    ; FD CB DIS 07
  rlc  (iy+DIS),b    ; FD CB DIS 00
  rlc  (iy+DIS),c    ; FD CB DIS 01
  rlc  (iy+DIS),d    ; FD CB DIS 02
  rlc  (iy+DIS),e    ; FD CB DIS 03
  rlc  (iy+DIS),h    ; FD CB DIS 04
  rlc  (iy+DIS),l    ; FD CB DIS 05
  rlc  (iy-NDIS)     ; FD CB NDIS 06
  rlc  (iy-NDIS),a   ; FD CB NDIS 07
  rlc  (iy-NDIS),b   ; FD CB NDIS 00
  rlc  (iy-NDIS),c   ; FD CB NDIS 01
  rlc  (iy-NDIS),d   ; FD CB NDIS 02
  rlc  (iy-NDIS),e   ; FD CB NDIS 03
  rlc  (iy-NDIS),h   ; FD CB NDIS 04
  rlc  (iy-NDIS),l   ; FD CB NDIS 05
  rlc  a             ; CB 07
  rlc  b             ; CB 00
  rlc  c             ; CB 01
  rlc  d             ; CB 02
  rlc  e             ; CB 03
  rlc  h             ; CB 04
  rlc  l             ; CB 05
  rlca               ; 07
  rld                ; ED 6F
  rr   (hl)          ; CB 1E
  rr   (ix)          ; DD CB 00 1E
  rr   (ix),a        ; DD CB 00 1F
  rr   (ix),b        ; DD CB 00 18
  rr   (ix),c        ; DD CB 00 19
  rr   (ix),d        ; DD CB 00 1A
  rr   (ix),e        ; DD CB 00 1B
  rr   (ix),h        ; DD CB 00 1C
  rr   (ix),l        ; DD CB 00 1D
  rr   (ix+DIS)      ; DD CB DIS 1E
  rr   (ix+DIS),a    ; DD CB DIS 1F
  rr   (ix+DIS),b    ; DD CB DIS 18
  rr   (ix+DIS),c    ; DD CB DIS 19
  rr   (ix+DIS),d    ; DD CB DIS 1A
  rr   (ix+DIS),e    ; DD CB DIS 1B
  rr   (ix+DIS),h    ; DD CB DIS 1C
  rr   (ix+DIS),l    ; DD CB DIS 1D
  rr   (ix-NDIS)     ; DD CB NDIS 1E
  rr   (ix-NDIS),a   ; DD CB NDIS 1F
  rr   (ix-NDIS),b   ; DD CB NDIS 18
  rr   (ix-NDIS),c   ; DD CB NDIS 19
  rr   (ix-NDIS),d   ; DD CB NDIS 1A
  rr   (ix-NDIS),e   ; DD CB NDIS 1B
  rr   (ix-NDIS),h   ; DD CB NDIS 1C
  rr   (ix-NDIS),l   ; DD CB NDIS 1D
  rr   (iy)          ; FD CB 00 1E
  rr   (iy),a        ; FD CB 00 1F
  rr   (iy),b        ; FD CB 00 18
  rr   (iy),c        ; FD CB 00 19
  rr   (iy),d        ; FD CB 00 1A
  rr   (iy),e        ; FD CB 00 1B
  rr   (iy),h        ; FD CB 00 1C
  rr   (iy),l        ; FD CB 00 1D
  rr   (iy+DIS)      ; FD CB DIS 1E
  rr   (iy+DIS),a    ; FD CB DIS 1F
  rr   (iy+DIS),b    ; FD CB DIS 18
  rr   (iy+DIS),c    ; FD CB DIS 19
  rr   (iy+DIS),d    ; FD CB DIS 1A
  rr   (iy+DIS),e    ; FD CB DIS 1B
  rr   (iy+DIS),h    ; FD CB DIS 1C
  rr   (iy+DIS),l    ; FD CB DIS 1D
  rr   (iy-NDIS)     ; FD CB NDIS 1E
  rr   (iy-NDIS),a   ; FD CB NDIS 1F
  rr   (iy-NDIS),b   ; FD CB NDIS 18
  rr   (iy-NDIS),c   ; FD CB NDIS 19
  rr   (iy-NDIS),d   ; FD CB NDIS 1A
  rr   (iy-NDIS),e   ; FD CB NDIS 1B
  rr   (iy-NDIS),h   ; FD CB NDIS 1C
  rr   (iy-NDIS),l   ; FD CB NDIS 1D
  rr   a             ; CB 1F
  rr   b             ; CB 18
  rr   bc            ; CB 18 CB 19
  rr   c             ; CB 19
  rr   d             ; CB 1A
  rr   de            ; CB 1A CB 1B
  rr   e             ; CB 1B
  rr   h             ; CB 1C
  rr   hl            ; CB 1C CB 1D
  rr   l             ; CB 1D
  rra                ; 1F
  rrc  (hl)          ; CB 0E
  rrc  (ix)          ; DD CB 00 0E
  rrc  (ix),a        ; DD CB 00 0F
  rrc  (ix),b        ; DD CB 00 08
  rrc  (ix),c        ; DD CB 00 09
  rrc  (ix),d        ; DD CB 00 0A
  rrc  (ix),e        ; DD CB 00 0B
  rrc  (ix),h        ; DD CB 00 0C
  rrc  (ix),l        ; DD CB 00 0D
  rrc  (ix+DIS)      ; DD CB DIS 0E
  rrc  (ix+DIS),a    ; DD CB DIS 0F
  rrc  (ix+DIS),b    ; DD CB DIS 08
  rrc  (ix+DIS),c    ; DD CB DIS 09
  rrc  (ix+DIS),d    ; DD CB DIS 0A
  rrc  (ix+DIS),e    ; DD CB DIS 0B
  rrc  (ix+DIS),h    ; DD CB DIS 0C
  rrc  (ix+DIS),l    ; DD CB DIS 0D
  rrc  (ix-NDIS)     ; DD CB NDIS 0E
  rrc  (ix-NDIS),a   ; DD CB NDIS 0F
  rrc  (ix-NDIS),b   ; DD CB NDIS 08
  rrc  (ix-NDIS),c   ; DD CB NDIS 09
  rrc  (ix-NDIS),d   ; DD CB NDIS 0A
  rrc  (ix-NDIS),e   ; DD CB NDIS 0B
  rrc  (ix-NDIS),h   ; DD CB NDIS 0C
  rrc  (ix-NDIS),l   ; DD CB NDIS 0D
  rrc  (iy)          ; FD CB 00 0E
  rrc  (iy),a        ; FD CB 00 0F
  rrc  (iy),b        ; FD CB 00 08
  rrc  (iy),c        ; FD CB 00 09
  rrc  (iy),d        ; FD CB 00 0A
  rrc  (iy),e        ; FD CB 00 0B
  rrc  (iy),h        ; FD CB 00 0C
  rrc  (iy),l        ; FD CB 00 0D
  rrc  (iy+DIS)      ; FD CB DIS 0E
  rrc  (iy+DIS),a    ; FD CB DIS 0F
  rrc  (iy+DIS),b    ; FD CB DIS 08
  rrc  (iy+DIS),c    ; FD CB DIS 09
  rrc  (iy+DIS),d    ; FD CB DIS 0A
  rrc  (iy+DIS),e    ; FD CB DIS 0B
  rrc  (iy+DIS),h    ; FD CB DIS 0C
  rrc  (iy+DIS),l    ; FD CB DIS 0D
  rrc  (iy-NDIS)     ; FD CB NDIS 0E
  rrc  (iy-NDIS),a   ; FD CB NDIS 0F
  rrc  (iy-NDIS),b   ; FD CB NDIS 08
  rrc  (iy-NDIS),c   ; FD CB NDIS 09
  rrc  (iy-NDIS),d   ; FD CB NDIS 0A
  rrc  (iy-NDIS),e   ; FD CB NDIS 0B
  rrc  (iy-NDIS),h   ; FD CB NDIS 0C
  rrc  (iy-NDIS),l   ; FD CB NDIS 0D
  rrc  a             ; CB 0F
  rrc  b             ; CB 08
  rrc  c             ; CB 09
  rrc  d             ; CB 0A
  rrc  e             ; CB 0B
  rrc  h             ; CB 0C
  rrc  l             ; CB 0D
  rrca               ; 0F
  rrd                ; ED 67
  rst  0             ; C7
  rst  16            ; D7
  rst  24            ; DF
  rst  32            ; E7
  rst  40            ; EF
  rst  48            ; F7
  rst  56            ; FF
  rst  8             ; CF
  sbc  a,(hl)        ; 9E
  sbc  a,(ix)        ; DD 9E 00
  sbc  a,(ix+DIS)    ; DD 9E DIS
  sbc  a,(ix-NDIS)   ; DD 9E NDIS
  sbc  a,(iy)        ; FD 9E 00
  sbc  a,(iy+DIS)    ; FD 9E DIS
  sbc  a,(iy-NDIS)   ; FD 9E NDIS
  sbc  a,N           ; DE N
  sbc  a,a           ; 9F
  sbc  a,b           ; 98
  sbc  a,c           ; 99
  sbc  a,d           ; 9A
  sbc  a,e           ; 9B
  sbc  a,h           ; 9C
  sbc  a,ixh         ; DD 9C
  sbc  a,ixl         ; DD 9D
  sbc  a,iyh         ; FD 9C
  sbc  a,iyl         ; FD 9D
  sbc  a,l           ; 9D
  sbc  hl,bc         ; ED 42
  sbc  hl,de         ; ED 52
  sbc  hl,hl         ; ED 62
  sbc  hl,sp         ; ED 72
  scf                ; 37
  set  0,(hl)        ; CB C6
  set  0,(ix)        ; DD CB 00 C6
  set  0,(ix),a      ; DD CB 00 C7
  set  0,(ix),b      ; DD CB 00 C0
  set  0,(ix),c      ; DD CB 00 C1
  set  0,(ix),d      ; DD CB 00 C2
  set  0,(ix),e      ; DD CB 00 C3
  set  0,(ix),h      ; DD CB 00 C4
  set  0,(ix),l      ; DD CB 00 C5
  set  0,(ix+DIS)    ; DD CB DIS C6
  set  0,(ix+DIS),a  ; DD CB DIS C7
  set  0,(ix+DIS),b  ; DD CB DIS C0
  set  0,(ix+DIS),c  ; DD CB DIS C1
  set  0,(ix+DIS),d  ; DD CB DIS C2
  set  0,(ix+DIS),e  ; DD CB DIS C3
  set  0,(ix+DIS),h  ; DD CB DIS C4
  set  0,(ix+DIS),l  ; DD CB DIS C5
  set  0,(ix-NDIS)   ; DD CB NDIS C6
  set  0,(ix-NDIS),a ; DD CB NDIS C7
  set  0,(ix-NDIS),b ; DD CB NDIS C0
  set  0,(ix-NDIS),c ; DD CB NDIS C1
  set  0,(ix-NDIS),d ; DD CB NDIS C2
  set  0,(ix-NDIS),e ; DD CB NDIS C3
  set  0,(ix-NDIS),h ; DD CB NDIS C4
  set  0,(ix-NDIS),l ; DD CB NDIS C5
  set  0,(iy)        ; FD CB 00 C6
  set  0,(iy),a      ; FD CB 00 C7
  set  0,(iy),b      ; FD CB 00 C0
  set  0,(iy),c      ; FD CB 00 C1
  set  0,(iy),d      ; FD CB 00 C2
  set  0,(iy),e      ; FD CB 00 C3
  set  0,(iy),h      ; FD CB 00 C4
  set  0,(iy),l      ; FD CB 00 C5
  set  0,(iy+DIS)    ; FD CB DIS C6
  set  0,(iy+DIS),a  ; FD CB DIS C7
  set  0,(iy+DIS),b  ; FD CB DIS C0
  set  0,(iy+DIS),c  ; FD CB DIS C1
  set  0,(iy+DIS),d  ; FD CB DIS C2
  set  0,(iy+DIS),e  ; FD CB DIS C3
  set  0,(iy+DIS),h  ; FD CB DIS C4
  set  0,(iy+DIS),l  ; FD CB DIS C5
  set  0,(iy-NDIS)   ; FD CB NDIS C6
  set  0,(iy-NDIS),a ; FD CB NDIS C7
  set  0,(iy-NDIS),b ; FD CB NDIS C0
  set  0,(iy-NDIS),c ; FD CB NDIS C1
  set  0,(iy-NDIS),d ; FD CB NDIS C2
  set  0,(iy-NDIS),e ; FD CB NDIS C3
  set  0,(iy-NDIS),h ; FD CB NDIS C4
  set  0,(iy-NDIS),l ; FD CB NDIS C5
  set  0,a           ; CB C7
  set  0,b           ; CB C0
  set  0,c           ; CB C1
  set  0,d           ; CB C2
  set  0,e           ; CB C3
  set  0,h           ; CB C4
  set  0,l           ; CB C5
  set  1,(hl)        ; CB CE
  set  1,(ix)        ; DD CB 00 CE
  set  1,(ix),a      ; DD CB 00 CF
  set  1,(ix),b      ; DD CB 00 C8
  set  1,(ix),c      ; DD CB 00 C9
  set  1,(ix),d      ; DD CB 00 CA
  set  1,(ix),e      ; DD CB 00 CB
  set  1,(ix),h      ; DD CB 00 CC
  set  1,(ix),l      ; DD CB 00 CD
  set  1,(ix+DIS)    ; DD CB DIS CE
  set  1,(ix+DIS),a  ; DD CB DIS CF
  set  1,(ix+DIS),b  ; DD CB DIS C8
  set  1,(ix+DIS),c  ; DD CB DIS C9
  set  1,(ix+DIS),d  ; DD CB DIS CA
  set  1,(ix+DIS),e  ; DD CB DIS CB
  set  1,(ix+DIS),h  ; DD CB DIS CC
  set  1,(ix+DIS),l  ; DD CB DIS CD
  set  1,(ix-NDIS)   ; DD CB NDIS CE
  set  1,(ix-NDIS),a ; DD CB NDIS CF
  set  1,(ix-NDIS),b ; DD CB NDIS C8
  set  1,(ix-NDIS),c ; DD CB NDIS C9
  set  1,(ix-NDIS),d ; DD CB NDIS CA
  set  1,(ix-NDIS),e ; DD CB NDIS CB
  set  1,(ix-NDIS),h ; DD CB NDIS CC
  set  1,(ix-NDIS),l ; DD CB NDIS CD
  set  1,(iy)        ; FD CB 00 CE
  set  1,(iy),a      ; FD CB 00 CF
  set  1,(iy),b      ; FD CB 00 C8
  set  1,(iy),c      ; FD CB 00 C9
  set  1,(iy),d      ; FD CB 00 CA
  set  1,(iy),e      ; FD CB 00 CB
  set  1,(iy),h      ; FD CB 00 CC
  set  1,(iy),l      ; FD CB 00 CD
  set  1,(iy+DIS)    ; FD CB DIS CE
  set  1,(iy+DIS),a  ; FD CB DIS CF
  set  1,(iy+DIS),b  ; FD CB DIS C8
  set  1,(iy+DIS),c  ; FD CB DIS C9
  set  1,(iy+DIS),d  ; FD CB DIS CA
  set  1,(iy+DIS),e  ; FD CB DIS CB
  set  1,(iy+DIS),h  ; FD CB DIS CC
  set  1,(iy+DIS),l  ; FD CB DIS CD
  set  1,(iy-NDIS)   ; FD CB NDIS CE
  set  1,(iy-NDIS),a ; FD CB NDIS CF
  set  1,(iy-NDIS),b ; FD CB NDIS C8
  set  1,(iy-NDIS),c ; FD CB NDIS C9
  set  1,(iy-NDIS),d ; FD CB NDIS CA
  set  1,(iy-NDIS),e ; FD CB NDIS CB
  set  1,(iy-NDIS),h ; FD CB NDIS CC
  set  1,(iy-NDIS),l ; FD CB NDIS CD
  set  1,a           ; CB CF
  set  1,b           ; CB C8
  set  1,c           ; CB C9
  set  1,d           ; CB CA
  set  1,e           ; CB CB
  set  1,h           ; CB CC
  set  1,l           ; CB CD
  set  2,(hl)        ; CB D6
  set  2,(ix)        ; DD CB 00 D6
  set  2,(ix),a      ; DD CB 00 D7
  set  2,(ix),b      ; DD CB 00 D0
  set  2,(ix),c      ; DD CB 00 D1
  set  2,(ix),d      ; DD CB 00 D2
  set  2,(ix),e      ; DD CB 00 D3
  set  2,(ix),h      ; DD CB 00 D4
  set  2,(ix),l      ; DD CB 00 D5
  set  2,(ix+DIS)    ; DD CB DIS D6
  set  2,(ix+DIS),a  ; DD CB DIS D7
  set  2,(ix+DIS),b  ; DD CB DIS D0
  set  2,(ix+DIS),c  ; DD CB DIS D1
  set  2,(ix+DIS),d  ; DD CB DIS D2
  set  2,(ix+DIS),e  ; DD CB DIS D3
  set  2,(ix+DIS),h  ; DD CB DIS D4
  set  2,(ix+DIS),l  ; DD CB DIS D5
  set  2,(ix-NDIS)   ; DD CB NDIS D6
  set  2,(ix-NDIS),a ; DD CB NDIS D7
  set  2,(ix-NDIS),b ; DD CB NDIS D0
  set  2,(ix-NDIS),c ; DD CB NDIS D1
  set  2,(ix-NDIS),d ; DD CB NDIS D2
  set  2,(ix-NDIS),e ; DD CB NDIS D3
  set  2,(ix-NDIS),h ; DD CB NDIS D4
  set  2,(ix-NDIS),l ; DD CB NDIS D5
  set  2,(iy)        ; FD CB 00 D6
  set  2,(iy),a      ; FD CB 00 D7
  set  2,(iy),b      ; FD CB 00 D0
  set  2,(iy),c      ; FD CB 00 D1
  set  2,(iy),d      ; FD CB 00 D2
  set  2,(iy),e      ; FD CB 00 D3
  set  2,(iy),h      ; FD CB 00 D4
  set  2,(iy),l      ; FD CB 00 D5
  set  2,(iy+DIS)    ; FD CB DIS D6
  set  2,(iy+DIS),a  ; FD CB DIS D7
  set  2,(iy+DIS),b  ; FD CB DIS D0
  set  2,(iy+DIS),c  ; FD CB DIS D1
  set  2,(iy+DIS),d  ; FD CB DIS D2
  set  2,(iy+DIS),e  ; FD CB DIS D3
  set  2,(iy+DIS),h  ; FD CB DIS D4
  set  2,(iy+DIS),l  ; FD CB DIS D5
  set  2,(iy-NDIS)   ; FD CB NDIS D6
  set  2,(iy-NDIS),a ; FD CB NDIS D7
  set  2,(iy-NDIS),b ; FD CB NDIS D0
  set  2,(iy-NDIS),c ; FD CB NDIS D1
  set  2,(iy-NDIS),d ; FD CB NDIS D2
  set  2,(iy-NDIS),e ; FD CB NDIS D3
  set  2,(iy-NDIS),h ; FD CB NDIS D4
  set  2,(iy-NDIS),l ; FD CB NDIS D5
  set  2,a           ; CB D7
  set  2,b           ; CB D0
  set  2,c           ; CB D1
  set  2,d           ; CB D2
  set  2,e           ; CB D3
  set  2,h           ; CB D4
  set  2,l           ; CB D5
  set  3,(hl)        ; CB DE
  set  3,(ix)        ; DD CB 00 DE
  set  3,(ix),a      ; DD CB 00 DF
  set  3,(ix),b      ; DD CB 00 D8
  set  3,(ix),c      ; DD CB 00 D9
  set  3,(ix),d      ; DD CB 00 DA
  set  3,(ix),e      ; DD CB 00 DB
  set  3,(ix),h      ; DD CB 00 DC
  set  3,(ix),l      ; DD CB 00 DD
  set  3,(ix+DIS)    ; DD CB DIS DE
  set  3,(ix+DIS),a  ; DD CB DIS DF
  set  3,(ix+DIS),b  ; DD CB DIS D8
  set  3,(ix+DIS),c  ; DD CB DIS D9
  set  3,(ix+DIS),d  ; DD CB DIS DA
  set  3,(ix+DIS),e  ; DD CB DIS DB
  set  3,(ix+DIS),h  ; DD CB DIS DC
  set  3,(ix+DIS),l  ; DD CB DIS DD
  set  3,(ix-NDIS)   ; DD CB NDIS DE
  set  3,(ix-NDIS),a ; DD CB NDIS DF
  set  3,(ix-NDIS),b ; DD CB NDIS D8
  set  3,(ix-NDIS),c ; DD CB NDIS D9
  set  3,(ix-NDIS),d ; DD CB NDIS DA
  set  3,(ix-NDIS),e ; DD CB NDIS DB
  set  3,(ix-NDIS),h ; DD CB NDIS DC
  set  3,(ix-NDIS),l ; DD CB NDIS DD
  set  3,(iy)        ; FD CB 00 DE
  set  3,(iy),a      ; FD CB 00 DF
  set  3,(iy),b      ; FD CB 00 D8
  set  3,(iy),c      ; FD CB 00 D9
  set  3,(iy),d      ; FD CB 00 DA
  set  3,(iy),e      ; FD CB 00 DB
  set  3,(iy),h      ; FD CB 00 DC
  set  3,(iy),l      ; FD CB 00 DD
  set  3,(iy+DIS)    ; FD CB DIS DE
  set  3,(iy+DIS),a  ; FD CB DIS DF
  set  3,(iy+DIS),b  ; FD CB DIS D8
  set  3,(iy+DIS),c  ; FD CB DIS D9
  set  3,(iy+DIS),d  ; FD CB DIS DA
  set  3,(iy+DIS),e  ; FD CB DIS DB
  set  3,(iy+DIS),h  ; FD CB DIS DC
  set  3,(iy+DIS),l  ; FD CB DIS DD
  set  3,(iy-NDIS)   ; FD CB NDIS DE
  set  3,(iy-NDIS),a ; FD CB NDIS DF
  set  3,(iy-NDIS),b ; FD CB NDIS D8
  set  3,(iy-NDIS),c ; FD CB NDIS D9
  set  3,(iy-NDIS),d ; FD CB NDIS DA
  set  3,(iy-NDIS),e ; FD CB NDIS DB
  set  3,(iy-NDIS),h ; FD CB NDIS DC
  set  3,(iy-NDIS),l ; FD CB NDIS DD
  set  3,a           ; CB DF
  set  3,b           ; CB D8
  set  3,c           ; CB D9
  set  3,d           ; CB DA
  set  3,e           ; CB DB
  set  3,h           ; CB DC
  set  3,l           ; CB DD
  set  4,(hl)        ; CB E6
  set  4,(ix)        ; DD CB 00 E6
  set  4,(ix),a      ; DD CB 00 E7
  set  4,(ix),b      ; DD CB 00 E0
  set  4,(ix),c      ; DD CB 00 E1
  set  4,(ix),d      ; DD CB 00 E2
  set  4,(ix),e      ; DD CB 00 E3
  set  4,(ix),h      ; DD CB 00 E4
  set  4,(ix),l      ; DD CB 00 E5
  set  4,(ix+DIS)    ; DD CB DIS E6
  set  4,(ix+DIS),a  ; DD CB DIS E7
  set  4,(ix+DIS),b  ; DD CB DIS E0
  set  4,(ix+DIS),c  ; DD CB DIS E1
  set  4,(ix+DIS),d  ; DD CB DIS E2
  set  4,(ix+DIS),e  ; DD CB DIS E3
  set  4,(ix+DIS),h  ; DD CB DIS E4
  set  4,(ix+DIS),l  ; DD CB DIS E5
  set  4,(ix-NDIS)   ; DD CB NDIS E6
  set  4,(ix-NDIS),a ; DD CB NDIS E7
  set  4,(ix-NDIS),b ; DD CB NDIS E0
  set  4,(ix-NDIS),c ; DD CB NDIS E1
  set  4,(ix-NDIS),d ; DD CB NDIS E2
  set  4,(ix-NDIS),e ; DD CB NDIS E3
  set  4,(ix-NDIS),h ; DD CB NDIS E4
  set  4,(ix-NDIS),l ; DD CB NDIS E5
  set  4,(iy)        ; FD CB 00 E6
  set  4,(iy),a      ; FD CB 00 E7
  set  4,(iy),b      ; FD CB 00 E0
  set  4,(iy),c      ; FD CB 00 E1
  set  4,(iy),d      ; FD CB 00 E2
  set  4,(iy),e      ; FD CB 00 E3
  set  4,(iy),h      ; FD CB 00 E4
  set  4,(iy),l      ; FD CB 00 E5
  set  4,(iy+DIS)    ; FD CB DIS E6
  set  4,(iy+DIS),a  ; FD CB DIS E7
  set  4,(iy+DIS),b  ; FD CB DIS E0
  set  4,(iy+DIS),c  ; FD CB DIS E1
  set  4,(iy+DIS),d  ; FD CB DIS E2
  set  4,(iy+DIS),e  ; FD CB DIS E3
  set  4,(iy+DIS),h  ; FD CB DIS E4
  set  4,(iy+DIS),l  ; FD CB DIS E5
  set  4,(iy-NDIS)   ; FD CB NDIS E6
  set  4,(iy-NDIS),a ; FD CB NDIS E7
  set  4,(iy-NDIS),b ; FD CB NDIS E0
  set  4,(iy-NDIS),c ; FD CB NDIS E1
  set  4,(iy-NDIS),d ; FD CB NDIS E2
  set  4,(iy-NDIS),e ; FD CB NDIS E3
  set  4,(iy-NDIS),h ; FD CB NDIS E4
  set  4,(iy-NDIS),l ; FD CB NDIS E5
  set  4,a           ; CB E7
  set  4,b           ; CB E0
  set  4,c           ; CB E1
  set  4,d           ; CB E2
  set  4,e           ; CB E3
  set  4,h           ; CB E4
  set  4,l           ; CB E5
  set  5,(hl)        ; CB EE
  set  5,(ix)        ; DD CB 00 EE
  set  5,(ix),a      ; DD CB 00 EF
  set  5,(ix),b      ; DD CB 00 E8
  set  5,(ix),c      ; DD CB 00 E9
  set  5,(ix),d      ; DD CB 00 EA
  set  5,(ix),e      ; DD CB 00 EB
  set  5,(ix),h      ; DD CB 00 EC
  set  5,(ix),l      ; DD CB 00 ED
  set  5,(ix+DIS)    ; DD CB DIS EE
  set  5,(ix+DIS),a  ; DD CB DIS EF
  set  5,(ix+DIS),b  ; DD CB DIS E8
  set  5,(ix+DIS),c  ; DD CB DIS E9
  set  5,(ix+DIS),d  ; DD CB DIS EA
  set  5,(ix+DIS),e  ; DD CB DIS EB
  set  5,(ix+DIS),h  ; DD CB DIS EC
  set  5,(ix+DIS),l  ; DD CB DIS ED
  set  5,(ix-NDIS)   ; DD CB NDIS EE
  set  5,(ix-NDIS),a ; DD CB NDIS EF
  set  5,(ix-NDIS),b ; DD CB NDIS E8
  set  5,(ix-NDIS),c ; DD CB NDIS E9
  set  5,(ix-NDIS),d ; DD CB NDIS EA
  set  5,(ix-NDIS),e ; DD CB NDIS EB
  set  5,(ix-NDIS),h ; DD CB NDIS EC
  set  5,(ix-NDIS),l ; DD CB NDIS ED
  set  5,(iy)        ; FD CB 00 EE
  set  5,(iy),a      ; FD CB 00 EF
  set  5,(iy),b      ; FD CB 00 E8
  set  5,(iy),c      ; FD CB 00 E9
  set  5,(iy),d      ; FD CB 00 EA
  set  5,(iy),e      ; FD CB 00 EB
  set  5,(iy),h      ; FD CB 00 EC
  set  5,(iy),l      ; FD CB 00 ED
  set  5,(iy+DIS)    ; FD CB DIS EE
  set  5,(iy+DIS),a  ; FD CB DIS EF
  set  5,(iy+DIS),b  ; FD CB DIS E8
  set  5,(iy+DIS),c  ; FD CB DIS E9
  set  5,(iy+DIS),d  ; FD CB DIS EA
  set  5,(iy+DIS),e  ; FD CB DIS EB
  set  5,(iy+DIS),h  ; FD CB DIS EC
  set  5,(iy+DIS),l  ; FD CB DIS ED
  set  5,(iy-NDIS)   ; FD CB NDIS EE
  set  5,(iy-NDIS),a ; FD CB NDIS EF
  set  5,(iy-NDIS),b ; FD CB NDIS E8
  set  5,(iy-NDIS),c ; FD CB NDIS E9
  set  5,(iy-NDIS),d ; FD CB NDIS EA
  set  5,(iy-NDIS),e ; FD CB NDIS EB
  set  5,(iy-NDIS),h ; FD CB NDIS EC
  set  5,(iy-NDIS),l ; FD CB NDIS ED
  set  5,a           ; CB EF
  set  5,b           ; CB E8
  set  5,c           ; CB E9
  set  5,d           ; CB EA
  set  5,e           ; CB EB
  set  5,h           ; CB EC
  set  5,l           ; CB ED
  set  6,(hl)        ; CB F6
  set  6,(ix)        ; DD CB 00 F6
  set  6,(ix),a      ; DD CB 00 F7
  set  6,(ix),b      ; DD CB 00 F0
  set  6,(ix),c      ; DD CB 00 F1
  set  6,(ix),d      ; DD CB 00 F2
  set  6,(ix),e      ; DD CB 00 F3
  set  6,(ix),h      ; DD CB 00 F4
  set  6,(ix),l      ; DD CB 00 F5
  set  6,(ix+DIS)    ; DD CB DIS F6
  set  6,(ix+DIS),a  ; DD CB DIS F7
  set  6,(ix+DIS),b  ; DD CB DIS F0
  set  6,(ix+DIS),c  ; DD CB DIS F1
  set  6,(ix+DIS),d  ; DD CB DIS F2
  set  6,(ix+DIS),e  ; DD CB DIS F3
  set  6,(ix+DIS),h  ; DD CB DIS F4
  set  6,(ix+DIS),l  ; DD CB DIS F5
  set  6,(ix-NDIS)   ; DD CB NDIS F6
  set  6,(ix-NDIS),a ; DD CB NDIS F7
  set  6,(ix-NDIS),b ; DD CB NDIS F0
  set  6,(ix-NDIS),c ; DD CB NDIS F1
  set  6,(ix-NDIS),d ; DD CB NDIS F2
  set  6,(ix-NDIS),e ; DD CB NDIS F3
  set  6,(ix-NDIS),h ; DD CB NDIS F4
  set  6,(ix-NDIS),l ; DD CB NDIS F5
  set  6,(iy)        ; FD CB 00 F6
  set  6,(iy),a      ; FD CB 00 F7
  set  6,(iy),b      ; FD CB 00 F0
  set  6,(iy),c      ; FD CB 00 F1
  set  6,(iy),d      ; FD CB 00 F2
  set  6,(iy),e      ; FD CB 00 F3
  set  6,(iy),h      ; FD CB 00 F4
  set  6,(iy),l      ; FD CB 00 F5
  set  6,(iy+DIS)    ; FD CB DIS F6
  set  6,(iy+DIS),a  ; FD CB DIS F7
  set  6,(iy+DIS),b  ; FD CB DIS F0
  set  6,(iy+DIS),c  ; FD CB DIS F1
  set  6,(iy+DIS),d  ; FD CB DIS F2
  set  6,(iy+DIS),e  ; FD CB DIS F3
  set  6,(iy+DIS),h  ; FD CB DIS F4
  set  6,(iy+DIS),l  ; FD CB DIS F5
  set  6,(iy-NDIS)   ; FD CB NDIS F6
  set  6,(iy-NDIS),a ; FD CB NDIS F7
  set  6,(iy-NDIS),b ; FD CB NDIS F0
  set  6,(iy-NDIS),c ; FD CB NDIS F1
  set  6,(iy-NDIS),d ; FD CB NDIS F2
  set  6,(iy-NDIS),e ; FD CB NDIS F3
  set  6,(iy-NDIS),h ; FD CB NDIS F4
  set  6,(iy-NDIS),l ; FD CB NDIS F5
  set  6,a           ; CB F7
  set  6,b           ; CB F0
  set  6,c           ; CB F1
  set  6,d           ; CB F2
  set  6,e           ; CB F3
  set  6,h           ; CB F4
  set  6,l           ; CB F5
  set  7,(hl)        ; CB FE
  set  7,(ix)        ; DD CB 00 FE
  set  7,(ix),a      ; DD CB 00 FF
  set  7,(ix),b      ; DD CB 00 F8
  set  7,(ix),c      ; DD CB 00 F9
  set  7,(ix),d      ; DD CB 00 FA
  set  7,(ix),e      ; DD CB 00 FB
  set  7,(ix),h      ; DD CB 00 FC
  set  7,(ix),l      ; DD CB 00 FD
  set  7,(ix+DIS)    ; DD CB DIS FE
  set  7,(ix+DIS),a  ; DD CB DIS FF
  set  7,(ix+DIS),b  ; DD CB DIS F8
  set  7,(ix+DIS),c  ; DD CB DIS F9
  set  7,(ix+DIS),d  ; DD CB DIS FA
  set  7,(ix+DIS),e  ; DD CB DIS FB
  set  7,(ix+DIS),h  ; DD CB DIS FC
  set  7,(ix+DIS),l  ; DD CB DIS FD
  set  7,(ix-NDIS)   ; DD CB NDIS FE
  set  7,(ix-NDIS),a ; DD CB NDIS FF
  set  7,(ix-NDIS),b ; DD CB NDIS F8
  set  7,(ix-NDIS),c ; DD CB NDIS F9
  set  7,(ix-NDIS),d ; DD CB NDIS FA
  set  7,(ix-NDIS),e ; DD CB NDIS FB
  set  7,(ix-NDIS),h ; DD CB NDIS FC
  set  7,(ix-NDIS),l ; DD CB NDIS FD
  set  7,(iy)        ; FD CB 00 FE
  set  7,(iy),a      ; FD CB 00 FF
  set  7,(iy),b      ; FD CB 00 F8
  set  7,(iy),c      ; FD CB 00 F9
  set  7,(iy),d      ; FD CB 00 FA
  set  7,(iy),e      ; FD CB 00 FB
  set  7,(iy),h      ; FD CB 00 FC
  set  7,(iy),l      ; FD CB 00 FD
  set  7,(iy+DIS)    ; FD CB DIS FE
  set  7,(iy+DIS),a  ; FD CB DIS FF
  set  7,(iy+DIS),b  ; FD CB DIS F8
  set  7,(iy+DIS),c  ; FD CB DIS F9
  set  7,(iy+DIS),d  ; FD CB DIS FA
  set  7,(iy+DIS),e  ; FD CB DIS FB
  set  7,(iy+DIS),h  ; FD CB DIS FC
  set  7,(iy+DIS),l  ; FD CB DIS FD
  set  7,(iy-NDIS)   ; FD CB NDIS FE
  set  7,(iy-NDIS),a ; FD CB NDIS FF
  set  7,(iy-NDIS),b ; FD CB NDIS F8
  set  7,(iy-NDIS),c ; FD CB NDIS F9
  set  7,(iy-NDIS),d ; FD CB NDIS FA
  set  7,(iy-NDIS),e ; FD CB NDIS FB
  set  7,(iy-NDIS),h ; FD CB NDIS FC
  set  7,(iy-NDIS),l ; FD CB NDIS FD
  set  7,a           ; CB FF
  set  7,b           ; CB F8
  set  7,c           ; CB F9
  set  7,d           ; CB FA
  set  7,e           ; CB FB
  set  7,h           ; CB FC
  set  7,l           ; CB FD
  sla  (hl)          ; CB 26
  sla  (ix)          ; DD CB 00 26
  sla  (ix),a        ; DD CB 00 27
  sla  (ix),b        ; DD CB 00 20
  sla  (ix),c        ; DD CB 00 21
  sla  (ix),d        ; DD CB 00 22
  sla  (ix),e        ; DD CB 00 23
  sla  (ix),h        ; DD CB 00 24
  sla  (ix),l        ; DD CB 00 25
  sla  (ix+DIS)      ; DD CB DIS 26
  sla  (ix+DIS),a    ; DD CB DIS 27
  sla  (ix+DIS),b    ; DD CB DIS 20
  sla  (ix+DIS),c    ; DD CB DIS 21
  sla  (ix+DIS),d    ; DD CB DIS 22
  sla  (ix+DIS),e    ; DD CB DIS 23
  sla  (ix+DIS),h    ; DD CB DIS 24
  sla  (ix+DIS),l    ; DD CB DIS 25
  sla  (ix-NDIS)     ; DD CB NDIS 26
  sla  (ix-NDIS),a   ; DD CB NDIS 27
  sla  (ix-NDIS),b   ; DD CB NDIS 20
  sla  (ix-NDIS),c   ; DD CB NDIS 21
  sla  (ix-NDIS),d   ; DD CB NDIS 22
  sla  (ix-NDIS),e   ; DD CB NDIS 23
  sla  (ix-NDIS),h   ; DD CB NDIS 24
  sla  (ix-NDIS),l   ; DD CB NDIS 25
  sla  (iy)          ; FD CB 00 26
  sla  (iy),a        ; FD CB 00 27
  sla  (iy),b        ; FD CB 00 20
  sla  (iy),c        ; FD CB 00 21
  sla  (iy),d        ; FD CB 00 22
  sla  (iy),e        ; FD CB 00 23
  sla  (iy),h        ; FD CB 00 24
  sla  (iy),l        ; FD CB 00 25
  sla  (iy+DIS)      ; FD CB DIS 26
  sla  (iy+DIS),a    ; FD CB DIS 27
  sla  (iy+DIS),b    ; FD CB DIS 20
  sla  (iy+DIS),c    ; FD CB DIS 21
  sla  (iy+DIS),d    ; FD CB DIS 22
  sla  (iy+DIS),e    ; FD CB DIS 23
  sla  (iy+DIS),h    ; FD CB DIS 24
  sla  (iy+DIS),l    ; FD CB DIS 25
  sla  (iy-NDIS)     ; FD CB NDIS 26
  sla  (iy-NDIS),a   ; FD CB NDIS 27
  sla  (iy-NDIS),b   ; FD CB NDIS 20
  sla  (iy-NDIS),c   ; FD CB NDIS 21
  sla  (iy-NDIS),d   ; FD CB NDIS 22
  sla  (iy-NDIS),e   ; FD CB NDIS 23
  sla  (iy-NDIS),h   ; FD CB NDIS 24
  sla  (iy-NDIS),l   ; FD CB NDIS 25
  sla  a             ; CB 27
  sla  b             ; CB 20
  sla  bc            ; CB 21 CB 10
  sla  c             ; CB 21
  sla  d             ; CB 22
  sla  de            ; CB 23 CB 12
  sla  e             ; CB 23
  sla  h             ; CB 24
  sla  hl            ; 29
  sla  l             ; CB 25
  sli  (hl)          ; CB 36
  sli  (ix)          ; DD CB 00 36
  sli  (ix),a        ; DD CB 00 37
  sli  (ix),b        ; DD CB 00 30
  sli  (ix),c        ; DD CB 00 31
  sli  (ix),d        ; DD CB 00 32
  sli  (ix),e        ; DD CB 00 33
  sli  (ix),h        ; DD CB 00 34
  sli  (ix),l        ; DD CB 00 35
  sli  (ix+DIS)      ; DD CB DIS 36
  sli  (ix+DIS),a    ; DD CB DIS 37
  sli  (ix+DIS),b    ; DD CB DIS 30
  sli  (ix+DIS),c    ; DD CB DIS 31
  sli  (ix+DIS),d    ; DD CB DIS 32
  sli  (ix+DIS),e    ; DD CB DIS 33
  sli  (ix+DIS),h    ; DD CB DIS 34
  sli  (ix+DIS),l    ; DD CB DIS 35
  sli  (ix-NDIS)     ; DD CB NDIS 36
  sli  (ix-NDIS),a   ; DD CB NDIS 37
  sli  (ix-NDIS),b   ; DD CB NDIS 30
  sli  (ix-NDIS),c   ; DD CB NDIS 31
  sli  (ix-NDIS),d   ; DD CB NDIS 32
  sli  (ix-NDIS),e   ; DD CB NDIS 33
  sli  (ix-NDIS),h   ; DD CB NDIS 34
  sli  (ix-NDIS),l   ; DD CB NDIS 35
  sli  (iy)          ; FD CB 00 36
  sli  (iy),a        ; FD CB 00 37
  sli  (iy),b        ; FD CB 00 30
  sli  (iy),c        ; FD CB 00 31
  sli  (iy),d        ; FD CB 00 32
  sli  (iy),e        ; FD CB 00 33
  sli  (iy),h        ; FD CB 00 34
  sli  (iy),l        ; FD CB 00 35
  sli  (iy+DIS)      ; FD CB DIS 36
  sli  (iy+DIS),a    ; FD CB DIS 37
  sli  (iy+DIS),b    ; FD CB DIS 30
  sli  (iy+DIS),c    ; FD CB DIS 31
  sli  (iy+DIS),d    ; FD CB DIS 32
  sli  (iy+DIS),e    ; FD CB DIS 33
  sli  (iy+DIS),h    ; FD CB DIS 34
  sli  (iy+DIS),l    ; FD CB DIS 35
  sli  (iy-NDIS)     ; FD CB NDIS 36
  sli  (iy-NDIS),a   ; FD CB NDIS 37
  sli  (iy-NDIS),b   ; FD CB NDIS 30
  sli  (iy-NDIS),c   ; FD CB NDIS 31
  sli  (iy-NDIS),d   ; FD CB NDIS 32
  sli  (iy-NDIS),e   ; FD CB NDIS 33
  sli  (iy-NDIS),h   ; FD CB NDIS 34
  sli  (iy-NDIS),l   ; FD CB NDIS 35
  sli  a             ; CB 37
  sli  b             ; CB 30
  sli  bc            ; CB 31 CB 10
  sli  c             ; CB 31
  sli  d             ; CB 32
  sli  de            ; CB 33 CB 12
  sli  e             ; CB 33
  sli  h             ; CB 34
  sli  hl            ; CB 35 CB 14
  sli  l             ; CB 35
  sll  (hl)          ; CB 36
  sll  (ix)          ; DD CB 00 36
  sll  (ix),a        ; DD CB 00 37
  sll  (ix),b        ; DD CB 00 30
  sll  (ix),c        ; DD CB 00 31
  sll  (ix),d        ; DD CB 00 32
  sll  (ix),e        ; DD CB 00 33
  sll  (ix),h        ; DD CB 00 34
  sll  (ix),l        ; DD CB 00 35
  sll  (ix+DIS)      ; DD CB DIS 36
  sll  (ix+DIS),a    ; DD CB DIS 37
  sll  (ix+DIS),b    ; DD CB DIS 30
  sll  (ix+DIS),c    ; DD CB DIS 31
  sll  (ix+DIS),d    ; DD CB DIS 32
  sll  (ix+DIS),e    ; DD CB DIS 33
  sll  (ix+DIS),h    ; DD CB DIS 34
  sll  (ix+DIS),l    ; DD CB DIS 35
  sll  (ix-NDIS)     ; DD CB NDIS 36
  sll  (ix-NDIS),a   ; DD CB NDIS 37
  sll  (ix-NDIS),b   ; DD CB NDIS 30
  sll  (ix-NDIS),c   ; DD CB NDIS 31
  sll  (ix-NDIS),d   ; DD CB NDIS 32
  sll  (ix-NDIS),e   ; DD CB NDIS 33
  sll  (ix-NDIS),h   ; DD CB NDIS 34
  sll  (ix-NDIS),l   ; DD CB NDIS 35
  sll  (iy)          ; FD CB 00 36
  sll  (iy),a        ; FD CB 00 37
  sll  (iy),b        ; FD CB 00 30
  sll  (iy),c        ; FD CB 00 31
  sll  (iy),d        ; FD CB 00 32
  sll  (iy),e        ; FD CB 00 33
  sll  (iy),h        ; FD CB 00 34
  sll  (iy),l        ; FD CB 00 35
  sll  (iy+DIS)      ; FD CB DIS 36
  sll  (iy+DIS),a    ; FD CB DIS 37
  sll  (iy+DIS),b    ; FD CB DIS 30
  sll  (iy+DIS),c    ; FD CB DIS 31
  sll  (iy+DIS),d    ; FD CB DIS 32
  sll  (iy+DIS),e    ; FD CB DIS 33
  sll  (iy+DIS),h    ; FD CB DIS 34
  sll  (iy+DIS),l    ; FD CB DIS 35
  sll  (iy-NDIS)     ; FD CB NDIS 36
  sll  (iy-NDIS),a   ; FD CB NDIS 37
  sll  (iy-NDIS),b   ; FD CB NDIS 30
  sll  (iy-NDIS),c   ; FD CB NDIS 31
  sll  (iy-NDIS),d   ; FD CB NDIS 32
  sll  (iy-NDIS),e   ; FD CB NDIS 33
  sll  (iy-NDIS),h   ; FD CB NDIS 34
  sll  (iy-NDIS),l   ; FD CB NDIS 35
  sll  a             ; CB 37
  sll  b             ; CB 30
  sll  bc            ; CB 31 CB 10
  sll  c             ; CB 31
  sll  d             ; CB 32
  sll  de            ; CB 33 CB 12
  sll  e             ; CB 33
  sll  h             ; CB 34
  sll  hl            ; CB 35 CB 14
  sll  l             ; CB 35
  sra  (hl)          ; CB 2E
  sra  (ix)          ; DD CB 00 2E
  sra  (ix),a        ; DD CB 00 2F
  sra  (ix),b        ; DD CB 00 28
  sra  (ix),c        ; DD CB 00 29
  sra  (ix),d        ; DD CB 00 2A
  sra  (ix),e        ; DD CB 00 2B
  sra  (ix),h        ; DD CB 00 2C
  sra  (ix),l        ; DD CB 00 2D
  sra  (ix+DIS)      ; DD CB DIS 2E
  sra  (ix+DIS),a    ; DD CB DIS 2F
  sra  (ix+DIS),b    ; DD CB DIS 28
  sra  (ix+DIS),c    ; DD CB DIS 29
  sra  (ix+DIS),d    ; DD CB DIS 2A
  sra  (ix+DIS),e    ; DD CB DIS 2B
  sra  (ix+DIS),h    ; DD CB DIS 2C
  sra  (ix+DIS),l    ; DD CB DIS 2D
  sra  (ix-NDIS)     ; DD CB NDIS 2E
  sra  (ix-NDIS),a   ; DD CB NDIS 2F
  sra  (ix-NDIS),b   ; DD CB NDIS 28
  sra  (ix-NDIS),c   ; DD CB NDIS 29
  sra  (ix-NDIS),d   ; DD CB NDIS 2A
  sra  (ix-NDIS),e   ; DD CB NDIS 2B
  sra  (ix-NDIS),h   ; DD CB NDIS 2C
  sra  (ix-NDIS),l   ; DD CB NDIS 2D
  sra  (iy)          ; FD CB 00 2E
  sra  (iy),a        ; FD CB 00 2F
  sra  (iy),b        ; FD CB 00 28
  sra  (iy),c        ; FD CB 00 29
  sra  (iy),d        ; FD CB 00 2A
  sra  (iy),e        ; FD CB 00 2B
  sra  (iy),h        ; FD CB 00 2C
  sra  (iy),l        ; FD CB 00 2D
  sra  (iy+DIS)      ; FD CB DIS 2E
  sra  (iy+DIS),a    ; FD CB DIS 2F
  sra  (iy+DIS),b    ; FD CB DIS 28
  sra  (iy+DIS),c    ; FD CB DIS 29
  sra  (iy+DIS),d    ; FD CB DIS 2A
  sra  (iy+DIS),e    ; FD CB DIS 2B
  sra  (iy+DIS),h    ; FD CB DIS 2C
  sra  (iy+DIS),l    ; FD CB DIS 2D
  sra  (iy-NDIS)     ; FD CB NDIS 2E
  sra  (iy-NDIS),a   ; FD CB NDIS 2F
  sra  (iy-NDIS),b   ; FD CB NDIS 28
  sra  (iy-NDIS),c   ; FD CB NDIS 29
  sra  (iy-NDIS),d   ; FD CB NDIS 2A
  sra  (iy-NDIS),e   ; FD CB NDIS 2B
  sra  (iy-NDIS),h   ; FD CB NDIS 2C
  sra  (iy-NDIS),l   ; FD CB NDIS 2D
  sra  a             ; CB 2F
  sra  b             ; CB 28
  sra  bc            ; CB 28 CB 19
  sra  c             ; CB 29
  sra  d             ; CB 2A
  sra  de            ; CB 2A CB 1B
  sra  e             ; CB 2B
  sra  h             ; CB 2C
  sra  hl            ; CB 2C CB 1D
  sra  l             ; CB 2D
  srl  (hl)          ; CB 3E
  srl  (ix)          ; DD CB 00 3E
  srl  (ix),a        ; DD CB 00 3F
  srl  (ix),b        ; DD CB 00 38
  srl  (ix),c        ; DD CB 00 39
  srl  (ix),d        ; DD CB 00 3A
  srl  (ix),e        ; DD CB 00 3B
  srl  (ix),h        ; DD CB 00 3C
  srl  (ix),l        ; DD CB 00 3D
  srl  (ix+DIS)      ; DD CB DIS 3E
  srl  (ix+DIS),a    ; DD CB DIS 3F
  srl  (ix+DIS),b    ; DD CB DIS 38
  srl  (ix+DIS),c    ; DD CB DIS 39
  srl  (ix+DIS),d    ; DD CB DIS 3A
  srl  (ix+DIS),e    ; DD CB DIS 3B
  srl  (ix+DIS),h    ; DD CB DIS 3C
  srl  (ix+DIS),l    ; DD CB DIS 3D
  srl  (ix-NDIS)     ; DD CB NDIS 3E
  srl  (ix-NDIS),a   ; DD CB NDIS 3F
  srl  (ix-NDIS),b   ; DD CB NDIS 38
  srl  (ix-NDIS),c   ; DD CB NDIS 39
  srl  (ix-NDIS),d   ; DD CB NDIS 3A
  srl  (ix-NDIS),e   ; DD CB NDIS 3B
  srl  (ix-NDIS),h   ; DD CB NDIS 3C
  srl  (ix-NDIS),l   ; DD CB NDIS 3D
  srl  (iy)          ; FD CB 00 3E
  srl  (iy),a        ; FD CB 00 3F
  srl  (iy),b        ; FD CB 00 38
  srl  (iy),c        ; FD CB 00 39
  srl  (iy),d        ; FD CB 00 3A
  srl  (iy),e        ; FD CB 00 3B
  srl  (iy),h        ; FD CB 00 3C
  srl  (iy),l        ; FD CB 00 3D
  srl  (iy+DIS)      ; FD CB DIS 3E
  srl  (iy+DIS),a    ; FD CB DIS 3F
  srl  (iy+DIS),b    ; FD CB DIS 38
  srl  (iy+DIS),c    ; FD CB DIS 39
  srl  (iy+DIS),d    ; FD CB DIS 3A
  srl  (iy+DIS),e    ; FD CB DIS 3B
  srl  (iy+DIS),h    ; FD CB DIS 3C
  srl  (iy+DIS),l    ; FD CB DIS 3D
  srl  (iy-NDIS)     ; FD CB NDIS 3E
  srl  (iy-NDIS),a   ; FD CB NDIS 3F
  srl  (iy-NDIS),b   ; FD CB NDIS 38
  srl  (iy-NDIS),c   ; FD CB NDIS 39
  srl  (iy-NDIS),d   ; FD CB NDIS 3A
  srl  (iy-NDIS),e   ; FD CB NDIS 3B
  srl  (iy-NDIS),h   ; FD CB NDIS 3C
  srl  (iy-NDIS),l   ; FD CB NDIS 3D
  srl  a             ; CB 3F
  srl  b             ; CB 38
  srl  bc            ; CB 38 CB 19
  srl  c             ; CB 39
  srl  d             ; CB 3A
  srl  de            ; CB 3A CB 1B
  srl  e             ; CB 3B
  srl  h             ; CB 3C
  srl  hl            ; CB 3C CB 1D
  srl  l             ; CB 3D
  stop               ; DD DD 00
  sub  (hl)          ; 96
  sub  (ix)          ; DD 96 00
  sub  (ix+DIS)      ; DD 96 DIS
  sub  (ix-NDIS)     ; DD 96 NDIS
  sub  (iy)          ; FD 96 00
  sub  (iy+DIS)      ; FD 96 DIS
  sub  (iy-NDIS)     ; FD 96 NDIS
  sub  N             ; D6 N
  sub  a             ; 97
  sub  b             ; 90
  sub  c             ; 91
  sub  d             ; 92
  sub  e             ; 93
  sub  h             ; 94
  sub  hl,bc         ; B7 ED 42
  sub  hl,de         ; B7 ED 52
  sub  hl,hl         ; B7 ED 62
  sub  hl,sp         ; B7 ED 72
  sub  ixh           ; DD 94
  sub  ixl           ; DD 95
  sub  iyh           ; FD 94
  sub  iyl           ; FD 95
  sub  l             ; 95
  xor  (hl)          ; AE
  xor  (ix)          ; DD AE 00
  xor  (ix+DIS)      ; DD AE DIS
  xor  (ix-NDIS)     ; DD AE NDIS
  xor  (iy)          ; FD AE 00
  xor  (iy+DIS)      ; FD AE DIS
  xor  (iy-NDIS)     ; FD AE NDIS
  xor  N             ; EE N
  xor  a             ; AF
  xor  b             ; A8
  xor  c             ; A9
  xor  d             ; AA
  xor  e             ; AB
  xor  h             ; AC
  xor  ixh           ; DD AC
  xor  ixl           ; DD AD
  xor  iyh           ; FD AC
  xor  iyl           ; FD AD
  xor  l             ; AD

=head1 ACKNOWLEDGEMENTS

Based on sjasmplus L<http://sjasmplus.sourceforge.net/> undocumented opcodes.
See also L<http://www.z80.info/zip/z80-documented.pdf> for a description 
of the undocumented Z80 instructions.

=head1 AUTHOR

Paulo Custodio, C<< <pscust at cpan.org> >>

=head1 BUGS and FEEDBACK

Please report any bugs or feature requests through the web interface at
L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Asm-Z80-Table>.  

=head1 LICENSE and COPYRIGHT

Copyright (c) 2010 Paulo Custodio.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut

#------------------------------------------------------------------------------

