package Net::Amazon::EMR::ListInstancesResult;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::Instance;


has 'Instances' => ( is => 'ro',
                            isa => 'Net::Amazon::EMR::Type::ArrayRefofInstance',
                            coerce => 1 );

has 'Marker' => ( is => 'ro',
                  isa => 'Str',
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ListInstancesResult

=head1 DESCRIPTION

Implements the ListInstances result type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/API/API_ListInstances.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
