/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the Hausdorff distance between the set of non-zero pixels of
two images.


HausdorffDistanceImageFilter computes the distance between the set non-zero pixels of two images
using the following formula: \\[ H(A,B) = \\max(h(A,B),h(B,A)) \\] where \\[ h(A,B) = \\max_{a \\in A} \\min_{b \\in B} \\| a -
b\\| \\] is the directed Hausdorff distance and $A$ and $B$ are respectively the set of non-zero pixels in the first and second
input images.

In particular, this filter uses the DirectedHausdorffImageFilter
inside to compute the two directed distances and then select the
largest of the two.

The Hausdorff distance measures the degree of mismatch between two
sets and behaves like a metric over the set of all closed bounded sets
- with properties of identity, symmetry and triangle inequality.

This filter requires the largest possible region of the first image
and the same corresponding region in the second image. It behaves as
filter with two inputs and one output. Thus it can be inserted in a
pipeline with other filters. The filter passes the first input through
unmodified.

This filter is templated over the two input image types. It assume
both images have the same number of dimensions.


See:
 DirectedHausdorffDistanceImageFilter

 itk::HausdorffDistanceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHausdorffDistanceImageFilter.h
*/
public class HausdorffDistanceImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HausdorffDistanceImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HausdorffDistanceImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HausdorffDistanceImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HausdorffDistanceImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HausdorffDistanceImageFilter::~HausdorffDistanceImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HausdorffDistanceImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HausdorffDistanceImageFilter::HausdorffDistanceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HausdorffDistanceImageFilter() {
    this(SimpleITKJNI.new_HausdorffDistanceImageFilter(), true);
  }

  /**
double itk::simple::HausdorffDistanceImageFilter::GetHausdorffDistance() const

Return the computed Hausdorff distance.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getHausdorffDistance() {
    return SimpleITKJNI.HausdorffDistanceImageFilter_getHausdorffDistance(swigCPtr, this);
  }

  /**
double itk::simple::HausdorffDistanceImageFilter::GetAverageHausdorffDistance() const

Return the computed Hausdorff distance.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getAverageHausdorffDistance() {
    return SimpleITKJNI.HausdorffDistanceImageFilter_getAverageHausdorffDistance(swigCPtr, this);
  }

  /**
std::string itk::simple::HausdorffDistanceImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HausdorffDistanceImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HausdorffDistanceImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HausdorffDistanceImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::HausdorffDistanceImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  void execute(Image image1, Image image2) {
    SimpleITKJNI.HausdorffDistanceImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2);
  }

}
