/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.MultikeyActionsHandler;
import org.openstreetmap.josm.gui.util.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class JumpToMarkerActions {
    private static volatile JumpToNextMarker jumpToNextMarkerAction;
    private static volatile JumpToPreviousMarker jumpToPreviousMarkerAction;

    private JumpToMarkerActions() {
    }

    public static void initialize() {
        jumpToNextMarkerAction = new JumpToNextMarker(null);
        jumpToPreviousMarkerAction = new JumpToPreviousMarker(null);
        MultikeyActionsHandler.getInstance().addAction(jumpToNextMarkerAction);
        MultikeyActionsHandler.getInstance().addAction(jumpToPreviousMarkerAction);
    }

    public static void unregisterActions() {
        MultikeyActionsHandler.getInstance().removeAction(jumpToNextMarkerAction);
        MultikeyActionsHandler.getInstance().removeAction(jumpToPreviousMarkerAction);
    }

    public static final class JumpToPreviousMarker
    extends JumpToMarker {
        public JumpToPreviousMarker(JumpToMarkerLayer layer) {
            super(layer, Shortcut.registerShortcut("core_multikey:previousMarker", I18n.tr("Multikey: {0}", I18n.tr("Previous marker", new Object[0])), 80, 5008));
            this.putValue("ShortDescription", I18n.tr("Jump to previous marker", new Object[0]));
            this.putValue("Name", I18n.tr("Jump to previous marker", new Object[0]));
        }

        @Override
        protected void execute(JumpToMarkerLayer l) {
            l.jumpToPreviousMarker();
            this.setLastLayer((Layer)((Object)l));
        }
    }

    public static final class JumpToNextMarker
    extends JumpToMarker {
        public JumpToNextMarker(JumpToMarkerLayer layer) {
            super(layer, Shortcut.registerShortcut("core_multikey:nextMarker", I18n.tr("Multikey: {0}", I18n.tr("Next marker", new Object[0])), 74, 5008));
            this.putValue("ShortDescription", I18n.tr("Jump to next marker", new Object[0]));
            this.putValue("Name", I18n.tr("Jump to next marker", new Object[0]));
        }

        @Override
        protected void execute(JumpToMarkerLayer l) {
            l.jumpToNextMarker();
            this.setLastLayer((Layer)((Object)l));
        }
    }

    private static abstract class JumpToMarker
    extends AbstractAction
    implements MultikeyShortcutAction {
        private final transient JumpToMarkerLayer layer;
        private final transient Shortcut multikeyShortcut;
        private transient WeakReference<Layer> lastLayer;

        JumpToMarker(JumpToMarkerLayer layer, Shortcut shortcut) {
            this.layer = layer;
            this.multikeyShortcut = shortcut;
            this.multikeyShortcut.setAccelerator(this);
        }

        protected final void setLastLayer(Layer l) {
            this.lastLayer = new WeakReference<Layer>(l);
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.execute(this.layer);
        }

        @Override
        public void executeMultikeyAction(int index, boolean repeat) {
            Layer l = LayerListDialog.getLayerForIndex(index);
            if (l != null) {
                if (l instanceof JumpToMarkerLayer) {
                    this.execute((JumpToMarkerLayer)((Object)l));
                }
            } else if (repeat && this.lastLayer != null && LayerListDialog.isLayerValid(l = (Layer)this.lastLayer.get()) && l instanceof JumpToMarkerLayer) {
                this.execute((JumpToMarkerLayer)((Object)l));
            }
        }

        protected abstract void execute(JumpToMarkerLayer var1);

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(JumpToMarkerLayer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.lastLayer != null) {
                return LayerListDialog.getLayerInfo((Layer)this.lastLayer.get());
            }
            return null;
        }
    }

    public static interface JumpToMarkerLayer {
        public void jumpToNextMarker();

        public void jumpToPreviousMarker();
    }
}

