import { Zcl } from "zigbee-herdsman";
import type { SendPolicy } from "zigbee-herdsman/dist/controller/tstype";
import type { BatteryArgs } from "../lib/modernExtend";
import type { ElectricityMeterArgs } from "./modernExtend";
import type { KeyValue, ModernExtend } from "./types";
export declare const manufacturerOptions: {
    manufacturerCode: Zcl.ManufacturerCode;
    sendPolicy: SendPolicy;
};
export declare const boschGeneralExtend: {
    /** Some devices now use a different name for some custom clusters than
     * originally used. This can lead to issues like those described in
     * https://github.com/Koenkk/zigbee2mqtt/issues/28806. To prevent that
     * we have to make sure that all attributes of the renamed cluster are
     * available when using "getEndpoint().getClusterAttributeValue()". */
    handleRenamedCustomCluster: (oldClusterName: string, newClusterName: string) => ModernExtend;
    /** Some Bosch devices ask the coordinator for their ZCL version
     * during deviceAnnouncement. Without answer, these devices regularly
     * re-join the network. To avoid that, we have to make sure that a readRequest
     * for the zclVersion is always being answered. The answered zclVersion is
     * taken from the Bosch Smart Home Controller II.
     *
     * Exception: BTH-RM and BTH-RM230Z ask the coordinator at regular
     * intervals for their zclVersion (maybe availability check like Z2M does?)
     * and *not* during interview! To avoid code-duplication, we handle that
     * case here as well. */
    handleZclVersionReadRequest: () => ModernExtend;
    batteryWithPercentageAndLowStatus: (args?: BatteryArgs) => ModernExtend;
};
interface BoschGeneralEnergyDeviceCluster {
    attributes: {
        /** ID: 6 | Type: BOOLEAN */
        autoOffEnabled: number;
        /** ID: 7 | Type: UINT16 */
        autoOffTime: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const boschGeneralEnergyDeviceExtend: {
    customMeteringCluster: () => ModernExtend;
    resetEnergyMeters: () => ModernExtend;
    autoOff: (args?: {
        endpoint: number;
    }) => ModernExtend;
};
export declare const boschGeneralSensorDeviceExtend: {
    testMode: (args: {
        testModeDescription: string;
        sensitivityLevelToUse: number;
        variableTimeoutSupported?: boolean;
        defaultTimeout?: number;
        zoneStatusBit?: number;
    }) => ModernExtend;
};
export interface BoschBmctCluster extends BoschGeneralEnergyDeviceCluster {
    attributes: {
        /** ID: 0 | Type: ENUM8 | Only used by BMCT-SLZ */
        deviceMode: number;
        /** ID: 1 | Type: ENUM8 */
        switchType: number;
        /** ID: 2 | Type: UINT32 | Only used by BMCT-SLZ */
        calibrationOpeningTime: number;
        /** ID: 3 | Type: UINT32 | Only used by BMCT-SLZ */
        calibrationClosingTime: number;
        /** ID: 4 | Type: BITMAP8 | Used by all BMCT devices, but function is unknown */
        unknownAttributeOne: number;
        /** ID: 5 | Type: UINT8 | Only used by BMCT-SLZ */
        calibrationButtonHoldTime: number;
        /** ID: 6 | Type: BOOLEAN | Only used by BMCT-RZ and BMCT-SLZ */
        autoOffEnabled: number;
        /** ID: 7 | Type: UINT16 | Only used by BMCT-RZ and BMCT-SLZ */
        autoOffTime: number;
        /** ID: 8 | Type: BOOLEAN */
        childLock: number;
        /** ID: 10 | Type: UINT32 | Only used by BMCT-SLZ */
        slatRotationDurationOne: number;
        /** ID: 11 | Type: UINT32 | Only used by BMCT-SLZ */
        slatRotationDurationTwo: number;
        /** ID: 13 | Type: ENUM8 | Only used by BMCT-SLZ */
        motorState: number;
        /** ID: 15 | Type: UINT8 | Only used by BMCT-SLZ */
        calibrationMotorStartDelay: number;
        /** ID: 21 | Type: UINT8 | Only used by BMCT-SLZ */
        calibrationMotorEndPosition: number;
        /** ID: 22 | Type: ENUM8 | Only used by BMCT-DZ */
        dimmerType: number;
        /** ID: 24 | Type: UINT16 | Only used by BMCT-RZ */
        pulseLength: number;
        /** ID: 25 | Type: UINT8 | Only used by BMCT-DZ */
        minimumBrightness: number;
        /** ID: 26 | Type: UINT8 | Only used by BMCT-DZ */
        maximumBrightness: number;
        /** ID: 31 | Type: BOOLEAN on BMCT-DZ and BMCT-RZ, UINT8 on BMCT-SLZ */
        switchMode: number;
        /** ID: 33 | Type: UINT16 | Only used by BMCT-SLZ */
        calibrationNewMotorStartDelay: number;
        /** ID: 34 | Type: ENUM8 | Only used by BMCT-RZ */
        actuatorType: number;
        /** ID: 42 | Type: BOOLEAN | Only used by BMCT-SLZ */
        unknownAttributeTwo: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const boschBmctExtend: {
    switchMode: (args: {
        endpoint?: number;
        deviceModeLookup?: KeyValue;
        switchModeLookup: KeyValue;
        switchTypeLookup: KeyValue;
    }) => ModernExtend;
    childLock: (args?: {
        endpoint?: number;
    }) => ModernExtend;
    actuatorType: () => ModernExtend;
    dimmerType: () => ModernExtend;
    brightnessRange: () => ModernExtend;
    rzDeviceModes: (args: {
        deviceModesLookup: KeyValue;
    }) => ModernExtend;
    pulseLength: (args: {
        updateDeviceMode: boolean;
        deviceModesLookup?: KeyValue;
    }) => ModernExtend;
    switchType: (args: {
        switchTypeLookup: KeyValue;
    }) => ModernExtend;
    reportSwitchAction: (args: {
        switchTypeLookup: KeyValue;
        hasDualSwitchInputs: boolean;
    }) => ModernExtend;
    slzExtends: () => ModernExtend;
};
export interface BoschBsirPowerCfgCluster {
    attributes: {
        /** ID: 40960 | Type: UINT16 */
        solarPanelVoltage: number;
        /** ID: 40961 | Type: UINT8 |
         * This was 1 in most of the cases during testing.
         * Only when the solar panel delivered high voltages
         * did I record 2 and 3 for pretty short times.
         * But was unable to find a clear linkage to the
         * charging behavior. That's why I haven't exposed it yet. */
        unknownAttribute: number;
        /** ID: 40962 | Type: UINT8 */
        primaryPowerSource: number;
    };
    commands: never;
    commandResponses: never;
}
export interface BoschBsirIasZoneCluster {
    attributes: {
        /** ID: 40960 | Type: UINT8 */
        currentPowerSource: number;
    };
    commands: {
        /** ID: 243 */
        acknowledgeStatusChange: {
            /** Type: UINT8 */
            data: number;
        };
    };
    commandResponses: never;
}
export interface BoschBsirIasWdCluster {
    attributes: {
        /** ID: 40960 | Type: UINT8 */
        sirenDuration: number;
        /** ID: 40961 | Type: UINT8 */
        alarmMode: number;
        /** ID: 40962 | Type: UINT8 */
        sirenVolume: number;
        /** ID: 40963 | Type: UINT16 */
        sirenDelay: number;
        /** ID: 40964 | Type: UINT16 */
        lightDelay: number;
        /** ID: 40965 | Type: UINT8 */
        lightDuration: number;
        /** ID: 40966 | Type: UINT8 */
        deviceState: number;
    };
    commands: {
        /** ID: 243 */
        alarmControl: {
            /** Type: UINT16 */
            data: number;
        };
    };
    commandResponses: never;
}
export declare const boschBsirExtend: {
    customPowerCfgCluster: () => ModernExtend;
    customIasZoneCluster: () => ModernExtend;
    customIasWdCluster: () => ModernExtend;
    alarmControl: () => ModernExtend;
    deviceState: () => ModernExtend;
    lightDelay: () => ModernExtend;
    sirenDelay: () => ModernExtend;
    sirenDuration: () => ModernExtend;
    lightDuration: () => ModernExtend;
    sirenVolume: () => ModernExtend;
    alarmMode: () => ModernExtend;
    primaryPowerSource: () => ModernExtend;
    iasZoneStatus: () => ModernExtend;
    currentPowerSource: () => ModernExtend;
    solarPanelVoltage: () => ModernExtend;
};
export declare const boschDoorWindowContactExtend: {
    doorWindowContactCluster: () => ModernExtend;
    reportContactState: () => ModernExtend;
    reportButtonActions: (args?: {
        doublePressSupported: boolean;
    }) => ModernExtend;
    breakFunctionality: () => ModernExtend;
    vibrationDetection: () => ModernExtend;
};
export declare const boschBsenExtend: {
    battery: () => ModernExtend;
    testMode: () => ModernExtend;
    illuminance: () => ModernExtend;
    temperature: () => ModernExtend;
    tamperAndOccupancyAlarm: () => ModernExtend;
    sensitivityLevel: () => ModernExtend;
    changedCheckinInterval: () => ModernExtend;
};
export declare const boschWaterAlarmExtend: {
    waterAlarmCluster: () => ModernExtend;
    changedSensitivityLevel: () => ModernExtend;
    waterAndTamperAlarm: () => ModernExtend;
    muteAlarmControl: () => ModernExtend;
    alarmOnMotion: () => ModernExtend;
    testMode: () => ModernExtend;
};
export declare const boschSmokeAlarmExtend: {
    customIasZoneCluster: () => ModernExtend;
    /** In previous implementations, the user was able to change the
     * sensitivity level of the smoke detector. That is not supported
     * when using the Bosch Smart Home Controller II. As the previous
     * creator assumed that Bosch follows the ZCL specification for
     * the sensitivity level (which isn't the case), this may result
     * in an unintentionally lowered sensitivity level. Therefore,
     * we set the manufacturer's default value here once to reverse
     * any previous modifications for safety reasons, as we talk
     * about a device that should save lives... */
    enforceDefaultSensitivityLevel: () => ModernExtend;
    smokeAlarmAndButtonPushes: () => ModernExtend;
    alarmControl: () => ModernExtend;
    testMode: () => ModernExtend;
    battery: () => ModernExtend;
};
export declare const boschSmartPlugExtend: {
    smartPlugCluster: () => ModernExtend;
    onOff: () => ModernExtend;
    ledBrightness: () => ModernExtend;
    energySavingMode: () => ModernExtend;
    electricityMeter: (args?: ElectricityMeterArgs) => ModernExtend;
};
export interface BoschThermostatCluster {
    attributes: {
        /** ID: 16391 | Type: ENUM8 */
        operatingMode: number;
        /** ID: 16416 | Type: ENUM8 | Only used on BTH-RA */
        heatingDemand: number;
        /** ID: 16418 | Type: ENUM8 | Only used on BTH-RA */
        valveAdaptStatus: number;
        /** ID: 16421 | Type: ENUM8 | Only used on BTH-RM230Z with value depending on heaterType */
        unknownAttribute0: number;
        /** ID: 16448 | Type: INT16 | Only used on BTH-RA */
        remoteTemperature: number;
        /** ID: 16449 | Type: ENUM8 | Only used on BTH-RA with default value 0x01 */
        unknownAttribute1: number;
        /** ID: 16450 | Type: ENUM8 */
        windowOpenMode: number;
        /** ID: 16451 | Type: ENUM8 */
        boostHeating: number;
        /** ID: 16466 | Type: INT16 | Only used on BTH-RM and BTH-RM230Z */
        cableSensorTemperature: number;
        /** ID: 16480 | Type: ENUM8 | Only used on BTH-RM230Z */
        valveType: number;
        /** ID: 16481 | Type: ENUM8 | Read-only on BTH-RM230Z with value depending on heaterType */
        unknownAttribute2: number;
        /** ID: 16482 | Type: ENUM8 | Only used on BTH-RM and BTH-RM230Z */
        cableSensorMode: number;
        /** ID: 16483 | Type: ENUM8 | Only used on BTH-RM230Z */
        heaterType: number;
        /** ID: 20480 | Type: BITMAP8 */
        errorState: number;
        /** ID: 20496 | Type: ENUM8 | Only used on BTH-RA */
        automaticValveAdapt: number;
    };
    commands: {
        /** ID: 65 | Only used on BTH-RA */
        calibrateValve: Record<string, never>;
    };
    commandResponses: never;
}
export interface BoschUserInterfaceCfgCluster {
    attributes: {
        /** ID: 16395 | Type: UINT8 | Only used on BTH-RA */
        displayOrientation: number;
        /** ID: 16435 | Type: ENUM8 | Only used on BTH-RM and BTH-RM230Z */
        activityLed: number;
        /** ID: 16441 | Type: ENUM8 | Only used on BTH-RA */
        displayedTemperature: number;
        /** ID: 16442 | Type: ENUM8 */
        displaySwitchOnDuration: number;
        /** ID: 16443 | Type: ENUM8 */
        displayBrightness: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const boschThermostatExtend: {
    customThermostatCluster: () => ModernExtend;
    customUserInterfaceCfgCluster: () => ModernExtend;
    relayState: () => ModernExtend;
    cableSensorMode: () => ModernExtend;
    cableSensorTemperature: () => ModernExtend;
    heaterType: () => ModernExtend;
    valveType: () => ModernExtend;
    humidity: () => ModernExtend;
    windowOpenMode: (args?: {
        enableReporting: boolean;
    }) => ModernExtend;
    childLock: () => ModernExtend;
    displayBrightness: () => ModernExtend;
    displaySwitchOnDuration: () => ModernExtend;
    displayOrientation: () => ModernExtend;
    displayedTemperature: () => ModernExtend;
    activityLedState: () => ModernExtend;
    remoteTemperature: () => ModernExtend;
    setpointChangeSource: (args?: {
        enableReporting: boolean;
    }) => ModernExtend;
    customHeatingDemand: () => ModernExtend;
    rmBattery: () => ModernExtend;
    rmThermostat: () => ModernExtend;
    customSystemMode: () => ModernExtend;
    raThermostat: () => ModernExtend;
    customRunningState: () => ModernExtend;
    operatingMode: (args?: {
        enableReporting: boolean;
    }) => ModernExtend;
    boostHeating: (args?: {
        enableReporting: boolean;
    }) => ModernExtend;
    errorState: (args?: {
        enableReporting: boolean;
    }) => ModernExtend;
    valveAdaptation: () => ModernExtend;
};
export {};
//# sourceMappingURL=bosch.d.ts.map