/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.ognl.ASTConst;
import org.apache.ibatis.ognl.ASTCtor;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ASTList
extends SimpleNode
implements NodeType {
    private static final long serialVersionUID = 5819304155523588899L;

    public ASTList(int id) {
        super(id);
    }

    public ASTList(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        ArrayList<Object> answer = new ArrayList<Object>(this.jjtGetNumChildren());
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            answer.add(this.children[i].getValue(context, source));
        }
        return answer;
    }

    @Override
    public Class<?> getGetterClass() {
        return null;
    }

    @Override
    public Class<?> getSetterClass() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("{ ");
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.children[i].toString());
        }
        return result + " }";
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        StringBuilder result = new StringBuilder();
        boolean array = this.parent instanceof ASTCtor && ((ASTCtor)this.parent).isArray();
        context.setCurrentType(List.class);
        context.setCurrentAccessor(List.class);
        if (!array) {
            if (this.jjtGetNumChildren() < 1) {
                return "java.util.Arrays.asList( new Object[0])";
            }
            result.append("java.util.Arrays.asList( new Object[] ");
        }
        result.append("{ ");
        try {
            for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                Class<?> prevType = context.getCurrentType();
                Object objValue = this.children[i].getValue(context, context.getRoot());
                String value = this.children[i].toGetSourceString(context, target);
                if (this.children[i] instanceof ASTConst) {
                    context.setCurrentType(prevType);
                }
                value = ExpressionCompiler.getRootExpression(this.children[i], target, context) + value;
                String cast = "";
                if (ExpressionCompiler.shouldCast(this.children[i])) {
                    cast = (String)context.remove("_preCast");
                }
                if (cast == null) {
                    cast = "";
                }
                if (!(this.children[i] instanceof ASTConst)) {
                    value = cast + value;
                }
                Class ctorClass = (Class)context.get("_ctorClass");
                if (array && ctorClass != null && !ctorClass.isPrimitive()) {
                    Class<?> valueClass = value.getClass();
                    if (NodeType.class.isAssignableFrom(this.children[i].getClass())) {
                        valueClass = ((NodeType)((Object)this.children[i])).getGetterClass();
                    }
                    if (valueClass != null && ctorClass.isArray()) {
                        value = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(ctorClass) + ")ognl.OgnlOps.toArray(" + value + ", " + ctorClass.getComponentType().getName() + ".class, true)", ctorClass);
                    } else if (ctorClass != Object.class) {
                        value = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ctorClass.getName() + ")ognl.OgnlOps.convertValue(" + value + "," + ctorClass.getName() + ".class)", ctorClass);
                    } else if (this.children[i] instanceof NodeType && ((NodeType)((Object)this.children[i])).getGetterClass() != null && Number.class.isAssignableFrom(((NodeType)((Object)this.children[i])).getGetterClass()) || Objects.requireNonNull(valueClass).isPrimitive()) {
                        value = " ($w) (" + value + ")";
                    }
                } else if (ctorClass == null || !ctorClass.isPrimitive()) {
                    value = " ($w) (" + value + ")";
                }
                if (objValue == null || value.length() <= 0) {
                    value = "null";
                }
                result.append(value);
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        context.setCurrentType(List.class);
        context.setCurrentAccessor(List.class);
        result.append("}");
        if (!array) {
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        throw new UnsupportedCompilationException("Can't generate setter for ASTList.");
    }
}

