/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

final class ShowJavadocAction
extends NodeAction {
    ShowJavadocAction() {
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return;
        }
        JavadocProvider jd = (JavadocProvider)activatedNodes[0].getLookup().lookup(JavadocProvider.class);
        if (jd == null) {
            return;
        }
        jd.showJavadoc();
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        JavadocProvider jd = (JavadocProvider)activatedNodes[0].getLookup().lookup(JavadocProvider.class);
        if (jd == null) {
            return false;
        }
        return jd.hasJavadoc();
    }

    public final String getName() {
        return NbBundle.getMessage(ShowJavadocAction.class, (String)"CTL_ShowJavadoc");
    }

    public final HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.apisupport.project.ui.ShowJavadocAction");
    }

    public final boolean asynchronous() {
        return false;
    }

    static void showJavaDoc(URL javadoc, String displayName) {
        if (javadoc != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(javadoc);
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowJavadocAction.class, (String)"TXT_NoJavadoc", (Object)displayName));
        }
    }

    static URL findJavadoc(String resource, URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            Object base = urls[i].toExternalForm();
            if (!((String)base).endsWith("/")) {
                base = (String)base + "/";
            }
            try {
                URL u = new URL((String)base + resource);
                FileObject fo = URLMapper.findFileObject((URL)u);
                if (fo == null) continue;
                return u;
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().log(65536, "Cannot create URL for " + (String)base + resource + ". " + ex.toString());
            }
        }
        return null;
    }

    public static interface JavadocProvider {
        public boolean hasJavadoc();

        public void showJavadoc();
    }
}

