/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.completion.entries;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.php.smarty.editor.completion.entries.CodeCompletionEntryMetadata;
import org.netbeans.modules.php.smarty.editor.completion.entries.CodeCompletionParamMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CodeCompletionEntries {
    protected static Collection<CodeCompletionEntryMetadata> readAllCodeCompletionEntriesFromXML(InputStream inputStream, String completionType) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<CodeCompletionEntryMetadata> ccEntries = new ArrayList<CodeCompletionEntryMetadata>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList allEntriesList = doc.getElementsByTagName("entry");
        for (int i = 0; i < allEntriesList.getLength(); ++i) {
            Node ccNode = allEntriesList.item(i);
            if (ccNode.getNodeType() != 1) continue;
            Element elem = (Element)ccNode;
            String desc = elem.getElementsByTagName("description").item(0).getTextContent();
            String url = elem.getElementsByTagName("url").item(0).getTextContent();
            String help = "";
            List<CodeCompletionParamMetadata> params = Collections.emptyList();
            NodeList attributes = elem.getElementsByTagName("attributes");
            ccEntries.add(new CodeCompletionEntryMetadata(elem.getAttribute("name"), help, url, params));
        }
        return ccEntries;
    }

    private static String generateHelpForFunctions(String desc, NodeList attributesRoot) {
        Element parent = (Element)attributesRoot.item(0);
        if (parent != null) {
            StringBuilder help = new StringBuilder(desc);
            help.append("<br><br><table border=1><tr style=\"font-weight:bold\"><td>Attribute name</td><td>Type</td><td>Required</td><td>Default</td><td>Description</td></tr>");
            NodeList attributes = parent.getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.item(i).getNodeType() != 1) continue;
                Element attribute = (Element)attributes.item(i);
                help.append("<tr><td>").append(attribute.getAttribute("name")).append("</td>");
                help.append(CodeCompletionEntries.getRestOfAttributeParams(attribute));
                help.append("</tr>");
            }
            help.append("</table>");
            return help.toString();
        }
        return desc;
    }

    private static String generateHelpForVariableModifiers(String desc, NodeList attributesRoot) {
        Element parent = (Element)attributesRoot.item(0);
        if (parent != null) {
            StringBuilder help = new StringBuilder(desc);
            help.append("<br><br><table border=1><tr style=\"font-weight:bold\"><td>Parameter Position</td><td>Type</td><td>Required</td><td>Default</td><td>Description</td></tr>");
            NodeList attributes = parent.getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.item(i).getNodeType() != 1) continue;
                Element attribute = (Element)attributes.item(i);
                help.append("<tr><td>").append(attribute.getAttribute("position")).append("</td>");
                help.append(CodeCompletionEntries.getRestOfAttributeParams(attribute));
                help.append("</tr>");
            }
            help.append("</table>");
            return help.toString();
        }
        return desc;
    }

    private static String getRestOfAttributeParams(Element attributeParams) {
        String help = "";
        help = help + "<td>" + attributeParams.getElementsByTagName("type").item(0).getTextContent() + "</td>";
        help = help + "<td>" + attributeParams.getElementsByTagName("required").item(0).getTextContent() + "</td>";
        help = help + "<td>" + attributeParams.getElementsByTagName("default").item(0).getTextContent() + "</td>";
        help = help + "<td>" + attributeParams.getElementsByTagName("description").item(0).getTextContent() + "</td>";
        return help;
    }

    private static Collection<CodeCompletionParamMetadata> getParametersForFunction(NodeList attributesRoot) {
        Element parent = (Element)attributesRoot.item(0);
        if (parent != null) {
            ArrayList<CodeCompletionParamMetadata> params = new ArrayList<CodeCompletionParamMetadata>();
            NodeList attributes = parent.getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.item(i).getNodeType() != 1) continue;
                Element attribute = (Element)attributes.item(i);
                String name = attribute.getAttribute("name");
                String help = CodeCompletionEntries.generateHelpFunctionParameters(attribute);
                CodeCompletionParamMetadata ccpm = new CodeCompletionParamMetadata(name, help);
                assert (ccpm != null);
                params.add(ccpm);
            }
            return params;
        }
        return null;
    }

    private static String generateHelpFunctionParameters(Element attribute) {
        String help = attribute.getElementsByTagName("description").item(0).getTextContent() + "<br><br><table border=1>";
        help = help + "<tr><td style=\"font-weight:bold\">Type</td><td>" + attribute.getElementsByTagName("type").item(0).getTextContent() + "</td></tr>";
        help = help + "<tr><td style=\"font-weight:bold\">Required</td><td>" + attribute.getElementsByTagName("required").item(0).getTextContent() + "</td></tr>";
        help = help + "<tr><td style=\"font-weight:bold\">Default</td><td>" + attribute.getElementsByTagName("default").item(0).getTextContent() + "</td></tr>";
        help = help + "</table>";
        return help;
    }
}

