/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBHelper;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.eclipse.persistence.jaxb.Subgraph;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.glassfish.jersey.message.filtering.spi.AbstractObjectProvider;

final class MoxyObjectProvider
extends AbstractObjectProvider<ObjectGraph> {
    private static final org.eclipse.persistence.jaxb.JAXBContext JAXB_CONTEXT;

    MoxyObjectProvider() {
    }

    public ObjectGraph transform(org.glassfish.jersey.message.filtering.spi.ObjectGraph graph) {
        return this.createObjectGraph(graph.getEntityClass(), graph);
    }

    private ObjectGraph createObjectGraph(Class<?> entityClass, org.glassfish.jersey.message.filtering.spi.ObjectGraph objectGraph) {
        Map subgraphs;
        ObjectGraph graph = JAXB_CONTEXT.createObjectGraph(entityClass);
        Set fields = objectGraph.getFields();
        if (!fields.isEmpty()) {
            graph.addAttributeNodes(fields.toArray(new String[fields.size()]));
        }
        if (!(subgraphs = objectGraph.getSubgraphs()).isEmpty()) {
            this.createSubgraphs(graph, objectGraph.getEntityClass(), subgraphs);
        }
        return graph;
    }

    private void createSubgraphs(ObjectGraph graph, Class<?> entityClass, Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entitySubgraphs) {
        for (Map.Entry<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entry : entitySubgraphs.entrySet()) {
            Map subgraphs;
            String fieldName = entry.getKey();
            Subgraph subgraph = graph.addSubgraph(fieldName);
            org.glassfish.jersey.message.filtering.spi.ObjectGraph entityGraph = entry.getValue();
            Set fields = entityGraph.getFields(fieldName);
            if (!fields.isEmpty()) {
                subgraph.addAttributeNodes(fields.toArray(new String[fields.size()]));
            }
            if ((subgraphs = entityGraph.getSubgraphs(fieldName)).isEmpty()) continue;
            Class subEntityClass = entityGraph.getEntityClass();
            Set<String> processed = Collections.singleton(this.subgraphIdentifier(entityClass, fieldName, subEntityClass));
            this.createSubgraphs(fieldName, subgraph, subEntityClass, subgraphs, processed);
        }
    }

    private void createSubgraphs(String parent, Subgraph graph, Class<?> entityClass, Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entitySubgraphs, Set<String> processed) {
        for (Map.Entry<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entry : entitySubgraphs.entrySet()) {
            String path;
            String fieldName = entry.getKey();
            Subgraph subgraph = graph.addSubgraph(fieldName);
            org.glassfish.jersey.message.filtering.spi.ObjectGraph entityGraph = entry.getValue();
            Set fields = entityGraph.getFields(path = parent + "." + fieldName);
            if (!fields.isEmpty()) {
                subgraph.addAttributeNodes(fields.toArray(new String[fields.size()]));
            }
            Map subgraphs = entityGraph.getSubgraphs(path);
            Class subEntityClass = entityGraph.getEntityClass();
            String processedSubgraph = this.subgraphIdentifier(entityClass, fieldName, subEntityClass);
            if (subgraphs.isEmpty() || processed.contains(processedSubgraph)) continue;
            Set subProcessed = this.immutableSetOf(processed, processedSubgraph);
            this.createSubgraphs(path, subgraph, subEntityClass, subgraphs, subProcessed);
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBHelper.getJAXBContext((JAXBContext)JAXBContextFactory.createContext((TypeMappingInfo[])new TypeMappingInfo[0], Collections.emptyMap(), null));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

