/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CallStackNodeModel
implements NodeModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private JPDADebugger debugger;
    private Session session;
    private Vector listeners = new Vector();
    private final RequestProcessor rp;
    private final Map<CallStackFrame, String> frameDescriptionsByFrame = new WeakHashMap<CallStackFrame, String>();
    private final Map<CallStackFrame, String> frameTooltipByFrame = new WeakHashMap<CallStackFrame, String>();

    public CallStackNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.rp = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        new Listener(this, this.debugger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Name");
        }
        if (o instanceof CallStackFrame) {
            String frameDescr;
            boolean isCurrent;
            CallStackFrame sf = (CallStackFrame)o;
            try {
                isCurrent = (Boolean)sf.getClass().getMethod("isCurrent", new Class[0]).invoke((Object)sf, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                isCurrent = false;
            }
            Map<CallStackFrame, String> map = this.frameDescriptionsByFrame;
            synchronized (map) {
                frameDescr = this.frameDescriptionsByFrame.get(sf);
                if (frameDescr == null) {
                    this.loadFrameDescription(sf);
                    return BoldVariablesTableModelFilter.toHTML(NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Frame_Loading"), false, false, Color.LIGHT_GRAY);
                }
            }
            if (isCurrent) {
                return BoldVariablesTableModelFilter.toHTML(frameDescr, true, false, null);
            }
            return frameDescr;
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    private void loadFrameDescription(final CallStackFrame sf) {
        this.rp.post(new Runnable(){
            final /* synthetic */ CallStackNodeModel this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String frameDescr = CallStackNodeModel.getCSFName(this.this$0.session, sf, false);
                Map map = this.this$0.frameDescriptionsByFrame;
                synchronized (map) {
                    this.this$0.frameDescriptionsByFrame.put(sf, frameDescr);
                }
                this.this$0.fireDisplayNameChanged(sf);
            }
        });
    }

    private void loadFrameTooltip(final CallStackFrame sf) {
        this.rp.post(new Runnable(){
            final /* synthetic */ CallStackNodeModel this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String frameDescr = CallStackNodeModel.getCSFName(this.this$0.session, sf, true);
                Map map = this.this$0.frameTooltipByFrame;
                synchronized (map) {
                    this.this$0.frameTooltipByFrame.put(sf, frameDescr);
                }
                this.this$0.fireTooltipChanged(sf);
            }
        });
    }

    private void fireDisplayNameChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        if (k == 0) {
            return;
        }
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 1);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    private void fireTooltipChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        if (k == 0) {
            return;
        }
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 4);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Desc");
        }
        if (o instanceof CallStackFrame) {
            String frameDescr;
            CallStackFrame sf = (CallStackFrame)o;
            Map<CallStackFrame, String> map = this.frameTooltipByFrame;
            synchronized (map) {
                frameDescr = this.frameTooltipByFrame.get(sf);
                if (frameDescr == null) {
                    this.loadFrameTooltip(sf);
                    return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Frame_Loading");
                }
            }
            return frameDescr;
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return null;
        }
        if (node instanceof CallStackFrame) {
            CallStackFrame ccsf = this.debugger.getCurrentCallStackFrame();
            if (ccsf != null && ccsf.equals(node)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireNodeChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        if (k == 0) {
            return;
        }
        ModelEvent.NodeChanged nodeChangedEvent = new ModelEvent.NodeChanged((Object)this, node);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)nodeChangedEvent);
        }
    }

    public static String getCSFName(Session s, CallStackFrame sf, boolean l) {
        boolean isJava;
        String language = s.getCurrentLanguage();
        int ln = sf.getLineNumber(language);
        String fileName = null;
        boolean bl = isJava = "Java".equals(language) || !sf.getAvailableStrata().contains(language);
        if (!isJava) {
            try {
                int dot;
                if (l) {
                    fileName = sf.getSourcePath(language);
                    if ("JS".equals(language) && (fileName.startsWith("jdk/nashorn/internal/scripts/") || fileName.startsWith("jdk\\nashorn\\internal\\scripts\\"))) {
                        fileName = sf.getSourceName(language);
                    }
                } else {
                    fileName = sf.getSourceName(language);
                }
                if ((dot = fileName.lastIndexOf(46)) > 0) {
                    fileName = fileName.substring(0, dot + 1);
                }
                fileName = fileName + sf.getMethodName();
            }
            catch (AbsentInformationException e) {
                isJava = true;
            }
        }
        if (isJava) {
            fileName = l ? sf.getClassName() : BreakpointsNodeModel.getShort(sf.getClassName());
            fileName = fileName + "." + sf.getMethodName();
        }
        if (ln < 0) {
            return fileName;
        }
        return fileName + ":" + ln;
    }

    public static String getCSFToolTipText(Session session, CallStackFrame stackFrame) {
        String thisName;
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        String csfName = CallStackNodeModel.getCSFName(session, stackFrame, true);
        buf.append(NbBundle.getMessage(CallStackNodeModel.class, (String)"CTL_CallStackFrame", (Object)csfName));
        This thisVariable = stackFrame.getThisVariable();
        if (thisVariable != null && thisVariable.getClassType() != null && (thisName = thisVariable.getClassType().getName()) != null && !thisName.equals(stackFrame.getClassName())) {
            buf.append("<br>");
            buf.append(NbBundle.getMessage(CallStackNodeModel.class, (String)"CTL_RunType", (Object)thisName));
        }
        buf.append("</html>");
        return buf.toString();
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference ref;
        private JPDADebugger debugger;

        private Listener(CallStackNodeModel rm, JPDADebugger debugger) {
            this.ref = new WeakReference<CallStackNodeModel>(rm);
            this.debugger = debugger;
            debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
        }

        private CallStackNodeModel getModel() {
            CallStackNodeModel rm = (CallStackNodeModel)this.ref.get();
            if (rm == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
            }
            return rm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            CallStackNodeModel rm = this.getModel();
            if (rm == null) {
                return;
            }
            rm.fireNodeChanged(e.getOldValue());
            rm.fireNodeChanged(e.getNewValue());
        }
    }
}

