/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.impl.NbBuildLogger;
import org.apache.tools.ant.module.run.StandardLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Redirector;
import org.openide.util.RequestProcessor;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOFolding;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ForkedJavaOverride
extends Java {
    private static final RequestProcessor PROCESSOR = new RequestProcessor(ForkedJavaOverride.class.getName(), Integer.MAX_VALUE);
    public static final int LOGGER_MAX_LINE_LENGTH = Integer.getInteger("logger.max.line.length", 3000);
    private static final String JIDENT = "[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*";
    private static final Pattern STACK_TRACE = Pattern.compile("(.*?((?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.])*)([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*)[.](?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*|<init>|<clinit>)[(])(((?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*(?:\\.[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*)*/)?[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.]java):([0-9]+)|Unknown Source)([)].*)");

    public ForkedJavaOverride() {
        this.redirector = new NbRedirector((Task)this);
        super.setFork(true);
    }

    public void setFork(boolean fork) {
    }

    private void useStandardRedirector() {
        if (this.redirector instanceof NbRedirector) {
            this.redirector = new Redirector((Task)this);
        }
        this.getProject().setProperty("USING_STANDARD_REDIRECTOR", "true");
    }

    public void setInput(File input) {
        this.useStandardRedirector();
        super.setInput(input);
    }

    public void setInputString(String inputString) {
        this.useStandardRedirector();
        super.setInputString(inputString);
    }

    public void setOutput(File out) {
        this.useStandardRedirector();
        super.setOutput(out);
    }

    public void setOutputproperty(String outputProp) {
        this.useStandardRedirector();
        super.setOutputproperty(outputProp);
    }

    public void setError(File error) {
        this.useStandardRedirector();
        super.setError(error);
    }

    public void setErrorProperty(String errorProperty) {
        this.useStandardRedirector();
        super.setErrorProperty(errorProperty);
    }

    private class NbRedirector
    extends Redirector {
        private String outEncoding;
        private String errEncoding;
        private boolean delegateOutputStream;
        private boolean delegateErrorStream;

        public NbRedirector(Task task) {
            super(task);
            this.outEncoding = System.getProperty("file.encoding");
            this.errEncoding = System.getProperty("file.encoding");
            this.delegateOutputStream = true;
            this.delegateErrorStream = true;
        }

        public ExecuteStreamHandler createHandler() throws BuildException {
            this.createStreams();
            return new NbOutputStreamHandler();
        }

        public synchronized void setOutputEncoding(String outputEncoding) {
            this.outEncoding = outputEncoding;
            super.setOutputEncoding(outputEncoding);
        }

        public synchronized void setErrorEncoding(String errorEncoding) {
            this.errEncoding = errorEncoding;
            super.setErrorEncoding(errorEncoding);
        }

        public void setOutput(File out) {
            if (out != null) {
                this.delegateOutputStream = false;
            }
            super.setOutput(out);
        }

        public synchronized void setOutput(File[] out) {
            if (out != null && out.length > 0) {
                this.delegateOutputStream = false;
            }
            super.setOutput(out);
        }

        public void setError(File error) {
            if (error != null) {
                this.delegateErrorStream = false;
            }
            super.setError(error);
        }

        public synchronized void setError(File[] error) {
            if (error != null && error.length > 0) {
                this.delegateOutputStream = false;
            }
            super.setError(error);
        }

        private class NbOutputStreamHandler
        implements ExecuteStreamHandler {
            private final ExecutorService tasks;
            private final FoldingHelper foldingHelper = new FoldingHelper();
            private Future inputTask;
            private InputStream stdout;
            private InputStream stderr;
            private OutputStream stdin;

            NbOutputStreamHandler() {
                this.tasks = Executors.newFixedThreadPool(3, r -> {
                    Thread t = new Thread(Thread.currentThread().getThreadGroup(), r, "I/O Thread for " + this$1.ForkedJavaOverride.this.getProject().getName());
                    t.setDaemon(true);
                    return t;
                });
            }

            private void setCopier(InputStream inputStream, OutputStream os, boolean delegate, boolean err) {
                if (os == null || delegate) {
                    this.tasks.submit(new TransferCopier(inputStream, AntBridge.delegateOutputStream((boolean)err)));
                } else {
                    this.tasks.submit(new TransferCopier(inputStream, os));
                }
            }

            public void start() throws IOException {
                NbBuildLogger buildLogger = ForkedJavaOverride.this.getProject().getBuildListeners().stream().filter(o -> o instanceof NbBuildLogger).map(o -> (NbBuildLogger)o).findFirst().orElse(null);
                if (buildLogger != null) {
                    this.tasks.submit(new MarkupCopier(this.stdout, 2, false, NbRedirector.this.outEncoding, buildLogger, this.foldingHelper));
                    this.tasks.submit(new MarkupCopier(this.stderr, 1, true, NbRedirector.this.errEncoding, buildLogger, this.foldingHelper));
                } else {
                    this.setCopier(this.stdout, NbRedirector.this.getOutputStream(), NbRedirector.this.delegateOutputStream, false);
                    this.setCopier(this.stderr, NbRedirector.this.getErrorStream(), NbRedirector.this.delegateErrorStream, true);
                }
                InputStream is = NbRedirector.this.getInputStream();
                if (is == null) {
                    is = AntBridge.delegateInputStream();
                }
                this.inputTask = this.tasks.submit(new TransferCopier(is, this.stdin));
            }

            public void stop() {
                try {
                    if (this.inputTask != null) {
                        this.inputTask.cancel(true);
                    }
                    this.tasks.shutdown();
                    this.tasks.awaitTermination(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.tasks.shutdownNow();
                }
            }

            public void setProcessOutputStream(InputStream inputStream) throws IOException {
                this.stdout = inputStream;
            }

            public void setProcessErrorStream(InputStream inputStream) throws IOException {
                this.stderr = inputStream;
            }

            public void setProcessInputStream(OutputStream outputStream) throws IOException {
                this.stdin = outputStream;
            }
        }
    }

    public static class FoldingHelper {
        private final Pattern STACK_TRACE = Pattern.compile("^\\s+at.*:");
        private final Pattern EXCEPTION = Pattern.compile("^(\\.?\\w)*(Exception|Error).*");
        private FoldHandle foldHandle = null;
        boolean inStackTrace = false;

        private void checkFolds(String s, boolean error, AntSession session) {
            boolean cheap;
            boolean bl = cheap = s.length() < LOGGER_MAX_LINE_LENGTH;
            if (cheap && error && this.EXCEPTION.matcher(s).find()) {
                this.clearHandle();
                this.inStackTrace = true;
            } else if (cheap && error && this.inStackTrace && this.STACK_TRACE.matcher(s).find()) {
                if (this.foldHandle == null) {
                    this.foldHandle = IOFolding.startFold((InputOutput)session.getIO(), (boolean)true);
                }
            } else {
                this.inStackTrace = false;
                this.clearHandle();
            }
        }

        void clearHandle() {
            if (this.foldHandle != null) {
                if (!this.foldHandle.isFinished()) {
                    this.foldHandle.silentFinish();
                }
                this.foldHandle = null;
            }
        }
    }

    private class MarkupCopier
    implements Runnable {
        private final InputStream in;
        private final int logLevel;
        private final String encoding;
        private final RequestProcessor.Task flusher;
        private final ByteArrayOutputStream currentLine;
        private final OutputWriter ow;
        private final boolean err;
        private final AntSession session;
        private final FoldingHelper foldingHelper;

        public MarkupCopier(InputStream in, int logLevel, boolean err, String encoding, NbBuildLogger buildLogger, FoldingHelper foldingHelper) {
            this.in = in;
            this.logLevel = logLevel;
            this.err = err;
            this.encoding = encoding;
            this.foldingHelper = foldingHelper;
            this.flusher = PROCESSOR.create(() -> this.maybeFlush(false));
            this.currentLine = new ByteArrayOutputStream();
            this.ow = err ? buildLogger.err : buildLogger.out;
            this.session = buildLogger.thisSession;
        }

        private synchronized void append(byte[] data, int off, int len) {
            this.currentLine.write(data, off, len);
            if (this.currentLine.size() > 8192) {
                this.flusher.run();
            } else {
                this.flusher.schedule(250);
            }
        }

        private synchronized String appendAndTake(byte[] data, int off, int len) throws UnsupportedEncodingException {
            this.currentLine.write(data, off, len);
            String str = this.currentLine.toString(this.encoding);
            this.currentLine.reset();
            return str;
        }

        private synchronized String take() throws UnsupportedEncodingException {
            String str = this.currentLine.toString(this.encoding);
            this.currentLine.reset();
            return str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] data = new byte[1024];
                try {
                    int len;
                    while ((len = this.in.read(data)) >= 0) {
                        int last = 0;
                        for (int i = 0; i < len; ++i) {
                            int c = data[i] & 0xFF;
                            if (c != 10) continue;
                            String str = this.appendAndTake(data, last, i > last && data[i - 1] == 13 ? i - last - 1 : i - last);
                            FoldingHelper foldingHelper = this.foldingHelper;
                            synchronized (foldingHelper) {
                                this.foldingHelper.checkFolds(str, this.err, this.session);
                                if (str.length() >= LOGGER_MAX_LINE_LENGTH || !STACK_TRACE.matcher(str).matches()) {
                                    StandardLogger.findHyperlink((String)str, (AntSession)this.session, null).println(this.session, this.err);
                                }
                                ForkedJavaOverride.this.log(str, this.logLevel);
                            }
                            last = i + 1;
                        }
                        if (last >= len) continue;
                        this.append(data, last, len - last);
                    }
                }
                finally {
                    this.maybeFlush(true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void maybeFlush(boolean end) {
            try {
                String str = this.take();
                FoldingHelper foldingHelper = this.foldingHelper;
                synchronized (foldingHelper) {
                    if (!str.isEmpty()) {
                        this.ow.write(str);
                        ForkedJavaOverride.this.log(str, this.logLevel);
                    }
                    if (end && this.err) {
                        this.foldingHelper.clearHandle();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class TransferCopier
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public TransferCopier(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int len;
                byte[] data = new byte[1024];
                while ((len = this.in.read(data)) >= 0) {
                    this.out.write(data, 0, len);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

