/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ParameterizedQueryDialog
extends JPanel {
    public static final int RETURNED_CANCEL = 0;
    public static final int RETURNED_OK = 1;
    public static final int PARAMETER_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    private int returnStatus = 0;
    private Dialog dialog;
    private DialogDescriptor dlg = null;
    ParameterizedTableModel _pTableModel = new ParameterizedTableModel();
    private JPanel mainPanel;
    private JTextArea messageArea;
    private JPanel messageAreaPanel;
    private JPanel messageAreaTablePanel;
    private JTable parameterValueTable;
    private JPanel parameterValueTablePanel;
    private JScrollPane parameterValueTableScrollPane;

    public ParameterizedQueryDialog() {
        this((String[])null, true);
    }

    public ParameterizedQueryDialog(String[] parameters, boolean modal) {
        this.initComponents();
        this.setParameters(parameters);
        TableColumn column = this.parameterValueTable.getColumnModel().getColumn(1);
        column.setCellEditor(new FocusCellEditor(new JTextField()));
        this.parameterValueTable.setRowSelectionAllowed(true);
        this.parameterValueTable.setColumnSelectionAllowed(true);
        this.parameterValueTable.setColumnSelectionInterval(1, 1);
        this.parameterValueTable.changeSelection(0, 1, false, false);
        this.parameterValueTable.setRowSelectionInterval(0, 0);
        DefaultCellEditor dce = (DefaultCellEditor)this.parameterValueTable.getDefaultEditor(Object.class);
        dce.setClickCountToStart(1);
        final JTable fTable = this.parameterValueTable;
        Runnable r = new Runnable(){
            final /* synthetic */ ParameterizedQueryDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                fTable.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(r);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object[] option;
                Object o = evt.getSource();
                if (o == (option = ParameterizedQueryDialog.this.dlg.getOptions())[1]) {
                    ParameterizedQueryDialog.this.returnStatus = 0;
                    ParameterizedQueryDialog.this.dialog.dispose();
                }
                if (o == option[0]) {
                    ParameterizedQueryDialog.this.returnStatus = 1;
                    ParameterizedQueryDialog.this.dialog.dispose();
                }
            }
        };
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"SPECIFY_PARAMETER_VALUES"), modal, listener);
        String okString = NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"OK");
        String cancelString = NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"CANCEL");
        this.dlg.setOptions(new Object[]{okString, cancelString});
        this.dlg.setClosingOptions(new Object[]{okString, cancelString});
        this.dlg.setHelpCtx(new HelpCtx("projrave_ui_elements_editors_about_query_editor"));
        this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dialog.setResizable(true);
        this.dialog.pack();
        this.dialog.show();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public String[] getParameterValues() {
        int rows = this._pTableModel.getRowCount();
        String[] values = new String[rows];
        for (int i = 0; i < rows; ++i) {
            values[i] = (String)this._pTableModel.getValueAt(i, 1);
        }
        return values;
    }

    public void setParameterValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this._pTableModel.setValueAt(values[i], i, 1);
        }
    }

    public String[] getParameters() {
        int rows = this._pTableModel.getRowCount();
        String[] parameters = new String[rows];
        for (int i = 0; i < rows; ++i) {
            parameters[i] = (String)this._pTableModel.getValueAt(i, 0);
        }
        return parameters;
    }

    public void setParameters(String[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        this._pTableModel.setRowCount(0);
        for (int i = 0; i < parameters.length; ++i) {
            Object[] rowData = new Object[]{parameters[i], ""};
            this._pTableModel.addRow(rowData);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.messageAreaTablePanel = new JPanel();
        this.messageAreaPanel = new JPanel();
        this.messageArea = new JTextArea();
        this.parameterValueTablePanel = new JPanel();
        this.parameterValueTableScrollPane = new JScrollPane();
        this.parameterValueTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridLayout(1, 0));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainPanel.setMinimumSize(new Dimension(400, 300));
        this.mainPanel.setPreferredSize(new Dimension(450, 350));
        this.mainPanel.setLayout(new BorderLayout());
        this.messageAreaTablePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageAreaTablePanel.setPreferredSize(new Dimension(450, 350));
        this.messageAreaTablePanel.setLayout(new BorderLayout());
        this.messageAreaPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageAreaPanel.setMinimumSize(new Dimension(300, 70));
        this.messageAreaPanel.setPreferredSize(new Dimension(300, 70));
        this.messageAreaPanel.setLayout(new BorderLayout());
        this.messageArea.setBackground(new Color(212, 208, 200));
        this.messageArea.setEditable(false);
        this.messageArea.setFont(new Font("Arial", 0, 12));
        this.messageArea.setLineWrap(true);
        this.messageArea.setText("You have chosen to run a parameterized query. It  requires parameter values to run. Please fill in the required values.");
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageAreaPanel.add((Component)this.messageArea, "Center");
        this.messageAreaTablePanel.add((Component)this.messageAreaPanel, "North");
        this.parameterValueTablePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.parameterValueTablePanel.setMinimumSize(new Dimension(300, 200));
        this.parameterValueTablePanel.setLayout(new GridLayout(1, 0));
        this.parameterValueTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.parameterValueTableScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.parameterValueTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Parameter", "Value"}));
        this.parameterValueTableScrollPane.setViewportView(this.parameterValueTable);
        this.parameterValueTable.setRowHeight(18);
        Dimension dim = this.parameterValueTable.getTableHeader().getPreferredSize();
        Dimension newDim = new Dimension((int)dim.getWidth(), 25);
        this.parameterValueTable.getTableHeader().setPreferredSize(newDim);
        this.parameterValueTableScrollPane.setViewportView(this.parameterValueTable);
        this.parameterValueTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"ACS_ParameterizedTableName"));
        this.parameterValueTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"ACS_ParameterizedTableDescription"));
        this.parameterValueTablePanel.add(this.parameterValueTableScrollPane);
        this.messageAreaTablePanel.add((Component)this.parameterValueTablePanel, "Center");
        this.mainPanel.add((Component)this.messageAreaTablePanel, "Center");
        this.add(this.mainPanel);
    }

    class ParameterizedTableModel
    extends DefaultTableModel {
        final String[] columnNames;
        Object[][] data;

        public ParameterizedTableModel() {
            super(0, 2);
            this.columnNames = new String[]{NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"PARAMETER"), NbBundle.getMessage(ParameterizedQueryDialog.class, (String)"VALUE")};
            this.data = new Object[][]{{"", ""}};
            this.setColumnIdentifiers(this.columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }
    }

    private class FocusCellEditor
    extends DefaultCellEditor {
        Component c;

        public FocusCellEditor(JTextField jtf) {
            super(jtf);
            this.addFocusListener(jtf);
        }

        private void addFocusListener(Component C) {
            C.getClass();
            super.getComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent fe) {
                    FocusCellEditor.this.lostFocus();
                }
            });
        }

        public void lostFocus() {
            this.stopCellEditing();
        }
    }

    class ParameterizedTable
    extends JTable {
        ParameterizedTable() {
        }

        @Override
        public boolean getSurrendersFocusOnKeystroke() {
            return true;
        }

        @Override
        public void changeSelection(int row, int col, boolean toggle, boolean expand) {
            if (!this.getModel().isCellEditable(row, col)) {
                int currentRow = this.getEditingRow();
                int currentCol = this.getEditingColumn();
                if (currentRow == -1) {
                    currentRow = this.getSelectedRow();
                }
                if (currentCol == -1) {
                    currentCol = this.getSelectedColumn();
                }
                int numberOfRows = this.getRowCount();
                int numberOfCols = this.getColumnCount();
                int nextRow = row;
                int nextCol = col;
                if (col == currentCol) {
                    int direction = row - currentRow;
                    if (direction > 1) {
                        direction = 1;
                    }
                    if (direction < -1) {
                        direction = -1;
                    }
                    nextRow = this.getNextEditableRow(row, col, direction, numberOfRows, numberOfCols);
                } else if (row == currentRow) {
                    int direction = col - currentCol;
                    if (direction > 1) {
                        direction = 1;
                    }
                    if (direction < -1) {
                        direction = -1;
                    }
                    int[] nextCell = this.getNextEditableCell(row, col, direction, numberOfRows, numberOfCols);
                    nextRow = nextCell[0];
                    nextCol = nextCell[1];
                } else {
                    int direction = row - currentRow;
                    if (direction > 1) {
                        direction = 1;
                    }
                    if (direction < -1) {
                        direction = -1;
                    }
                    if (row == 0 && currentRow == numberOfRows - 1) {
                        direction = 1;
                    }
                    int[] nextCell = this.getNextEditableCell(row, col, direction, numberOfRows, numberOfCols);
                    nextRow = nextCell[0];
                    nextCol = nextCell[1];
                }
                super.changeSelection(nextRow, nextCol, toggle, expand);
            } else {
                super.changeSelection(row, col, toggle, expand);
            }
        }

        int[] getNextEditableCell(int row, int col, int direction, int numberOfRows, int numberOfCols) {
            int originalRow = row;
            int originalCol = col;
            do {
                if ((col += direction) >= numberOfCols) {
                    col = 0;
                    row += direction;
                }
                if (col < 0) {
                    col = numberOfCols - 1;
                    row += direction;
                }
                if (row >= numberOfRows) {
                    row = 0;
                }
                if (row < 0) {
                    row = numberOfRows - 1;
                }
                if (!this.isCellEditable(row, col)) continue;
                return new int[]{row, col};
            } while (row != originalRow || col != originalCol);
            return new int[]{originalRow, originalCol};
        }

        int getNextEditableRow(int row, int col, int direction, int numberOfRows, int numberOfCols) {
            int originalRow = row;
            do {
                if ((row += direction) < 0) {
                    row = numberOfRows - 1;
                }
                if (row >= numberOfRows) {
                    row = 0;
                }
                if (!this.isCellEditable(row, col)) continue;
                return row;
            } while (row != originalRow);
            return originalRow;
        }
    }
}

