/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.netbeans.modules.cloud.oracle.vault.VaultNode;
import org.openide.NotifyDescriptor;

public class VaultStep
extends AbstractStep<VaultItem> {
    private static final Logger LOG = Logger.getLogger(VaultStep.class.getName());
    private Map<String, VaultItem> vaults = null;
    private VaultItem selected;

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        h.progress(Bundle.FetchingVaults());
        CompartmentItem compartment = (CompartmentItem)values.getValueForStep(CompartmentStep.class);
        this.vaults = VaultNode.getVaults().apply(compartment).stream().collect(Collectors.toMap(OCIItem::getName, vault -> vault));
    }

    @Override
    public NotifyDescriptor createInput() {
        return Steps.createQuickPick(this.vaults, Bundle.SelectVault());
    }

    @Override
    public void setValue(String selected) {
        this.selected = this.vaults.get(selected);
    }

    @Override
    public VaultItem getValue() {
        if (this.onlyOneChoice()) {
            this.selected = this.vaults.values().iterator().next();
        }
        return this.selected;
    }

    @Override
    public boolean onlyOneChoice() {
        return this.vaults.size() == 1;
    }
}

