/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.webresources.ClasspathURLStreamHandler;
import org.apache.catalina.webresources.war.Handler;

public class TomcatURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String WAR_PROTOCOL = "war";
    private static final String CLASSPATH_PROTOCOL = "classpath";
    private static volatile TomcatURLStreamHandlerFactory instance = null;
    private final boolean registered;
    private final List<URLStreamHandlerFactory> userFactories = new CopyOnWriteArrayList<URLStreamHandlerFactory>();

    public static TomcatURLStreamHandlerFactory getInstance() {
        TomcatURLStreamHandlerFactory.getInstanceInternal(true);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TomcatURLStreamHandlerFactory getInstanceInternal(boolean bl) {
        if (instance != null) return instance;
        Class<TomcatURLStreamHandlerFactory> clazz = TomcatURLStreamHandlerFactory.class;
        synchronized (TomcatURLStreamHandlerFactory.class) {
            if (instance != null) return instance;
            instance = new TomcatURLStreamHandlerFactory(bl);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean register() {
        return TomcatURLStreamHandlerFactory.getInstanceInternal(true).isRegistered();
    }

    public static boolean disable() {
        return !TomcatURLStreamHandlerFactory.getInstanceInternal(false).isRegistered();
    }

    public static void release(ClassLoader classLoader) {
        if (instance == null) {
            return;
        }
        List<URLStreamHandlerFactory> list = TomcatURLStreamHandlerFactory.instance.userFactories;
        block0: for (URLStreamHandlerFactory uRLStreamHandlerFactory : list) {
            for (ClassLoader classLoader2 = uRLStreamHandlerFactory.getClass().getClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                if (!classLoader.equals(classLoader2)) continue;
                list.remove(uRLStreamHandlerFactory);
                continue block0;
            }
        }
    }

    private TomcatURLStreamHandlerFactory(boolean bl) {
        this.registered = bl;
        if (bl) {
            URL.setURLStreamHandlerFactory(this);
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void addUserFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        this.userFactories.add(uRLStreamHandlerFactory);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        if (WAR_PROTOCOL.equals(string)) {
            return new Handler();
        }
        if (CLASSPATH_PROTOCOL.equals(string)) {
            return new ClasspathURLStreamHandler();
        }
        for (URLStreamHandlerFactory uRLStreamHandlerFactory : this.userFactories) {
            URLStreamHandler uRLStreamHandler = uRLStreamHandlerFactory.createURLStreamHandler(string);
            if (uRLStreamHandler == null) continue;
            return uRLStreamHandler;
        }
        return null;
    }
}

