/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007, 2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADAV	 = 10,
	OP_PADHV	 = 11,
	OP_PADANY	 = 12,
	OP_PUSHRE	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_SASSIGN	 = 36,
	OP_AASSIGN	 = 37,
	OP_CHOP		 = 38,
	OP_SCHOP	 = 39,
	OP_CHOMP	 = 40,
	OP_SCHOMP	 = 41,
	OP_DEFINED	 = 42,
	OP_UNDEF	 = 43,
	OP_STUDY	 = 44,
	OP_POS		 = 45,
	OP_PREINC	 = 46,
	OP_I_PREINC	 = 47,
	OP_PREDEC	 = 48,
	OP_I_PREDEC	 = 49,
	OP_POSTINC	 = 50,
	OP_I_POSTINC	 = 51,
	OP_POSTDEC	 = 52,
	OP_I_POSTDEC	 = 53,
	OP_POW		 = 54,
	OP_MULTIPLY	 = 55,
	OP_I_MULTIPLY	 = 56,
	OP_DIVIDE	 = 57,
	OP_I_DIVIDE	 = 58,
	OP_MODULO	 = 59,
	OP_I_MODULO	 = 60,
	OP_REPEAT	 = 61,
	OP_ADD		 = 62,
	OP_I_ADD	 = 63,
	OP_SUBTRACT	 = 64,
	OP_I_SUBTRACT	 = 65,
	OP_CONCAT	 = 66,
	OP_STRINGIFY	 = 67,
	OP_LEFT_SHIFT	 = 68,
	OP_RIGHT_SHIFT	 = 69,
	OP_LT		 = 70,
	OP_I_LT		 = 71,
	OP_GT		 = 72,
	OP_I_GT		 = 73,
	OP_LE		 = 74,
	OP_I_LE		 = 75,
	OP_GE		 = 76,
	OP_I_GE		 = 77,
	OP_EQ		 = 78,
	OP_I_EQ		 = 79,
	OP_NE		 = 80,
	OP_I_NE		 = 81,
	OP_NCMP		 = 82,
	OP_I_NCMP	 = 83,
	OP_SLT		 = 84,
	OP_SGT		 = 85,
	OP_SLE		 = 86,
	OP_SGE		 = 87,
	OP_SEQ		 = 88,
	OP_SNE		 = 89,
	OP_SCMP		 = 90,
	OP_BIT_AND	 = 91,
	OP_BIT_XOR	 = 92,
	OP_BIT_OR	 = 93,
	OP_NEGATE	 = 94,
	OP_I_NEGATE	 = 95,
	OP_NOT		 = 96,
	OP_COMPLEMENT	 = 97,
	OP_SMARTMATCH	 = 98,
	OP_ATAN2	 = 99,
	OP_SIN		 = 100,
	OP_COS		 = 101,
	OP_RAND		 = 102,
	OP_SRAND	 = 103,
	OP_EXP		 = 104,
	OP_LOG		 = 105,
	OP_SQRT		 = 106,
	OP_INT		 = 107,
	OP_HEX		 = 108,
	OP_OCT		 = 109,
	OP_ABS		 = 110,
	OP_LENGTH	 = 111,
	OP_SUBSTR	 = 112,
	OP_VEC		 = 113,
	OP_INDEX	 = 114,
	OP_RINDEX	 = 115,
	OP_SPRINTF	 = 116,
	OP_FORMLINE	 = 117,
	OP_ORD		 = 118,
	OP_CHR		 = 119,
	OP_CRYPT	 = 120,
	OP_UCFIRST	 = 121,
	OP_LCFIRST	 = 122,
	OP_UC		 = 123,
	OP_LC		 = 124,
	OP_QUOTEMETA	 = 125,
	OP_RV2AV	 = 126,
	OP_AELEMFAST	 = 127,
	OP_AELEM	 = 128,
	OP_ASLICE	 = 129,
	OP_AEACH	 = 130,
	OP_AKEYS	 = 131,
	OP_AVALUES	 = 132,
	OP_EACH		 = 133,
	OP_VALUES	 = 134,
	OP_KEYS		 = 135,
	OP_DELETE	 = 136,
	OP_EXISTS	 = 137,
	OP_RV2HV	 = 138,
	OP_HELEM	 = 139,
	OP_HSLICE	 = 140,
	OP_UNPACK	 = 141,
	OP_PACK		 = 142,
	OP_SPLIT	 = 143,
	OP_JOIN		 = 144,
	OP_LIST		 = 145,
	OP_LSLICE	 = 146,
	OP_ANONLIST	 = 147,
	OP_ANONHASH	 = 148,
	OP_SPLICE	 = 149,
	OP_PUSH		 = 150,
	OP_POP		 = 151,
	OP_SHIFT	 = 152,
	OP_UNSHIFT	 = 153,
	OP_SORT		 = 154,
	OP_REVERSE	 = 155,
	OP_GREPSTART	 = 156,
	OP_GREPWHILE	 = 157,
	OP_MAPSTART	 = 158,
	OP_MAPWHILE	 = 159,
	OP_RANGE	 = 160,
	OP_FLIP		 = 161,
	OP_FLOP		 = 162,
	OP_AND		 = 163,
	OP_OR		 = 164,
	OP_XOR		 = 165,
	OP_DOR		 = 166,
	OP_COND_EXPR	 = 167,
	OP_ANDASSIGN	 = 168,
	OP_ORASSIGN	 = 169,
	OP_DORASSIGN	 = 170,
	OP_METHOD	 = 171,
	OP_ENTERSUB	 = 172,
	OP_LEAVESUB	 = 173,
	OP_LEAVESUBLV	 = 174,
	OP_CALLER	 = 175,
	OP_WARN		 = 176,
	OP_DIE		 = 177,
	OP_RESET	 = 178,
	OP_LINESEQ	 = 179,
	OP_NEXTSTATE	 = 180,
	OP_DBSTATE	 = 181,
	OP_UNSTACK	 = 182,
	OP_ENTER	 = 183,
	OP_LEAVE	 = 184,
	OP_SCOPE	 = 185,
	OP_ENTERITER	 = 186,
	OP_ITER		 = 187,
	OP_ENTERLOOP	 = 188,
	OP_LEAVELOOP	 = 189,
	OP_RETURN	 = 190,
	OP_LAST		 = 191,
	OP_NEXT		 = 192,
	OP_REDO		 = 193,
	OP_DUMP		 = 194,
	OP_GOTO		 = 195,
	OP_EXIT		 = 196,
	OP_METHOD_NAMED	 = 197,
	OP_ENTERGIVEN	 = 198,
	OP_LEAVEGIVEN	 = 199,
	OP_ENTERWHEN	 = 200,
	OP_LEAVEWHEN	 = 201,
	OP_BREAK	 = 202,
	OP_CONTINUE	 = 203,
	OP_OPEN		 = 204,
	OP_CLOSE	 = 205,
	OP_PIPE_OP	 = 206,
	OP_FILENO	 = 207,
	OP_UMASK	 = 208,
	OP_BINMODE	 = 209,
	OP_TIE		 = 210,
	OP_UNTIE	 = 211,
	OP_TIED		 = 212,
	OP_DBMOPEN	 = 213,
	OP_DBMCLOSE	 = 214,
	OP_SSELECT	 = 215,
	OP_SELECT	 = 216,
	OP_GETC		 = 217,
	OP_READ		 = 218,
	OP_ENTERWRITE	 = 219,
	OP_LEAVEWRITE	 = 220,
	OP_PRTF		 = 221,
	OP_PRINT	 = 222,
	OP_SAY		 = 223,
	OP_SYSOPEN	 = 224,
	OP_SYSSEEK	 = 225,
	OP_SYSREAD	 = 226,
	OP_SYSWRITE	 = 227,
	OP_EOF		 = 228,
	OP_TELL		 = 229,
	OP_SEEK		 = 230,
	OP_TRUNCATE	 = 231,
	OP_FCNTL	 = 232,
	OP_IOCTL	 = 233,
	OP_FLOCK	 = 234,
	OP_SEND		 = 235,
	OP_RECV		 = 236,
	OP_SOCKET	 = 237,
	OP_SOCKPAIR	 = 238,
	OP_BIND		 = 239,
	OP_CONNECT	 = 240,
	OP_LISTEN	 = 241,
	OP_ACCEPT	 = 242,
	OP_SHUTDOWN	 = 243,
	OP_GSOCKOPT	 = 244,
	OP_SSOCKOPT	 = 245,
	OP_GETSOCKNAME	 = 246,
	OP_GETPEERNAME	 = 247,
	OP_LSTAT	 = 248,
	OP_STAT		 = 249,
	OP_FTRREAD	 = 250,
	OP_FTRWRITE	 = 251,
	OP_FTREXEC	 = 252,
	OP_FTEREAD	 = 253,
	OP_FTEWRITE	 = 254,
	OP_FTEEXEC	 = 255,
	OP_FTIS		 = 256,
	OP_FTSIZE	 = 257,
	OP_FTMTIME	 = 258,
	OP_FTATIME	 = 259,
	OP_FTCTIME	 = 260,
	OP_FTROWNED	 = 261,
	OP_FTEOWNED	 = 262,
	OP_FTZERO	 = 263,
	OP_FTSOCK	 = 264,
	OP_FTCHR	 = 265,
	OP_FTBLK	 = 266,
	OP_FTFILE	 = 267,
	OP_FTDIR	 = 268,
	OP_FTPIPE	 = 269,
	OP_FTSUID	 = 270,
	OP_FTSGID	 = 271,
	OP_FTSVTX	 = 272,
	OP_FTLINK	 = 273,
	OP_FTTTY	 = 274,
	OP_FTTEXT	 = 275,
	OP_FTBINARY	 = 276,
	OP_CHDIR	 = 277,
	OP_CHOWN	 = 278,
	OP_CHROOT	 = 279,
	OP_UNLINK	 = 280,
	OP_CHMOD	 = 281,
	OP_UTIME	 = 282,
	OP_RENAME	 = 283,
	OP_LINK		 = 284,
	OP_SYMLINK	 = 285,
	OP_READLINK	 = 286,
	OP_MKDIR	 = 287,
	OP_RMDIR	 = 288,
	OP_OPEN_DIR	 = 289,
	OP_READDIR	 = 290,
	OP_TELLDIR	 = 291,
	OP_SEEKDIR	 = 292,
	OP_REWINDDIR	 = 293,
	OP_CLOSEDIR	 = 294,
	OP_FORK		 = 295,
	OP_WAIT		 = 296,
	OP_WAITPID	 = 297,
	OP_SYSTEM	 = 298,
	OP_EXEC		 = 299,
	OP_KILL		 = 300,
	OP_GETPPID	 = 301,
	OP_GETPGRP	 = 302,
	OP_SETPGRP	 = 303,
	OP_GETPRIORITY	 = 304,
	OP_SETPRIORITY	 = 305,
	OP_TIME		 = 306,
	OP_TMS		 = 307,
	OP_LOCALTIME	 = 308,
	OP_GMTIME	 = 309,
	OP_ALARM	 = 310,
	OP_SLEEP	 = 311,
	OP_SHMGET	 = 312,
	OP_SHMCTL	 = 313,
	OP_SHMREAD	 = 314,
	OP_SHMWRITE	 = 315,
	OP_MSGGET	 = 316,
	OP_MSGCTL	 = 317,
	OP_MSGSND	 = 318,
	OP_MSGRCV	 = 319,
	OP_SEMOP	 = 320,
	OP_SEMGET	 = 321,
	OP_SEMCTL	 = 322,
	OP_REQUIRE	 = 323,
	OP_DOFILE	 = 324,
	OP_HINTSEVAL	 = 325,
	OP_ENTEREVAL	 = 326,
	OP_LEAVEEVAL	 = 327,
	OP_ENTERTRY	 = 328,
	OP_LEAVETRY	 = 329,
	OP_GHBYNAME	 = 330,
	OP_GHBYADDR	 = 331,
	OP_GHOSTENT	 = 332,
	OP_GNBYNAME	 = 333,
	OP_GNBYADDR	 = 334,
	OP_GNETENT	 = 335,
	OP_GPBYNAME	 = 336,
	OP_GPBYNUMBER	 = 337,
	OP_GPROTOENT	 = 338,
	OP_GSBYNAME	 = 339,
	OP_GSBYPORT	 = 340,
	OP_GSERVENT	 = 341,
	OP_SHOSTENT	 = 342,
	OP_SNETENT	 = 343,
	OP_SPROTOENT	 = 344,
	OP_SSERVENT	 = 345,
	OP_EHOSTENT	 = 346,
	OP_ENETENT	 = 347,
	OP_EPROTOENT	 = 348,
	OP_ESERVENT	 = 349,
	OP_GPWNAM	 = 350,
	OP_GPWUID	 = 351,
	OP_GPWENT	 = 352,
	OP_SPWENT	 = 353,
	OP_EPWENT	 = 354,
	OP_GGRNAM	 = 355,
	OP_GGRGID	 = 356,
	OP_GGRENT	 = 357,
	OP_SGRENT	 = 358,
	OP_EGRENT	 = 359,
	OP_GETLOGIN	 = 360,
	OP_SYSCALL	 = 361,
	OP_LOCK		 = 362,
	OP_ONCE		 = 363,
	OP_CUSTOM	 = 364,
	OP_max		
} opcode;

#define MAXO 365
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


/* the OP_IS_(SOCKET|FILETEST) macros are optimized to a simple range
    check because all the member OPs are contiguous in opcode.pl
    <DATA> table.  opcode.pl verifies the range contiguity.  */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

/* ex: set ro: */
