# This file was autogenerated.
use 5.008001;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::String;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.016';

=head1 NAME

Hydrogen::String - a standard library for strings

=head1 VERSION

This documentation is for Hydrogen::String 0.016,
which is based on Sub::HandlesVia::HandlerLibrary::String 0.037.

=cut

=head1 FUNCTIONS

Each function expects a string scalar as its first argument.

=cut

use Exporter::Shiny qw(
    append
    chomp
    chop
    clear
    cmp
    cmpi
    contains
    contains_i
    ends_with
    ends_with_i
    eq
    eqi
    fc
    ge
    gei
    get
    gt
    gti
    inc
    lc
    le
    lei
    length
    lt
    lti
    match
    match_i
    ne
    nei
    prepend
    replace
    replace_globally
    reset
    set
    starts_with
    starts_with_i
    substr
    uc
);

=head2 C<< append( $string, $tail ) >>

Additional arguments: B<< Str >>.

Appends another string to the end of the current string and updates the original value.

=cut

sub append {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "append", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for append: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for append: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = $$__REF__ . $_[1];
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for append: expected %s, got value %s",
                    "Str", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< chomp( $string ) >>

Like C<chomp> from L<perlfunc>.

=cut

sub chomp {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for chomp; usage: "
          . "Hydrogen::String::chomp( \$string )" );
    1;
    chomp($$__REF__);
}

=head2 C<< chop( $string ) >>

Like C<chop> from L<perlfunc>.

=cut

sub chop {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for chop; usage: "
          . "Hydrogen::String::chop( \$string )" );
    1;
    chop($$__REF__);
}

=head2 C<< clear( $string ) >>

Sets the string to the empty string.

=cut

sub clear {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for clear; usage: "
          . "Hydrogen::String::clear( \$string )" );
    1;
    ( ${$__REF__} = q() );
}

=head2 C<< cmp( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string cmp $str >>.

=cut

sub cmp {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "cmp", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for cmp: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for cmp: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ cmp $_[1];
}

=head2 C<< cmpi( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) cmp fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub cmpi {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "cmpi", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for cmpi: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for cmpi: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) cmp Hydrogen::fc( $_[1] );
}

=head2 C<< contains( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns true iff the string contains C<< $str >>.

=cut

sub contains {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "contains", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for contains: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for contains: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    index( $$__REF__, $_[1] ) != -1;
}

=head2 C<< contains_i( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns true iff the string contains C<< $str >> case-insensitvely.

=cut

sub contains_i {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "contains_i", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for contains_i: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for contains_i: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    index( Hydrogen::fc($$__REF__), Hydrogen::fc( $_[1] ) ) != -1;
}

=head2 C<< ends_with( $string, $tail ) >>

Additional arguments: B<< Str >>.

Returns true iff the string ends with C<< $tail >>.

=cut

sub ends_with {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ends_with", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ends_with: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ends_with: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    substr( $$__REF__, -length $_[1] ) eq $_[1];
}

=head2 C<< ends_with_i( $string, $tail ) >>

Additional arguments: B<< Str >>.

Returns true iff the string ends with C<< $tail >> case-insensitvely.

=cut

sub ends_with_i {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ends_with_i", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ends_with_i: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ends_with_i: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc( substr( $$__REF__, -length $_[1] ) ) eq Hydrogen::fc( $_[1] );
}

=head2 C<< eq( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string eq $str >>.

=cut

sub eq {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "eq", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for eq: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for eq: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ eq $_[1];
}

=head2 C<< eqi( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) eq fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub eqi {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "eqi", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for eqi: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for eqi: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) eq Hydrogen::fc( $_[1] );
}

=head2 C<< fc( $string ) >>

Returns C<< fc($string) >>.

=cut

sub fc {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for fc; usage: "
          . "Hydrogen::String::fc( \$string )" );
    Hydrogen::fc($$__REF__);
}

=head2 C<< ge( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string ge $str >>.

=cut

sub ge {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ge", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ge: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ge: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ ge $_[1];
}

=head2 C<< gei( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) ge fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub gei {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gei", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gei: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gei: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) ge Hydrogen::fc( $_[1] );
}

=head2 C<< get( $string ) >>

Gets the current value of the string.

=cut

sub get {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for get; usage: "
          . "Hydrogen::String::get( \$string )" );
    $$__REF__;
}

=head2 C<< gt( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string gt $str >>.

=cut

sub gt {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gt", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gt: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gt: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ gt $_[1];
}

=head2 C<< gti( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) gt fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub gti {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gti", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gti: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gti: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) gt Hydrogen::fc( $_[1] );
}

=head2 C<< inc( $string ) >>

Performs C<< ++ >> on the string.

=cut

sub inc {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for inc; usage: "
          . "Hydrogen::String::inc( \$string )" );
    1;
    ++$$__REF__;
}

=head2 C<< lc( $string ) >>

Returns C<< lc($string) >>.

=cut

sub lc {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for lc; usage: "
          . "Hydrogen::String::lc( \$string )" );
    lc($$__REF__);
}

=head2 C<< le( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string le $str >>.

=cut

sub le {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "le", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for le: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for le: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ le $_[1];
}

=head2 C<< lei( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) le fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub lei {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lei", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lei: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lei: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) le Hydrogen::fc( $_[1] );
}

=head2 C<< length( $string ) >>

Like C<length> from L<perlfunc>.

=cut

sub length {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for length; usage: "
          . "Hydrogen::String::length( \$string )" );
    length($$__REF__);
}

=head2 C<< lt( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string lt $str >>.

=cut

sub lt {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lt", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lt: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lt: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ lt $_[1];
}

=head2 C<< lti( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) lt fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub lti {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lti", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lti: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lti: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) lt Hydrogen::fc( $_[1] );
}

=head2 C<< match( $string, $regexp ) >>

Additional arguments: B<< Str|RegexpRef >>.

Returns true iff the string matches the regexp.

=cut

sub match {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "match", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for match: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[1] ) and do {
                        ref( \$_[1] ) eq 'SCALAR'
                          or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[1] ) && !!re::is_regexp( $_[1] )
                          or Scalar::Util::blessed( $_[1] )
                          && $_[1]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for match: %s should be %s",
            "\$_[1]", "Str|RegexpRef" );

        (@_);
    };
    $$__REF__ =~ /$_[1]/;
}

=head2 C<< match_i( $string, $regexp ) >>

Additional arguments: B<< Str|RegexpRef >>.

Returns true iff the string matches the regexp case-insensitively.

=cut

sub match_i {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "match_i", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for match_i: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[1] ) and do {
                        ref( \$_[1] ) eq 'SCALAR'
                          or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[1] ) && !!re::is_regexp( $_[1] )
                          or Scalar::Util::blessed( $_[1] )
                          && $_[1]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for match_i: %s should be %s",
            "\$_[1]", "Str|RegexpRef" );

        (@_);
    };
    $$__REF__ =~ /$_[1]/i;
}

=head2 C<< ne( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< $string ne $str >>.

=cut

sub ne {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ne", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ne: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ne: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    $$__REF__ ne $_[1];
}

=head2 C<< nei( $string, $str ) >>

Additional arguments: B<< Str >>.

Returns C<< fc($string) ne fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub nei {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "nei", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for nei: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for nei: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    Hydrogen::fc($$__REF__) ne Hydrogen::fc( $_[1] );
}

=head2 C<< prepend( $string, $head ) >>

Additional arguments: B<< Str >>.

Prepends another string to the start of the current string and updates the original value.

=cut

sub prepend {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "prepend", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for prepend: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for prepend: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = $_[1] . $$__REF__;
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for prepend: expected %s, got value %s",
                    "Str", $shv_final_unchecked
                  );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< replace( $string, $regexp, $replacement ) >>

Additional arguments: B<< Str|RegexpRef >>, B<< Str|CodeRef >>.

Replaces the first regexp match within the string with the replacement string.

=cut

sub replace {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 3
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "replace", scalar(@_), "expected exactly 3 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for replace: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[1] ) and do {
                        ref( \$_[1] ) eq 'SCALAR'
                          or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[1] ) && !!re::is_regexp( $_[1] )
                          or Scalar::Util::blessed( $_[1] )
                          && $_[1]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for replace: %s should be %s",
            "\$_[1]", "Str|RegexpRef" );

        # Parameter $_[2] (type: Str|CodeRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[2] ) and do {
                        ref( \$_[2] ) eq 'SCALAR'
                          or ref( \( my $val = $_[2] ) ) eq 'SCALAR';
                    }
                  }
                  or ( ref( $_[2] ) eq 'CODE' )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for replace: %s should be %s",
            "\$_[2]", "Str|CodeRef" );

        (@_);
    };
    my $shv_tmp = $$__REF__;
    if ( ( ref( $_[2] ) eq 'CODE' ) ) {
        my $shv_callback = $_[2];
        $shv_tmp =~ s/$_[1]/$shv_callback->()/e;
    }
    else { $shv_tmp =~ s/$_[1]/$_[2]/ }
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = $shv_tmp;
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for replace: expected %s, got value %s",
                    "Str", $shv_final_unchecked
                  );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< replace_globally( $string, $regexp, $replacement ) >>

Additional arguments: B<< Str|RegexpRef >>, B<< Str|CodeRef >>.

Replaces the all regexp matches within the string with the replacement string.

=cut

sub replace_globally {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 3
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "replace_globally", scalar(@_), "expected exactly 3 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
"Type check failed in signature for replace_globally: %s should be %s",
            "\$_[0]", "Str"
          );

        # Parameter $_[1] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[1] ) and do {
                        ref( \$_[1] ) eq 'SCALAR'
                          or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[1] ) && !!re::is_regexp( $_[1] )
                          or Scalar::Util::blessed( $_[1] )
                          && $_[1]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
"Type check failed in signature for replace_globally: %s should be %s",
            "\$_[1]", "Str|RegexpRef"
          );

        # Parameter $_[2] (type: Str|CodeRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[2] ) and do {
                        ref( \$_[2] ) eq 'SCALAR'
                          or ref( \( my $val = $_[2] ) ) eq 'SCALAR';
                    }
                  }
                  or ( ref( $_[2] ) eq 'CODE' )
            );
          }
          or Hydrogen::croak(
"Type check failed in signature for replace_globally: %s should be %s",
            "\$_[2]", "Str|CodeRef"
          );

        (@_);
    };
    my $shv_tmp = $$__REF__;
    if ( ( ref( $_[2] ) eq 'CODE' ) ) {
        my $shv_callback = $_[2];
        $shv_tmp =~ s/$_[1]/$shv_callback->()/eg;
    }
    else { $shv_tmp =~ s/$_[1]/$_[2]/g }
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = $shv_tmp;
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
"Type check failed for replace_globally: expected %s, got value %s",
                    "Str", $shv_final_unchecked
                  );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< reset( $string ) >>

Resets the original value to its default value, or an empty string if it has no default.

=cut

sub reset {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for reset; usage: "
          . "Hydrogen::String::reset( \$string )" );
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = q{};
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for reset: expected %s, got value %s",
                    "Str", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< set( $string, $value ) >>

Additional arguments: B<< Str >>.

Sets the string to a new value.

=cut

sub set {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "set", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = $_[1];
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for set: expected %s, got value %s",
                    "Str", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< starts_with( $string, $head ) >>

Additional arguments: B<< Str >>.

Returns true iff the string starts with C<< $head >>.

=cut

sub starts_with {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "starts_with", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for starts_with: %s should be %s",
            "\$_[0]", "Str" );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for starts_with: %s should be %s",
            "\$_[1]", "Str" );

        (@_);
    };
    substr( $$__REF__, 0, length $_[1] ) eq $_[1];
}

=head2 C<< starts_with_i( $string, $head ) >>

Additional arguments: B<< Str >>.

Returns true iff the string starts with C<< $head >> case-insensitvely.

=cut

sub starts_with_i {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "starts_with_i", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for starts_with_i: %s should be %s",
            "\$_[0]", "Str"
          );

        # Parameter $_[1] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[1] ) and do {
                ref( \$_[1] ) eq 'SCALAR'
                  or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for starts_with_i: %s should be %s",
            "\$_[1]", "Str"
          );

        (@_);
    };
    Hydrogen::fc( substr( $$__REF__, 0, length $_[1] ) ) eq Hydrogen::fc( $_[1] );
}

=head2 C<< substr( $string, $start, $length?, $replacement? ) >>

Additional arguments: B<< Int >>, B<< Optional[Int] >>, B<< Optional[Str] >>.

Like C<substr> from L<perlfunc>, but is not an lvalue.

=cut

{
    my $__signature;

    sub substr {
        my $__REF__ = \$_[0];

        package Hydrogen::String::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 2 && @_ <= 4
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "substr", scalar(@_), "expected exactly 2 parameters" );

            # Parameter $_[0] (type: Str)
            do {

                package Hydrogen::String::__SANDBOX__;
                defined( $_[0] ) and do {
                    ref( \$_[0] ) eq 'SCALAR'
                      or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[0]", "Str" );

            # Parameter $_[1] (type: Int)
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[1]", "Int" );

            # Parameter $_[2] (type: Optional[Int])
            $#_ >= 2
              or return (@_);
            (
                do {
                    my $tmp = $_[2];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[2]", "Optional[Int]" );

            # Parameter $_[3] (type: Optional[Str])
            $#_ >= 3
              or return (@_);
            do {

                package Hydrogen::String::__SANDBOX__;
                defined( $_[3] ) and do {
                    ref( \$_[3] ) eq 'SCALAR'
                      or ref( \( my $val = $_[3] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[3]", "Optional[Str]" );

            (@_);
        };
        @_ = &$__signature;
        if    ( ( @_ - 1 ) == 1 ) { substr( $$__REF__, $_[1] ) }
        elsif ( ( @_ - 1 ) == 2 ) { substr( $$__REF__, $_[1], $_[2] ) }
        elsif ( ( @_ - 1 ) == 3 ) {
            my $shv_tmp    = $$__REF__;
            my $shv_return = substr( $shv_tmp, $_[1], $_[2], $_[3] );
            (
                ${$__REF__} = do {
                    my $shv_final_unchecked = $shv_tmp;
                    do {
                        do {

                            package Hydrogen::String::__SANDBOX__;
                            defined($shv_final_unchecked) and do {
                                ref( \$shv_final_unchecked ) eq 'SCALAR'
                                  or ref( \( my $val = $shv_final_unchecked ) )
                                  eq 'SCALAR';
                            }
                          }
                          or Hydrogen::croak(
"Type check failed for substr: expected %s, got value %s",
                            "Str", $shv_final_unchecked
                          );
                        $shv_final_unchecked;
                    };
                }
            );
            $shv_return;
        }
    }
}

=head2 C<< uc( $string ) >>

Returns C<< uc($string) >>.

=cut

sub uc {
    my $__REF__ = \$_[0];

    package Hydrogen::String::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for uc; usage: "
          . "Hydrogen::String::uc( \$string )" );
    uc($$__REF__);
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all (this is usually a bad idea), use:

    use Hydrogen::String -all;

To import a particular function, use:

    use Hydrogen::String 'chop';

To rename functions:

    use Hydrogen::String 'chop' => { -as => 'myfunc' };

On Perl 5.37.2+, you can import lexically:

    use Hydrogen::String -lexical, 'chop';

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::Curry::String>,
L<Hydrogen::Topic::String>,
L<Sub::HandlesVia::HandlerLibrary::String>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

