#!/usr/bin/env perl

use strict;
use warnings;

use Test::More;
use Blockchain::Ethereum::ABI::Encoder;
use Blockchain::Ethereum::ABI::Decoder;

subtest "Dynamic" => sub {
    my $encoder   = Blockchain::Ethereum::ABI::Encoder->new;
    my $addresses = [
        '0x0000000000000000000000000000000000000000', '0x0000000000000000000000000000000000000001',
        '0x0000000000000000000000000000000000000002', '0x0000000000000000000000000000000000000003',
        '0x0000000000000000000000000000000000000004', '0x0000000000000000000000000000000000000005',
        '0x0000000000000000000000000000000000000006', '0x0000000000000000000000000000000000000007',
        '0x0000000000000000000000000000000000000008', '0x0000000000000000000000000000000000000009',
        '0x0000000000000000000000000000000000000010', '0x0000000000000000000000000000000000000011',
        '0x0000000000000000000000000000000000000012', '0x0000000000000000000000000000000000000013',
        '0x0000000000000000000000000000000000000014', '0x0000000000000000000000000000000000000015',
        '0x0000000000000000000000000000000000000016', '0x0000000000000000000000000000000000000017',
    ];
    $encoder->function('foo')->append('address[]' => $addresses);
    my $encoded = $encoder->encode;

    my $encoded_expected =
        '0x13cb49d400000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000012000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000300000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000005000000000000000000000000000000000000000000000000000000000000000600000000000000000000000000000000000000000000000000000000000000070000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000900000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000001200000000000000000000000000000000000000000000000000000000000000130000000000000000000000000000000000000000000000000000000000000014000000000000000000000000000000000000000000000000000000000000001500000000000000000000000000000000000000000000000000000000000000160000000000000000000000000000000000000000000000000000000000000017';
    is $encoded, $encoded_expected;

    my $decoder = Blockchain::Ethereum::ABI::Decoder->new;

    my $decoded = $decoder->append('address[]')->decode(substr $encoded_expected, 10);
    is_deeply $decoded->[0], $addresses;
};

done_testing;

