# Generated by default/object.tt
package Paws::IoTAnalytics::DatastorePartition;
  use Moose;
  has AttributePartition => (is => 'ro', isa => 'Paws::IoTAnalytics::Partition', request_name => 'attributePartition', traits => ['NameInRequest']);
  has TimestampPartition => (is => 'ro', isa => 'Paws::IoTAnalytics::TimestampPartition', request_name => 'timestampPartition', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTAnalytics::DatastorePartition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTAnalytics::DatastorePartition object:

  $service_obj->Method(Att1 => { AttributePartition => $value, ..., TimestampPartition => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTAnalytics::DatastorePartition object:

  $result = $service_obj->Method(...);
  $result->Att1->AttributePartition

=head1 DESCRIPTION

A single partition in a data store.

=head1 ATTRIBUTES


=head2 AttributePartition => L<Paws::IoTAnalytics::Partition>

A partition defined by an C<attributeName>.


=head2 TimestampPartition => L<Paws::IoTAnalytics::TimestampPartition>

A partition defined by an C<attributeName> and a timestamp format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

