### The Blue Dither algorithm itself (acting on RGBA values of the pixels)

use 'GFX-Tools-Buffer::matrix'; ### uses this math matrix class !

sub new {
    my $class = shift;

    $self = { percentage => 0.1, }; ### amount of dither 

    bless $self, $class;

}

sub setPercentage {
  my ($self, $p) = @_;

  $self->{percentage} = $p;
}

sub ditherBlue {
  my ($self, $matrixbitmapobj) = @_;

  my $matrix = $matrixbitmapobj->getMatrix;
  
  my $pngbppmultiplynumber = 4; ### R,G,B and A
    
    for (my $j = 0; $j < $matrix->getRowsNumber * $pngbppmultiplynumber; $j++) {
      for (my $i = 0; $i < $matrix->getColumnsNumber; $i++) {
	for (my $rgbanumber = $pngbppmultiplynumber; $rgbanumber > 0; $rgbanumber--) {
	  if ($rgbanumber == 3) { ### choose blue in the matrix
	    $matrix->setAtIndex($j, $i, hex(@rowofbytes[$j][$i]));
	}
      }
    }
  
  ### NOTE : returns a class
  return MatrixBitmap->new->setMatrix($matrix);
}

1;
