### Blue dither algorithm, real filter

use parent 'OnePassBitmapAlgorithm';

sub new {
    my $class = shift;

    $self = SUPER::OnePassBitmapAlgorithm->new;
    
    bless $self, $class;

    $self->init; ### sets bitmap undef, componentsbag new
}

sub addBitmap { ### sets bitmapmatrix
  my ($self, $bitmap) = @_;

  defined($bitmap) or die "OnePassFilterAlgorithmBlue : bitmap of the blue dither algorithm is empty !";
  
  $self->{bitmap} = $bitmap;
}

### returns a matrixbitmap, unwritten to file
sub pass {
  my ($self, $pngfilename) = @_;

  ### 1 of el1 means one follower
  my $secondel1 = BlueDitherComponent->new;
  my $firstel1 = MatrixBitmapLoaderComponent->new->setNext($secondel1);
  $self->addBagElement1($firstel1);
  
  return SUPER::OnePassBitmapAlgorithm->pass->(OnePassSystemBlue->new($pngfilename)); 
}

1;

