########################################################################
# Verifies Notepad object messages / methods work
#   subgroup: meta-information methods
########################################################################
use 5.010;
use strict;
use warnings;
use Test::More;
use Win32;
use version;

use FindBin;
BEGIN { my $f = $FindBin::Bin . '/nppPath.inc'; require $f if -f $f; }

use lib $FindBin::Bin;
use myTestHelpers qw/runCodeAndClickPopup :userSession/;

use Path::Tiny 0.018 qw/path tempfile/;

use Win32::Mechanize::NotepadPlusPlus qw/:main :vars/;

my $EmergencySessionHash;
BEGIN { $EmergencySessionHash = saveUserSession(); }
END { restoreUserSession( $EmergencySessionHash ); }


# need a safe dummy file with known values (for the getNppVar tests)
our $fnew1 = tempfile( TEMPLATE => 'nppNewFile_XXXXXXXX', SUFFIX => '.txt'); note $fnew1->canonpath();
notepad->closeAll(); # don't want to affect existing files
editor->addText("MetaFile\n");
editor->addText( $fnew1->absolute->canonpath() );
notepad->saveAs( $fnew1->absolute->canonpath() );
editor->gotoPos( editor->getFileEndPosition() );

my $ret;
$ret = notepad()->getNppVersion;
like $ret, qr/^v\d+[\.\d]*$/, 'getNppVersion';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';
my $ver = version->parse($ret); # save for later

$ret = notepad()->getPluginVersion;
like $ret, qr/v\d+\.[\._\d]+/, 'getPluginVersion';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getPerlVersion;
ok $ret, 'getPerlVersion';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';
$ret = notepad()->getPerlBits;
ok $ret, 'getPerlBits';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppDir;
ok $ret, 'getNppDir';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getPluginConfigDir;
ok $ret, 'getPluginConfigDir';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

# 2020-Mar-17: add getNppVar()
$ret = notepad()->getNppVar( $INTERNALVAR{CURRENT_LINE} );
ok $ret, 'getNppVar(CURRENT_LINE)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

SKIP: {
    skip "getNppVar(CURRENT_LINESTR) not implemented in $ver", 1 if $ver < version->parse(v8.3.2);

    $ret = notepad()->getNppVar( $INTERNALVAR{CURRENT_LINESTR} );
    ok $ret, 'getNppVar(CURRENT_LINESTR)';
        note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';
}

$ret = notepad()->getNppVar( $INTERNALVAR{CURRENT_COLUMN} );
ok $ret, 'getNppVar(CURRENT_COLUMN)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{FULL_CURRENT_PATH} );
ok $ret, 'getNppVar(FULL_CURRENT_PATH)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{CURRENT_DIRECTORY} );
ok $ret, 'getNppVar(CURRENT_DIRECTORY)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{FILE_NAME} );
ok $ret, 'getNppVar(FILE_NAME)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{NAME_PART} );
ok $ret, 'getNppVar(NAME_PART)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{EXT_PART} );
ok $ret, 'getNppVar(EXT_PART)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{CURRENT_WORD} );
ok $ret, 'getNppVar(CURRENT_WORD)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{NPP_DIRECTORY} );
ok $ret, 'getNppVar(NPP_DIRECTORY)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

$ret = notepad()->getNppVar( $INTERNALVAR{NPP_FULL_FILE_PATH} );
ok $ret, 'getNppVar(NPP_FULL_FILE_PATH)';
    note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';

SKIP: {
    skip "getSettingsOnCloudPath() not implemented in $ver", 1 if $ver < version->parse(v7.9.2);
    my $exp_len = notepad()->SendMessage( $NPPMSG{NPPM_GETSETTINGSONCLOUDPATH} , 0 );
        note sprintf "\t=> \"%s\"", defined $exp_len ? explain $exp_len : '<undef>';
    my $path = notepad()->getSettingsOnCloudPath();
        note sprintf "\t=> \"%s\"", defined $path ? explain $path : '<undef>';
    is $exp_len, length($path), 'getSettingsOnCloudPath matches expected length';
}


$ret = notepad->getDebugInfo();
ok $ret, 'getDebugInfo()';
ok UNIVERSAL::isa($ret, 'HASH'), 'getDebugInfo(): is hashref';
    note sprintf "\tkeys => (%s)\n", join ', ', sort keys %$ret;
ok exists $ret->{-APP}, 'getDebugInfo(): contains key -APP';

$ret = notepad->getDebugInfo('-APP');
like $ret, qr/\QNotepad++\E/i, 'getDebugInfo("-APP") returns Notepad++';

my ($p, $a) = notepad->getDebugInfo('path', 'Admin Mode');
like $p, qr/\Qnotepad++.exe\E/i, 'getDebugInfo(path, Admin Mode) => path contains executable';
like $a, qr/(ON|OFF)/i, 'getDebugInfo(path, Admin Mode) => mode is on or off';
    note sprintf "\tpath => %s\n\tAdmin mode => %s\n", $p, $a;

$ret = notepad()->getCommandLine;
if($ver < version->parse(v8.0.0)) {
	is $ret, undef, "getCommandLine expects undef for $ver";
} else {
	isnt $ret, undef, "getCommandLine expects defined for $ver";
}
note sprintf "\t=> \"%s\"", defined $ret ? explain $ret : '<undef>';


done_testing;
