package HashData::ColorCode::CMYK::ToutesLesCouleursCom::Green;

use strict;
use Role::Tiny::With;
with 'HashDataRole::Source::LinesInDATA';
#with 'Role::TinyCommons::Collection::FindItem::Iterator';         # add find_item() (has_item already added above)
#with 'Role::TinyCommons::Collection::PickItems::RandomSeekLines'; # add pick_items() that uses binary search

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-10'; # DATE
our $DIST = 'HashData-ColorCode-CMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.002'; # VERSION

# STATS

1;
# ABSTRACT: Green CMYK color names (from ToutesLesCouleursCom)

=pod

=encoding UTF-8

=head1 NAME

HashData::ColorCode::CMYK::ToutesLesCouleursCom::Green - Green CMYK color names (from ToutesLesCouleursCom)

=head1 VERSION

This document describes version 0.002 of HashData::ColorCode::CMYK::ToutesLesCouleursCom::Green (from Perl distribution HashData-ColorCode-CMYK-ToutesLesCouleursCom), released on 2024-05-10.

=head1 DESCRIPTION

CMKY value are in this format: I<C>,I<M>,I<Y>,I<K>. Where each C/M/Y/K value is
an integer from 0 to 100.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/HashData-ColorCode-CMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-HashData-Color-CMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Source: L<https://www.toutes-les-couleurs.com/en/CMYK-color-code.php>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=HashData-ColorCode-CMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
green:100,0,100,0
aquamarine:51,0,0,3
asparagus:23,0,43,37
teal:100,0,0,44
duck:97,10,0,40
celadon:21,0,9,35
frosted:38,0,0,18
murky:35,0,12,39
hooker:66,0,90,69
jade:42,0,38,9
khaki:0,13,71,42
peppermint:88,0,58,28
water mint:66,0,43,2
sinople:86,0,86,42
turquoise:85,0,8,1
vert absinthe:43,0,66,13
green almond:34,0,45,23
english green:58,0,47,78
anise green:37,0,92,0
green lawyer:34,0,98,49
green bottle:92,0,92,58
green chartreuse:21,0,80,3
lime:100,0,100,0
chrome green:58,0,47,78
verdigris:10,0,10,35
sap green:72,0,88,53
green water:27,0,25,5
emerald green:100,0,59,16
green empire:100,0,69,66
green spinach:41,0,0,69
green grass:63,0,78,38
green imperial:100,0,69,66
green khaki:12,0,63,46
lichen green:31,0,35,24
lime green:38,0,78,1
malachite green:81,0,47,37
larch green:50,0,35,56
military green:13,0,34,60
moss:35,0,43,38
olive:21,0,75,45
green opaline:32,0,11,13
green parrot:76,0,69,5
pine green:99,0,8,53
pistachio green:22,0,53,4
green leek:54,0,36,35
apple green:74,0,82,21
green meadow:59,0,72,16
green prasin:54,0,36,35
spring green:100,0,50,0
forest green:89,0,51,68
sage green:34,0,28,38
green smaragdin:100,0,59,16
green lime:21,0,61,18
veronese green:21,0,59,56
viride green:51,0,16,49
