/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_dataview.h"

        #include <wx/dataview.h>

        #include <wx/event.h>
        #include <wx/dataobj.h>
        #include <wx/dataobj.h>
        #include <wx/dataview.h>
        #include <wx/dataview.h>
        #include <wx/dataview.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    PyObject* _wxDataViewEvent_GetDataBuffer(const wxDataViewEvent* self)
    {
        wxPyThreadBlocker blocker;
        return wxPyMakeBuffer(self->GetDataBuffer(), self->GetDataSize(), true);
    }


class sipwxDataViewEvent : public  ::wxDataViewEvent
{
public:
    sipwxDataViewEvent( ::wxEventType,int);
    sipwxDataViewEvent(const  ::wxDataViewEvent&);
    virtual ~sipwxDataViewEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEvent* Clone() const SIP_OVERRIDE;
     ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxDataViewEvent(const sipwxDataViewEvent &);
    sipwxDataViewEvent &operator = (const sipwxDataViewEvent &);

    char sipPyMethods[2];
};

sipwxDataViewEvent::sipwxDataViewEvent( ::wxEventType commandType,int winid):  ::wxDataViewEvent(commandType,winid), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxDataViewEvent::sipwxDataViewEvent(const  ::wxDataViewEvent& a0):  ::wxDataViewEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxDataViewEvent::~sipwxDataViewEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxEvent* sipwxDataViewEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,SIP_NULLPTR,sipName_Clone);

    if (!sipMeth)
        return  ::wxDataViewEvent::Clone();

    extern  ::wxEvent* sipVH__dataview_58(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__dataview_58(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEventCategory sipwxDataViewEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,SIP_NULLPTR,sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxDataViewEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__dataview_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__dataview_57(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetColumn, "GetColumn() -> int\n"
"\n"
"Returns the position of the column in the control or -1 if no column\n"
"field was set by the event emitter.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetColumn(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetColumn(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumn();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDataViewColumn, "GetDataViewColumn() -> DataViewColumn\n"
"\n"
"Returns a pointer to the wxDataViewColumn from which the event was\n"
"emitted or NULL.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDataViewColumn(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDataViewColumn(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDataViewColumn*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDataViewColumn();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDataViewColumn,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDataViewColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetModel, "GetModel() -> DataViewModel\n"
"\n"
"Returns the wxDataViewModel associated with the event.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetModel(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetModel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDataViewModel*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetModel();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDataViewModel,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetModel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetPosition, "GetPosition() -> wx.Point\n"
"\n"
"Returns the position of a context menu event in screen coordinates.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->GetPosition());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetValue, "GetValue() -> DVCVariant\n"
"\n"
"Returns a reference to a value.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDVCVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDVCVariant(sipCpp->GetValue());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDVCVariant,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_IsEditCancelled, "IsEditCancelled() -> bool\n"
"\n"
"Can be used to determine whether the new value is going to be accepted\n"
"in wxEVT_DATAVIEW_ITEM_EDITING_DONE handler.");

extern "C" {static PyObject *meth_wxDataViewEvent_IsEditCancelled(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_IsEditCancelled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEditCancelled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_IsEditCancelled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetColumn, "SetColumn(col)\n"
"\n"
"Sets the column index associated with this event.");

extern "C" {static PyObject *meth_wxDataViewEvent_SetColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int col;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &col))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColumn(col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDataViewColumn, "SetDataViewColumn(col)\n"
"\n"
"For wxEVT_DATAVIEW_COLUMN_HEADER_CLICK only.");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDataViewColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDataViewColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataViewColumn* col;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDataViewColumn, &col))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDataViewColumn(col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDataViewColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetModel, "SetModel(model)\n"
"\n"
"Sets the dataview model associated with this event.");

extern "C" {static PyObject *meth_wxDataViewEvent_SetModel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetModel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataViewModel* model;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_model,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDataViewModel, &model))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetModel(model);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetModel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetValue, "SetValue(value)\n"
"\n"
"Sets the value associated with this event.");

extern "C" {static PyObject *meth_wxDataViewEvent_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDVCVariant* value;
        int valueState = 0;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDVCVariant,&value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDVCVariant *>(value),sipType_wxDVCVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDataObject, "SetDataObject(obj)\n"
"\n"
"Set wxDataObject for data transfer within a drag operation.");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDataObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDataObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataObject* obj;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDataObject, &obj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDataObject(obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDataObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDataFormat, "GetDataFormat() -> wx.DataFormat\n"
"\n"
"Gets the wxDataFormat during a drop operation.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDataFormat(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDataFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDataFormat*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDataFormat(sipCpp->GetDataFormat());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDataFormat,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDataFormat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDataSize, "GetDataSize() -> size_t\n"
"\n"
"Gets the data size for a drop data transfer.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDataSize(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDataSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDataSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDataSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDataBuffer, "GetDataBuffer() -> PyObject\n"
"\n"
"Gets the data buffer for a drop data transfer");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDataBuffer(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDataBuffer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDataViewEvent_GetDataBuffer(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDataBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDragFlags, "SetDragFlags(flags)\n"
"\n"
"Specify the kind of the drag operation to perform.");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDragFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDragFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDragFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDragFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDropEffect, "GetDropEffect() -> DragResult\n"
"\n"
"Returns the effect the user requested to happen to the dropped data.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDropEffect(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDropEffect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDragResult sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDropEffect();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDragResult);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDropEffect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetCacheFrom, "GetCacheFrom() -> int\n"
"\n"
"Return the first row that will be displayed.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetCacheFrom(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetCacheFrom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCacheFrom();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetCacheFrom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetCacheTo, "GetCacheTo() -> int\n"
"\n"
"Return the last row that will be displayed.");

extern "C" {static PyObject *meth_wxDataViewEvent_GetCacheTo(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetCacheTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCacheTo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetCacheTo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetItem, "GetItem() -> DataViewItem");

extern "C" {static PyObject *meth_wxDataViewEvent_GetItem(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetItem(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDataViewItem*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxDataViewItem(sipCpp->GetItem());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxDataViewItem,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetItem, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetItem, "SetItem(item)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetItem(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetItem(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewItem* item;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDataViewItem, &item))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetItem(*item);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetItem, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetEditCanceled, "SetEditCanceled(editCancelled)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetEditCanceled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetEditCanceled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool editCancelled;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_editCancelled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &editCancelled))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEditCanceled(editCancelled);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetEditCanceled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetPosition, "SetPosition(x, y)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int x;
        int y;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetCache, "SetCache(from_, to_)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetCache(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetCache(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int from_;
        int to_;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &from_, &to_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCache(from_,to_);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetCache, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDataObject, "GetDataObject() -> wx.DataObject");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDataObject(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDataObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxDataObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDataObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDataObject,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDataObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDataFormat, "SetDataFormat(format)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDataFormat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDataFormat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataFormat* format;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDataFormat, &format))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDataFormat(*format);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDataFormat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDataSize, "SetDataSize(size)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDataSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDataSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t size;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &size))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDataSize(size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDataSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDataBuffer, "SetDataBuffer(buf)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDataBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDataBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        void* buf;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv", &sipSelf, sipType_wxDataViewEvent, &sipCpp, &buf))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDataBuffer(buf);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDataBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_GetDragFlags, "GetDragFlags() -> int");

extern "C" {static PyObject *meth_wxDataViewEvent_GetDragFlags(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_GetDragFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDragFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_GetDragFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_SetDropEffect, "SetDropEffect(effect)");

extern "C" {static PyObject *meth_wxDataViewEvent_SetDropEffect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_SetDropEffect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDragResult effect;
         ::wxDataViewEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_effect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxDataViewEvent, &sipCpp, sipType_wxDragResult, &effect))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDropEffect(effect);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_SetDropEffect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewEvent_Clone, "Clone(self) -> Event");

extern "C" {static PyObject *meth_wxDataViewEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataViewEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewEvent, sipName_Clone, doc_wxDataViewEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxDataViewEvent(void *, const sipTypeDef *);}
static void *cast_wxDataViewEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxDataViewEvent *sipCpp = reinterpret_cast< ::wxDataViewEvent *>(sipCppV);

    if (targetType == sipType_wxNotifyEvent)
        return static_cast< ::wxNotifyEvent *>(sipCpp);

    if (targetType == sipType_wxCommandEvent)
        return static_cast< ::wxCommandEvent *>(sipCpp);

    if (targetType == sipType_wxEvent)
        return static_cast< ::wxEvent *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDataViewEvent(void *, int);}
static void release_wxDataViewEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxDataViewEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxDataViewEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxDataViewEvent(sipSimpleWrapper *);}
static void dealloc_wxDataViewEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxDataViewEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDataViewEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxDataViewEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxDataViewEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxDataViewEvent *sipCpp = SIP_NULLPTR;

    {
         ::wxEventType commandType = wxEVT_NULL;
        int winid = 0;

        static const char *sipKwdList[] = {
            sipName_commandType,
            sipName_winid,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &commandType, &winid))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxDataViewEvent(commandType,winid);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxDataViewEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxDataViewEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxDataViewEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxDataViewEvent[] = {{23, 0, 1}};


static PyMethodDef methods_wxDataViewEvent[] = {
    {SIP_MLNAME_CAST(sipName_Clone), meth_wxDataViewEvent_Clone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_Clone)},
    {SIP_MLNAME_CAST(sipName_GetCacheFrom), meth_wxDataViewEvent_GetCacheFrom, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetCacheFrom)},
    {SIP_MLNAME_CAST(sipName_GetCacheTo), meth_wxDataViewEvent_GetCacheTo, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetCacheTo)},
    {SIP_MLNAME_CAST(sipName_GetColumn), meth_wxDataViewEvent_GetColumn, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetColumn)},
    {SIP_MLNAME_CAST(sipName_GetDataBuffer), meth_wxDataViewEvent_GetDataBuffer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDataBuffer)},
    {SIP_MLNAME_CAST(sipName_GetDataFormat), meth_wxDataViewEvent_GetDataFormat, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDataFormat)},
    {SIP_MLNAME_CAST(sipName_GetDataObject), meth_wxDataViewEvent_GetDataObject, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDataObject)},
    {SIP_MLNAME_CAST(sipName_GetDataSize), meth_wxDataViewEvent_GetDataSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDataSize)},
    {SIP_MLNAME_CAST(sipName_GetDataViewColumn), meth_wxDataViewEvent_GetDataViewColumn, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDataViewColumn)},
    {SIP_MLNAME_CAST(sipName_GetDragFlags), meth_wxDataViewEvent_GetDragFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDragFlags)},
    {SIP_MLNAME_CAST(sipName_GetDropEffect), meth_wxDataViewEvent_GetDropEffect, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetDropEffect)},
    {SIP_MLNAME_CAST(sipName_GetItem), meth_wxDataViewEvent_GetItem, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetItem)},
    {SIP_MLNAME_CAST(sipName_GetModel), meth_wxDataViewEvent_GetModel, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetModel)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxDataViewEvent_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetPosition)},
    {SIP_MLNAME_CAST(sipName_GetValue), meth_wxDataViewEvent_GetValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_GetValue)},
    {SIP_MLNAME_CAST(sipName_IsEditCancelled), meth_wxDataViewEvent_IsEditCancelled, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewEvent_IsEditCancelled)},
    {SIP_MLNAME_CAST(sipName_SetCache), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetCache), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetCache)},
    {SIP_MLNAME_CAST(sipName_SetColumn), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetColumn), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetColumn)},
    {SIP_MLNAME_CAST(sipName_SetDataBuffer), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDataBuffer), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDataBuffer)},
    {SIP_MLNAME_CAST(sipName_SetDataFormat), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDataFormat), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDataFormat)},
    {SIP_MLNAME_CAST(sipName_SetDataObject), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDataObject), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDataObject)},
    {SIP_MLNAME_CAST(sipName_SetDataSize), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDataSize), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDataSize)},
    {SIP_MLNAME_CAST(sipName_SetDataViewColumn), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDataViewColumn), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDataViewColumn)},
    {SIP_MLNAME_CAST(sipName_SetDragFlags), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDragFlags), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDragFlags)},
    {SIP_MLNAME_CAST(sipName_SetDropEffect), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetDropEffect), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetDropEffect)},
    {SIP_MLNAME_CAST(sipName_SetEditCanceled), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetEditCanceled), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetEditCanceled)},
    {SIP_MLNAME_CAST(sipName_SetItem), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetItem), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetItem)},
    {SIP_MLNAME_CAST(sipName_SetModel), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetModel), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetModel)},
    {SIP_MLNAME_CAST(sipName_SetPosition), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetPosition), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetPosition)},
    {SIP_MLNAME_CAST(sipName_SetValue), SIP_MLMETH_CAST(meth_wxDataViewEvent_SetValue), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewEvent_SetValue)}
};

sipVariableDef variables_wxDataViewEvent[] = {
    {PropertyVariable, sipName_EditCancelled, &methods_wxDataViewEvent[15], &methods_wxDataViewEvent[25], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxDataViewEvent, "DataViewEvent(commandType=wx.wxEVT_NULL, winid=0)\n"
"\n"
"This is the event class for the wxDataViewCtrl notifications.");


sipClassTypeDef sipTypeDef__dataview_wxDataViewEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxDataViewEvent,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_DataViewEvent,
        {0, 0, 1},
        30, methods_wxDataViewEvent,
        0, SIP_NULLPTR,
        1, variables_wxDataViewEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDataViewEvent,
    -1,
    -1,
    supers_wxDataViewEvent,
    SIP_NULLPTR,
    init_type_wxDataViewEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxDataViewEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxDataViewEvent,
    cast_wxDataViewEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
