/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.CurrentJarUnpacker;
import $installer$.org.aspectj.Installer;
import $installer$.org.aspectj.LaunchScriptMaker;
import $installer$.org.aspectj.WizardPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class InstallPane
extends WizardPane {
    private JProgressBar progressBar;
    private JTextField progressItem;
    private JEditorPane message;
    private boolean makeLaunchScripts = false;
    int nBytes = 0;
    int bytesWritten = 0;

    public InstallPane(boolean makeLaunchScripts) {
        this.makeLaunchScripts = makeLaunchScripts;
    }

    @Override
    public JPanel makePanel() {
        this.message = this.makeHTMLArea("install-start.html");
        this.progressBar = new JProgressBar();
        this.progressItem = new JTextField();
        this.progressItem.setOpaque(false);
        this.progressItem.setFont(context.getFont());
        this.progressItem.setEditable(false);
        GridBagLayout bag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(bag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        bag.setConstraints(this.message, c);
        panel.add(this.message);
        c.weighty = 0.0;
        bag.setConstraints(this.progressBar, c);
        panel.add(this.progressBar);
        c.weighty = 0.1;
        JLabel space = new JLabel();
        bag.setConstraints(space, c);
        panel.add(space);
        c.weighty = 0.0;
        bag.setConstraints(this.progressItem, c);
        panel.add(this.progressItem);
        c.weighty = 0.5;
        space = new JLabel();
        bag.setConstraints(space, c);
        panel.add(space);
        return panel;
    }

    @Override
    public Component makeButtons(Installer installer2) {
        Component ret = super.makeButtons(installer2);
        this.nextButton.setEnabled(false);
        this.backButton.setEnabled(false);
        return ret;
    }

    @Override
    public void run() {
        Thread thread = new Thread(new InstallRunner());
        thread.start();
    }

    public void progressMessage(final String message) {
        if (!this.hasGui()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    InstallPane.this.progressItem.setText(message);
                }
            });
        }
        catch (InvocationTargetException ite) {
            context.handleException(ite.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void progressBytesWritten(int bytes) {
        if (!this.hasGui()) {
            return;
        }
        this.bytesWritten += bytes;
        final int PCT = (int)(100.0 * (double)this.bytesWritten / (double)this.nBytes);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    InstallPane.this.progressBar.setValue(PCT);
                }
            });
        }
        catch (InvocationTargetException ite) {
            context.handleException(ite.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class InstallRunner
    implements Runnable {
        @Override
        public void run() {
            try {
                new CurrentJarUnpacker(WizardPane.context, InstallPane.this).unpack("resources/contents.txt", WizardPane.context.getOutputDir());
                if (InstallPane.this.makeLaunchScripts) {
                    LaunchScriptMaker lsm = new LaunchScriptMaker(WizardPane.context);
                    lsm.writeScript("ajc");
                    lsm.writeScript("ajdoc");
                    lsm.writeScript("ajbrowser");
                    lsm.writeAJLaunchScript("aj", false);
                    lsm.writeAJLaunchScript("aj5", true);
                }
                if (InstallPane.this.hasGui()) {
                    InstallPane.this.progressBar.setValue(100);
                    InstallPane.this.setHTMLArea(InstallPane.this.message, "install-finish.html");
                }
            }
            catch (IOException ioe) {
                WizardPane.context.handleException(ioe);
            }
            if (InstallPane.this.hasGui()) {
                InstallPane.this.cancelButton.setEnabled(false);
                InstallPane.this.nextButton.setEnabled(true);
            }
        }
    }
}

