/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "user.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_USER_USER_H
#define AB_USER_USER_H


#ifdef __cplusplus
extern "C" {
#endif

/** @page P_AB_USER Structure AB_USER
<p>This page describes the properties of AB_USER.</p>



<h1>AB_USER</h1>

This type contains basic information about users. All text fields are in UTF-8.


<h2>Identifiers</h2>



@anchor AB_USER_uniqueId
<h3>uniqueId</h3>

This is a unique id assigned by AqBanking.
<p>Set this property with @ref AB_User_SetUniqueId(), get it with @ref AB_User_GetUniqueId().</p>


<h2>Common Information</h2>



@anchor AB_USER_backendName
<h3>backendName</h3>

Name of the banking backend this account belongs to.
<p>Set this property with @ref AB_User_SetBackendName(), get it with @ref AB_User_GetBackendName().</p>


@anchor AB_USER_userName
<h3>userName</h3>

Clear name of the user.
<p>Set this property with @ref AB_User_SetUserName(), get it with @ref AB_User_GetUserName().</p>


<h2>Information Provided by Banks</h2>



@anchor AB_USER_userId
<h3>userId</h3>

user id assigned by the bank
<p>Set this property with @ref AB_User_SetUserId(), get it with @ref AB_User_GetUserId().</p>


@anchor AB_USER_customerId
<h3>customerId</h3>

customer id assigned by the bank (in many cases same as user id)
<p>Set this property with @ref AB_User_SetCustomerId(), get it with @ref AB_User_GetCustomerId().</p>


@anchor AB_USER_country
<h3>country</h3>

<p>Set this property with @ref AB_User_SetCountry(), get it with @ref AB_User_GetCountry().</p>


@anchor AB_USER_bankCode
<h3>bankCode</h3>

National bank code (e.g. BLZ in Germany, routing number in other countries).
<p>Set this property with @ref AB_User_SetBankCode(), get it with @ref AB_User_GetBankCode().</p>


<h2>Internal Data</h2>



@anchor AB_USER_provider
<h3>provider</h3>

<p>Set this property with @ref AB_User_SetProvider(), get it with @ref AB_User_GetProvider().</p>


@anchor AB_USER_certDb
<h3>certDb</h3>

<p>Set this property with @ref AB_User_SetCertDb(), get it with @ref AB_User_GetCertDb().</p>


@anchor AB_USER_lastSessionId
<h3>lastSessionId</h3>

Last session id for this user.
<p>Set this property with @ref AB_User_SetLastSessionId(), get it with @ref AB_User_GetLastSessionId().</p>

*/

/* needed system headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/list1.h>
#include <gwenhywfar/list2.h>
#include <gwenhywfar/inherit.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

/* pre-headers */
#include <aqbanking/error.h>
#include <gwenhywfar/mdigest.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/buffer.h>

typedef struct AB_USER AB_USER;
GWEN_LIST_FUNCTION_DEFS(AB_USER, AB_User)
GWEN_LIST2_FUNCTION_DEFS(AB_USER, AB_User)
GWEN_INHERIT_FUNCTION_DEFS(AB_USER)



/* post-headers */
#include <aqbanking/backendsupport/provider.h>


/* definitions for virtual functions (post) */
typedef int  (*AB_USER_READFROMDB_FN)(AB_USER *p_struct, GWEN_DB_NODE* dbData);

typedef int  (*AB_USER_WRITETODB_FN)(const AB_USER *p_struct, GWEN_DB_NODE* dbData);

/** Constructor. */
AB_USER *AB_User_new(void);

/** Destructor. */
void AB_User_free(AB_USER *p_struct);

void AB_User_Attach(AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "uniqueId" (see @ref AB_USER_uniqueId)
*/
uint32_t AB_User_GetUniqueId(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "backendName" (see @ref AB_USER_backendName)
*/
const char *AB_User_GetBackendName(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "userName" (see @ref AB_USER_userName)
*/
const char *AB_User_GetUserName(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "userId" (see @ref AB_USER_userId)
*/
const char *AB_User_GetUserId(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "customerId" (see @ref AB_USER_customerId)
*/
const char *AB_User_GetCustomerId(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "country" (see @ref AB_USER_country)
*/
const char *AB_User_GetCountry(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "bankCode" (see @ref AB_USER_bankCode)
*/
const char *AB_User_GetBankCode(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "provider" (see @ref AB_USER_provider)
*/
AB_PROVIDER *AB_User_GetProvider(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "certDb" (see @ref AB_USER_certDb)
*/
GWEN_DB_NODE *AB_User_GetCertDb(const AB_USER *p_struct);

/** Getter.
 * Use this function to get the member "lastSessionId" (see @ref AB_USER_lastSessionId)
*/
uint32_t AB_User_GetLastSessionId(const AB_USER *p_struct);

/** Setter.
 * Use this function to set the member "uniqueId" (see @ref AB_USER_uniqueId)
*/
void AB_User_SetUniqueId(AB_USER *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "backendName" (see @ref AB_USER_backendName)
*/
void AB_User_SetBackendName(AB_USER *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "userName" (see @ref AB_USER_userName)
*/
void AB_User_SetUserName(AB_USER *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "userId" (see @ref AB_USER_userId)
*/
void AB_User_SetUserId(AB_USER *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "customerId" (see @ref AB_USER_customerId)
*/
void AB_User_SetCustomerId(AB_USER *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "country" (see @ref AB_USER_country)
*/
void AB_User_SetCountry(AB_USER *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankCode" (see @ref AB_USER_bankCode)
*/
void AB_User_SetBankCode(AB_USER *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "provider" (see @ref AB_USER_provider)
*/
void AB_User_SetProvider(AB_USER *p_struct, AB_PROVIDER *p_src);

/** Setter.
 * Use this function to set the member "certDb" (see @ref AB_USER_certDb)
*/
void AB_User_SetCertDb(AB_USER *p_struct, GWEN_DB_NODE *p_src);

/** Setter.
 * Use this function to set the member "lastSessionId" (see @ref AB_USER_lastSessionId)
*/
void AB_User_SetLastSessionId(AB_USER *p_struct, uint32_t p_src);

/* prototypes for virtual functions */
/**
 * Read a user from a GWEN_DB_NODE.
 * @param dbData Config data to read from.
 */
int AB_User_ReadFromDb(AB_USER *p_struct, GWEN_DB_NODE* dbData);

/**
 * Write a user to a GWEN_DB_NODE.
 * @param dbData Config data to read from.
 */
int AB_User_WriteToDb(const AB_USER *p_struct, GWEN_DB_NODE* dbData);

/* setters for virtual functions */
AB_USER_READFROMDB_FN AB_User_SetReadFromDbFn(AB_USER *p_struct, AB_USER_READFROMDB_FN fn);

AB_USER_WRITETODB_FN AB_User_SetWriteToDbFn(AB_USER *p_struct, AB_USER_WRITETODB_FN fn);

/* getters for virtual functions */
AB_USER_READFROMDB_FN AB_User_GetReadFromDbFn(const AB_USER *p_struct);

AB_USER_WRITETODB_FN AB_User_GetWriteToDbFn(const AB_USER *p_struct);

void AB_User_ReadDb(AB_USER *p_struct, GWEN_DB_NODE *p_db);

int AB_User_WriteDb(const AB_USER *p_struct, GWEN_DB_NODE *p_db);

AB_USER *AB_User_fromDb(GWEN_DB_NODE *p_db);

int AB_User_toDb(const AB_USER *p_struct, GWEN_DB_NODE *p_db);

void AB_User_ReadXml(AB_USER *p_struct, GWEN_XMLNODE *p_db);

void AB_User_WriteXml(const AB_USER *p_struct, GWEN_XMLNODE *p_db);

void AB_User_toXml(const AB_USER *p_struct, GWEN_XMLNODE *p_db);

AB_USER *AB_User_fromXml(GWEN_XMLNODE *p_db);

AB_USER *AB_User_List_GetByUniqueId(const AB_USER_LIST *p_list, uint32_t p_cmp);

AB_USER *AB_User_List_GetByLastSessionId(const AB_USER_LIST *p_list, uint32_t p_cmp);

/* end-headers */


#ifdef __cplusplus
}
#endif

#endif

