
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileSymbolAdvancedTableModeAttributes.h
    \brief Definition of SymbolAdvancedTableMode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef SymbolAdvancedTableModeAttributes_H
#define SymbolAdvancedTableModeAttributes_H

#include "magics.h"
#include "LevelSelection.h"
#include "OutLayerTechnique.h"
#include "ColourTechnique.h"
#include "Colour.h"
#include "HeightTechnique.h"
namespace magics {

class XmlNode;
class SymbolAdvancedTableModeAttributes 
{
public:
//  --  constructor
    SymbolAdvancedTableModeAttributes();
    
//  --  destructor
    virtual ~SymbolAdvancedTableModeAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SymbolAdvancedTableModeAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double min_;
	double max_;
	int count_;
	int tolerance_;
	double interval_;
	double reference_;
	doublearray list_;
	string direction_;
	stringarray colours_;
	intarray markers_;
	stringarray markers_names_;
	double height_max_;
	double height_min_;
	doublearray heights_;
	stringarray text_list_;
	string text_font_name_;
	double text_font_size_;
	string text_font_style_;
	string text_display_type_;
	double outlayer_min_;
	double outlayer_max_;
	unique_ptr<LevelSelection> levels_;
	unique_ptr<ColourTechnique> colourMethod_;
	unique_ptr<Colour> maxColour_;
	unique_ptr<Colour> minColour_;
	ListPolicy colour_policy_;
	ListPolicy marker_policy_;
	unique_ptr<HeightTechnique> height_method_;
	ListPolicy height_policy_;
	ListPolicy text_policy_;
	unique_ptr<Colour> text_font_colour_;
	unique_ptr<NoOutLayerTechnique> outlayer_;
	 

private:
	friend ostream& operator<<(ostream& s,const SymbolAdvancedTableModeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

