.\"
.\"
.\" Copyright © 2013 Keith Packard
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that copyright
.\" notice and this permission notice appear in supporting documentation, and
.\" that the name of the copyright holders not be used in advertising or
.\" publicity pertaining to distribution of the software without specific,
.\" written prior permission.  The copyright holders make no representations
.\" about the suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
.\" OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XPresentNotifyMSC __libmansuffix__ 2022-08-27 __xorgversion__
.SH NAME
XPresentNotifyMSC \- X Present Extension
.SH SYNTAX
\&#include <X11/extensions/Xpresent.h>
.nf
.sp
void XPresentNotifyMSC \^(\^Display *\fIdisplay\fP,
	Window \fIwindow\fP,
	uint32_t \fIserial\fP,
	uint64_t \fItarget_msc\fP,
	uint64_t \fIdivisor\fP,
	uint64_t \fIremainder\fP\^)\^;
.fi
.SH DESCRIPTION
.B XPresentNotifyMSC
requests that the X server specified by \fIdisplay\fP
deliver a \fBPresentCompleteNotifyEvent\fP with kind
\fBPresentCompleteKindNotifyMSC\fP after the time specified by
\fItarget-msc\fP, \fIdivisor\fP and \fIremainder\fP.
.PP
\fIserial\fP is an arbitrary client-specified value which will be
returned in the event so that the client can associate the
event and request.
.PP
If \fItarget-msc\fP is greater than the current Media Stream Counter (msc)
for \fIwindow\fP, the event will be delivered at (or after) the \fItarget-msc\fP
field.
Otherwise, the event delivery will occur after the next
field where msc % \fIdivisor\fP == \fIremainder\fP.
.PP
If \fIwindow\fP is destroyed before the event is delivered, then
the event delivery will not be completed.
.SH SEE ALSO
.BR Xpresent (__libmansuffix__),
.BR XPresentPixmap (__libmansuffix__),
.BR XPresentQueryCapabilities (__libmansuffix__),
.BR XPresentSelectInput (__libmansuffix__)
.SH AUTHORS
Keith Packard, Intel
