/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

public class PrimitiveType
extends GenericType {
    public PrimitiveType(String n) {
        this.name = n;
    }

    @Override
    public GenericType build(String n, String d) {
        return this;
    }

    @Override
    public int getSize() {
        if (this.name.equals("bool")) {
            return Inspector.getBoolSize();
        }
        if (this.name.equals("long long") || this.name.equals("unsigned long long")) {
            return Inspector.getLongLongSize();
        }
        if (this.name.equals("long") || this.name.equals("unsigned long")) {
            return Inspector.getLongSize();
        }
        if (this.name.equals("int") || this.name.equals("unsigned int")) {
            return Inspector.getIntSize();
        }
        if (this.name.equals("short") || this.name.equals("unsigned short")) {
            return 2;
        }
        if (this.name.equals("char") || this.name.equals("unsigned char")) {
            return 1;
        }
        if (this.name.equals("float")) {
            return 4;
        }
        if (this.name.equals("double")) {
            return 8;
        }
        return 0;
    }

    @Override
    public String toString(String indent) {
        return this.name;
    }

    @Override
    public String memoryToString(String indent, ByteBuffer mem, int start) {
        String str;
        long value;
        if (start < 0) {
            return "?";
        }
        if (this.name.equals("float")) {
            return Float.toString(mem.getFloat(start));
        }
        if (this.name.equals("double")) {
            return Double.toString(mem.getDouble(start));
        }
        int size = this.getSize();
        switch (size) {
            case 1: {
                byte valueB = mem.get(start);
                value = valueB;
                str = Byte.toString(valueB);
                break;
            }
            case 2: {
                short valueS = mem.getShort(start);
                value = valueS;
                str = Short.toString(valueS);
                break;
            }
            case 4: {
                int valueI = mem.getInt(start);
                value = valueI;
                str = Integer.toString(valueI);
                break;
            }
            case 8: {
                value = mem.getLong(start);
                str = Long.toString(value);
                break;
            }
            default: {
                return "???";
            }
        }
        if (this.name.equals("bool")) {
            return value != 0L ? "true" : "false";
        }
        return str;
    }

    @Override
    public String getValue(TypeVisitor v) {
        String str;
        long value;
        if (this.name.equals("float")) {
            return Float.toString(v.getFloat());
        }
        if (this.name.equals("double")) {
            return Double.toString(v.getDouble());
        }
        int size = this.getSize();
        switch (size) {
            case 1: {
                value = v.getByte();
                str = Byte.toString(v.getByte());
                break;
            }
            case 2: {
                value = v.getShort();
                str = Short.toString(v.getShort());
                break;
            }
            case 4: {
                value = v.getInteger();
                str = Integer.toString(v.getInteger());
                break;
            }
            case 8: {
                value = v.getLong();
                str = Long.toString(v.getLong());
                break;
            }
            default: {
                return "???";
            }
        }
        if (this.name.equals("bool")) {
            return value != 0L ? "true" : "false";
        }
        return str;
    }

    @Override
    public void visit(TypeVisitor v) {
        if (v.isValid()) {
            String str = null;
            if (this.name.equals("float")) {
                str = Float.toString(v.getFloat());
            }
            if (this.name.equals("double")) {
                str = Double.toString(v.getDouble());
            }
            int size = this.getSize();
            long value = 0L;
            switch (size) {
                case 1: {
                    value = v.getByte();
                    str = Byte.toString(v.getByte());
                    break;
                }
                case 2: {
                    value = v.getShort();
                    str = Short.toString(v.getShort());
                    break;
                }
                case 4: {
                    value = v.getInteger();
                    str = Integer.toString(v.getInteger());
                    break;
                }
                case 8: {
                    value = v.getLong();
                    str = Long.toString(v.getLong());
                    break;
                }
                default: {
                    str = "???";
                }
            }
            if (this.name.equals("bool")) {
                str = value != 0L ? "true" : "false";
            }
            v.addValue(str);
        } else {
            v.addValue("?");
        }
    }
}

