/*
 *  Author: pbrufal (and tican)
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <ctype.h>
#include <fcntl.h>
#include <linux/fs.h>
#include <linux/hdreg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>

void show_id(char *devname)
{
        static struct hd_driveid id;
        int fd;
	long size;

        fd = open (devname, O_RDONLY|O_NONBLOCK);
        if (fd < 0) {
                perror(devname);
		return;
        }
        if (ioctl(fd, HDIO_GET_IDENTITY, &id)) {
                perror("ioctl");
        }
        printf("\tModel:\t%s\n", id.model);
	if(ioctl(fd, BLKGETSIZE, &size)) {
		perror(devname);
		return;
        }
	size /= 2;
	if (size == ((1<<30)-1) || size == 0) {
		close(fd);
		printf("\n");
		return;
	}
	printf("\tSize:\t%ld KB\n\n", size);
        close(fd);
        return;
}

void ide(const int BUF_SIZE2, const int BUF_SIZE3, const int BUF_SIZE4)
{
	FILE *file;
	int hd;
	char buf[BUF_SIZE2], buf2[BUF_SIZE3], devname[BUF_SIZE4];

	puts("");
	printf("  IDE\n\n");

	for(hd = 'a'; hd <= 't'; hd++) {
		sprintf(buf, "/proc/ide/hd%c/media", hd);
		file = fopen(buf, "r");
		if ( file ) {
			printf("  /dev/hd%c:\n", hd);
			while ( fgets(buf2, BUF_SIZE2, file) ) {
				if ( buf2 ) {
					printf("\tType:\t%s", buf2);
				}
			}
			sprintf(devname, "/dev/hd%c", hd);
			show_id(devname);
			fclose(file);
		}
	}
}
