/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.jobs;

import java.io.File;
import java.io.IOException;
import okhttp3.RequestBody;
import org.rundeck.client.api.model.JobFileItem;
import org.rundeck.client.api.model.JobFileItemList;
import org.rundeck.client.api.model.JobFileUploadResult;
import org.rundeck.client.api.model.Paging;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.tool.options.PagingResultOptions;
import org.rundeck.client.util.Client;
import picocli.CommandLine;

@CommandLine.Command(description={"List and manage File options for Jobs."}, name="files")
public class Files
extends BaseCommand {
    @CommandLine.Command(description={"Get info about a Job input option file (API v19)"})
    public void info(@CommandLine.Option(paramLabel="id", names={"-i", "--id"}, description={"File ID"}, required=true) String id) throws IOException, InputError {
        JobFileItem jobFileItem = (JobFileItem)this.apiCall(api -> api.getJobFileInfo(id));
        this.getRdOutput().output(jobFileItem);
    }

    @CommandLine.Command(description={"List files uploaded for a Job or Execution (API v19). Specify Job ID or Execution ID"})
    public void list(@CommandLine.Mixin FileListOpts opts) throws IOException, InputError {
        if (!opts.isJobId() && !opts.isExecId() || opts.isExecId() && opts.isJobId()) {
            throw new InputError("One of -j/--jobid or -e/--eid is required");
        }
        if (opts.isExecId() && opts.isFileState()) {
            throw new InputError("-s/--state not a valid option for -e/--eid");
        }
        int offset = opts.isOffset() ? opts.getOffset() : 0;
        int max = opts.isMax() ? opts.getMax() : 20;
        JobFileItemList result = opts.isJobId() ? (JobFileItemList)this.apiCall(api -> api.listJobFiles(opts.getJobId(), opts.isFileState() ? opts.getFileState().toString() : null, offset, max)) : (JobFileItemList)this.apiCall(api -> api.listExecutionFiles(opts.getExecId(), offset, max));
        Paging paging = result.getPaging();
        if (paging != null) {
            this.getRdOutput().info(paging);
        }
        this.getRdOutput().output(result.asList());
        if (paging != null && paging.hasMoreResults()) {
            this.getRdOutput().info(paging.moreResults("-o"));
        }
    }

    @CommandLine.Command(description={"Upload a file as input for a job option (API v19). Returns a unique key for the uploaded file, which can be used as the option value when running the job."})
    public int load(@CommandLine.Mixin FileUploadOpts options) throws IOException, InputError {
        File input = options.getFile();
        if (!input.canRead() || !input.isFile()) {
            throw new InputError(String.format("File is not readable or does not exist: %s", input));
        }
        String fileName = input.getName();
        JobFileUploadResult jobFileUploadResult = Files.uploadFileForJob(this.getRdTool(), input, options.getId(), options.getOption());
        String fileid = jobFileUploadResult.getFileIdForOption(options.getOption());
        if (null != fileid) {
            this.getRdOutput().info("File " + fileName + " uploaded successfully for option " + options.getOption());
            this.getRdOutput().info("File key:");
            this.getRdOutput().output(fileid);
            return 0;
        }
        this.getRdOutput().error(String.format("Expected one option result for option %s, but saw: ", options.getOption()));
        this.getRdOutput().output(jobFileUploadResult);
        return 1;
    }

    public static JobFileUploadResult uploadFileForJob(RdTool rdTool, File input, String jobId, String optionName) throws IOException, InputError {
        if (Files.invalidInputFile(input)) {
            throw new IOException("Can't read file: " + input);
        }
        RequestBody requestBody = RequestBody.create(input, Client.MEDIA_TYPE_OCTET_STREAM);
        return (JobFileUploadResult)rdTool.apiCallDowngradable(api -> api.uploadJobOptionFile(jobId, optionName, input.getName(), requestBody));
    }

    public static boolean invalidInputFile(File input) {
        return !input.exists() || !input.canRead() || !input.isFile();
    }

    static class FileUploadOpts {
        @CommandLine.Option(names={"-i", "--id"}, description={"Job ID"}, required=true)
        String id;
        @CommandLine.Option(names={"-o", "--option"}, description={"Option name"}, required=true)
        String option;
        @CommandLine.Option(names={"-f", "--file"}, description={"File path of the file to upload (load command) or destination for storing the jobs (list command)"}, required=true)
        File file;

        FileUploadOpts() {
        }

        public String getId() {
            return this.id;
        }

        public String getOption() {
            return this.option;
        }

        public File getFile() {
            return this.file;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setOption(String option) {
            this.option = option;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    static enum FileState {
        temp,
        expired,
        deleted,
        retained;

    }

    static class FileListOpts
    extends PagingResultOptions {
        @CommandLine.Option(names={"-j", "--jobid"}, description={"Job ID"})
        String jobId;
        @CommandLine.Option(names={"-e", "--eid"}, description={"Execution ID"})
        String execId;
        @CommandLine.Option(names={"-s", "--state"}, description={"File state filter for listing Files for a Job only. (default:temp), one of: temp,expired,deleted,retained."})
        FileState fileState;

        FileListOpts() {
        }

        boolean isJobId() {
            return this.jobId != null;
        }

        boolean isExecId() {
            return this.execId != null;
        }

        boolean isFileState() {
            return this.fileState != null;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getExecId() {
            return this.execId;
        }

        public FileState getFileState() {
            return this.fileState;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public void setExecId(String execId) {
            this.execId = execId;
        }

        public void setFileState(FileState fileState) {
            this.fileState = fileState;
        }
    }
}

