/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public final class SimpleCSVReader {
    private final BufferedReader br;
    private boolean hasNext = true;
    private final char separator;
    private final char quotechar;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';

    public SimpleCSVReader(Reader reader) {
        this(reader, ',');
    }

    public SimpleCSVReader(Reader reader, char separator) {
        this(reader, separator, '\"');
    }

    public SimpleCSVReader(Reader reader, char separator, char quotechar) {
        this.br = new BufferedReader(reader);
        this.separator = separator;
        this.quotechar = quotechar;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String nextLine = this.getNextLine();
        return this.hasNext ? this.parseLine(nextLine) : null;
    }

    private String getNextLine() throws IOException {
        String nextLine = this.br.readLine();
        if (nextLine == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private String[] parseLine(String input) throws IOException {
        if (input == null) {
            return null;
        }
        String nextLine = input;
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        do {
            if (sb.length() > 0) {
                sb.append("\n");
                nextLine = this.getNextLine();
                if (nextLine == null) break;
            }
            for (int i = 0; i < nextLine.length(); ++i) {
                char c = nextLine.charAt(i);
                if (c == this.quotechar) {
                    inQuotes = !inQuotes;
                    continue;
                }
                if (c == this.separator && !inQuotes) {
                    tokensOnThisLine.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(c);
            }
        } while (inQuotes);
        tokensOnThisLine.add(sb.toString());
        return tokensOnThisLine.toArray(new String[0]);
    }
}

