/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JPanel;

public final class JGCardPanel
extends JPanel {
    public JGCardPanel() {
        super(new Layout());
    }

    public Component getVisibleCard() {
        int index = this.getVisibleChildIndex();
        return index != -1 ? this.getComponent(index) : null;
    }

    public int getVisibleChildIndex() {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!child.isVisible()) continue;
            return i;
        }
        return -1;
    }

    public String getVisibleChildName() {
        int i = this.getVisibleChildIndex();
        return -1 == i ? null : this.getComponent(i).getName();
    }

    public void showCard(Component card) {
        Component visibleComponent = this.getVisibleCard();
        if (visibleComponent == card) {
            return;
        }
        visibleComponent.setVisible(false);
        card.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    public void showCard(String cardName) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = this.getComponent(i);
            if (!child.getName().equals(cardName) || child.isVisible()) continue;
            this.showCard(child);
            break;
        }
    }

    public void showFirstCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        this.showCard(this.getComponent(0));
    }

    public void showLastCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        this.showCard(this.getComponent(this.getComponentCount() - 1));
    }

    public void showNextCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        int index = this.getVisibleChildIndex();
        if (index == -1 || index == this.getComponentCount() - 1) {
            this.showCard(this.getComponent(0));
        } else {
            this.showCard(this.getComponent(index + 1));
        }
    }

    public void showPreviousCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        int index = this.getVisibleChildIndex();
        if (index == -1) {
            this.showCard(this.getComponent(0));
        } else if (index == 0) {
            this.showCard(this.getComponent(this.getComponentCount() - 1));
        } else {
            this.showCard(this.getComponent(index - 1));
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        Preconditions.checkArgument(constraints == null || constraints instanceof String, "The constraints must be null or String.\nConstraints=" + constraints);
        super.addImpl(comp, constraints, index);
    }

    private static final class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component child) {
            if (name != null) {
                child.setName(name);
            }
            child.setVisible(child.getParent().getComponentCount() == 1);
        }

        @Override
        public void removeLayoutComponent(Component child) {
            Container parent;
            if (child.isVisible() && (parent = child.getParent()).getComponentCount() > 0) {
                parent.getComponent(0).setVisible(true);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return Layout.layoutSize(parent, Component::getPreferredSize);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return Layout.layoutSize(parent, Component::getMinimumSize);
        }

        @Override
        public void layoutContainer(Container parent) {
            int count = parent.getComponentCount();
            Insets insets = parent.getInsets();
            for (int i = 0; i < count; ++i) {
                Component child = parent.getComponent(i);
                if (!child.isVisible()) continue;
                Rectangle r = parent.getBounds();
                int width = r.width - (insets.left + insets.right);
                int height = r.height - (insets.top + insets.bottom);
                child.setBounds(insets.left, insets.top, width, height);
                break;
            }
        }

        private static Dimension layoutSize(Container parent, Function<Component, Dimension> sizeMeasure) {
            int count = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = 0;
            int height = 0;
            for (int i = 0; i < count; ++i) {
                Dimension d = sizeMeasure.apply(parent.getComponent(i));
                if (d.width > width) {
                    width = d.width;
                }
                if (d.height <= height) continue;
                height = d.height;
            }
            return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
        }
    }
}

