import { useContext } from 'react';
import { RouterLinkProviderContext } from '../index';

/**
 * __useRouterLink()__
 *
 * Hook: Returns app-configured router link component.
 *
 * A generic can be passed to define advanced link configuration:
 * ```
 * type MyRouterLinkConfig = {
 *  to: string;
 *  replace?: boolean;
 * }
 *
 * const RouterLink = useRouterLink<MyRouterLinkConfig>();
 * ```
 */
const useRouterLink = () => {
  const {
    routerLinkComponent
  } = useContext(RouterLinkProviderContext);
  if (routerLinkComponent) {
    return routerLinkComponent;
  }
};
export default useRouterLink;