"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScrollable = void 0;
var _cssBoxModel = require("css-box-model");
// Simplified version of RBD's droppable: minimum required fields just to get it working with cursor-based scolling.
var getScrollable = exports.getScrollable = function getScrollable(_ref) {
  var closestScrollable = _ref.closestScrollable;
  var rect = closestScrollable.getBoundingClientRect();
  var scrollPosition = {
    x: closestScrollable.scrollLeft,
    y: closestScrollable.scrollTop
  };
  return {
    container: (0, _cssBoxModel.getRect)(rect),
    scroll: {
      current: scrollPosition,
      max: {
        x: closestScrollable.scrollWidth - closestScrollable.clientWidth,
        y: closestScrollable.scrollHeight - closestScrollable.clientHeight
      }
    }
  };
};