"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _styleMaps = require("../xcss/style-maps.partial");
var _xcss = require("../xcss/xcss");
/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766

var justifyContentMap = {
  start: (0, _react2.css)({
    justifyContent: 'start'
  }),
  center: (0, _react2.css)({
    justifyContent: 'center'
  }),
  end: (0, _react2.css)({
    justifyContent: 'end'
  }),
  'space-between': (0, _react2.css)({
    justifyContent: 'space-between'
  }),
  'space-around': (0, _react2.css)({
    justifyContent: 'space-around'
  }),
  'space-evenly': (0, _react2.css)({
    justifyContent: 'space-evenly'
  }),
  stretch: (0, _react2.css)({
    justifyContent: 'stretch'
  })
};
var flexDirectionMap = {
  column: (0, _react2.css)({
    flexDirection: 'column'
  }),
  row: (0, _react2.css)({
    flexDirection: 'row'
  })
};
var flexWrapMap = {
  wrap: (0, _react2.css)({
    flexWrap: 'wrap'
  }),
  nowrap: (0, _react2.css)({
    flexWrap: 'nowrap'
  })
};
var alignItemsMap = {
  start: (0, _react2.css)({
    alignItems: 'start'
  }),
  center: (0, _react2.css)({
    alignItems: 'center'
  }),
  baseline: (0, _react2.css)({
    alignItems: 'baseline'
  }),
  end: (0, _react2.css)({
    alignItems: 'end'
  }),
  stretch: (0, _react2.css)({
    alignItems: 'stretch'
  })
};
var baseStyles = (0, _react2.css)({
  display: 'flex',
  boxSizing: 'border-box'
});

/**
 * __Flex__
 *
 * `Flex` is a primitive component that implements the CSS Flexbox API.
 *
 * - [Examples](https://atlassian.design/components/primitives/flex/examples)
 * - [Code](https://atlassian.design/components/primitives/flex/code)
 *
 * @example
 * ```tsx
 * import { Flex, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Flex direction="column">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Flex>
 * )
 * ```
 */
var Flex = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'div' : _ref$as,
    role = _ref.role,
    alignItems = _ref.alignItems,
    justifyContent = _ref.justifyContent,
    gap = _ref.gap,
    columnGap = _ref.columnGap,
    rowGap = _ref.rowGap,
    children = _ref.children,
    testId = _ref.testId,
    direction = _ref.direction,
    wrap = _ref.wrap,
    xcss = _ref.xcss;
  var resolvedStyles = (0, _xcss.parseXcss)(xcss);
  return (0, _react2.jsx)(Component, {
    role: role
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    ,
    className: resolvedStyles.static,
    css: [baseStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    gap && _styleMaps.spaceStylesMap.gap[gap],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    columnGap && _styleMaps.spaceStylesMap.columnGap[columnGap],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    rowGap && _styleMaps.spaceStylesMap.rowGap[rowGap], alignItems && alignItemsMap[alignItems], direction && flexDirectionMap[direction], justifyContent && justifyContentMap[justifyContent], wrap && flexWrapMap[wrap], resolvedStyles.emotion],
    "data-testid": testId,
    ref: ref
  }, children);
}));
Flex.displayName = 'Flex';
var _default = exports.default = Flex;