/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Domain;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.spell.Spell;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreSpellTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) {
        Collection mods;
        CharacterDisplay display = character.getDisplay();
        int requiredNumber = 0;
        try {
            requiredNumber = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException e) {
            Logging.errorPrint((String)(LanguageBundle.getString((String)"PreSpell.error.badly_formed_attribute") + prereq.toString()));
        }
        List aArrayList = character.aggregateSpellList("", "", "", 0, 20);
        for (Domain d : display.getDomainSet()) {
            aArrayList.addAll(character.getAllSpellsInLists(Collections.singletonList(d.get(ObjectKey.DOMAIN_SPELLLIST))));
        }
        if (character.getAutoSpells() && (mods = display.getRace().getListMods(Spell.SPELLS)) != null) {
            for (CDOMReference ref : mods) {
                aArrayList.addAll(ref.getContainedObjects());
            }
        }
        String spellName = prereq.getKey();
        int runningTotal = 0;
        for (Spell aSpell : aArrayList) {
            if (aSpell == null || aSpell.getKeyName() == null || !aSpell.getKeyName().equalsIgnoreCase(spellName)) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, requiredNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "SPELL";
    }

    public String toHtmlString(Prerequisite prereq) {
        Object[] args = new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), prereq.getKey()};
        return LanguageBundle.getFormattedString((String)"PreSpell.toHtml", (Object[])args);
    }
}

