/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.Equipment;
import pcgen.core.character.EquipSet;

public class EquipSetFacet
extends AbstractListFacet<CharID, EquipSet>
implements DataFacetChangeListener<CharID, Equipment> {
    public boolean delEquipSet(CharID id, EquipSet eSet) {
        Collection componentSet = this.getCachedSet(id);
        if (componentSet == null) {
            return false;
        }
        boolean found = false;
        String pid = eSet.getIdPath();
        componentSet.remove(eSet);
        Iterator e = componentSet.iterator();
        while (e.hasNext()) {
            String abPid;
            EquipSet es = (EquipSet)e.next();
            String abParentId = es.getParentIdPath() + ".";
            if (!abParentId.startsWith(abPid = pid + ".")) continue;
            e.remove();
            found = true;
        }
        return found;
    }

    public void updateEquipSetItem(CharID id, Equipment oldItem, Equipment newItem) {
        if (this.isEmpty(id)) {
            return;
        }
        ArrayList<EquipSet> tmpList = new ArrayList<EquipSet>();
        for (EquipSet es : this.getSet(id)) {
            Equipment eqI = es.getItem();
            if (eqI == null || !oldItem.equals(eqI)) continue;
            tmpList.add(es);
        }
        for (EquipSet es : tmpList) {
            es.setValue(newItem.getName());
            es.setItem(newItem);
        }
    }

    public void delEquipSetItem(CharID id, Equipment eq) {
        if (this.isEmpty(id)) {
            return;
        }
        ArrayList<EquipSet> tmpList = new ArrayList<EquipSet>();
        for (EquipSet es : this.getSet(id)) {
            Equipment eqI = es.getItem();
            if (eqI == null || !eq.equals(eqI)) continue;
            tmpList.add(es);
        }
        for (EquipSet es : tmpList) {
            this.delEquipSet(id, es);
        }
    }

    public EquipSet getEquipSetByIdPath(CharID id, String path) {
        for (EquipSet eSet : this.getSet(id)) {
            if (!eSet.getIdPath().equals(path)) continue;
            return eSet;
        }
        return null;
    }

    public EquipSet getEquipSetByName(CharID id, String name) {
        for (EquipSet eSet : this.getSet(id)) {
            if (!eSet.getName().equals(name)) continue;
            return eSet;
        }
        return null;
    }

    public Float getEquipSetCount(CharID id, String idPath, String name) {
        float count = 0.0f;
        for (EquipSet eSet : this.getSet(id)) {
            String abID;
            String esID = eSet.getIdPath() + ".";
            if (!esID.startsWith(abID = idPath + ".") || !eSet.getValue().equals(name)) continue;
            count += eSet.getQty().floatValue();
        }
        return Float.valueOf(count);
    }

    public Float getEquippedQuantity(CharID id, EquipSet set, Equipment eq) {
        String rPath = set.getIdPath();
        for (EquipSet es : this.getSet(id)) {
            String rIdPath;
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(rIdPath = rPath + ".") || !eq.getName().equals(es.getValue())) continue;
            return es.getQty();
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Equipment> dfce) {
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Equipment> dfce) {
        this.delEquipSetItem(dfce.getCharID(), dfce.getCDOMObject());
    }
}

