/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.FollowerLimit;
import pcgen.cdom.list.CompanionList;

public class FollowerLimitFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private FormulaResolvingFacet formulaResolvingFacet;
    private BonusCheckingFacet bonusCheckingFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<FollowerLimit> followers = cdo.getListFor(ListKey.FOLLOWERS);
        if (followers != null) {
            this.addAll(dfce.getCharID(), followers, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    private void addAll(CharID id, List<FollowerLimit> list, CDOMObject cdo) {
        for (FollowerLimit fo : list) {
            this.add(id, fo, cdo);
        }
    }

    private void add(CharID id, FollowerLimit fo, CDOMObject cdo) {
        if (fo == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        CompanionList cl = fo.getCompanionList().resolvesTo();
        Map<FollowerLimit, Set<CDOMObject>> foMap = this.getConstructingCachedMap(id, cl);
        WrappedMapSet set = foMap.get(fo);
        if (set == null) {
            set = new WrappedMapSet(IdentityHashMap.class);
            foMap.put(fo, (Set<CDOMObject>)set);
        }
        set.add((CDOMObject)cdo);
    }

    private void removeAll(CharID id, CDOMObject source) {
        Map<CompanionList, Map<FollowerLimit, Set<CDOMObject>>> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            Iterator<Map<FollowerLimit, Set<CDOMObject>>> it = componentMap.values().iterator();
            while (it.hasNext()) {
                Map<FollowerLimit, Set<CDOMObject>> foMap = it.next();
                Iterator<Set<CDOMObject>> it2 = foMap.values().iterator();
                while (it2.hasNext()) {
                    Set<CDOMObject> set = it2.next();
                    if (!set.remove(source) || !set.isEmpty()) continue;
                    it2.remove();
                }
                if (!foMap.isEmpty()) continue;
                it.remove();
            }
        }
    }

    private Map<CompanionList, Map<FollowerLimit, Set<CDOMObject>>> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<FollowerLimit, Set<CDOMObject>> getConstructingCachedMap(CharID id, CompanionList cl) {
        Map<FollowerLimit, Set<CDOMObject>> foMap;
        Map<CompanionList, Map<FollowerLimit, Set<CDOMObject>>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = new HashMap<CompanionList, Map<FollowerLimit, Set<CDOMObject>>>();
            this.setCache(id, componentMap);
        }
        if ((foMap = componentMap.get(cl)) == null) {
            foMap = new IdentityHashMap<FollowerLimit, Set<CDOMObject>>();
            componentMap.put(cl, foMap);
        }
        return foMap;
    }

    public int getMaxFollowers(CharID id, CompanionList cl) {
        Map<CompanionList, Map<FollowerLimit, Set<CDOMObject>>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return -1;
        }
        Map<FollowerLimit, Set<CDOMObject>> foMap = componentMap.get(cl);
        if (foMap == null) {
            return -1;
        }
        int ret = -1;
        for (Map.Entry<FollowerLimit, Set<CDOMObject>> me : foMap.entrySet()) {
            FollowerLimit fl = me.getKey();
            Set<CDOMObject> set = me.getValue();
            for (CDOMObject source : set) {
                int val = this.formulaResolvingFacet.resolve(id, fl.getValue(), source.getQualifiedKey()).intValue();
                ret = Math.max(ret, val);
            }
        }
        if (ret != -1) {
            ret = (int)((double)ret + this.bonusCheckingFacet.getBonus(id, "FOLLOWERS", cl.getKeyName().toUpperCase()));
        }
        return ret;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<CompanionList, Map<FollowerLimit, Set<CDOMObject>>> map = this.getCachedMap(source);
        if (map != null) {
            for (Map<FollowerLimit, Set<CDOMObject>> fm : map.values()) {
                for (Map.Entry<FollowerLimit, Set<CDOMObject>> fme : fm.entrySet()) {
                    FollowerLimit fl = fme.getKey();
                    for (CDOMObject cdo : fme.getValue()) {
                        this.add(copy, fl, cdo);
                    }
                }
            }
        }
    }

    public int getCount(CharID id) {
        Map<CompanionList, Map<FollowerLimit, Set<CDOMObject>>> map = this.getCachedMap(id);
        int count = 0;
        if (map != null) {
            for (Map<FollowerLimit, Set<CDOMObject>> fm : map.values()) {
                count += fm.size();
            }
        }
        return count;
    }
}

