/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.base.util.GenericMapToList;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.PCGenIdentifier;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.ScopeFacetChangeEvent;
import pcgen.cdom.facet.event.ScopeFacetChangeListener;

public class AbstractScopeFacet<IDT extends PCGenIdentifier, S, T>
extends AbstractStorageFacet<IDT> {
    private final Map<Integer, ScopeFacetChangeListener<? super IDT, ? super S, ? super T>[]> listeners = new TreeMap<Integer, ScopeFacetChangeListener<? super IDT, ? super S, ? super T>[]>();

    private Map<S, Map<T, Set<Object>>> getConstructingInfo(IDT id) {
        Map<S, Map<T, Set<Object>>> map = this.getInfo(id);
        if (map == null) {
            map = new IdentityHashMap<S, Map<T, Set<Object>>>();
            this.setCache(id, map);
        }
        return map;
    }

    private Map<S, Map<T, Set<Object>>> getInfo(IDT id) {
        return (Map)this.getCache(id);
    }

    public void add(IDT id, S scope, T obj, Object source) {
        WrappedMapSet sources;
        boolean isNew;
        if (scope == null) {
            throw new IllegalArgumentException("Scope cannot be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Map<S, Map<T, Set<Object>>> map = this.getConstructingInfo(id);
        Map<T, Set<Object>> scopeMap = map.get(scope);
        if (scopeMap == null) {
            scopeMap = new IdentityHashMap<T, Set<Object>>();
            map.put(scope, scopeMap);
        }
        boolean bl = isNew = (sources = scopeMap.get(obj)) == null;
        if (isNew) {
            sources = new WrappedMapSet(IdentityHashMap.class);
            scopeMap.put(obj, (Set<Object>)sources);
        }
        sources.add((Object)source);
        if (isNew) {
            this.fireScopeFacetChangeEvent(id, scope, obj, 0);
        }
    }

    public void addAll(IDT id, S scope, Collection<T> coll, Object source) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope cannot be null");
        }
        if (coll == null) {
            throw new IllegalArgumentException("Collection cannot be null");
        }
        Map<S, Map<T, Set<Object>>> map = this.getConstructingInfo(id);
        Map<T, Set<Object>> scopeMap = map.get(scope);
        if (scopeMap == null) {
            scopeMap = new IdentityHashMap<T, Set<Object>>();
            map.put(scope, scopeMap);
        }
        for (T obj : coll) {
            boolean isNew;
            WrappedMapSet sources = scopeMap.get(obj);
            boolean bl = isNew = sources == null;
            if (isNew) {
                sources = new WrappedMapSet(IdentityHashMap.class);
                scopeMap.put(obj, (Set<Object>)sources);
            }
            sources.add((Object)source);
            if (!isNew) continue;
            this.fireScopeFacetChangeEvent(id, scope, obj, 0);
        }
    }

    public void remove(IDT id, S scope, T obj, Object source) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope cannot be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Map<S, Map<T, Set<Object>>> map = this.getInfo(id);
        if (map == null) {
            return;
        }
        Map<T, Set<Object>> scopeMap = map.get(scope);
        if (scopeMap == null) {
            return;
        }
        Set<Object> sources = scopeMap.get(obj);
        if (sources == null) {
            return;
        }
        if (sources.remove(source) && sources.isEmpty()) {
            this.fireScopeFacetChangeEvent(id, scope, obj, 1);
            scopeMap.remove(obj);
        }
        if (scopeMap.isEmpty()) {
            map.remove(scope);
        }
        if (map.isEmpty()) {
            this.removeCache(id);
        }
    }

    public Collection<T> getSet(IDT id, S scope) {
        Map<S, Map<T, Set<Object>>> map = this.getInfo(id);
        if (map == null) {
            return Collections.emptyList();
        }
        Map<T, Set<Object>> scopeMap = map.get(scope);
        if (scopeMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(scopeMap.keySet());
    }

    public Collection<S> getScopes(IDT id) {
        Map<S, Map<T, Set<Object>>> map = this.getInfo(id);
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<S>(map.keySet());
    }

    public boolean contains(IDT id, S scope, T obj) {
        Map<S, Map<T, Set<Object>>> map = this.getInfo(id);
        if (map == null) {
            return false;
        }
        Map<T, Set<Object>> scopeMap = map.get(scope);
        return scopeMap != null && scopeMap.containsKey(obj);
    }

    public void removeAllFromSource(IDT id, Object source) {
        Map<S, Map<T, Set<Object>>> map = this.getInfo(id);
        GenericMapToList removed = GenericMapToList.getMapToList(IdentityHashMap.class);
        if (map != null) {
            Iterator<Map.Entry<S, Map<T, Set<Object>>>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<S, Map<T, Set<Object>>> entry = it.next();
                S scope = entry.getKey();
                Map<T, Set<Object>> scopeMap = entry.getValue();
                Iterator<Map.Entry<T, Set<Object>>> lmit = scopeMap.entrySet().iterator();
                while (lmit.hasNext()) {
                    Map.Entry<T, Set<Object>> lme = lmit.next();
                    Set<Object> sources = lme.getValue();
                    if (!sources.remove(source) || !sources.isEmpty()) continue;
                    T obj = lme.getKey();
                    lmit.remove();
                    removed.addToListFor(scope, obj);
                }
                if (!scopeMap.isEmpty()) continue;
                it.remove();
            }
            if (map.isEmpty()) {
                this.removeCache(id);
            }
            for (Object scope : removed.getKeySet()) {
                for (Object obj : removed.getListFor(scope)) {
                    this.fireScopeFacetChangeEvent(id, scope, obj, 1);
                }
            }
        }
    }

    @Override
    public void copyContents(IDT source, IDT copy) {
        Map<S, Map<T, Set<Object>>> map = this.getInfo(source);
        if (map != null) {
            for (Map.Entry<S, Map<T, Set<Object>>> lme : map.entrySet()) {
                S scope = lme.getKey();
                for (Map.Entry<T, Set<Object>> ome : lme.getValue().entrySet()) {
                    T sp = ome.getKey();
                    for (Object spsource : ome.getValue()) {
                        this.add(copy, scope, sp, spsource);
                    }
                }
            }
        }
    }

    public void addScopeFacetChangeListener(ScopeFacetChangeListener<? super IDT, ? super S, ? super T> listener) {
        this.addScopeFacetChangeListener(0, listener);
    }

    public void addScopeFacetChangeListener(int priority, ScopeFacetChangeListener<? super IDT, ? super S, ? super T> listener) {
        ScopeFacetChangeListener<? super IDT, ? super S, ? super T>[] dfcl = this.listeners.get(priority);
        int newSize = dfcl == null ? 1 : dfcl.length + 1;
        ScopeFacetChangeListener[] newArray = new ScopeFacetChangeListener[newSize];
        if (dfcl != null) {
            System.arraycopy(dfcl, 0, newArray, 1, dfcl.length);
        }
        newArray[0] = listener;
        this.listeners.put(priority, newArray);
    }

    public void removeScopeFacetChangeListener(ScopeFacetChangeListener<? super IDT, ? super S, ? super T> listener) {
        this.removeScopeFacetChangeListener(0, listener);
    }

    public void removeScopeFacetChangeListener(int priority, ScopeFacetChangeListener<? super IDT, ? super S, ? super T> listener) {
        int newSize;
        ScopeFacetChangeListener<? super IDT, ? super S, ? super T>[] dfcl = this.listeners.get(priority);
        if (dfcl == null) {
            return;
        }
        int foundLoc = -1;
        for (int i = newSize = dfcl.length - 1; i >= 0; --i) {
            if (dfcl[i] != listener) continue;
            foundLoc = i;
            break;
        }
        if (foundLoc != -1) {
            if (dfcl.length == 1) {
                this.listeners.remove(priority);
            } else {
                ScopeFacetChangeListener[] newArray = new ScopeFacetChangeListener[newSize];
                if (foundLoc != 0) {
                    System.arraycopy(dfcl, 0, newArray, 0, foundLoc);
                }
                if (foundLoc != newSize) {
                    System.arraycopy(dfcl, foundLoc + 1, newArray, foundLoc, newSize - foundLoc);
                }
                this.listeners.put(priority, newArray);
            }
        }
    }

    protected void fireScopeFacetChangeEvent(IDT id, S scope, T node, int type) {
        for (ScopeFacetChangeListener<? super IDT, ? super S, ? super T>[] dfclArray : this.listeners.values()) {
            ScopeFacetChangeEvent<IDT, S, T> ccEvent = null;
            block5: for (int i = dfclArray.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = new ScopeFacetChangeEvent<IDT, S, T>(id, scope, node, this, type);
                }
                ScopeFacetChangeListener<IDT, S, T> dfcl = dfclArray[i];
                switch (ccEvent.getEventType()) {
                    case 0: {
                        dfcl.dataAdded(ccEvent);
                        continue block5;
                    }
                    case 1: {
                        dfcl.dataRemoved(ccEvent);
                        continue block5;
                    }
                }
            }
        }
    }
}

