/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.converter.AddFilterConverter;
import pcgen.cdom.converter.DereferencingConverter;
import pcgen.cdom.helper.SpellLevel;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public class SpellLevelInfo
implements PrimitiveFilter<PCClass> {
    private final PrimitiveCollection<PCClass> filter;
    private final Formula minimumLevel;
    private final Formula maximumLevel;

    public SpellLevelInfo(PrimitiveCollection<PCClass> classFilter, Formula minLevel, Formula maxLevel) {
        this.filter = classFilter;
        this.minimumLevel = minLevel;
        this.maximumLevel = maxLevel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25);
        sb.append(this.filter.getLSTformat(false));
        sb.append("|");
        sb.append(this.minimumLevel);
        sb.append("|");
        sb.append(this.maximumLevel);
        return sb.toString();
    }

    public Collection<SpellLevel> getLevels(PlayerCharacter pc) {
        ArrayList<SpellLevel> list = new ArrayList<SpellLevel>();
        AddFilterConverter conv = new AddFilterConverter(new DereferencingConverter(pc), this);
        for (PCClass cl : this.filter.getCollection(pc, conv)) {
            int max;
            int min = this.minimumLevel.resolve(pc, cl.getQualifiedKey()).intValue();
            if (min > (max = this.maximumLevel.resolve(pc, cl.getQualifiedKey()).intValue())) {
                Logging.errorPrint("Resolved Minimum: " + min + " (from " + this.minimumLevel + ") was greater than resolved Maximum: " + max + " (from " + this.maximumLevel + ")");
            }
            for (int i = min; i <= max; ++i) {
                list.add(new SpellLevel(cl, i));
            }
        }
        return list;
    }

    @Override
    public boolean allow(PlayerCharacter pc, PCClass cl) {
        return pc.getClassKeyed(cl.getKeyName()) != null;
    }
}

